/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.primitive;

import java.util.Map;
import mod.azure.azurelib.common.internal.common.AzureLibException;
import mod.azure.azurelib.rewrite.animation.cache.AzBakedAnimationCache;
import mod.azure.azurelib.rewrite.animation.primitive.AzBakedAnimation;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record AzBakedAnimations(Map<String, AzBakedAnimation> animations, Map<String, ResourceLocation> includes) {
    @Nullable
    public AzBakedAnimation getAnimation(String name) {
        ResourceLocation otherFileID;
        AzBakedAnimation result = this.animations.get(name);
        if (result == null && this.includes != null && (otherFileID = (ResourceLocation)this.includes.getOrDefault(name, null)) != null) {
            AzBakedAnimations otherBakedAnims = AzBakedAnimationCache.getInstance().getNullable(otherFileID);
            if (otherBakedAnims.equals(this)) {
                throw new AzureLibException("The animation file '" + String.valueOf(otherFileID) + "' refers back to itself through includes.");
            }
            result = otherBakedAnims.getAnimationWithoutIncludes(name);
        }
        return result;
    }

    private AzBakedAnimation getAnimationWithoutIncludes(String name) {
        return this.animations.get(name);
    }
}

