/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.core.object;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;

public record Color(int argbInt) {
    public static Codec<Color> RGBA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("r").forGetter(Color::getRed), (App)Codec.INT.fieldOf("g").forGetter(Color::getGreen), (App)Codec.INT.fieldOf("b").forGetter(Color::getBlue), (App)Codec.INT.fieldOf("a").orElse((Object)255).forGetter(Color::getAlpha)).apply((Applicative)instance, Color::ofRGBA));
    public static Codec<Color> STRING_CODEC = Codec.STRING.comapFlatMap(Color::tryHexString, Color::toString);
    public static final Codec<Color> INT_CODEC = Codec.INT.xmap(Color::new, color -> color.argbInt);
    public static final Codec<Color> CODEC = Codec.either(STRING_CODEC, RGBA_CODEC).comapFlatMap(either -> (DataResult)either.map(DataResult::success, DataResult::success), Either::left);
    public static final Color WHITE = new Color(-1);
    public static final Color LIGHT_GRAY = new Color(-4144960);
    public static final Color GRAY = new Color(-8355712);
    public static final Color DARK_GRAY = new Color(-12566464);
    public static final Color BLACK = new Color(-16777216);
    public static final Color RED = new Color(-65536);
    public static final Color PINK = new Color(-20561);
    public static final Color ORANGE = new Color(-14336);
    public static final Color YELLOW = new Color(-256);
    public static final Color GREEN = new Color(-16711936);
    public static final Color MAGENTA = new Color(-65281);
    public static final Color CYAN = new Color(-16711681);
    public static final Color BLUE = new Color(-16776961);

    public static Color ofOpaque(int color) {
        return new Color(0xFF000000 | color);
    }

    public static Color ofRGB(float red, float green, float blue) {
        return Color.ofRGBA(red, green, blue, 1.0f);
    }

    public static Color ofRGB(int r, int g, int b) {
        return Color.ofRGBA(r, g, b, 255);
    }

    public static Color ofRGBA(float r, float g, float b, float a) {
        return Color.ofRGBA((int)((double)(r * 255.0f) + 0.5), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f), (int)(a * 255.0f + 0.5f));
    }

    public static Color ofRGBA(int r, int g, int b, int a) {
        return new Color((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public static Color ofHSB(float hue, float saturation, float brightness) {
        return Color.ofOpaque(Color.HSBtoARGB(hue, saturation, brightness));
    }

    public static int HSBtoARGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static Color ofHexString(String hexColor) {
        if (hexColor.startsWith("#")) {
            hexColor = hexColor.substring(1);
        }
        if (hexColor.length() == 3) {
            StringBuilder expanded = new StringBuilder();
            for (char c : hexColor.toCharArray()) {
                expanded.append(c).append(c);
            }
            hexColor = expanded.toString();
        }
        return new Color(Integer.parseInt(hexColor, 16));
    }

    public static DataResult<Color> tryHexString(String hexColor) {
        try {
            return DataResult.success((Object)Color.ofHexString(hexColor));
        }
        catch (Exception err) {
            return DataResult.error(err::toString);
        }
    }

    public int getColor() {
        return this.argbInt;
    }

    public int getAlpha() {
        return this.argbInt >> 24 & 0xFF;
    }

    public float getAlphaFloat() {
        return (float)this.getAlpha() / 255.0f;
    }

    public int getRed() {
        return this.argbInt >> 16 & 0xFF;
    }

    public float getRedFloat() {
        return (float)this.getRed() / 255.0f;
    }

    public int getGreen() {
        return this.argbInt >> 8 & 0xFF;
    }

    public float getGreenFloat() {
        return (float)this.getGreen() / 255.0f;
    }

    public int getBlue() {
        return this.argbInt & 0xFF;
    }

    public float getBlueFloat() {
        return (float)this.getBlue() / 255.0f;
    }

    public List<Integer> getList() {
        return List.of(Integer.valueOf(this.getRed()), Integer.valueOf(this.getGreen()), Integer.valueOf(this.getBlue()), Integer.valueOf(this.getAlpha()));
    }

    public Color brighter(double factor) {
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        int i = (int)(1.0 / (1.0 - 1.0 / factor));
        if (r == 0 && g == 0 && b == 0) {
            return Color.ofRGBA(i, i, i, this.getAlpha());
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return Color.ofRGBA(Math.min((int)((double)r / (1.0 / factor)), 255), Math.min((int)((double)g / (1.0 / factor)), 255), Math.min((int)((double)b / (1.0 / factor)), 255), this.getAlpha());
    }

    public Color darker(float factor) {
        return Color.ofRGBA(Math.max((int)((float)this.getRed() * (1.0f / factor)), 0), Math.max((int)((float)this.getGreen() * (1.0f / factor)), 0), Math.max((int)((float)this.getBlue() * (1.0f / factor)), 0), this.getAlpha());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.hashCode() == other.hashCode();
    }

    @Override
    public int hashCode() {
        return this.argbInt;
    }

    @Override
    public String toString() {
        return String.valueOf(this.argbInt);
    }
}

