/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.network.packet;

import mod.azure.azurelib.common.internal.common.network.AbstractPacket;
import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimatableManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public record AnimTriggerPacket(String syncableId, long instanceId, String controllerName, String animName) implements AbstractPacket
{
    public static final CustomPacketPayload.Type<AnimTriggerPacket> TYPE = new CustomPacketPayload.Type(AzureLibNetwork.ANIM_TRIGGER_SYNC_PACKET_ID);
    public static final StreamCodec<FriendlyByteBuf, AnimTriggerPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AnimTriggerPacket::syncableId, (StreamCodec)ByteBufCodecs.VAR_LONG, AnimTriggerPacket::instanceId, (StreamCodec)ByteBufCodecs.STRING_UTF8, AnimTriggerPacket::controllerName, (StreamCodec)ByteBufCodecs.STRING_UTF8, AnimTriggerPacket::animName, AnimTriggerPacket::new);

    @Override
    public void handle() {
        GeoAnimatable animatable = AzureLibNetwork.getSyncedAnimatable(this.syncableId);
        if (animatable != null) {
            AnimatableManager manager = animatable.getAnimatableInstanceCache().getManagerForId(this.instanceId);
            manager.tryTriggerAnimation(this.controllerName, this.animName);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

