/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.loading;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.AzureLibException;
import mod.azure.azurelib.common.internal.common.loading.json.raw.Model;
import mod.azure.azurelib.common.internal.common.loading.object.BakedAnimations;
import mod.azure.azurelib.common.internal.common.util.JsonUtil;
import mod.azure.azurelib.rewrite.animation.primitive.AzBakedAnimations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;

public final class FileLoader {
    private FileLoader() {
        throw new UnsupportedOperationException();
    }

    public static BakedAnimations loadAnimationsFile(ResourceLocation location, ResourceManager manager) {
        return (BakedAnimations)JsonUtil.GEO_GSON.fromJson((JsonElement)FileLoader.loadFile(location, manager), BakedAnimations.class);
    }

    public static AzBakedAnimations loadAzAnimationsFile(ResourceLocation location, ResourceManager manager) {
        return (AzBakedAnimations)JsonUtil.GEO_GSON.fromJson((JsonElement)FileLoader.loadFile(location, manager), AzBakedAnimations.class);
    }

    public static Model loadModelFile(ResourceLocation location, ResourceManager manager) {
        return (Model)JsonUtil.GEO_GSON.fromJson((JsonElement)FileLoader.loadFile(location, manager), Model.class);
    }

    public static JsonObject loadFile(ResourceLocation location, ResourceManager manager) {
        return (JsonObject)GsonHelper.fromJson((Gson)JsonUtil.GEO_GSON, (String)FileLoader.getFileContents(location, manager), JsonObject.class);
    }

    public static String getFileContents(ResourceLocation location, ResourceManager manager) {
        String string;
        block8: {
            InputStream inputStream = manager.getResourceOrThrow(location).open();
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    AzureLib.LOGGER.error("Couldn't load {}", (Object)location, (Object)e);
                    throw new AzureLibException(location.toString());
                }
            }
            inputStream.close();
        }
        return string;
    }
}

