/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.processor;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.world.processor.ModStructureProcessors;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@MethodsReturnNonnullByDefault
public class NatureCovenLegProcessor
extends StructureProcessor {
    public static final MapCodec<NatureCovenLegProcessor> CODEC = MapCodec.unit(NatureCovenLegProcessor::new);

    @ParametersAreNonnullByDefault
    public StructureTemplate.StructureBlockInfo process(LevelReader worldReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData, @Nullable StructureTemplate template) {
        BlockPos worldPos = blockInfoGlobal.pos();
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().set((Vec3i)worldPos);
        ChunkPos currentChunkPos = new ChunkPos(blockInfoGlobal.pos());
        ChunkAccess currentChunk = worldReader.getChunk(currentChunkPos.x, currentChunkPos.z);
        if (blockInfoGlobal.state().getBlock() == Blocks.RED_STAINED_GLASS_PANE) {
            WorldGenRegion worldGenRegion;
            if (worldReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)worldReader).getCenter().equals((Object)new ChunkPos((BlockPos)currentPos))) {
                return NatureCovenLegProcessor.getReturnBlock(worldPos, blockInfoGlobal.state());
            }
            BlockState newState = ((Block)ModBlocks.WILLOW_VINES_PLANT.get()).defaultBlockState();
            currentChunk.setBlockState(blockInfoGlobal.pos(), newState, false);
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), newState, blockInfoGlobal.nbt());
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().below().mutable();
            BlockState currBlock = worldReader.getBlockState((BlockPos)mutable);
            while (mutable.getY() > 0 && (currBlock.canBeReplaced() || currBlock.isAir() || currBlock.is(BlockTags.LEAVES) || currBlock.is(Blocks.WATER) || currBlock.is(Blocks.LAVA))) {
                currentChunk.setBlockState((BlockPos)mutable, newState, false);
                mutable.move(Direction.DOWN);
                currBlock = worldReader.getBlockState((BlockPos)mutable);
                if (currBlock.canBeReplaced() || currBlock.isAir() || currBlock.is(BlockTags.LEAVES) || currBlock.is(Blocks.WATER) || currBlock.is(Blocks.LAVA)) continue;
                currentChunk.setBlockState(mutable.above(), ((Block)ModBlocks.WILLOW_VINES.get()).defaultBlockState(), false);
                break;
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ModStructureProcessors.NATURE_COVEN_LEG_PROCESSOR.get();
    }

    private static StructureTemplate.StructureBlockInfo getReturnBlock(BlockPos worldPos, BlockState originalReplacementState) {
        return originalReplacementState == null || originalReplacementState.is(Blocks.STRUCTURE_VOID) ? null : new StructureTemplate.StructureBlockInfo(worldPos, originalReplacementState, null);
    }
}

