/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.gen;

import java.util.List;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.world.gen.ModConfiguredFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> SELENITE_GEODE_PLACED_KEY = ModPlacedFeatures.registerKey("selenite_geode_placed");
    public static final ResourceKey<PlacedFeature> COMMON_SWAMP_FLOWERS_PLACED_KEY = ModPlacedFeatures.registerKey("common_swamp_flowers_placed");
    public static final ResourceKey<PlacedFeature> SWAMP_FLOWERS_PLACED_KEY = ModPlacedFeatures.registerKey("swamp_flowers_placed");
    public static final ResourceKey<PlacedFeature> WILLOW_PLACED_KEY = ModPlacedFeatures.registerKey("willow_placed");
    public static final ResourceKey<PlacedFeature> WITCH_HAZEL_PLACED_KEY = ModPlacedFeatures.registerKey("witch_hazel_placed");
    public static final ResourceKey<PlacedFeature> MAHOGANY_PLACED_KEY = ModPlacedFeatures.registerKey("mahogany_placed");
    public static final ResourceKey<PlacedFeature> TREES_WILLOW_SWAMP_PLACED_KEY = ModPlacedFeatures.registerKey("trees_willow_swamp_placed");
    public static final ResourceKey<PlacedFeature> FLOWERING_LILYPAD_PLACED_KEY = ModPlacedFeatures.registerKey("flowering_lilypad_placed");

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)HexereiUtil.getResource(name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeature = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, SELENITE_GEODE_PLACED_KEY, configuredFeature.getOrThrow(ModConfiguredFeatures.SELENITE_GEODE_KEY), List.of(RarityFilter.onAverageOnceEvery((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)6), (VerticalAnchor)VerticalAnchor.absolute((int)30)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, WILLOW_PLACED_KEY, configuredFeature.getOrThrow(ModConfiguredFeatures.WILLOW_KEY), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)ModBlocks.WILLOW_SAPLING.get()))));
        ModPlacedFeatures.register(context, WITCH_HAZEL_PLACED_KEY, configuredFeature.getOrThrow(ModConfiguredFeatures.WITCH_HAZEL_KEY), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)ModBlocks.WITCH_HAZEL_SAPLING.get()))));
        ModPlacedFeatures.register(context, MAHOGANY_PLACED_KEY, configuredFeature.getOrThrow(ModConfiguredFeatures.MAHOGANY_KEY), List.of(PlacementUtils.filteredByBlockSurvival((Block)((Block)ModBlocks.MAHOGANY_SAPLING.get()))));
        ModPlacedFeatures.register(context, TREES_WILLOW_SWAMP_PLACED_KEY, configuredFeature.getOrThrow(ModConfiguredFeatures.WILLOW_KEY), List.of(PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)2), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)Blocks.OAK_SAPLING.defaultBlockState(), (Vec3i)BlockPos.ZERO))));
        ModPlacedFeatures.register(context, SWAMP_FLOWERS_PLACED_KEY, configuredFeature.getOrThrow(ModConfiguredFeatures.SWAMP_FLOWERS_KEY), List.of(CountPlacement.of((int)3), RarityFilter.onAverageOnceEvery((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome(), PlacementUtils.HEIGHTMAP));
        ModPlacedFeatures.register(context, FLOWERING_LILYPAD_PLACED_KEY, configuredFeature.getOrThrow(ModConfiguredFeatures.FLOWERING_LILYPAD_KEY), VegetationPlacements.worldSurfaceSquaredWithCount((int)4));
    }
}

