/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class OwlSyncInvPacket
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, OwlSyncInvPacket> CODEC = StreamCodec.ofMember(OwlSyncInvPacket::encode, OwlSyncInvPacket::new);
    public static final CustomPacketPayload.Type<OwlSyncInvPacket> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("owl_sync_inv"));
    int sourceId;
    CompoundTag tag;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public OwlSyncInvPacket(Entity entity, CompoundTag tag) {
        this.sourceId = entity.getId();
        this.tag = tag;
    }

    public OwlSyncInvPacket(RegistryFriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        this.tag = buf.readNbt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.sourceId);
        buffer.writeNbt((Tag)this.tag);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Entity entity = player.level().getEntity(this.sourceId);
        if (entity instanceof OwlEntity) {
            OwlEntity owl = (OwlEntity)entity;
            owl.itemHandler.deserializeNBT((HolderLookup.Provider)minecraft.level.registryAccess(), this.tag);
        }
    }
}

