/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class CrowInteractionRangeToServer
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, CrowInteractionRangeToServer> CODEC = StreamCodec.ofMember(CrowInteractionRangeToServer::encode, CrowInteractionRangeToServer::new);
    public static final CustomPacketPayload.Type<CrowInteractionRangeToServer> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("crow_interaction_range_server"));
    int sourceId;
    int range;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public CrowInteractionRangeToServer(CrowEntity entity, int newRange) {
        this.sourceId = entity.getId();
        this.range = newRange;
        entity.interactionRange = newRange;
    }

    public CrowInteractionRangeToServer(RegistryFriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
        this.range = buf.readInt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.sourceId);
        buffer.writeInt(this.range);
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        Entity entity = player.level().getEntity(this.sourceId);
        if (entity instanceof CrowEntity) {
            CrowEntity crowEntity = (CrowEntity)entity;
            crowEntity.interactionRange = this.range;
        }
    }
}

