/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.UUID;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.data_components.FluteData;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class CrowFluteClearCrowPerchToServer
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, CrowFluteClearCrowPerchToServer> CODEC = StreamCodec.ofMember(CrowFluteClearCrowPerchToServer::encode, CrowFluteClearCrowPerchToServer::new);
    public static final CustomPacketPayload.Type<CrowFluteClearCrowPerchToServer> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("crow_flute_clear_perch_server"));
    ItemStack flute;
    UUID entityId;
    int hand;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public CrowFluteClearCrowPerchToServer(ItemStack flute, UUID entityId, int hand) {
        this.flute = flute;
        this.entityId = entityId;
        this.hand = hand;
    }

    public CrowFluteClearCrowPerchToServer(RegistryFriendlyByteBuf buf) {
        this.flute = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
        this.entityId = buf.readUUID();
        this.hand = buf.readInt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)this.flute);
        buffer.writeUUID(this.entityId);
        buffer.writeInt(this.hand);
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        block4: {
            block3: {
                if (this.hand != 0) break block3;
                ItemStack stack = player.level().getPlayerByUUID(this.entityId).getMainHandItem();
                if (stack.getItem() != this.flute.getItem()) break block4;
                FluteData fluteData = (FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY);
                for (FluteData.CrowIds crowIds : fluteData.crowList()) {
                    Entity entity = ((ServerLevel)player.level()).getEntity(crowIds.uuid());
                    if (!(entity instanceof CrowEntity)) continue;
                    CrowEntity crow = (CrowEntity)entity;
                    crow.setPerchPos(null);
                }
                break block4;
            }
            ItemStack stack = player.level().getPlayerByUUID(this.entityId).getOffhandItem();
            if (stack.getItem() == this.flute.getItem()) {
                FluteData fluteData = (FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY);
                for (FluteData.CrowIds crowIds : fluteData.crowList()) {
                    Entity entity = ((ServerLevel)player.level()).getEntity(crowIds.uuid());
                    if (!(entity instanceof CrowEntity)) continue;
                    CrowEntity crow = (CrowEntity)entity;
                    crow.setPerchPos(null);
                }
            }
        }
    }
}

