/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.data.books.BookChapter;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.data.books.BookPage;
import net.joefoxe.hexerei.data.books.BookPageEntry;
import net.joefoxe.hexerei.data.books.BookWritableTextBox;
import net.joefoxe.hexerei.item.data_components.BookData;
import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientboundBookDataUpdate
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundBookDataUpdate> CODEC = StreamCodec.ofMember(ClientboundBookDataUpdate::encode, ClientboundBookDataUpdate::new);
    public static final CustomPacketPayload.Type<ClientboundBookDataUpdate> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("book_data_update_client"));
    BlockPos bookAltar;
    BookData bookData;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public ClientboundBookDataUpdate(BookOfShadowsAltarTile bookAltar, BookData bookData) {
        this.bookAltar = bookAltar.getBlockPos();
        this.bookData = bookData;
    }

    public ClientboundBookDataUpdate(RegistryFriendlyByteBuf buf) {
        this.bookAltar = buf.readBlockPos();
        this.bookData = (BookData)BookData.STREAM_CODEC.decode((Object)buf);
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.bookAltar);
        BookData.STREAM_CODEC.encode((Object)buffer, (Object)this.bookData);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        BlockEntity blockEntity = player.level().getBlockEntity(this.bookAltar);
        if (blockEntity instanceof BookOfShadowsAltarTile) {
            BookOfShadowsAltarTile altar = (BookOfShadowsAltarTile)blockEntity;
            altar.currentBook = this.bookData;
            for (ResourceLocation book : BookManager.getBookLocations()) {
                BookEntries bookEntries = BookManager.getBookEntries(book);
                if (bookEntries == null) continue;
                for (BookChapter bookChapter : bookEntries.chapterList) {
                    for (BookPageEntry bookPageEntry : bookChapter.pages) {
                        BookPage page;
                        if (!this.bookData.pageTexts().containsKey(bookPageEntry.location) || (page = BookManager.getBookPages(book, ResourceLocation.parse((String)bookPageEntry.location))) == null) continue;
                        for (BookWritableTextBox bookWritableTextBox : page.writableTextBoxes) {
                            bookWritableTextBox.client.clearDisplayCache(this.bookData.getUUID());
                        }
                    }
                }
            }
        }
    }
}

