/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util;

import com.mojang.datafixers.util.Either;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ResourceOrTag<K> {
    private final Either<ResourceKey<K>, TagKey<K>> either;

    private ResourceOrTag(Either<ResourceKey<K>, TagKey<K>> either) {
        this.either = either;
    }

    public static <K> ResourceOrTag<K> get(String string, ResourceKey<Registry<K>> registry) {
        if (string.startsWith("#")) {
            String str = string.substring(1);
            ResourceLocation loc = ResourceLocation.parse((String)str);
            return new ResourceOrTag<K>(Either.right((Object)TagKey.create(registry, (ResourceLocation)loc)));
        }
        ResourceLocation loc = ResourceLocation.parse((String)string);
        return new ResourceOrTag<K>(Either.left((Object)ResourceKey.create(registry, (ResourceLocation)loc)));
    }

    public Predicate<Holder<K>> holderPredicate() {
        return (Predicate)this.either.map(resourceKey -> holder -> holder.is(resourceKey), tagKey -> holder -> holder.is(tagKey));
    }
}

