/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.CourierLetter;
import net.joefoxe.hexerei.block.custom.CourierPackage;
import net.joefoxe.hexerei.block.custom.OwlCourierDepotWall;
import net.joefoxe.hexerei.data.owl.ClientOwlCourierDepotData;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.OwlCourierDepotTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class OwlCourierDepotRenderer
implements BlockEntityRenderer<OwlCourierDepotTile> {
    private final Font font;
    private final Minecraft minecraft = Minecraft.getInstance();
    private final ItemRenderer itemRenderer = this.minecraft.getItemRenderer();
    private final ItemModelShaper shaper = this.itemRenderer.getItemModelShaper();

    public OwlCourierDepotRenderer() {
        this.font = Minecraft.getInstance().font;
    }

    public void render(OwlCourierDepotTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        List list;
        BlockEntity blockEntity;
        BlockState state = tileEntityIn.getLevel().getBlockState(tileEntityIn.getBlockPos());
        if (!state.hasBlockEntity() || !((blockEntity = tileEntityIn.getLevel().getBlockEntity(tileEntityIn.getBlockPos())) instanceof OwlCourierDepotTile)) {
            return;
        }
        OwlCourierDepotTile owlCourierDepotTile = (OwlCourierDepotTile)blockEntity;
        int col = 4607830;
        int colr = (int)((double)FastColor.ARGB32.red((int)col) * 0.4);
        int colg = (int)((double)FastColor.ARGB32.green((int)col) * 0.4);
        int colb = (int)((double)FastColor.ARGB32.blue((int)col) * 0.4);
        int i1 = FastColor.ARGB32.color((int)0, (int)colr, (int)colg, (int)colb);
        if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
            matrixStackIn.translate(0.5, 0.359375, 0.859375);
        } else if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
            matrixStackIn.translate(0.5, 0.359375, 0.140625);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
        } else if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
            matrixStackIn.translate(0.140625, 0.359375, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
            matrixStackIn.translate(0.859375, 0.359375, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        if (!(state.getBlock() instanceof OwlCourierDepotWall)) {
            matrixStackIn.translate(0.0, -0.3125, 0.0);
        }
        if (ClientOwlCourierDepotData.getDepots().containsKey(GlobalPos.of((ResourceKey)tileEntityIn.getLevel().dimension(), (BlockPos)tileEntityIn.getBlockPos()))) {
            int i;
            OwlCourierDepotData depotData = ClientOwlCourierDepotData.getDepots().get(GlobalPos.of((ResourceKey)tileEntityIn.getLevel().dimension(), (BlockPos)tileEntityIn.getBlockPos()));
            int packages = 0;
            int letters = 0;
            for (ItemStack stack : depotData.items) {
                if (stack.getItem() == ModItems.COURIER_PACKAGE.get()) {
                    ++packages;
                }
                if (stack.getItem() != ModItems.COURIER_LETTER.get()) continue;
                ++letters;
            }
            Random random = new Random(4200L);
            float packageOffset = 0.5f;
            for (i = 0; i < packages; ++i) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(-0.39375, (double)packageOffset / 16.0, -0.7625);
                matrixStackIn.scale(0.8f, 0.8f, 0.8f);
                matrixStackIn.translate(0.5, 0.0, 0.5);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(random.nextInt(360) * i)));
                matrixStackIn.translate(-0.5, 0.0, -0.5);
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((CourierPackage)ModBlocks.COURIER_PACKAGE.get()).defaultBlockState());
                matrixStackIn.popPose();
                packageOffset += 5.7f;
            }
            packageOffset += 0.1f;
            for (i = 0; i < letters; ++i) {
                matrixStackIn.pushPose();
                matrixStackIn.translate((-6.3 - (double)random.nextFloat(0.8f * (float)(letters - i)) + (double)(0.4f * (float)(letters - i))) / 16.0, (double)packageOffset / 16.0, (-12.2 - (double)random.nextFloat(0.8f * (float)(letters - i)) + (double)(0.4f * (float)(letters - i))) / 16.0);
                matrixStackIn.scale(0.8f, 0.8f, 0.8f);
                matrixStackIn.translate(0.5, 0.0, 0.5);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(random.nextInt(360) * i)));
                matrixStackIn.translate(-0.5, 0.0, -0.5);
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((CourierLetter)ModBlocks.COURIER_LETTER.get()).defaultBlockState());
                matrixStackIn.popPose();
                packageOffset += 0.2f;
            }
        }
        if (state.getBlock() instanceof OwlCourierDepotWall) {
            matrixStackIn.translate(0.0, -0.0625, 0.0);
        }
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(-22.0f));
        matrixStackIn.translate(0.0, 0.0625, 0.0);
        matrixStackIn.scale(0.00694445f, -0.00694445f, 0.00694445f);
        MutableComponent component = Component.literal((String)"").withStyle(Style.EMPTY.withColor(0xAAAAAA));
        if (owlCourierDepotTile.hasCustomName() && owlCourierDepotTile.getCustomName().getString().length() > 0) {
            component = owlCourierDepotTile.getCustomName();
        }
        if ((list = Minecraft.getInstance().font.split((FormattedText)component, 512)).size() > 0) {
            int width = this.minecraft.font.width((FormattedCharSequence)list.get(0));
            Objects.requireNonNull(this.minecraft.font);
            float lineHeight = 9.0f / 2.0f;
            if (width > 70) {
                float percent = (float)width / 70.0f;
                matrixStackIn.pushPose();
                matrixStackIn.scale(1.0f / percent, 1.0f / percent, 1.0f / percent);
                Minecraft.getInstance().font.drawInBatch8xOutline((FormattedCharSequence)list.get(0), (float)(-width) / 2.0f, lineHeight * percent, i1, 0x222222, matrixStackIn.last().pose(), bufferIn, combinedLightIn);
                matrixStackIn.popPose();
            } else {
                Minecraft.getInstance().font.drawInBatch8xOutline((FormattedCharSequence)list.get(0), (float)(-width) / 2.0f, lineHeight, i1, 0x222222, matrixStackIn.last().pose(), bufferIn, combinedLightIn);
            }
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BlockState state, RenderType renderType, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, renderType, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, RenderType renderType, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    for (RenderType rt : bakedmodel.getRenderTypes(p_110913_, RandomSource.create((long)42L), modelData)) {
                        dispatcher.getModelRenderer().renderModel(p_110914_.last(), p_110915_.getBuffer(renderType != null ? renderType : RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, rt);
                    }
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

