/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Matrix4f;

public class MixingCauldronRenderer
implements BlockEntityRenderer<MixingCauldronTile> {
    public static final float CORNERS = (float)MixingCauldron.SHAPE.min(Direction.Axis.X) + 0.1875f;
    public static final float MIN_Y = 0.25f;
    public static final float MAX_Y = 0.9375f;

    public AABB getRenderBoundingBox(MixingCauldronTile blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(5.0);
    }

    public void render(MixingCauldronTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.getLevel().getBlockState(tileEntityIn.getBlockPos()).hasBlockEntity() || !(tileEntityIn.getLevel().getBlockEntity(tileEntityIn.getBlockPos()) instanceof MixingCauldronTile)) {
            return;
        }
        boolean heated = false;
        BlockState heatSource = tileEntityIn.getLevel().getBlockState(tileEntityIn.getPos().below());
        if (heatSource.is(HexereiTags.Blocks.HEAT_SOURCES) && (!heatSource.hasProperty((Property)BlockStateProperties.LIT) || ((Boolean)heatSource.getValue((Property)BlockStateProperties.LIT)).booleanValue())) {
            heated = true;
        }
        float tickSpeed = ClientEvents.getClientTicks() / 2.0f;
        if (heated) {
            tickSpeed = (float)((double)tickSpeed * 3.0);
        }
        float craftPercent = 0.0f;
        if (!Objects.requireNonNull(tileEntityIn.getLevel()).getBlockState(tileEntityIn.getPos()).hasBlockEntity() || !(tileEntityIn.getLevel().getBlockEntity(tileEntityIn.getBlockPos()) instanceof MixingCauldronTile)) {
            return;
        }
        craftPercent = (float)tileEntityIn.craftDelay / 100.0f;
        float craftPercentOld = (float)tileEntityIn.craftDelayOld / 100.0f;
        craftPercent = Mth.lerp((float)partialTicks, (float)craftPercentOld, (float)craftPercent);
        float fillPercentage = 0.0f;
        boolean flag = false;
        FluidStack fluidStack = tileEntityIn.getFluidInTank(0);
        if (tileEntityIn.renderedFluid != null) {
            fluidStack = tileEntityIn.renderedFluid;
            flag = true;
        }
        if (!fluidStack.isEmpty()) {
            fillPercentage = Math.min(1.0f, (flag ? tileEntityIn.fluidRenderLevel : (float)fluidStack.getAmount()) / (float)tileEntityIn.getTankCapacity(0));
        }
        float dist = Math.abs(tileEntityIn.fluidRenderLevel - (float)tileEntityIn.getFluidStack().getAmount()) / 1000.0f;
        tileEntityIn.fluidRenderLevel = HexereiUtil.moveTo(tileEntityIn.fluidRenderLevel, tileEntityIn.getFluidStack().getAmount(), (25.0f + 50.0f * dist) * partialTicks);
        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ((Block)ModBlocks.MIXING_CAULDRON_DYE.get()).defaultBlockState(), null, tileEntityIn.getDyeColor());
        float height = 0.25f + 0.6875f * fillPercentage;
        for (int i = 0; i < 8; ++i) {
            ItemStack item = tileEntityIn.getItemStackInSlot(i);
            if (item.isEmpty()) continue;
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, (double)(height + 0.00390625f), 0.5);
            double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
            if (fillPercentage > 0.0f) {
                matrixStackIn.translate(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)tickSpeed / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((tickSpeed + (float)(i * 20)) / 40.0f))));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees((float)(-97.5 + 5.0 * Math.cos((tickSpeed + (float)(i * 22)) / 40.0f))));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees((float)(-182.5 + 5.0 * Math.cos((tickSpeed + (float)(i * 24)) / 40.0f))));
                matrixStackIn.scale(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
            } else {
                matrixStackIn.translate(0.0 + Math.sin(itemRotationOffset) / 3.5, 0.0, 0.0 + Math.cos(itemRotationOffset) / 3.5);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(45 * i)));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(85.0f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-2.5f));
            }
            matrixStackIn.scale(0.4f, 0.4f, 0.4f);
            this.renderItem(item, tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.popPose();
        }
        ItemStack item2 = new ItemStack((ItemLike)tileEntityIn.getItemInSlot(8));
        if (!item2.isEmpty()) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, (double)(height + 0.00390625f), 0.5);
            if (fillPercentage > 0.0f) {
                matrixStackIn.translate(0.0, Math.sin(Math.PI * (double)tickSpeed / 60.0 + 20.0) / 10.0 * 0.2, 0.0);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(44.0 + 2.0 * Math.sin((tickSpeed + 20.0f) / 40.0f)) - craftPercent * craftPercent * 720.0f));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees((float)(82.5 + 5.0 * Math.cos((tickSpeed + 22.0f) / 40.0f))));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees((float)(-2.5 + 5.0 * Math.cos((tickSpeed + 24.0f) / 40.0f))));
            } else {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(45.0f - craftPercent * craftPercent * 720.0f));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(85.0f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-2.5f));
            }
            matrixStackIn.scale(0.4f, 0.4f, 0.4f);
            this.renderItem(item2, tileEntityIn.getLevel(), matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.popPose();
        }
        if (tileEntityIn.getItemInSlot(9) == ModItems.BLOOD_SIGIL.get() && tileEntityIn.getItemInSlot(9).asItem() == ModItems.BLOOD_SIGIL.get()) {
            matrixStackIn.pushPose();
            this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BLOOD_SIGIL.get()).defaultBlockState());
            matrixStackIn.popPose();
        }
        if (bufferIn instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)bufferIn;
            bufferSource.endBatch();
        }
        if (!fluidStack.isEmpty()) {
            matrixStackIn.pushPose();
            Color color2 = new Color(BiomeColors.getAverageWaterColor((BlockAndTintGetter)tileEntityIn.getLevel(), (BlockPos)new BlockPos(tileEntityIn.getPos().getX(), tileEntityIn.getPos().getY(), tileEntityIn.getPos().getZ())));
            int waterColor = HexereiUtil.getColorValue((float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f);
            if (fluidStack.getFluid().is(Tags.Fluids.GASEOUS)) {
                MixingCauldronRenderer.renderFluid(matrixStackIn, bufferIn, fluidStack, fillPercentage, 1.0f, combinedLightIn, tileEntityIn, waterColor);
            } else {
                MixingCauldronRenderer.renderFluid(matrixStackIn, bufferIn, fluidStack, 1.0f, fillPercentage, combinedLightIn, tileEntityIn, waterColor);
            }
            matrixStackIn.popPose();
        }
    }

    public static Optional<TextureAtlasSprite> getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        return Optional.ofNullable(fluidStill).map(f -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(f)).filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation());
    }

    public static void renderFluidBox(FluidStack fluidStack, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack matrixStack, int light, boolean renderBottom, int waterColor) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidType fluidAttributes = fluid.getFluidType();
        MixingCauldronRenderer.getStillFluidSprite(fluidStack).ifPresent(fluidTexture -> {
            VertexConsumer builder = buffer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)fluidTexture.atlasLocation()));
            int color = clientFluid.getTintColor(fluidStack);
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 0 & 0xFF;
            if (FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)new FluidStack((Fluid)Fluids.WATER, 1))) {
                color = a << 24 | waterColor;
            }
            int lightF = light;
            int blockLightIn = lightF >> 4 & 0xF;
            int luminosity = Math.max(blockLightIn, fluidAttributes.getLightLevel(fluidStack));
            lightF = lightF & 0xF00000 | luminosity << 4;
            matrixStack.pushPose();
            for (Direction side : Direction.values()) {
                boolean positive;
                if (side == Direction.DOWN && !renderBottom) continue;
                boolean bl = positive = side.getAxisDirection() == Direction.AxisDirection.POSITIVE;
                if (side.getAxis().isHorizontal()) {
                    if (side.getAxis() == Direction.Axis.X) {
                        MixingCauldronRenderer.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, matrixStack, lightF, color, fluidTexture);
                        continue;
                    }
                    MixingCauldronRenderer.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, matrixStack, lightF, color, fluidTexture);
                    continue;
                }
                MixingCauldronRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, matrixStack, lightF, color, fluidTexture);
            }
            matrixStack.popPose();
        });
    }

    public static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        MixingCauldronRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 0.0625f);
    }

    public static void renderFlowingTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        MixingCauldronRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 0.03125f);
    }

    public static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.getAxis().isHorizontal();
        boolean x = dir.getAxis() == Direction.Axis.X;
        float shrink = texture.uvShrinkRatio() * 0.25f * textureScale;
        float centerU = texture.getU0() + (texture.getU1() - texture.getU0()) * 0.5f * textureScale;
        float centerV = texture.getV0() + (texture.getV1() - texture.getV0()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.floor((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.ceil((float)x2);
                u1 = texture.getU((f - x2) * 16.0f * textureScale);
                u2 = texture.getU((f - x1) * 16.0f * textureScale);
            } else {
                u1 = texture.getU((x1 - f) * 16.0f * textureScale);
                u2 = texture.getU((x2 - f) * 16.0f * textureScale);
            }
            u1 = Mth.lerp((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.lerp((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.floor((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.getV((y1 - f) * 16.0f * textureScale);
                    v2 = texture.getV((y2 - f) * 16.0f * textureScale);
                } else {
                    f = Mth.ceil((float)y2);
                    v1 = texture.getV((f - y2) * 16.0f * textureScale);
                    v2 = texture.getV((f - y1) * 16.0f * textureScale);
                }
                v1 = Mth.lerp((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.lerp((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        MixingCauldronRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        MixingCauldronRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        MixingCauldronRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        MixingCauldronRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        MixingCauldronRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        MixingCauldronRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        MixingCauldronRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        MixingCauldronRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    MixingCauldronRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    MixingCauldronRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    MixingCauldronRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    MixingCauldronRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.getNormal();
        PoseStack.Pose peek = ms.last();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.addVertex(peek.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(peek, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }

    private static void renderFluid(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, FluidStack fluidStack, float alpha, float heightPercentage, int combinedLight, MixingCauldronTile tileEntityIn, int waterColor) {
        float from = 0.125f;
        float to = 0.875f;
        MixingCauldronRenderer.renderFluidBox(fluidStack, from, 0.25f, from, to, 0.25f + 0.6875f * heightPercentage, to, renderTypeBuffer, matrixStack, 0xF000F0, false, waterColor);
    }

    public static void renderFluidGUI(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, FluidStack fluidStack, float alpha, float heightPercentage, int combinedLight) {
        ResourceLocation loc = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack);
        try {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(loc);
            VertexConsumer vertexBuilder = renderTypeBuffer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)sprite.atlasLocation()));
            int color = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            MixingCauldronRenderer.renderQuads(matrixStack.last(), vertexBuilder, sprite, red, green, blue, alpha *= (float)(color >> 24 & 0xFF) / 255.0f, heightPercentage, combinedLight);
        }
        catch (Exception e) {
            System.out.println(fluidStack.getFluid());
            System.out.println(loc);
        }
    }

    public static void renderFluidBlockGUI(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, FluidStack fluidStack, float alpha, int combinedLight) {
        ResourceLocation loc = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(loc);
        VertexConsumer vertexBuilder = renderTypeBuffer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)sprite.atlasLocation()));
        int color = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        MixingCauldronRenderer.renderQuadsBlock(matrixStack.last(), vertexBuilder, sprite, red, green, blue, alpha *= (float)(color >> 24 & 0xFF) / 255.0f, combinedLight);
    }

    private static void renderQuads(PoseStack.Pose pose, VertexConsumer vertexBuilder, TextureAtlasSprite sprite, float r, float g, float b, float alpha, float heightPercentage, int light) {
        Matrix4f matrix = pose.pose();
        float height = 0.25f + 0.6875f * heightPercentage;
        float minU = sprite.getU(CORNERS);
        float maxU = sprite.getU(1.0f - CORNERS);
        float minV = sprite.getV(CORNERS);
        float maxV = sprite.getV(1.0f - CORNERS);
        vertexBuilder.addVertex(matrix, CORNERS, height, CORNERS).setColor(r, g, b, alpha).setUv(minU, minV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS, height, 1.0f - CORNERS).setColor(r, g, b, alpha).setUv(minU, maxV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS, height, 1.0f - CORNERS).setColor(r, g, b, alpha).setUv(maxU, maxV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS, height, CORNERS).setColor(r, g, b, alpha).setUv(maxU, minV).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private static void renderQuadsBlock(PoseStack.Pose pose, VertexConsumer vertexBuilder, TextureAtlasSprite sprite, float r, float g, float b, float alpha, int light) {
        float height = 0.75f;
        float minU = sprite.getU(CORNERS);
        float maxU = sprite.getU(1.0f - CORNERS);
        float minV = sprite.getV(CORNERS);
        float maxV = sprite.getV(1.0f - CORNERS);
        Matrix4f matrix = pose.pose();
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS / 5.0f, height, CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, -1.0f, 0.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, -1.0f, 0.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, 0.0f, CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, -1.0f, 0.0f, 0.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, -1.0f, 0.0f, 0.0f);
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, -1.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, height, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, -1.0f);
        vertexBuilder.addVertex(matrix, CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, -1.0f);
        vertexBuilder.addVertex(matrix, 1.0f - CORNERS / 5.0f, 0.0f, 1.0f - CORNERS / 5.0f).setColor(r, g, b, alpha).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 0.0f, -1.0f);
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BlockState state, RenderType renderType, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, renderType, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, RenderType renderType, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    for (RenderType rt : bakedmodel.getRenderTypes(p_110913_, RandomSource.create((long)42L), modelData)) {
                        dispatcher.getModelRenderer().renderModel(p_110914_.last(), p_110915_.getBuffer(renderType != null ? renderType : RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, rt);
                    }
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

