/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.data.coffer.ClientCofferData;
import net.joefoxe.hexerei.data.coffer.CofferInventorySavedData;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.CofferSyncCrowButtonToServer;
import net.joefoxe.hexerei.util.message.CofferUpdateWhitelistToServer;
import net.joefoxe.hexerei.util.message.SyncCofferInventoryPacket;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CofferTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
Clearable {
    public static final int DEFAULT_COLOR = 4337438;
    public static final int DEFAULT_COLOR_ENTANGLED = 856599;
    public int degreesOpened;
    public int buttonToggled = 0;
    public static final int lidOpenAmount = 112;
    public int degreesOpenedPrev = 0;
    public int dyeColor = 4337438;
    public WhitelistMode mode = WhitelistMode.WHITELIST_INV;
    public Component customName;
    public UUID cofferId;
    private CompoundTag deferredInventoryNbt = null;
    public NonNullList<ItemStack> whitelist = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private static final int[] SLOTS = IntStream.range(0, 36).toArray();

    public CofferTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
        if (blockState.is(ModBlocks.ENTANGLED_COFFER)) {
            this.dyeColor = 856599;
        }
    }

    public CofferTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.COFFER_TILE.get(), blockPos, blockState);
    }

    public BlockEntityType<?> getType() {
        return super.getType();
    }

    public void setDyeColor(int dyeColor) {
        this.dyeColor = dyeColor;
    }

    public int getDyeColor() {
        DyeColor dye = HexereiUtil.getDyeColorNamed(this.getDisplayName().getString());
        if (dye != null) {
            return HexereiUtil.getColorValue(dye);
        }
        return this.dyeColor;
    }

    public void syncCofferInventory() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UUID cofferId = this.getOrCreateCofferId();
            NonNullList<ItemStack> inventory = CofferInventorySavedData.get().getInventory(cofferId);
            HexereiPacketHandler.sendToAllPlayers(new SyncCofferInventoryPacket(cofferId, inventory), serverLevel.getServer());
        }
    }

    public UUID getOrCreateCofferId() {
        if (this.cofferId == null) {
            this.cofferId = UUID.randomUUID();
            this.setChanged();
            if (this.deferredInventoryNbt != null) {
                NonNullList<ItemStack> inv = CofferInventorySavedData.get().getInventory(this.cofferId);
                ListTag tagList = this.deferredInventoryNbt.getList("Items", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag itemTags = tagList.getCompound(i);
                    int slot = itemTags.getInt("Slot");
                    if (slot < 0 || slot >= inv.size()) continue;
                    ItemStack.parse((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (Tag)itemTags).ifPresent(stack -> inv.set(slot, stack));
                }
                this.deferredInventoryNbt = null;
                this.syncCofferInventory();
            }
            this.sync();
        }
        return this.cofferId;
    }

    protected NonNullList<ItemStack> getItems() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return CofferInventorySavedData.get().getInventory(this.getOrCreateCofferId());
        }
        return ClientCofferData.getInventory(this.cofferId);
    }

    protected void setItems(NonNullList<ItemStack> items) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CofferInventorySavedData.get().getInventory(this.getOrCreateCofferId()).clear();
            CofferInventorySavedData.get().getInventory(this.getOrCreateCofferId()).addAll(items);
            CofferInventorySavedData.get().setLastModified(this.getOrCreateCofferId());
            this.setChanged();
            this.syncCofferInventory();
        }
    }

    public ItemStack removeItem(int slot, int count) {
        ItemStack itemstack;
        this.unpackLootTable(null);
        ItemStack itemStack = itemstack = slot >= 0 && slot < this.getItems().size() && !this.getItem(slot).isEmpty() && count > 0 ? ((ItemStack)this.getItems().get(slot)).split(count) : ItemStack.EMPTY;
        if (!itemstack.isEmpty()) {
            this.syncCofferInventory();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.unpackLootTable(null);
        if (slot >= 0 && slot < this.getItems().size()) {
            ItemStack temp = this.getItem(slot).copy();
            this.setItem(slot, ItemStack.EMPTY);
            if (!temp.isEmpty()) {
                this.syncCofferInventory();
            }
            return temp;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getItem(int slot) {
        this.unpackLootTable(null);
        if (this.getItems().size() > slot) {
            return (ItemStack)this.getItems().get(slot);
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        this.unpackLootTable(null);
        NonNullList<ItemStack> stacks = this.getItems();
        if (this.getItems().size() > slot) {
            this.getItems().set(slot, (Object)stack);
            if (stack.getCount() > this.getMaxStackSize()) {
                stack.setCount(this.getMaxStackSize());
            }
            this.syncCofferInventory();
        } else {
            System.out.println("out of bounds");
        }
    }

    public void setChanged() {
        super.setChanged();
    }

    public void startOpen(Player p_18955_) {
        super.startOpen(p_18955_);
    }

    public void stopOpen(Player p_18954_) {
        super.stopOpen(p_18954_);
    }

    public boolean canPlaceItem(int p_18952_, ItemStack stack) {
        String id = HexereiUtil.getRegistryName(stack.getItem()).toString();
        if (((List)HexConfig.COFFER_BLACKLIST.get()).contains(id) || stack.is(ModItems.COFFER) || stack.is(ModItems.ENTANGLED_COFFER)) {
            return false;
        }
        return super.canPlaceItem(p_18952_, stack);
    }

    public int countItem(Item p_18948_) {
        return super.countItem(p_18948_);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.hexerei.coffer");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new CofferContainer(id, this.level, this.worldPosition, player, player.player);
    }

    public void clearContent() {
        super.clearContent();
        CofferInvWrapper wrapper = new CofferInvWrapper(this.cofferId, this.level);
        for (int i = 0; i < wrapper.getSlots(); ++i) {
            wrapper.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider reg) {
        if (!this.trySaveLootTable(compound) && this.cofferId != null) {
            compound.putUUID("CofferId", this.cofferId);
        }
        if (this.cofferId == null && this.deferredInventoryNbt != null) {
            compound.put("inv", (Tag)this.deferredInventoryNbt);
        }
        ListTag itemsTag = new ListTag();
        for (int slot = 0; slot < this.whitelist.size(); ++slot) {
            ItemStack stack = (ItemStack)this.whitelist.get(slot);
            if (stack.isEmpty()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.putInt("Slot", slot);
            Tag itemTag = stack.save(reg, (Tag)slotTag);
            slotTag.put("Item", itemTag);
            itemsTag.add((Object)slotTag);
        }
        compound.put("WhitelistItems", (Tag)itemsTag);
        compound.putInt("WhitelistMode", this.mode.ordinal());
        if (this.customName != null) {
            compound.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)reg));
        }
        compound.putInt("ButtonToggled", this.buttonToggled);
        compound.putInt("DyeColor", this.dyeColor);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!this.tryLoadLootTable(tag) && tag.hasUUID("CofferId")) {
            this.cofferId = tag.getUUID("CofferId");
        }
        this.whitelist.clear();
        if (tag.contains("WhitelistItems", 9)) {
            ListTag itemsTag = tag.getList("WhitelistItems", 10);
            for (int i = 0; i < itemsTag.size(); ++i) {
                CompoundTag slotTag = itemsTag.getCompound(i);
                int slot = slotTag.getInt("Slot");
                if (slot < 0 || slot >= this.whitelist.size()) continue;
                this.whitelist.set(slot, (Object)ItemStack.parse((HolderLookup.Provider)registries, (Tag)slotTag.getCompound("Item")).orElse(ItemStack.EMPTY));
            }
        }
        if (tag.contains("WhitelistMode")) {
            this.mode = WhitelistMode.byId(tag.getInt("WhitelistMode"));
        }
        if (tag.contains("inv")) {
            this.deferredInventoryNbt = tag.getCompound("inv");
        }
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        if (tag.contains("ButtonToggled")) {
            this.buttonToggled = tag.getInt("ButtonToggled");
        }
        if (tag.contains("DyeColor")) {
            this.dyeColor = tag.getInt("DyeColor");
            if (this.dyeColor == 0) {
                this.dyeColor = 4337438;
            }
        }
    }

    @javax.annotation.Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (tag, registryAccess) -> this.getUpdateTag((HolderLookup.Provider)registryAccess));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void sync() {
        this.setChanged();
        if (this.level != null) {
            if (!this.level.isClientSide) {
                CompoundTag tag = new CompoundTag();
                this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
                HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new TESyncPacket(this.worldPosition, tag));
            }
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 2);
            }
        }
    }

    public ItemStack getItemStackInSlot(int slot) {
        return this.getItem(slot);
    }

    public boolean hasItem(Item item) {
        CofferInvWrapper wrapper = new CofferInvWrapper(this.cofferId, this.level);
        for (int i = 0; i < wrapper.getSlots(); ++i) {
            if (!wrapper.getStackInSlot(i).is(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWhitelistItem(ItemStack item) {
        for (ItemStack stack : this.whitelist) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonMaxStackItemStack(ItemStack item) {
        CofferInvWrapper wrapper = new CofferInvWrapper(this.cofferId, this.level);
        for (int i = 0; i < wrapper.getSlots(); ++i) {
            if (wrapper.getStackInSlot(i) != item || wrapper.getStackInSlot(i).getCount() >= wrapper.getStackInSlot(i).getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        CofferInvWrapper wrapper = new CofferInvWrapper(this.cofferId, this.level);
        for (int i = 0; i < wrapper.getSlots(); ++i) {
            if (wrapper.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isWhitelistEmpty() {
        for (ItemStack stack : this.whitelist) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.getX() - (double)pos.getX();
        double deltaY = entity.getY() - (double)pos.getY();
        double deltaZ = entity.getZ() - (double)pos.getZ();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public Component getDisplayName() {
        return this.customName != null ? this.customName : Component.literal((String)"");
    }

    public Component getCustomName() {
        return this.customName;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public Component getName() {
        return this.customName;
    }

    public int getDegreesOpened() {
        return this.degreesOpened;
    }

    public void setDegreesOpened(int degrees) {
        this.degreesOpened = degrees;
    }

    public void setButtonToggled(int buttonToggled) {
        this.buttonToggled = buttonToggled;
        if (this.level.isClientSide) {
            HexereiPacketHandler.sendToServer(new CofferSyncCrowButtonToServer(this, buttonToggled));
        }
    }

    public void setWhitelistSlot(int slot, ItemStack stack) {
        if (this.level.isClientSide) {
            HexereiPacketHandler.sendToServer(new CofferUpdateWhitelistToServer(this, slot, stack));
        }
    }

    public int getButtonToggled() {
        return this.buttonToggled;
    }

    public void tick() {
        int distanceFromSide;
        this.degreesOpenedPrev = this.degreesOpened;
        boolean flag = false;
        Player playerEntity = this.level.getNearestPlayer((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 5.0, false);
        if (playerEntity != null && Math.floor(CofferTile.getDistanceToEntity((Entity)playerEntity, this.worldPosition)) < 4.0) {
            if (!this.level.isClientSide && this.getOrCreateCofferId() != null && this.getLootTable() != null) {
                this.unpackLootTable(playerEntity);
            }
            distanceFromSide = 56 - Math.abs(56 - this.degreesOpened);
            flag = true;
            this.degreesOpened = (double)this.degreesOpened + Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0 < 112.0 ? (int)((double)this.degreesOpened + (Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0)) : 112;
        }
        if (!flag) {
            distanceFromSide = 56 - Math.abs(56 - this.degreesOpened);
            if ((double)this.degreesOpened + Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0 > 0.0) {
                this.degreesOpened = (int)((double)this.degreesOpened - (Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0));
                if (this.degreesOpened < 0) {
                    this.degreesOpened = 0;
                }
            } else {
                this.degreesOpened = 0;
            }
        }
    }

    public int getContainerSize() {
        return 36;
    }

    public void unpackLootTable(@javax.annotation.Nullable Player player) {
        Level level = this.getLevel();
        boolean flag = false;
        if (this.getLootTable() != null && !level.isClientSide) {
            flag = true;
            super.unpackLootTable(player);
        } else {
            super.unpackLootTable(player);
        }
        if (flag && this.getLootTable() == null) {
            this.syncCofferInventory();
        }
    }

    public int getMaxStackSize() {
        return super.getMaxStackSize();
    }

    public int[] getSlotsForFace(Direction pSide) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return new CofferInvWrapper(this.cofferId, this.level).isItemValid(pIndex, pItemStack);
    }

    public boolean canTakeItemThroughFace(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public static enum WhitelistMode {
        WHITELIST_INV("whitelist_inv"),
        WHITELIST("whitelist_only"),
        BLACKLIST_INV("blacklist_inv");

        private final String name;

        private WhitelistMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static WhitelistMode byId(int id) {
            WhitelistMode[] type = WhitelistMode.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }
    }

    public static class CofferInvWrapper
    extends ItemStackHandler {
        private final UUID cofferId;
        private final boolean isClientSide;
        private final int size;
        private CofferTile coffer = null;

        public CofferInvWrapper(UUID cofferId, Level level) {
            this.cofferId = cofferId;
            this.isClientSide = level == null || level.isClientSide();
            this.size = 36;
        }

        public CofferInvWrapper(CofferTile coffer) {
            this.coffer = coffer;
            this.cofferId = coffer.cofferId;
            this.isClientSide = coffer.getLevel() == null || coffer.getLevel().isClientSide();
            this.size = 36;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.validateSlotIndex(slot);
            if (this.isClientSide) {
                NonNullList<ItemStack> items = ClientCofferData.getInventory(this.cofferId);
                items.set(slot, (Object)stack);
                ClientCofferData.storeInventory(this.cofferId, items);
            } else {
                NonNullList<ItemStack> items = CofferInventorySavedData.get().getInventory(this.cofferId);
                items.set(slot, (Object)stack);
                CofferInventorySavedData.get().setLastModified(this.cofferId);
                CofferInventorySavedData.get().setDirty();
            }
            this.onContentsChanged(slot);
        }

        public int getSlots() {
            return this.size;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            this.validateSlotIndex(slot);
            if (this.isClientSide) {
                NonNullList<ItemStack> items = ClientCofferData.getInventory(this.cofferId);
                return slot < items.size() ? (ItemStack)items.get(slot) : ItemStack.EMPTY;
            }
            NonNullList<ItemStack> items = CofferInventorySavedData.get().getInventory(this.cofferId);
            return slot < items.size() ? (ItemStack)items.get(slot) : ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            this.validateSlotIndex(slot);
            NonNullList<ItemStack> items = this.getInventory();
            ItemStack existing = (ItemStack)items.get(slot);
            int limit = Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
            if (!existing.isEmpty()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) {
                    return stack;
                }
                limit -= existing.getCount();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.getCount() > limit;
            if (!simulate) {
                if (existing.isEmpty()) {
                    items.set(slot, (Object)(reachedLimit ? stack.copyWithCount(limit) : stack.copy()));
                } else {
                    existing.grow(reachedLimit ? limit : stack.getCount());
                }
                this.updateInventory(items);
            }
            return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.EMPTY;
            }
            this.validateSlotIndex(slot);
            NonNullList<ItemStack> items = this.getInventory();
            ItemStack existing = (ItemStack)items.get(slot);
            if (existing.isEmpty()) {
                return ItemStack.EMPTY;
            }
            int toExtract = Math.min(amount, existing.getMaxStackSize());
            if (existing.getCount() <= toExtract) {
                if (!simulate) {
                    items.set(slot, (Object)ItemStack.EMPTY);
                    this.updateInventory(items);
                    return existing;
                }
                return existing.copy();
            }
            if (!simulate) {
                items.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
                this.updateInventory(items);
            }
            return existing.copyWithCount(toExtract);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return !((List)HexConfig.COFFER_BLACKLIST.get()).contains(HexereiUtil.getRegistryName(stack.getItem()).toString()) && !stack.is(ModItems.COFFER) && !stack.is(ModItems.ENTANGLED_COFFER);
        }

        private NonNullList<ItemStack> getInventory() {
            if (this.isClientSide) {
                return ClientCofferData.getInventory(this.cofferId);
            }
            return CofferInventorySavedData.get().getInventory(this.cofferId);
        }

        private void updateInventory(NonNullList<ItemStack> items) {
            if (this.isClientSide) {
                ClientCofferData.storeInventory(this.cofferId, items);
            } else {
                CofferInventorySavedData.get().setDirty();
                if (this.coffer != null) {
                    this.coffer.syncCofferInventory();
                }
            }
        }

        public void validateSlotIndex(int slot) {
            if (slot < 0 || slot >= this.size) {
                throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
            }
        }
    }
}

