/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.recipes.DipperRecipe;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.EmitParticlesPacket;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class CandleDipperTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
Clearable,
MenuProvider {
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    public float numberOfCandles;
    public static int DRYING_START_TICKS = 60;
    public List<DipperSlot> dipperSlots = new ArrayList<DipperSlot>(3);

    public CandleDipperTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
        this.dipperSlots.add(new DipperSlot(0, new Vec3(0.5, (double)0.4f, 0.5), DipperState.NON, 200, 60, 3, 100, ItemStack.EMPTY));
        this.dipperSlots.add(new DipperSlot(1, new Vec3(0.5, (double)0.4f, 0.5), DipperState.NON, 200, 60, 3, 100, ItemStack.EMPTY));
        this.dipperSlots.add(new DipperSlot(2, new Vec3(0.5, (double)0.4f, 0.5), DipperState.NON, 200, 60, 3, 100, ItemStack.EMPTY));
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void setChanged() {
        super.setChanged();
        this.sync();
    }

    public void sync() {
        if (this.level != null) {
            if (!this.level.isClientSide) {
                CompoundTag tag = new CompoundTag();
                this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
                HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new TESyncPacket(this.worldPosition, tag));
            }
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 2);
            }
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    public CandleDipperTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.CANDLE_DIPPER_TILE.get(), blockPos, blockState);
    }

    public void setItem(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.copy();
            itemStack.setCount(1);
            this.items.set(index, (Object)itemStack);
            this.dipperSlots.get((int)index).dryingTicks = DRYING_START_TICKS;
            this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.4f + 1.0f);
        }
        this.setChanged();
    }

    public ItemStack removeItem(int index, int p_59614_) {
        this.unpackLootTable(null);
        ItemStack itemstack = ContainerHelper.removeItem(this.getItems(), (int)index, (int)p_59614_);
        if (!itemstack.isEmpty()) {
            this.dipperSlots.get((int)index).state = DipperState.NON;
            this.setChanged();
        }
        return itemstack;
    }

    private static CraftingContainer makeContainer(int width, int height, NonNullList<ItemStack> items) {
        return new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            @NotNull
            public ItemStack quickMoveStack(@NotNull Player p_218264_, int p_218265_) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(@NotNull Player p_29888_) {
                return false;
            }
        }, width, height, items);
    }

    public void craft() {
        CraftingContainer container = CandleDipperTile.makeContainer(3, 1, this.items);
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.below());
        AtomicBoolean[] matchesRecipe = new AtomicBoolean[3];
        for (int i = 0; i < matchesRecipe.length; ++i) {
            matchesRecipe[i] = new AtomicBoolean(false);
        }
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingCauldronTile = (MixingCauldronTile)blockEntity;
            List<DipperRecipe> recipes = this.level.getRecipeManager().getRecipesFor((RecipeType)ModRecipeTypes.DIPPER_TYPE.get(), (RecipeInput)container.asCraftInput(), this.level).stream().filter(dipperRecipe -> {
                FluidStack tileFluid = mixingCauldronTile.getFluidStack();
                FluidStack recipeFluid = ((DipperRecipe)dipperRecipe.value()).getLiquid();
                return FluidStack.isSameFluidSameComponents((FluidStack)tileFluid, (FluidStack)recipeFluid);
            }).map(RecipeHolder::value).toList();
            recipes.forEach(iRecipe -> {
                ItemStack output = iRecipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
                ItemStack input = ((Ingredient)iRecipe.getIngredients().getFirst()).getItems()[0];
                boolean matchesFluid = FluidStack.isSameFluidSameComponents((FluidStack)iRecipe.getLiquid(), (FluidStack)mixingCauldronTile.getFluidStack()) && iRecipe.getFluidLevelsConsumed() <= mixingCauldronTile.getFluidStack().getAmount();
                boolean useInputItemAsOutput = iRecipe.getUseInputItemAsOutput();
                for (int i = 0; i < matchesRecipe.length; ++i) {
                    boolean same = ItemStack.isSameItemSameComponents((ItemStack)input, (ItemStack)((ItemStack)this.items.get(i)));
                    DipperSlot dipperSlot = this.dipperSlots.get(i);
                    if (same && !matchesRecipe[i].get()) {
                        if (!matchesFluid) continue;
                        matchesRecipe[i].set(true);
                        if (!dipperSlot.isNon()) continue;
                        dipperSlot.state = DipperState.DRYING;
                        dipperSlot.output = output.copy();
                        if (useInputItemAsOutput) {
                            ItemStack stack = ((ItemStack)this.items.get(i)).copy();
                            DataComponentMap map = DataComponentMap.composite((DataComponentMap)stack.getComponents(), (DataComponentMap)output.getComponents());
                            stack.applyComponents(map);
                            dipperSlot.output = stack;
                        }
                        dipperSlot.fluidConsumptionAmount = iRecipe.getFluidLevelsConsumed();
                        dipperSlot.timesDipped = 0;
                        dipperSlot.timesDippedMax = iRecipe.getNumberOfDips();
                        dipperSlot.dryingTicksMax = iRecipe.getDryingTime();
                        dipperSlot.dryingTicks = DRYING_START_TICKS;
                        dipperSlot.dippingTicks = dipperSlot.dippingTicksMax = iRecipe.getDippingTime();
                        this.setChanged();
                        continue;
                    }
                    if (!matchesFluid || !dipperSlot.isCrafting()) continue;
                    dipperSlot.state = DipperState.NON;
                    this.setChanged();
                }
            });
            for (int i = 0; i < matchesRecipe.length; ++i) {
                if (matchesRecipe[i].get() || !this.dipperSlots.get(i).isCrafting()) continue;
                this.dipperSlots.get((int)i).state = DipperState.NON;
                this.dipperSlots.get((int)i).dryingTicks = DRYING_START_TICKS;
                this.setChanged();
            }
            for (DipperSlot slot : this.dipperSlots) {
                if (slot.isDrying() && slot.timesDipped < slot.timesDippedMax) {
                    --slot.dryingTicks;
                    if (slot.dryingTicks > 0) continue;
                    slot.dryingTicks = slot.dryingTicksMax;
                    slot.state = DipperState.DUNKING;
                    this.setChanged();
                    continue;
                }
                if (!slot.isDunking()) continue;
                if (mixingCauldronTile.getFluidStack().getAmount() > 0) {
                    --slot.dippingTicks;
                }
                if (slot.dippingTicks > 0) continue;
                slot.dippingTicks = slot.dippingTicksMax;
                slot.state = DipperState.DRYING;
                slot.dryingTicks = slot.dryingTicksMax;
                ++slot.timesDipped;
                this.decreaseFluid(slot.fluidConsumptionAmount);
                if (slot.timesDipped >= slot.timesDippedMax) {
                    slot.state = DipperState.FINISHED;
                    slot.timesDipped = 0;
                    slot.dippingTicks = slot.dippingTicksMax;
                    slot.dryingTicks = slot.dryingTicksMax;
                    this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.4f + 1.0f);
                    this.items.set(slot.index, (Object)slot.output);
                }
                this.setChanged();
            }
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
        if (tag.contains("slot0")) {
            this.dipperSlots.get(0).load(tag.getCompound("slot0"), registries);
        }
        if (tag.contains("slot1")) {
            this.dipperSlots.get(1).load(tag.getCompound("slot1"), registries);
        }
        if (tag.contains("slot2")) {
            this.dipperSlots.get(2).load(tag.getCompound("slot2"), registries);
        }
        super.loadAdditional(tag, registries);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.hexerei.dipper");
    }

    protected AbstractContainerMenu createMenu(int p_58627_, Inventory p_58628_) {
        return null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.put("slot0", (Tag)this.dipperSlots.get(0).save(registries));
        tag.put("slot1", (Tag)this.dipperSlots.get(1).save(registries));
        tag.put("slot2", (Tag)this.dipperSlots.get(2).save(registries));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (tag, registryAccess) -> this.getUpdateTag((HolderLookup.Provider)registryAccess));
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.z() - (double)this.getBlockPos().getZ() - 0.5, pos.x() - (double)this.getBlockPos().getX() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getSpeed(double pos, double posTo) {
        return (float)((double)1.0E-4f + (double)0.15f * Math.abs(pos - posTo));
    }

    public Vec3 rotateAroundVec(Vec3 vector3dCenter, float rotation, Vec3 vector3d) {
        Vec3 newVec = vector3d.subtract(vector3dCenter);
        newVec = newVec.yRot(rotation / 180.0f * (float)Math.PI);
        newVec = newVec.add(vector3dCenter);
        return newVec;
    }

    public int putItems(int slot, @Nonnull ItemStack stack) {
        if (((ItemStack)this.items.get(slot)).isEmpty()) {
            ItemStack stack1 = stack.copy();
            stack1.setCount(1);
            this.items.set(slot, (Object)stack1);
            this.setChanged();
            stack.shrink(1);
            return 1;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)this.items.get(slot)))) {
            return 0;
        }
        return 1;
    }

    public InteractionResult interactWithoutItem(Player player) {
        if (player.isShiftKeyDown()) {
            boolean flag = false;
            for (int i = 0; i < 3; ++i) {
                DipperSlot dipperSlot = this.dipperSlots.get(i);
                if (((ItemStack)this.items.get(i)).isEmpty() || dipperSlot.isCrafting()) continue;
                dipperSlot.timesDipped = 0;
                dipperSlot.dippingTicks = dipperSlot.dippingTicksMax;
                dipperSlot.state = DipperState.NON;
                dipperSlot.dryingTicks = dipperSlot.dryingTicksMax;
                player.getInventory().placeItemBackInInventory(((ItemStack)this.items.get(i)).copy());
                this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.4f + 1.0f);
                this.items.set(i, (Object)ItemStack.EMPTY);
                dipperSlot.output = ItemStack.EMPTY;
                flag = true;
            }
            if (flag) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public ItemInteractionResult interactWithItem(Player player) {
        if (!player.isShiftKeyDown()) {
            int i;
            if (!player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                Random rand = new Random();
                for (i = 0; i < 3; ++i) {
                    if (!((ItemStack)this.items.get(i)).isEmpty()) continue;
                    this.putItems(i, player.getItemInHand(InteractionHand.MAIN_HAND));
                    this.dipperSlots.get((int)i).dryingTicks = DRYING_START_TICKS;
                    this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
            }
            boolean flag = false;
            for (i = 0; i < 3; ++i) {
                DipperSlot dipperSlot = this.dipperSlots.get(i);
                if (!dipperSlot.isFinished()) continue;
                dipperSlot.timesDipped = 0;
                dipperSlot.dippingTicks = dipperSlot.dippingTicksMax;
                dipperSlot.state = DipperState.NON;
                dipperSlot.dryingTicks = dipperSlot.dryingTicksMax;
                player.getInventory().placeItemBackInInventory(((ItemStack)this.items.get(i)).copy());
                this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.4f + 1.0f);
                this.items.set(i, (Object)ItemStack.EMPTY);
                dipperSlot.output = ItemStack.EMPTY;
                flag = true;
            }
            return flag ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void tick() {
        BlockEntity blockEntity;
        if (this.level instanceof ServerLevel) {
            this.craft();
        }
        for (DipperSlot slot : this.dipperSlots) {
            slot.posLast = slot.pos;
        }
        this.numberOfCandles = 0.0f;
        Vec3[] targetPos = new Vec3[]{new Vec3(0.25, 0.0, 0.0625), new Vec3(0.5, 0.0, 0.0625), new Vec3(0.75, 0.0, 0.0625)};
        if (this.level != null && (blockEntity = this.level.getBlockEntity(this.worldPosition.below())) instanceof MixingCauldronTile) {
            Direction dir;
            MixingCauldronTile cauldronTile = (MixingCauldronTile)blockEntity;
            float fillPercentage = 0.0f;
            FluidStack fluidStack = cauldronTile.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                fillPercentage = Math.min(1.0f, (float)fluidStack.getAmount() / (float)cauldronTile.getTankCapacity(0));
            }
            float height = 0.25f + 0.6875f * fillPercentage - 1.0f + 0.0625f;
            DipperSlot dipperSlot = this.dipperSlots.get(0);
            if (dipperSlot.isDrying() || !((ItemStack)this.items.get(0)).isEmpty()) {
                targetPos[0] = new Vec3(targetPos[0].x(), 0.3125 + Math.sin((float)this.level.getGameTime() / 16.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isDunking()) {
                targetPos[0] = new Vec3(targetPos[0].x(), (double)height + Math.sin((float)this.level.getGameTime() / 16.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isFinished()) {
                targetPos[0] = new Vec3(targetPos[0].x(), 0.625 + Math.sin((float)this.level.getGameTime() / 16.0f) / 32.0, 0.5);
            }
            if ((dipperSlot = this.dipperSlots.get(1)).isDrying() || !((ItemStack)this.items.get(1)).isEmpty()) {
                targetPos[1] = new Vec3(targetPos[1].x(), 0.3125 + Math.sin(((float)this.level.getGameTime() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isDunking()) {
                targetPos[1] = new Vec3(targetPos[1].x(), (double)height + Math.sin(((float)this.level.getGameTime() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isFinished()) {
                targetPos[1] = new Vec3(targetPos[1].x(), 0.625 + Math.sin(((float)this.level.getGameTime() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if ((dipperSlot = this.dipperSlots.get(2)).isDrying() || !((ItemStack)this.items.get(2)).isEmpty()) {
                targetPos[2] = new Vec3(targetPos[2].x(), 0.3125 + Math.sin(((float)this.level.getGameTime() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isDunking()) {
                targetPos[2] = new Vec3(targetPos[2].x(), (double)height + Math.sin(((float)this.level.getGameTime() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (dipperSlot.isFinished()) {
                targetPos[2] = new Vec3(targetPos[2].x(), 0.625 + Math.sin(((float)this.level.getGameTime() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            int rot = (dir = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)) == Direction.NORTH ? 180 : (dir == Direction.SOUTH ? 0 : (dir == Direction.EAST ? 90 : 270));
            for (int i = 0; i < this.dipperSlots.size(); ++i) {
                targetPos[i] = this.rotateAroundVec(new Vec3(0.5, 0.0, 0.5), rot, targetPos[i]);
                DipperSlot slot = this.dipperSlots.get(i);
                slot.pos = new Vec3((double)HexereiUtil.moveTo((float)slot.pos.x, (float)targetPos[i].x(), this.getSpeed((float)slot.pos.x, targetPos[i].x())), (double)HexereiUtil.moveTo((float)slot.pos.y, (float)targetPos[i].y(), 0.75f * this.getSpeed((float)slot.pos.y, targetPos[i].y())), (double)HexereiUtil.moveTo((float)slot.pos.z, (float)targetPos[i].z(), this.getSpeed((float)slot.pos.z, targetPos[i].z())));
            }
        }
    }

    private void decreaseFluid(int amount) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.below());
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile cauldronTile = (MixingCauldronTile)blockEntity;
            if (!this.level.isClientSide()) {
                cauldronTile.getFluidStack().shrink(amount);
                cauldronTile.setChanged();
                HexereiPacketHandler.sendToNearbyClient(this.level, cauldronTile.getPos(), (CustomPacketPayload)new EmitParticlesPacket(cauldronTile.getPos(), 10, false));
            }
        }
    }

    public int[] getSlotsForFace(Direction p_19238_) {
        return new int[]{0, 1, 2};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return ((ItemStack)this.items.get(index)).isEmpty();
    }

    public boolean canTakeItemThroughFace(int index, ItemStack p_19240_, Direction p_19241_) {
        return !this.dipperSlots.get(index).isCrafting();
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public static class DipperSlot {
        public int index;
        public Vec3 pos;
        public Vec3 posLast;
        public DipperState state;
        public int dippingTicks;
        public int dippingTicksMax;
        public int dryingTicks;
        public int dryingTicksMax;
        public int timesDipped;
        public int timesDippedMax;
        public int fluidConsumptionAmount;
        public ItemStack output;

        public DipperSlot(int index, Vec3 pos, DipperState state, int dippingTicksMax, int dryingTicksMax, int timesDippedMax, int fluidConsumptionAmount, ItemStack output) {
            this.index = index;
            this.pos = pos;
            this.posLast = pos;
            this.state = state;
            this.dippingTicks = dippingTicksMax;
            this.dippingTicksMax = dippingTicksMax;
            this.dryingTicks = dryingTicksMax;
            this.dryingTicksMax = dryingTicksMax;
            this.timesDipped = 0;
            this.timesDippedMax = timesDippedMax;
            this.fluidConsumptionAmount = fluidConsumptionAmount;
            this.output = output;
        }

        public boolean isCrafting() {
            return this.state != DipperState.NON && this.state != DipperState.FINISHED;
        }

        public boolean isDrying() {
            return this.state == DipperState.DRYING;
        }

        public boolean isDunking() {
            return this.state == DipperState.DUNKING;
        }

        public boolean isFinished() {
            return this.state == DipperState.FINISHED;
        }

        public boolean isNon() {
            return this.state == DipperState.NON;
        }

        public CompoundTag save(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("state", this.state.ordinal());
            tag.putInt("dippingTicks", this.dippingTicks);
            tag.putInt("dippingTicksMax", this.dippingTicksMax);
            tag.putInt("dryingTicks", this.dryingTicks);
            tag.putInt("dryingTicksMax", this.dryingTicksMax);
            tag.putInt("timesDipped", this.timesDipped);
            tag.putInt("timesDippedMax", this.timesDippedMax);
            tag.putInt("fluidConsumptionAmount", this.fluidConsumptionAmount);
            if (!this.output.isEmpty()) {
                tag.put("output", this.output.save(registries));
            }
            return tag;
        }

        public void load(CompoundTag tag, HolderLookup.Provider registries) {
            this.state = DipperState.byId(tag.getInt("state"));
            this.dippingTicks = tag.getInt("dippingTicks");
            this.dippingTicksMax = tag.getInt("dippingTicksMax");
            this.dryingTicks = tag.getInt("dryingTicks");
            this.dryingTicksMax = tag.getInt("dryingTicksMax");
            this.timesDipped = tag.getInt("timesDipped");
            this.timesDippedMax = tag.getInt("timesDippedMax");
            this.fluidConsumptionAmount = tag.getInt("fluidConsumptionAmount");
            if (tag.contains("output")) {
                this.output = ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("output")).orElse(ItemStack.EMPTY);
            }
        }
    }

    public static enum DipperState {
        DRYING,
        DUNKING,
        FINISHED,
        NON;


        public static DipperState byId(int id) {
            DipperState[] type = DipperState.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }
    }
}

