/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.data.books.HexereiBookItem;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.data_components.BookData;
import net.joefoxe.hexerei.sounds.ModSounds;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.BookBookmarkDeleteToServer;
import net.joefoxe.hexerei.util.message.BookBookmarkPageToServer;
import net.joefoxe.hexerei.util.message.BookBookmarkSwapToServer;
import net.joefoxe.hexerei.util.message.BookSyncDataPacket;
import net.joefoxe.hexerei.util.message.BookTurnPageToServer;
import net.joefoxe.hexerei.util.message.ClientboundBookDataUpdate;
import net.joefoxe.hexerei.util.message.ClientboundBookTurnPage;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BookOfShadowsAltarTile
extends RandomizableContainerBlockEntity
implements Clearable,
MenuProvider {
    public final ItemStackHandler itemHandler = this.createHandler();
    private final Optional<IItemHandler> handler = Optional.of(this.itemHandler);
    public BookData currentBook;
    public PageDrawing drawing = new PageDrawing(this);
    public float bookYaw = 0.0f;
    public float bookYawO = 0.0f;
    public float bookYawIncrement = 0.0f;
    public float degreesSpun = 0.0f;
    public float degreesSpunOld;
    public float degreesSpunTo = 0.0f;
    public float degreesSpunRender = 0.0f;
    public float degreesSpunSpeed = 0.0f;
    public float degreesOpened = 90.0f;
    public float openedPercent = 1.0f;
    public float openedPercentOld = 1.0f;
    public float degreesOpenedTo = 1.0f;
    public float degreesOpenedRender = 90.0f;
    public float degreesOpenedSpeed = 0.0f;
    public float floppedPercent = 1.0f;
    public float floppedPercentOld = 1.0f;
    public float degreesFlopped = 90.0f;
    public float degreesFloppedTo = 1.0f;
    public float degreesFloppedRender = 90.0f;
    public float degreesFloppedSpeed = 0.0f;
    public boolean drawTooltip = false;
    public float tooltipScale = 0.0f;
    public float tooltipScaleOld = 0.0f;
    public int turnPage = 0;
    public int turnToPage;
    public int turnToChapter;
    public float buttonScale = 1.0f;
    public float buttonScaleOld;
    public float buttonScaleTo = 1.0f;
    public float buttonScaleRender = 1.0f;
    public float buttonScaleSpeed = 0.0f;
    public float bookmarkSelectorScale = 0.0f;
    public float pageOneRotation = 0.0f;
    public float pageTwoRotation = 0.0f;
    public float pageOneRotationLast = 0.0f;
    public float pageTwoRotationLast = 0.0f;
    public float pageOneRotationTo = 0.0f;
    public float pageTwoRotationTo = 0.0f;
    public float pageOneRotationRender = 0.0f;
    public float pageTwoRotationRender = 0.0f;
    public float pageOneRotationSpeed = 0.0f;
    public float pageTwoRotationSpeed = 0.0f;
    public float numberOfCandles;
    public float maxCandles = 3.0f;
    public BlockPos candlePos1;
    public BlockPos candlePos2;
    public BlockPos candlePos3;
    public int candlePos1Slot = 0;
    public int candlePos2Slot = 0;
    public int candlePos3Slot = 0;
    public float degreesSpunCandles;
    public float tickCount;
    public Vec3 closestPlayerPos;
    public Player closestPlayer;
    public double closestDist;
    public final double maxDist = 5.0;
    public int slotClicked = -1;
    public int slotClickedTick = 0;
    public boolean fromItem = false;

    public BookOfShadowsAltarTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                BookOfShadowsAltarTile.this.setChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (tag, registryAccess) -> this.getUpdateTag((HolderLookup.Provider)registryAccess));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public void setChanged() {
        super.setChanged();
        this.sync();
    }

    public void sync() {
        if (this.level != null) {
            if (!this.level.isClientSide) {
                CompoundTag tag = new CompoundTag();
                this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
                HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new TESyncPacket(this.worldPosition, tag));
            }
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 2);
            }
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        return tag;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inv", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putFloat("degreesSpun", this.degreesSpun);
        tag.putFloat("floppedPercent", this.floppedPercent);
        tag.putFloat("openedPercent", this.openedPercent);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inv"));
        if (this.currentBook == null) {
            this.currentBook = (BookData)this.itemHandler.getStackInSlot(0).get(ModDataComponents.BOOK);
        }
        this.degreesSpunRender = this.degreesSpun = tag.getFloat("degreesSpun");
        this.bookYaw = this.degreesSpun;
        this.floppedPercentOld = this.floppedPercent = tag.getFloat("floppedPercent");
        this.openedPercentOld = this.openedPercent = tag.getFloat("openedPercent");
    }

    public boolean interact(Player player, InteractionHand handIn, ItemStack stackIn) {
        ItemStack stack = this.itemHandler.getStackInSlot(0).copy();
        if (!player.isShiftKeyDown()) {
            BookData bookData;
            if (stack.isEmpty()) {
                Random rand = new Random();
                if (!stackIn.isEmpty()) {
                    this.itemHandler.setStackInSlot(0, stackIn);
                    this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                    player.setItemInHand(handIn, ItemStack.EMPTY);
                    BookData bookData2 = (BookData)stackIn.get(ModDataComponents.BOOK);
                    if (stackIn.getItem() instanceof HexereiBookItem) {
                        if (bookData2 != null) {
                            this.turnToChapter = bookData2.getChapter();
                            this.turnToPage = bookData2.getPage();
                            this.closestDist = BookOfShadowsAltarTile.getDistanceToEntity((Entity)player, this.worldPosition);
                            this.closestPlayerPos = player.position();
                            this.closestPlayer = player;
                            this.degreesSpun = 270.0f - this.getAngle(this.closestPlayerPos);
                            this.degreesSpunTo = 270.0f - this.getAngle(this.closestPlayerPos);
                            this.degreesSpunRender = 270.0f - this.getAngle(this.closestPlayerPos);
                        }
                        this.setChanged();
                    }
                    return true;
                }
            } else if (stack.getItem() instanceof HexereiBookItem && (bookData = (BookData)stack.get(ModDataComponents.BOOK)) != null && !bookData.isOpened() && this.openedPercent == 1.0f) {
                this.level.playSound(null, this.worldPosition.above(), (SoundEvent)ModSounds.BOOK_OPENING.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.25f + 0.75f);
                bookData = bookData.setOpened(true);
                stack.set(ModDataComponents.BOOK, (Object)bookData);
                this.itemHandler.setStackInSlot(0, stack);
                HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new ClientboundBookDataUpdate(this, bookData));
                this.setChanged();
                return true;
            }
        }
        if (!stack.isEmpty()) {
            if (stack.getItem() instanceof HexereiBookItem && !player.isShiftKeyDown()) {
                return false;
            }
            this.setChanged();
            if (player.getItemInHand(handIn).isEmpty()) {
                player.setItemInHand(handIn, this.itemHandler.getStackInSlot(0).copy());
            } else {
                player.getInventory().placeItemBackInInventory(this.itemHandler.getStackInSlot(0).copy());
            }
            this.resetBookRotations();
            this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.4f + 1.0f);
            this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
            this.setChanged();
            return true;
        }
        return false;
    }

    public void resetBookRotations() {
        this.floppedPercent = 1.0f;
        this.degreesFlopped = 90.0f;
        this.degreesFloppedRender = 90.0f;
        this.openedPercent = 1.0f;
        this.degreesOpened = 90.0f;
        this.degreesOpenedRender = 90.0f;
        this.degreesSpun = 0.0f;
        this.degreesSpunRender = 0.0f;
        this.degreesSpunTo = 0.0f;
        this.pageOneRotation = 0.0f;
        this.pageOneRotationTo = 0.0f;
        this.pageOneRotationRender = 0.0f;
        this.pageTwoRotation = 0.0f;
        this.pageTwoRotationTo = 0.0f;
        this.pageTwoRotationRender = 0.0f;
        this.turnPage = 0;
        this.turnToPage = 0;
        this.turnToChapter = 0;
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
    }

    public void onLoad() {
        super.onLoad();
    }

    protected Component getDefaultName() {
        return null;
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return null;
    }

    protected NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        return items;
    }

    public ItemStack removeItem(int p_59613_, int p_59614_) {
        ItemStack itemstack;
        this.unpackLootTable(null);
        ItemStack itemStack = itemstack = p_59613_ >= 0 && p_59613_ < this.itemHandler.getSlots() && !this.itemHandler.getStackInSlot(p_59613_).isEmpty() && p_59614_ > 0 ? ((ItemStack)this.getItems().get(p_59613_)).split(p_59614_) : ItemStack.EMPTY;
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int p_59630_) {
        this.unpackLootTable(null);
        if (p_59630_ >= 0 && p_59630_ < this.itemHandler.getSlots()) {
            this.itemHandler.setStackInSlot(p_59630_, ItemStack.EMPTY);
            return this.itemHandler.getStackInSlot(p_59630_);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getItem(int p_59611_) {
        this.unpackLootTable(null);
        return this.itemHandler.getStackInSlot(p_59611_);
    }

    public void setItem(int p_59616_, ItemStack p_59617_) {
        this.unpackLootTable(null);
        this.itemHandler.setStackInSlot(p_59616_, p_59617_);
        if (p_59617_.getCount() > this.getMaxStackSize()) {
            p_59617_.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    protected void setItems(NonNullList<ItemStack> itemsIn) {
        for (int i = 0; i < Math.min(itemsIn.size(), this.itemHandler.getSlots()); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)itemsIn.get(i));
        }
    }

    public void clearContent() {
        super.clearContent();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public BookOfShadowsAltarTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.BOOK_OF_SHADOWS_ALTAR_TILE.get(), blockPos, blockState);
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.position().x() - (double)pos.getX() - 0.5;
        double deltaY = entity.position().y() - (double)pos.getY() - 0.5;
        double deltaZ = entity.position().z() - (double)pos.getZ() - 0.5;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistance(float x1, float y1, float x2, float y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.z() - (double)this.worldPosition.getZ() - 0.5, pos.x() - (double)this.worldPosition.getX() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private boolean getCandle(Level world, BlockPos pos) {
        return world.getBlockEntity(pos) instanceof CandleTile;
    }

    public static float easeFlop(float x) {
        return x < 0.5f ? (float)Math.pow(2.0, 20.0f * x - 10.0f) / 2.0f : (float)(2.0 - Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0f;
    }

    public static float easeOpened(float x) {
        float c1 = 1.0f;
        float c2 = c1 * 1.525f;
        return x < 0.5f ? (float)(Math.pow(2.0f * x, 2.0) * (double)((c2 + 1.0f) * 2.0f * x - c2)) / 2.0f : (float)(2.0 - Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0f;
    }

    public static float easeButtons(float x) {
        float c1 = 1.70158f;
        float c2 = c1 * 1.525f;
        return (double)x < 0.5 ? (float)(Math.pow(2.0f * x, 2.0) * (double)((c2 + 1.0f) * 2.0f * x - c2)) / 2.0f : (float)(Math.pow(2.0f * x - 2.0f, 2.0) * (double)((c2 + 1.0f) * (x * 2.0f - 2.0f) + c2) + 2.0) / 2.0f;
    }

    public void tickCandles() {
        Object candleData;
        Object candleData22;
        BlockEntity l2;
        this.tickCount += 1.0f;
        this.numberOfCandles = 0.0f;
        this.candlePos1 = new BlockPos(0, 0, 0);
        this.candlePos2 = new BlockPos(0, 0, 0);
        this.candlePos3 = new BlockPos(0, 0, 0);
        for (int k = -1; k <= 1; ++k) {
            for (int l2 = -1; l2 <= 1; ++l2) {
                BlockEntity i6;
                BlockEntity i22;
                BlockEntity i32;
                BlockEntity i42;
                CandleTile candleTile;
                if (k == 0 && l2 == 0) continue;
                BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.offset(l2 * 2, 0, k * 2));
                if (blockEntity instanceof CandleTile) {
                    candleTile = (CandleTile)blockEntity;
                    if (this.numberOfCandles < this.maxCandles) {
                        for (int i42 = 0; i42 < candleTile.getNumberOfCandles(); ++i42) {
                            if (!(i42 == 0 && ((CandleData)candleTile.candles.get((int)0)).lit || i42 == 1 && ((CandleData)candleTile.candles.get((int)1)).lit || i42 == 2 && ((CandleData)candleTile.candles.get((int)2)).lit) && (i42 != 3 || !((CandleData)candleTile.candles.get((int)3)).lit)) continue;
                            if (this.numberOfCandles == 0.0f) {
                                this.candlePos1 = this.worldPosition.offset(l2 * 2, 0, k * 2);
                                this.candlePos1Slot = i42;
                            }
                            if (this.numberOfCandles == 1.0f) {
                                this.candlePos2 = this.worldPosition.offset(l2 * 2, 0, k * 2);
                                this.candlePos2Slot = i42;
                            }
                            if (this.numberOfCandles == 2.0f) {
                                this.candlePos3 = this.worldPosition.offset(l2 * 2, 0, k * 2);
                                this.candlePos3Slot = i42;
                            }
                            this.numberOfCandles += 1.0f;
                        }
                    }
                }
                if ((i42 = this.level.getBlockEntity(this.worldPosition.offset(l2 * 2, 1, k * 2))) instanceof CandleTile) {
                    candleTile = (CandleTile)i42;
                    if (this.numberOfCandles < this.maxCandles) {
                        for (int i5 = 0; i5 < candleTile.getNumberOfCandles(); ++i5) {
                            if (!(i5 == 0 && ((CandleData)candleTile.candles.get((int)0)).lit || i5 == 1 && ((CandleData)candleTile.candles.get((int)1)).lit || i5 == 2 && ((CandleData)candleTile.candles.get((int)2)).lit) && (i5 != 3 || !((CandleData)candleTile.candles.get((int)3)).lit)) continue;
                            if (this.numberOfCandles == 0.0f) {
                                this.candlePos1 = this.worldPosition.offset(l2 * 2, 1, k * 2);
                                this.candlePos1Slot = i5;
                            }
                            if (this.numberOfCandles == 1.0f) {
                                this.candlePos2 = this.worldPosition.offset(l2 * 2, 1, k * 2);
                                this.candlePos2Slot = i5;
                            }
                            if (this.numberOfCandles == 2.0f) {
                                this.candlePos3 = this.worldPosition.offset(l2 * 2, 1, k * 2);
                                this.candlePos3Slot = i5;
                            }
                            this.numberOfCandles += 1.0f;
                        }
                    }
                }
                if (l2 == 0 || k == 0) continue;
                BlockEntity i5 = this.level.getBlockEntity(this.worldPosition.offset(l2 * 2, 0, k));
                if (i5 instanceof CandleTile) {
                    candleTile = (CandleTile)i5;
                    if (this.numberOfCandles < this.maxCandles) {
                        for (int i32 = 0; i32 < candleTile.getNumberOfCandles(); ++i32) {
                            if (!(i32 == 0 && ((CandleData)candleTile.candles.get((int)0)).lit || i32 == 1 && ((CandleData)candleTile.candles.get((int)1)).lit || i32 == 2 && ((CandleData)candleTile.candles.get((int)2)).lit) && (i32 != 3 || !((CandleData)candleTile.candles.get((int)3)).lit)) continue;
                            if (this.numberOfCandles == 0.0f) {
                                this.candlePos1 = this.worldPosition.offset(l2 * 2, 0, k);
                                this.candlePos1Slot = i32;
                            }
                            if (this.numberOfCandles == 1.0f) {
                                this.candlePos2 = this.worldPosition.offset(l2 * 2, 0, k);
                                this.candlePos2Slot = i32;
                            }
                            if (this.numberOfCandles == 2.0f) {
                                this.candlePos3 = this.worldPosition.offset(l2 * 2, 0, k);
                                this.candlePos3Slot = i32;
                            }
                            this.numberOfCandles += 1.0f;
                        }
                    }
                }
                if ((i32 = this.level.getBlockEntity(this.worldPosition.offset(l2 * 2, 1, k))) instanceof CandleTile) {
                    candleTile = (CandleTile)i32;
                    if (this.numberOfCandles < this.maxCandles) {
                        for (int i22 = 0; i22 < candleTile.getNumberOfCandles(); ++i22) {
                            if (!(i22 == 0 && ((CandleData)candleTile.candles.get((int)0)).lit || i22 == 1 && ((CandleData)candleTile.candles.get((int)1)).lit || i22 == 2 && ((CandleData)candleTile.candles.get((int)2)).lit) && (i22 != 3 || !((CandleData)candleTile.candles.get((int)3)).lit)) continue;
                            if (this.numberOfCandles == 0.0f) {
                                this.candlePos1 = this.worldPosition.offset(l2 * 2, 1, k);
                                this.candlePos1Slot = i22;
                            }
                            if (this.numberOfCandles == 1.0f) {
                                this.candlePos2 = this.worldPosition.offset(l2 * 2, 1, k);
                                this.candlePos2Slot = i22;
                            }
                            if (this.numberOfCandles == 2.0f) {
                                this.candlePos3 = this.worldPosition.offset(l2 * 2, 1, k);
                                this.candlePos3Slot = i22;
                            }
                            this.numberOfCandles += 1.0f;
                        }
                    }
                }
                if ((i22 = this.level.getBlockEntity(this.worldPosition.offset(l2, 0, k * 2))) instanceof CandleTile) {
                    candleTile = (CandleTile)i22;
                    if (this.numberOfCandles < this.maxCandles) {
                        for (int i6 = 0; i6 < candleTile.getNumberOfCandles(); ++i6) {
                            if (!(i6 == 0 && ((CandleData)candleTile.candles.get((int)0)).lit || i6 == 1 && ((CandleData)candleTile.candles.get((int)1)).lit || i6 == 2 && ((CandleData)candleTile.candles.get((int)2)).lit) && (i6 != 3 || !((CandleData)candleTile.candles.get((int)3)).lit)) continue;
                            if (this.numberOfCandles == 0.0f) {
                                this.candlePos1 = this.worldPosition.offset(l2, 0, k * 2);
                                this.candlePos1Slot = i6;
                            }
                            if (this.numberOfCandles == 1.0f) {
                                this.candlePos2 = this.worldPosition.offset(l2, 0, k * 2);
                                this.candlePos2Slot = i6;
                            }
                            if (this.numberOfCandles == 2.0f) {
                                this.candlePos3 = this.worldPosition.offset(l2, 0, k * 2);
                                this.candlePos3Slot = i6;
                            }
                            this.numberOfCandles += 1.0f;
                        }
                    }
                }
                if (!((i6 = this.level.getBlockEntity(this.worldPosition.offset(l2, 1, k * 2))) instanceof CandleTile)) continue;
                candleTile = (CandleTile)i6;
                if (!(this.numberOfCandles < this.maxCandles)) continue;
                for (int i7 = 0; i7 < candleTile.getNumberOfCandles(); ++i7) {
                    if (!(i7 == 0 && ((CandleData)candleTile.candles.get((int)0)).lit || i7 == 1 && ((CandleData)candleTile.candles.get((int)1)).lit || i7 == 2 && ((CandleData)candleTile.candles.get((int)2)).lit) && (i7 != 3 || !((CandleData)candleTile.candles.get((int)3)).lit)) continue;
                    if (this.numberOfCandles == 0.0f) {
                        this.candlePos1 = this.worldPosition.offset(l2, 1, k * 2);
                        this.candlePos1Slot = i7;
                    }
                    if (this.numberOfCandles == 1.0f) {
                        this.candlePos2 = this.worldPosition.offset(l2, 1, k * 2);
                        this.candlePos2Slot = i7;
                    }
                    if (this.numberOfCandles == 2.0f) {
                        this.candlePos3 = this.worldPosition.offset(l2, 1, k * 2);
                        this.candlePos3Slot = i7;
                    }
                    this.numberOfCandles += 1.0f;
                }
            }
        }
        this.degreesSpunCandles = HexereiUtil.moveToAngle(this.degreesSpunCandles, this.degreesSpunCandles + 1.0f, 0.025f);
        if (this.numberOfCandles >= 1.0f && (l2 = this.level.getBlockEntity(this.candlePos1)) instanceof CandleTile) {
            CandleTile candle = (CandleTile)l2;
            CandleData candleData22 = (CandleData)candle.candles.get(this.candlePos1Slot);
            candleData22.setNotReturn((int)this.tickCount);
            candleData22.xTarget = (float)(this.worldPosition.getX() - this.candlePos1.getX()) + (float)Math.sin(this.degreesSpunCandles) * 1.25f;
            candleData22.yTarget = (float)(this.worldPosition.getY() - this.candlePos1.getY()) + 1.0f + (float)Math.sin(this.tickCount / 20.0f) / 10.0f;
            candleData22.zTarget = (float)(this.worldPosition.getZ() - this.candlePos1.getZ()) + (float)Math.cos(this.degreesSpunCandles) * 1.25f;
        }
        if (this.numberOfCandles >= 2.0f && (candleData22 = this.level.getBlockEntity(this.candlePos2)) instanceof CandleTile) {
            CandleTile candle = (CandleTile)((Object)candleData22);
            candleData22 = (CandleData)candle.candles.get(this.candlePos2Slot);
            ((CandleData)candleData22).setNotReturn((int)this.tickCount);
            ((CandleData)candleData22).xTarget = (float)(this.worldPosition.getX() - this.candlePos2.getX()) + (float)Math.sin((double)this.degreesSpunCandles + (this.numberOfCandles == 2.0f ? Math.PI : 2.0943951023931953)) * 1.25f;
            ((CandleData)candleData22).yTarget = (float)(this.worldPosition.getY() - this.candlePos2.getY()) + 1.0f + (float)Math.sin((this.tickCount + 10.0f) / 20.0f) / 10.0f;
            ((CandleData)candleData22).zTarget = (float)(this.worldPosition.getZ() - this.candlePos2.getZ()) + (float)Math.cos((double)this.degreesSpunCandles + (this.numberOfCandles == 2.0f ? Math.PI : 2.0943951023931953)) * 1.25f;
        }
        if (this.numberOfCandles >= 3.0f && (candleData = this.level.getBlockEntity(this.candlePos3)) instanceof CandleTile) {
            CandleTile candle = (CandleTile)((Object)candleData);
            candleData = (CandleData)candle.candles.get(this.candlePos3Slot);
            ((CandleData)candleData).setNotReturn((int)this.tickCount);
            ((CandleData)candleData).xTarget = (float)(this.worldPosition.getX() - this.candlePos3.getX()) + (float)Math.sin((double)this.degreesSpunCandles + 4.1887902047863905) * 1.25f;
            ((CandleData)candleData).yTarget = (float)(this.worldPosition.getY() - this.candlePos3.getY()) + 1.0f + (float)Math.sin((this.tickCount + 20.0f) / 20.0f) / 10.0f;
            ((CandleData)candleData).zTarget = (float)(this.worldPosition.getZ() - this.candlePos3.getZ()) + (float)Math.cos((double)this.degreesSpunCandles + 4.1887902047863905) * 1.25f;
        }
    }

    public void tickBook(ItemStack stack) {
        this.tickBook(stack, false);
    }

    public static int snapToCardinalDirection(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        int[] directions = new int[]{0, 45, 90, 135, 180, 225, 270, 315, 360};
        int closestDirection = 0;
        float smallestDifference = 360.0f;
        for (int direction : directions) {
            float difference = Math.abs(angle - (float)direction);
            if (!(difference < smallestDifference)) continue;
            smallestDifference = difference;
            closestDirection = direction;
        }
        if (closestDirection == 360) {
            closestDirection = 0;
        }
        return closestDirection;
    }

    public void tickBook(ItemStack stack, boolean fromItem) {
        if (stack.getItem() instanceof HexereiBookItem) {
            BookData bookData1;
            boolean opened;
            if (this.slotClicked != -1) {
                ++this.slotClickedTick;
            }
            BookData bookData = fromItem || this.level.isClientSide ? this.currentBook : (BookData)stack.get(ModDataComponents.BOOK);
            this.pageOneRotationLast = this.pageOneRotation;
            this.pageTwoRotationLast = this.pageTwoRotation;
            boolean bl = opened = bookData != null && bookData.isOpened();
            if (opened) {
                this.buttonScaleRender = this.buttonScale = HexereiUtil.moveTo(this.buttonScale, this.buttonScaleTo, this.buttonScaleSpeed);
                this.bookmarkSelectorScale = this.slotClicked != -1 && this.slotClickedTick > 5 ? HexereiUtil.moveTo(this.bookmarkSelectorScale, 1.0f, 0.15f * (this.bookmarkSelectorScale + 0.25f)) : 0.0f;
                if (this.closestPlayerPos != null || fromItem) {
                    if (!fromItem && (this.level.isClientSide ? this.degreesFloppedRender < 81.0f : this.floppedPercent < 0.9f)) {
                        Vec3 playerPos = this.closestPlayerPos;
                        double dx = playerPos.x - (double)this.getBlockPos().getX() - 0.5;
                        double dz = playerPos.z - (double)this.getBlockPos().getZ() - 0.5;
                        float yaw = 270.0f - (float)(Math.atan2(dz, dx) * 57.29577951308232);
                        yaw = BookOfShadowsAltarTile.snapToCardinalDirection(yaw);
                        this.bookYawIncrement = this.updateIncrement(this.bookYaw, yaw, this.bookYawIncrement);
                        this.bookYaw = this.updateAngle(this.bookYaw, this.bookYawIncrement);
                    }
                    this.degreesFloppedTo = 0.0f;
                    this.degreesFloppedSpeed = (3.0f + 6.0f * Math.abs(this.floppedPercent - 0.66f)) / 90.0f / 2.0f;
                    this.degreesOpenedTo = 0.0f;
                    this.degreesOpenedSpeed = (2.0f + 5.0f * (0.5f - Math.abs(0.5f - this.openedPercent))) / 90.0f / 2.0f;
                } else {
                    this.degreesOpenedTo = 1.0f;
                    this.degreesOpenedSpeed = (2.0f + 6.0f * (0.5f - Math.abs(0.5f - this.openedPercent))) / 90.0f / 2.0f;
                    this.degreesFloppedTo = 1.0f;
                    this.degreesFloppedSpeed = (2.0f + 4.0f * (0.5f - Math.abs(0.5f - this.floppedPercent))) / 90.0f / 2.0f;
                }
                this.degreesSpun = this.bookYaw;
                this.floppedPercent = HexereiUtil.moveTo(this.floppedPercent, this.degreesFloppedTo, this.degreesFloppedSpeed);
                this.degreesFlopped = this.floppedPercent * 90.0f;
                this.openedPercent = HexereiUtil.moveTo(this.openedPercent, this.degreesOpenedTo, this.degreesOpenedSpeed);
                this.degreesOpened = BookOfShadowsAltarTile.easeOpened(this.openedPercent) * 90.0f;
                if (this.turnPage == 1) {
                    if (this.pageOneRotation == 180.0f) {
                        bookData = this.clickedNext(bookData, 1);
                        this.pageOneRotationRender = 0.0f;
                        this.pageOneRotation = 0.0f;
                        this.pageOneRotationTo = 0.0f;
                        this.turnPage = 0;
                        this.pageOneRotationLast = this.pageOneRotation;
                    } else {
                        if (this.pageOneRotation == 0.0f) {
                            if (fromItem) {
                                if (EffectiveSide.get().isClient()) {
                                    ClientSounds.playTurnPageSound();
                                }
                            } else if (!this.level.isClientSide) {
                                this.level.playSound(null, this.worldPosition.above(), (SoundEvent)ModSounds.BOOK_TURN_PAGE_SLOW.get(), SoundSource.BLOCKS, this.level.random.nextFloat() * 0.25f + 0.5f, this.level.random.nextFloat() * 0.25f + 0.75f);
                            }
                        }
                        float f = (float)Math.sin((double)(this.pageOneRotation / 180.0f) * Math.PI);
                        this.pageOneRotationSpeed = f * f * 35.0f + 10.0f;
                        this.pageOneRotationTo = 180.0f;
                    }
                } else if (this.turnPage == 2) {
                    if (this.pageTwoRotation == 180.0f) {
                        bookData = this.clickedBack(bookData, 1);
                        this.pageTwoRotationRender = 0.0f;
                        this.pageTwoRotation = 0.0f;
                        this.pageTwoRotationTo = 0.0f;
                        this.pageTwoRotationLast = this.pageTwoRotation;
                        this.turnPage = 0;
                    } else {
                        if (this.pageTwoRotation == 0.0f) {
                            if (fromItem) {
                                if (EffectiveSide.get().isClient()) {
                                    ClientSounds.playTurnPageSound();
                                }
                            } else if (!this.level.isClientSide) {
                                this.level.playSound(null, this.worldPosition.above(), (SoundEvent)ModSounds.BOOK_TURN_PAGE_SLOW.get(), SoundSource.BLOCKS, this.level.random.nextFloat() * 0.25f + 0.5f, this.level.random.nextFloat() * 0.25f + 0.75f);
                            }
                        }
                        float f = (float)Math.sin((double)(this.pageTwoRotation / 180.0f) * Math.PI);
                        this.pageTwoRotationSpeed = f * f * 35.0f + 10.0f;
                        this.pageTwoRotationTo = 180.0f;
                    }
                } else if (this.turnPage == -1) {
                    BookEntries bookEntries = BookManager.getBookEntries(this.currentBook.getBook());
                    if (bookEntries != null) {
                        float f;
                        int pagesToTurn;
                        int chapter = bookData.getChapter();
                        int page = bookData.getPage();
                        int pageOnNum = bookEntries.chapterList.get((int)chapter).startPage + page;
                        if (this.turnToChapter >= bookEntries.chapterList.size()) {
                            this.turnToChapter = bookEntries.chapterList.size() - 1;
                        }
                        if (this.turnToPage >= bookEntries.chapterList.get((int)this.turnToChapter).pages.size()) {
                            this.turnToPage = bookEntries.chapterList.get((int)this.turnToChapter).pages.size() - 1;
                        }
                        int destPageNum = bookEntries.chapterList.get((int)this.turnToChapter).startPage + this.turnToPage;
                        int numPagesToDest = Math.abs(destPageNum - pageOnNum);
                        if (page % 2 == 1) {
                            --page;
                        }
                        int n = numPagesToDest > 90 ? 13 : (numPagesToDest > 75 ? 11 : (numPagesToDest > 60 ? 9 : (numPagesToDest > 45 ? 7 : (numPagesToDest > 30 ? 5 : (pagesToTurn = numPagesToDest > 15 ? 3 : 1)))));
                        if (chapter > this.turnToChapter || chapter == this.turnToChapter && page > this.turnToPage) {
                            if (this.pageTwoRotation == 180.0f) {
                                bookData = this.clickedBack(bookData, pagesToTurn);
                                this.pageTwoRotation = 0.0f;
                                this.pageTwoRotationRender = 0.0f;
                                this.pageTwoRotationLast = this.pageTwoRotation;
                                this.pageTwoRotationTo = 0.0f;
                                this.pageTwoRotationSpeed = 0.01f;
                            } else {
                                if (this.pageTwoRotation == 0.0f && numPagesToDest > 1) {
                                    if (fromItem) {
                                        if (EffectiveSide.get().isClient()) {
                                            ClientSounds.playTurnPageFastSound();
                                        }
                                    } else if (!this.level.isClientSide) {
                                        this.level.playSound(null, this.worldPosition.above(), (SoundEvent)ModSounds.BOOK_TURN_PAGE_FAST.get(), SoundSource.BLOCKS, this.level.random.nextFloat() * 0.25f + 0.5f, this.level.random.nextFloat() * 0.3f + 0.7f);
                                    }
                                }
                                f = 1.0f + (float)Math.min(numPagesToDest, 50) / 200.0f;
                                this.pageTwoRotationSpeed = 65.0f * f * f + 15.0f;
                                this.pageTwoRotationTo = 180.0f;
                            }
                        }
                        if (chapter < this.turnToChapter || chapter == this.turnToChapter && page < this.turnToPage) {
                            if (this.pageOneRotation == 180.0f) {
                                bookData = this.clickedNext(bookData, pagesToTurn);
                                this.pageOneRotation = 0.0f;
                                this.pageOneRotationRender = 0.0f;
                                this.pageOneRotationTo = 0.0f;
                                this.pageOneRotationLast = this.pageOneRotation;
                                this.pageOneRotationSpeed = 0.01f;
                            } else {
                                if (this.pageOneRotation == 0.0f && numPagesToDest > 0) {
                                    if (fromItem) {
                                        if (EffectiveSide.get().isClient()) {
                                            ClientSounds.playTurnPageFastSound();
                                        }
                                    } else if (!this.level.isClientSide) {
                                        this.level.playSound(null, this.worldPosition.above(), (SoundEvent)ModSounds.BOOK_TURN_PAGE_FAST.get(), SoundSource.BLOCKS, this.level.random.nextFloat() * 0.3f + 0.7f, this.level.random.nextFloat() * 0.25f + 0.5f);
                                    }
                                }
                                f = 1.0f + (float)Math.min(numPagesToDest, 50) / 200.0f;
                                this.pageOneRotationSpeed = 65.0f * f * f + 15.0f;
                                this.pageOneRotationTo = 180.0f;
                            }
                        }
                        if (chapter == this.turnToChapter && (page == this.turnToPage || page + 1 == this.turnToPage)) {
                            this.turnPage = 0;
                            this.pageTwoRotation = 0.0f;
                            this.pageTwoRotationTo = 0.0f;
                            this.pageTwoRotationRender = 0.0f;
                            this.pageTwoRotationSpeed = 0.01f;
                            this.pageOneRotation = 0.0f;
                            this.pageOneRotationTo = 0.0f;
                            this.pageOneRotationRender = 0.0f;
                            this.pageOneRotationSpeed = 0.01f;
                            this.pageTwoRotationLast = this.pageTwoRotation;
                            this.pageOneRotationLast = this.pageOneRotation;
                        }
                    }
                } else if (this.turnPage == 0) {
                    this.currentBook = (BookData)this.itemHandler.getStackInSlot(0).get(ModDataComponents.BOOK);
                    this.pageTwoRotation = 0.0f;
                    this.pageTwoRotationTo = 0.0f;
                    this.pageTwoRotationRender = 0.0f;
                    this.pageTwoRotationSpeed = 0.01f;
                    this.pageOneRotation = 0.0f;
                    this.pageOneRotationTo = 0.0f;
                    this.pageOneRotationRender = 0.0f;
                    this.pageOneRotationSpeed = 0.01f;
                    this.pageTwoRotationLast = this.pageTwoRotation;
                    this.pageOneRotationLast = this.pageOneRotation;
                }
                this.pageOneRotation = HexereiUtil.moveTo(this.pageOneRotation, this.pageOneRotationTo, this.pageOneRotationSpeed);
                this.pageTwoRotation = HexereiUtil.moveTo(this.pageTwoRotation, this.pageTwoRotationTo, this.pageTwoRotationSpeed);
            } else {
                this.currentBook = (BookData)this.itemHandler.getStackInSlot(0).get(ModDataComponents.BOOK);
                this.degreesOpenedTo = 1.0f;
                this.degreesOpenedSpeed = (2.0f + 6.0f * Math.abs(0.5f - this.openedPercent)) / 90.0f / 2.0f;
                this.openedPercent = HexereiUtil.moveTo(this.openedPercent, this.degreesOpenedTo, this.degreesOpenedSpeed);
                this.degreesOpened = BookOfShadowsAltarTile.easeOpened(this.openedPercent) * 90.0f;
                if (this.openedPercent > 0.2f) {
                    this.degreesFloppedTo = 1.0f;
                    this.degreesFloppedSpeed = (2.0f + 7.0f * (0.5f - Math.abs(0.5f - this.floppedPercent))) / 90.0f / 2.0f;
                }
                this.floppedPercent = HexereiUtil.moveTo(this.floppedPercent, this.degreesFloppedTo, this.degreesFloppedSpeed);
                this.degreesFlopped = this.floppedPercent * 90.0f;
            }
            BookData bookData2 = bookData1 = fromItem || this.level.isClientSide ? this.currentBook : (BookData)this.itemHandler.getStackInSlot(0).get(ModDataComponents.BOOK);
            if (bookData1 != bookData) {
                if (!fromItem && !this.level.isClientSide) {
                    ItemStack stack1 = this.itemHandler.getStackInSlot(0).copy();
                    stack1.set(ModDataComponents.BOOK, (Object)bookData);
                    this.itemHandler.setStackInSlot(0, stack1);
                } else {
                    this.currentBook = bookData;
                }
            }
        } else {
            this.currentBook = null;
            this.floppedPercent = 1.0f;
            this.degreesFlopped = 90.0f;
            this.degreesFloppedRender = 90.0f;
            this.openedPercent = 1.0f;
            this.degreesOpened = 90.0f;
            this.degreesOpenedRender = 90.0f;
            this.degreesSpun = 0.0f;
            this.degreesSpunRender = 0.0f;
            this.degreesSpunTo = 0.0f;
            this.pageOneRotation = 0.0f;
            this.pageOneRotationTo = 0.0f;
            this.pageOneRotationRender = 0.0f;
            this.pageTwoRotation = 0.0f;
            this.pageTwoRotationTo = 0.0f;
            this.pageTwoRotationRender = 0.0f;
        }
    }

    public void tickClient() {
        this.openedPercentOld = this.openedPercent;
        this.floppedPercentOld = this.floppedPercent;
        this.degreesSpunOld = this.degreesSpun;
        this.tooltipScaleOld = this.tooltipScale;
        this.buttonScaleOld = this.buttonScale;
        this.drawing.tick();
        this.tooltipScale = this.drawTooltip ? HexereiUtil.moveTo(this.tooltipScale, 1.0f, 0.075f) : HexereiUtil.moveTo(this.tooltipScale, 0.0f, 0.15f);
        ItemStack stack = this.itemHandler.getStackInSlot(0).copy();
        BookData bookData = (BookData)stack.get(ModDataComponents.BOOK);
        if (this.turnPage != 0 || bookData != null && !bookData.isOpened()) {
            this.buttonScaleSpeed = 0.1f * (this.buttonScale + 0.25f);
            this.buttonScaleTo = 0.0f;
        } else {
            this.buttonScaleSpeed = 0.15f * (this.buttonScale + 0.25f);
            this.buttonScaleTo = 1.0f;
        }
        this.closestPlayerPos = null;
    }

    public void tick() {
        double dist;
        Player playerEntity;
        if (this.level.isClientSide) {
            this.tickClient();
        }
        this.tickCandles();
        this.closestDist = 5.0;
        if (this.itemHandler.getStackInSlot(0).getItem() instanceof HexereiBookItem && (playerEntity = this.level.getNearestPlayer((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), 5.0, false)) != null && (dist = BookOfShadowsAltarTile.getDistanceToEntity((Entity)playerEntity, this.worldPosition)) < 5.0 && dist < this.closestDist) {
            this.closestDist = dist;
            this.closestPlayerPos = playerEntity.position();
            this.closestPlayer = playerEntity;
        }
        this.tickBook(this.itemHandler.getStackInSlot(0));
    }

    public float updateIncrement(float currentAngle, float targetAngle, float lastIncrement) {
        float angleDifference = (targetAngle = this.normalizeAngle(targetAngle)) - (currentAngle = this.normalizeAngle(currentAngle));
        if (angleDifference > 180.0f) {
            angleDifference -= 360.0f;
        } else if (angleDifference < -180.0f) {
            angleDifference += 360.0f;
        }
        float distance = Math.abs(angleDifference);
        if (Mth.abs((float)lastIncrement) < 0.1f && distance < 0.9f) {
            return 0.0f;
        }
        float adjustment = (distance / 180.0f * (distance / 180.0f) + 0.175f) * (float)(angleDifference > 0.0f ? 1 : -1);
        if (Mth.abs((float)lastIncrement) < 0.8f && distance < 10.0f) {
            return (lastIncrement + adjustment) * (0.72f + 0.2f * Mth.abs((float)lastIncrement) / 0.8f);
        }
        return (lastIncrement + adjustment) * 0.92f;
    }

    public float updateAngle(float currentAngle, float maxIncrement) {
        currentAngle = this.normalizeAngle(currentAngle);
        return this.normalizeAngle(currentAngle += maxIncrement);
    }

    private float normalizeAngle(float angle) {
        while (angle > 90.0f) {
            angle -= 360.0f;
        }
        while (angle < -270.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public BookData clickedNext(BookData bookData, int pages) {
        if (bookData == null) {
            return bookData;
        }
        BookEntries bookEntries = BookManager.getBookEntries(bookData.getBook());
        if (bookEntries != null) {
            for (int i = 0; i < pages; ++i) {
                int currentPage = bookData.getPage();
                int currentChapter = bookData.getChapter();
                if (currentPage < bookEntries.chapterList.get((int)currentChapter).pages.size() - 2) {
                    bookData = bookData.setPage(currentPage + 2);
                    if (currentChapter >= bookEntries.chapterList.size() - 1 || currentPage + 2 <= bookEntries.chapterList.get((int)currentChapter).pages.size() - 1) continue;
                    bookData = bookData.setChapter(++currentChapter);
                    bookData = bookData.setPage(bookEntries.chapterList.get((int)currentChapter).pages.size() - 1);
                    continue;
                }
                if (currentChapter < bookEntries.chapterList.size() - 1) {
                    bookData = bookData.setChapter(++currentChapter);
                    bookData = bookData.setPage(0);
                    continue;
                }
                bookData = bookData.setPage(bookEntries.chapterList.get((int)currentChapter).pages.size() - 1);
            }
        }
        return bookData;
    }

    public BookData clickedBack(BookData bookData, int pages) {
        if (bookData == null) {
            return bookData;
        }
        BookEntries bookEntries = BookManager.getBookEntries(bookData.getBook());
        if (bookEntries != null) {
            for (int i = 0; i < pages; ++i) {
                int currentPage = bookData.getPage();
                int currentChapter = bookData.getChapter();
                if (currentPage > 0) {
                    if (currentChapter > 0 && currentPage - 2 < 0) {
                        bookData = bookData.setChapter(--currentChapter);
                        bookData = bookData.setPage(bookEntries.chapterList.get((int)currentChapter).pages.size() - 1);
                        continue;
                    }
                    bookData = bookData.setPage(Math.max(currentPage - 2, 0));
                    continue;
                }
                if (currentChapter > 0) {
                    bookData = bookData.setChapter(--currentChapter);
                    bookData = bookData.setPage(bookEntries.chapterList.get((int)currentChapter).pages.size() - 1);
                    continue;
                }
                bookData = bookData.setPage(0);
            }
        }
        return bookData;
    }

    public void forceTurnPage(int turnPage, int chapter, int page) {
        if (this.currentBook == null) {
            return;
        }
        if (turnPage == -2) {
            turnPage += 2;
            if (EffectiveSide.get().isClient()) {
                ClientSounds.playBookCloseSound();
            }
            if (this.currentBook.isOpened()) {
                this.currentBook = this.currentBook.setOpened(false);
            }
        }
        this.turnPage = turnPage;
        this.turnToChapter = chapter;
        this.turnToPage = page;
        this.pageOneRotationRender = 0.0f;
        this.pageOneRotation = 0.0f;
        this.pageOneRotationTo = 0.0f;
        this.pageOneRotationLast = this.pageOneRotation;
        this.pageTwoRotationRender = 0.0f;
        this.pageTwoRotation = 0.0f;
        this.pageTwoRotationTo = 0.0f;
        this.pageTwoRotationLast = this.pageTwoRotation;
    }

    public void setTurnPage(int turnPage, int chapter, int page) {
        if (this.fromItem) {
            this.forceTurnPage(turnPage, chapter, page);
            return;
        }
        if (this.level.isClientSide) {
            HexereiPacketHandler.sendToServer(new BookTurnPageToServer(this, turnPage, chapter, page));
            return;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0).copy();
        BookData bookData = (BookData)stack.get(ModDataComponents.BOOK);
        HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new ClientboundBookTurnPage(this, turnPage, chapter, page, bookData.getChapter(), bookData.getPage()));
        this.turnToChapter = chapter;
        this.turnToPage = page;
        boolean flag = false;
        if (turnPage == -2) {
            turnPage += 2;
            flag = true;
        }
        if (flag) {
            this.level.playSound(null, this.worldPosition.above(), (SoundEvent)ModSounds.BOOK_CLOSE.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.25f + 0.75f);
            ItemStack stack2 = this.itemHandler.getStackInSlot(0).copy();
            BookData bookData2 = (BookData)stack2.get(ModDataComponents.BOOK);
            if (bookData2 != null && bookData2.isOpened()) {
                bookData2 = bookData2.setOpened(false);
            }
            stack2.set(ModDataComponents.BOOK, (Object)bookData2);
            this.itemHandler.setStackInSlot(0, stack2);
            HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new ClientboundBookDataUpdate(this, bookData2));
        }
        this.turnPage = turnPage;
    }

    public void setTurnPage(int turnPage) {
        if (turnPage == -1) {
            this.setTurnPage(turnPage, 0, 0);
        } else {
            this.setTurnPage(turnPage, -1, -1);
        }
    }

    public void forcePageBookmark(int chapter, int page) {
        BookEntries bookEntries;
        if (EffectiveSide.get().isClient()) {
            ClientSounds.playBookmarkSound();
        }
        if (this.currentBook != null && (bookEntries = BookManager.getBookEntries(this.currentBook.getBook())) != null) {
            List<BookData.Bookmarks.Slot> slots = this.currentBook.getBookmarks().getSlots();
            boolean flag = false;
            BookData.Bookmarks.Slot firstEmpty = null;
            for (BookData.Bookmarks.Slot slot : slots) {
                if (!slot.getId().isEmpty()) {
                    if (!bookEntries.chapterList.get((int)chapter).pages.get((int)page).location.equals(slot.getId())) continue;
                    slot.setColor(DyeColor.byId((int)(slot.getColor().getId() + 1 >= DyeColor.values().length ? 0 : slot.getColor().getId() + 1)));
                    flag = true;
                    break;
                }
                if (firstEmpty != null) continue;
                firstEmpty = slot;
            }
            if (!flag && firstEmpty != null) {
                firstEmpty.setId(bookEntries.chapterList.get((int)chapter).pages.get((int)page).location);
                firstEmpty.setColor(DyeColor.values()[new Random().nextInt(DyeColor.values().length)]);
            }
        }
    }

    public void clickPageBookmark(int chapter, int page) {
        if (this.fromItem) {
            this.forcePageBookmark(chapter, page);
            return;
        }
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            HexereiPacketHandler.sendToServer(new BookBookmarkPageToServer(this, chapter, page));
        } else {
            BookEntries bookEntries;
            this.level.playSound(null, this.worldPosition.above(), (SoundEvent)ModSounds.BOOKMARK_BUTTON.get(), SoundSource.BLOCKS, 0.75f, this.level.random.nextFloat() * 0.25f + 0.75f);
            ItemStack stack = this.itemHandler.getStackInSlot(0).copy();
            BookData bookData = (BookData)stack.get(ModDataComponents.BOOK);
            if (bookData != null && (bookEntries = BookManager.getBookEntries(bookData.getBook())) != null) {
                List<BookData.Bookmarks.Slot> slots = bookData.getBookmarks().getSlots();
                boolean flag = false;
                BookData.Bookmarks.Slot firstEmpty = null;
                for (BookData.Bookmarks.Slot slot : slots) {
                    if (!slot.getId().isEmpty()) {
                        if (!bookEntries.chapterList.get((int)chapter).pages.get((int)page).location.equals(slot.getId())) continue;
                        slot.setColor(DyeColor.byId((int)(slot.getColor().getId() + 1 >= DyeColor.values().length ? 0 : slot.getColor().getId() + 1)));
                        flag = true;
                        break;
                    }
                    if (firstEmpty != null) continue;
                    firstEmpty = slot;
                }
                if (!flag && firstEmpty != null) {
                    firstEmpty.setId(bookEntries.chapterList.get((int)chapter).pages.get((int)page).location);
                    firstEmpty.setColor(DyeColor.values()[new Random().nextInt(DyeColor.values().length)]);
                }
            }
            stack.set(ModDataComponents.BOOK, (Object)bookData);
            this.itemHandler.setStackInSlot(0, stack);
            HexereiPacketHandler.sendToNearbyClient(this.level, this.getBlockPos(), (CustomPacketPayload)new BookSyncDataPacket(this.getBlockPos()));
            this.setChanged();
        }
    }

    public void forceSwapBookmarks(int slot1, int slot2) {
        if (EffectiveSide.get().isClient()) {
            ClientSounds.playBookmarkSwapSound();
        }
        ArrayList<BookData.Bookmarks.Slot> slots = new ArrayList<BookData.Bookmarks.Slot>(this.currentBook.getBookmarks().getSlots());
        BookData.Bookmarks.Slot temp = ((BookData.Bookmarks.Slot)slots.get(slot1)).copyWithIndex(slot2);
        slots.set(slot1, ((BookData.Bookmarks.Slot)slots.get(slot2)).copyWithIndex(slot1));
        slots.set(slot2, temp);
        this.currentBook = this.currentBook.setBookmarks(new BookData.Bookmarks(slots));
    }

    public void swapBookmarks(int slot1, int slot2) {
        if (this.fromItem) {
            this.forceSwapBookmarks(slot1, slot2);
            return;
        }
        if (this.level.isClientSide) {
            HexereiPacketHandler.sendToServer(new BookBookmarkSwapToServer(this, slot1, slot2));
        } else {
            this.level.playSound(null, this.worldPosition.above(), (SoundEvent)ModSounds.BOOKMARK_SWAP.get(), SoundSource.BLOCKS, 0.75f, this.level.random.nextFloat() * 0.25f + 0.75f);
            ItemStack stack = this.itemHandler.getStackInSlot(0).copy();
            BookData bookData = (BookData)stack.get(ModDataComponents.BOOK);
            if (bookData != null) {
                ArrayList<BookData.Bookmarks.Slot> slots = new ArrayList<BookData.Bookmarks.Slot>(bookData.getBookmarks().getSlots());
                BookData.Bookmarks.Slot temp = ((BookData.Bookmarks.Slot)slots.get(slot1)).copyWithIndex(slot2);
                slots.set(slot1, ((BookData.Bookmarks.Slot)slots.get(slot2)).copyWithIndex(slot1));
                slots.set(slot2, temp);
                bookData = bookData.setBookmarks(new BookData.Bookmarks(slots));
                stack.set(ModDataComponents.BOOK, (Object)bookData);
                this.itemHandler.setStackInSlot(0, stack);
                HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new ClientboundBookDataUpdate(this, bookData));
            }
            this.setChanged();
        }
    }

    public void forceDeleteBookmark(int slot1) {
        if (EffectiveSide.get().isClient()) {
            ClientSounds.playBookmarkDeleteSound();
        }
        ArrayList<BookData.Bookmarks.Slot> slots = new ArrayList<BookData.Bookmarks.Slot>(this.currentBook.getBookmarks().getSlots());
        slots.set(slot1, new BookData.Bookmarks.Slot("", DyeColor.WHITE, slot1));
        this.currentBook = this.currentBook.setBookmarks(new BookData.Bookmarks(slots));
    }

    public void deleteBookmark(int slot1) {
        if (this.fromItem) {
            this.forceDeleteBookmark(slot1);
            return;
        }
        if (this.level.isClientSide) {
            HexereiPacketHandler.sendToServer(new BookBookmarkDeleteToServer(this, slot1));
        } else {
            this.level.playSound(null, this.worldPosition.above(), (SoundEvent)ModSounds.BOOKMARK_DELETE.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.25f + 0.75f);
            ItemStack stack = this.itemHandler.getStackInSlot(0).copy();
            BookData bookData = (BookData)stack.get(ModDataComponents.BOOK);
            if (bookData != null) {
                ArrayList<BookData.Bookmarks.Slot> slots = new ArrayList<BookData.Bookmarks.Slot>(bookData.getBookmarks().getSlots());
                slots.set(slot1, new BookData.Bookmarks.Slot("", DyeColor.WHITE, slot1));
                bookData = bookData.setBookmarks(new BookData.Bookmarks(slots));
                stack.set(ModDataComponents.BOOK, (Object)bookData);
                this.itemHandler.setStackInSlot(0, stack);
                HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new ClientboundBookDataUpdate(this, bookData));
            }
            this.setChanged();
        }
    }

    public int getContainerSize() {
        return 0;
    }

    static class ClientSounds {
        ClientSounds() {
        }

        public static void playTurnPageSound() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.BOOK_TURN_PAGE_SLOW.get()), (float)(new Random().nextFloat() * 0.25f + 0.75f), (float)(0.25f * (new Random().nextFloat() * 0.25f + 0.5f))));
        }

        public static void playTurnPageFastSound() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.BOOK_TURN_PAGE_FAST.get()), (float)(new Random().nextFloat() * 0.3f + 0.7f), (float)(0.25f * (new Random().nextFloat() * 0.25f + 0.5f))));
        }

        public static void playBookCloseSound() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.BOOK_CLOSE.get()), (float)(new Random().nextFloat() * 0.25f + 0.75f)));
        }

        public static void playBookmarkSound() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.BOOKMARK_BUTTON.get()), (float)(new Random().nextFloat() * 0.25f + 0.75f)));
        }

        public static void playBookmarkSwapSound() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.BOOKMARK_SWAP.get()), (float)(new Random().nextFloat() * 0.25f + 0.75f), (float)0.1875f));
        }

        public static void playBookmarkDeleteSound() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.BOOKMARK_DELETE.get()), (float)(new Random().nextFloat() * 0.25f + 0.75f)));
        }
    }
}

