/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.joefoxe.hexerei.container.HerbJarContainer;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class HerbJarScreen
extends AbstractContainerScreen<HerbJarContainer> {
    private final ResourceLocation GUI = HexereiUtil.getResource("textures/gui/herb_jar_gui.png");
    private final ResourceLocation INVENTORY = HexereiUtil.getResource("textures/gui/inventory.png");

    public HerbJarScreen(HerbJarContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.inventoryLabelY = 107;
        this.inventoryLabelX = 8;
        this.titleLabelY = -27;
        this.titleLabelX = 52;
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderButtonTooltip(guiGraphics, mouseX, mouseY);
    }

    public Component getTitle() {
        return super.getTitle();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(this.GUI, i, j - 3 - 28, 0, 0, 214, 157);
        if (((HerbJarContainer)this.menu).getToggled() == 1) {
            guiGraphics.blit(this.GUI, i + 82, j + 105 - 28, 238, 26, 18, 18);
        }
        guiGraphics.blit(this.GUI, i + 78, j - 30 - 28, 230, 0, 26, 26);
        Minecraft minecraft = Minecraft.getInstance();
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        RenderSystem.disableDepthTest();
        guiGraphics.renderItem(((HerbJarContainer)this.menu).stack, this.leftPos + 83, this.topPos - 25 - 28);
        RenderSystem.enableDepthTest();
        guiGraphics.blit(this.INVENTORY, i + 3, j + 129 - 28, 0, 0, 176, 100);
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean mouseClicked = super.mouseClicked(x, y, button);
        if (x > (double)(this.leftPos + 82) && x <= (double)(this.leftPos + 82 + 18) && y >= (double)(this.topPos + 105 - 28) && y < (double)(this.topPos + 105 + 18 - 28)) {
            ((HerbJarContainer)this.menu).setToggled(1 - ((HerbJarContainer)this.menu).getToggled());
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        return mouseClicked;
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= (double)this.leftPos + x && mouseX < (double)this.leftPos + x + width && mouseY >= (double)this.topPos + y && mouseY < (double)this.topPos + y + height;
    }

    public void renderButtonTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        if (this.isHovering(mouseX, mouseY, 82.0, 77.0, 18.0, 18.0)) {
            components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button"));
            if (Screen.hasShiftDown()) {
                components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

