/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.joefoxe.hexerei.block.custom.PickableDoublePlant;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.container.CrowContainer;
import net.joefoxe.hexerei.events.CrowWhitelistEvent;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.CrowCanAttackToServer;
import net.joefoxe.hexerei.util.message.CrowInteractionRangeToServer;
import net.joefoxe.hexerei.util.message.CrowWhitelistSyncToServer;
import net.joefoxe.hexerei.util.message.PlayerWhitelistingForCrowSyncToServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class CrowScreen
extends AbstractContainerScreen<CrowContainer> {
    private static final int FRONT_OVERLAY_BLIT_LAYER = 3;
    private static final int FRONT_BLIT_LAYER = 2;
    private static final int BACK_OVERLAY_BLIT_LAYER = 1;
    private static final int BACK_BLIT_LAYER = 0;
    private final ResourceLocation GUI = HexereiUtil.getResource("textures/gui/crow_gui.png");
    private final ResourceLocation INVENTORY = HexereiUtil.getResource("textures/gui/inventory.png");
    public final CrowEntity crowEntity;
    public float whitelistOffset;
    public float leftPanelOffset;
    private int whitelistPage;
    private int rangeSlider;
    private boolean rangeSliderClicked;
    private double rangeSliderClickedPos;

    public CrowScreen(CrowContainer crowContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)crowContainer, inv, titleIn);
        this.crowEntity = crowContainer.crowEntity;
        this.titleLabelY = -27;
        this.titleLabelX = 4;
        this.inventoryLabelY = 106;
        this.inventoryLabelX = 9;
        this.whitelistOffset = 0.0f;
        this.leftPanelOffset = 0.0f;
        this.whitelistPage = 0;
        this.rangeSlider = this.crowEntity.interactionRange;
        this.rangeSliderClickedPos = 0.0;
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int i = this.leftPos;
        int j = this.topPos - 28;
        this.whitelistOffset = CrowScreen.isMouseOver(mouseX, mouseY, i + 184, j + 18, 10 + (int)this.whitelistOffset, 100) ? HexereiUtil.moveTo(this.whitelistOffset, 28.0f, 2.0f * ((32.0f - this.whitelistOffset) / 31.0f)) : HexereiUtil.moveTo(this.whitelistOffset, 0.0f, Math.abs(2.0f * ((-1.0f - this.whitelistOffset) / 31.0f)));
        this.leftPanelOffset = CrowScreen.isMouseOver(mouseX, mouseY, i - 5 - (int)this.leftPanelOffset, j + 18, 10 + (int)this.leftPanelOffset, 100) ? HexereiUtil.moveTo(this.leftPanelOffset, 28.0f, 2.0f * ((32.0f - this.leftPanelOffset) / 31.0f)) : HexereiUtil.moveTo(this.leftPanelOffset, 0.0f, Math.abs(2.0f * ((-1.0f - this.leftPanelOffset) / 31.0f)));
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderButtonTooltip(guiGraphics, mouseX, mouseY);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)x && mouseX <= (double)(x + sizeX) && mouseY >= (double)y && mouseY <= (double)(y + sizeY);
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= (double)this.leftPos + x && mouseX < (double)this.leftPos + x + width && mouseY >= (double)(this.topPos - 28) + y && mouseY < (double)(this.topPos - 28) + y + height;
    }

    protected void containerTick() {
        super.containerTick();
    }

    public Component getTitle() {
        return super.getTitle();
    }

    public void renderButtonTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        if (this.whitelistOffset > 21.0f) {
            if (this.isHovering(mouseX, mouseY, 162 + (int)this.whitelistOffset, 27.0, 18.0, 18.0)) {
                components.add(Component.translatable((String)"tooltip.hexerei.crow_whitelist_button"));
                if (Screen.hasShiftDown()) {
                    components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_whitelist_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_whitelist_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                } else {
                    components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                }
                guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
            }
            if (this.isHovering(mouseX, mouseY, 175 + (int)this.whitelistOffset, 48.0, 7.0, 7.0)) {
                if (this.crowEntity.harvestWhitelist.size() >= this.whitelistPage * 3 + 1) {
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_whitelist_remove"));
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.isHovering(mouseX, mouseY, 175 + (int)this.whitelistOffset, 66.0, 7.0, 7.0)) {
                if (this.crowEntity.harvestWhitelist.size() >= this.whitelistPage * 3 + 2) {
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_whitelist_remove"));
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.isHovering(mouseX, mouseY, 175 + (int)this.whitelistOffset, 84.0, 7.0, 7.0)) {
                if (this.crowEntity.harvestWhitelist.size() >= this.whitelistPage * 3 + 3) {
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_whitelist_remove"));
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.isHovering(mouseX, mouseY, 175 + (int)this.whitelistOffset - 12, 52.0, 16.0, 16.0)) {
                if (this.crowEntity.harvestWhitelist.size() >= this.whitelistPage * 3 + 1) {
                    components.add(this.crowEntity.harvestWhitelist.get(this.whitelistPage * 3).getName());
                    components.add(this.crowEntity.harvestWhitelist.get(this.whitelistPage * 3).getName());
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.isHovering(mouseX, mouseY, 175 + (int)this.whitelistOffset - 12, 70.0, 16.0, 16.0)) {
                if (this.crowEntity.harvestWhitelist.size() >= this.whitelistPage * 3 + 2) {
                    components.add(this.crowEntity.harvestWhitelist.get(this.whitelistPage * 3 + 1).getName());
                    guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.isHovering(mouseX, mouseY, 175 + (int)this.whitelistOffset - 12, 88.0, 16.0, 16.0) && this.crowEntity.harvestWhitelist.size() >= this.whitelistPage * 3 + 3) {
                components.add(this.crowEntity.harvestWhitelist.get(this.whitelistPage * 3 + 2).getName());
                guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
            }
            if (this.isHovering(mouseX, mouseY, 177 + (int)this.whitelistOffset, 107.0, 7.0, 10.0)) {
                components.add(Component.translatable((String)"tooltip.hexerei.crow_whitelist_next"));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
            }
            if (this.isHovering(mouseX, mouseY, 159 + (int)this.whitelistOffset, 107.0, 7.0, 10.0)) {
                components.add(Component.translatable((String)"tooltip.hexerei.crow_whitelist_back"));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.leftPanelOffset > 21.0f) {
            if (this.isHovering(mouseX, mouseY, 5 - (int)this.leftPanelOffset, 107.0, 7.0, 10.0)) {
                components.add(Component.translatable((String)"tooltip.hexerei.crow_range_decrease"));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
            } else if (this.isHovering(mouseX, mouseY, 23 - (int)this.leftPanelOffset, 107.0, 7.0, 10.0)) {
                components.add(Component.translatable((String)"tooltip.hexerei.crow_range_increase"));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
            } else if (this.isHovering(mouseX, mouseY, 6 - (int)this.leftPanelOffset, 94.0, 22.0, 15.0)) {
                components.add(Component.translatable((String)"tooltip.hexerei.crow_range_interaction"));
                if (Screen.hasShiftDown()) {
                    components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_range_interaction_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_range_interaction_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                } else {
                    components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                }
                guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
            } else if (this.isHovering(mouseX, mouseY, 4 - (int)this.leftPanelOffset, 30.0, 18.0, 18.0)) {
                components.add(Component.translatable((String)"tooltip.hexerei.crow_attack_toggle"));
                if (Screen.hasShiftDown()) {
                    components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_attack_toggled", (Object[])new Object[]{this.crowEntity.canAttack ? "On" : "Off"}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_attack_toggle_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                    components.add(Component.translatable((String)"tooltip.hexerei.crow_attack_toggle_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                } else {
                    components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                }
                guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isHovering(mouseX, mouseY, 23.0, 92.0, 18.0, 18.0)) {
            components.add(Component.translatable((String)"entity.hexerei.crow_command_gui_0"));
            if (Screen.hasShiftDown()) {
                components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_follow_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_follow_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_follow_button_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, 43.0, 92.0, 18.0, 18.0)) {
            components.add(Component.translatable((String)"entity.hexerei.crow_command_gui_1"));
            if (Screen.hasShiftDown()) {
                components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_sit_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_sit_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, 63.0, 92.0, 18.0, 18.0)) {
            components.add(Component.translatable((String)"entity.hexerei.crow_command_gui_2"));
            if (Screen.hasShiftDown()) {
                components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_wander_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_wander_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, 83.0, 92.0, 18.0, 18.0)) {
            components.add(Component.translatable((String)"entity.hexerei.crow_command_gui_3"));
            if (Screen.hasShiftDown()) {
                components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_help_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_help_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_help_button_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, 107.0, 92.0, 18.0, 18.0)) {
            components.add(Component.translatable((String)"entity.hexerei.crow_help_command_gui_0"));
            if (Screen.hasShiftDown()) {
                components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_gather_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_gather_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_gather_button_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, 127.0, 92.0, 18.0, 18.0)) {
            components.add(Component.translatable((String)"entity.hexerei.crow_help_command_gui_1"));
            if (Screen.hasShiftDown()) {
                components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_harvest_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_harvest_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(mouseX, mouseY, 147.0, 92.0, 18.0, 18.0)) {
            components.add(Component.translatable((String)"entity.hexerei.crow_help_command_gui_2"));
            if (Screen.hasShiftDown()) {
                components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_pickpocket_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_pickpocket_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_pickpocket_button_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_pickpocket_button_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.crow_flute_pickpocket_button_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    private void drawFont(GuiGraphics guiGraphics, MutableComponent component, float x, float y, int z, int color, boolean shadow) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(x, y, (float)z);
        guiGraphics.drawString(this.minecraft.font, (Component)component, 0, 0, color, shadow);
        guiGraphics.pose().popPose();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int i = this.leftPos;
        int j = this.topPos - 28;
        this.inventoryLabelY = 106;
        this.inventoryLabelX = 9;
        guiGraphics.blit(this.GUI, i + 184 - 28 + (int)this.whitelistOffset, j + 19, 0, 0.0f, 156.0f, 37, 100, 256, 256);
        guiGraphics.blit(this.GUI, i - 5 - (int)this.leftPanelOffset, j + 19, 0, 74.0f, 156.0f, 37, 100, 256, 256);
        if (CrowWhitelistEvent.whiteListingCrow != null && CrowWhitelistEvent.whiteListingCrow == this.crowEntity) {
            guiGraphics.blit(this.GUI, i + 184 - 28 + 6 + (int)this.whitelistOffset, j + 19 + 8, 1, 238.0f, 178.0f, 18, 18, 256, 256);
        }
        guiGraphics.blit(this.GUI, i + 184 - 28 + (int)this.whitelistOffset, j + 19 + 100 - 12, 1, 37.0f, 244.0f, 37, 12, 256, 256);
        guiGraphics.blit(this.GUI, i + 2 - (int)this.leftPanelOffset, j + 19 + 100 - 12, 1, 37.0f, 244.0f, 37, 12, 256, 256);
        if (!this.crowEntity.canAttack) {
            guiGraphics.blit(this.GUI, i + 8 - (int)this.leftPanelOffset, j + 30, 1, 238.0f, 196.0f, 18, 18, 256, 256);
        }
        if (this.rangeSliderClicked) {
            guiGraphics.blit(this.GUI, i - 5 + 14 - (int)this.leftPanelOffset, j + 19 + 64 - Mth.clamp((int)(this.crowEntity.interactionRange + (int)(this.rangeSliderClickedPos - (double)y)), (int)0, (int)24), 1, 40.0f, 232.0f, 16, 5, 256, 256);
        } else {
            guiGraphics.blit(this.GUI, i - 5 + 14 - (int)this.leftPanelOffset, j + 19 + 64 - this.crowEntity.interactionRange, 1, 40.0f, 238.0f, 16, 5, 256, 256);
        }
        MutableComponent component = Component.literal((String)String.valueOf(this.crowEntity.interactionRange));
        if (this.rangeSliderClicked) {
            component = Component.literal((String)String.valueOf(Mth.clamp((int)(this.crowEntity.interactionRange + (int)(this.rangeSliderClickedPos - (double)y)), (int)0, (int)24)));
        }
        if (this.minecraft != null) {
            float f = (float)(i - 5) + 22.5f - (float)((int)this.leftPanelOffset) - (float)(this.font.width(component.getVisualOrderText()) / 2);
            float f2 = j + 102;
            Objects.requireNonNull(this.font);
            this.drawFont(guiGraphics, component, f, f2 - 9.0f / 2.0f, 1, -13619152, false);
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        if (this.crowEntity.harvestWhitelist.size() >= this.whitelistPage * 3 + 1) {
            guiGraphics.blit(this.GUI, i + 184 - 28 + 19 + (int)this.whitelistOffset, j + 19 + 29, 1, 231.0f, 117.0f, 7, 7, 256, 256);
        }
        if (this.crowEntity.harvestWhitelist.size() >= this.whitelistPage * 3 + 2) {
            guiGraphics.blit(this.GUI, i + 184 - 28 + 19 + (int)this.whitelistOffset, j + 19 + 29 + 18, 1, 231.0f, 117.0f, 7, 7, 256, 256);
        }
        if (this.crowEntity.harvestWhitelist.size() >= this.whitelistPage * 3 + 3) {
            guiGraphics.blit(this.GUI, i + 184 - 28 + 19 + (int)this.whitelistOffset, j + 19 + 29 + 18 + 18, 1, 231.0f, 117.0f, 7, 7, 256, 256);
        }
        if (((CrowContainer)this.menu).crowEntity.harvestWhitelist.size() > 3 + 3 * this.whitelistPage) {
            guiGraphics.blit(this.GUI, i + 184 + 21 - 28 + (int)this.whitelistOffset, j + 19 + 88, 1, 217.0f, 107.0f, 7, 10, 256, 256);
        }
        if (this.whitelistPage > 0) {
            guiGraphics.blit(this.GUI, i + 184 + 3 - 28 + (int)this.whitelistOffset, j + 19 + 88, 1, 210.0f, 107.0f, 7, 10, 256, 256);
        }
        if (((CrowContainer)this.menu).crowEntity.interactionRange < 24) {
            guiGraphics.blit(this.GUI, i + 5 - (int)this.leftPanelOffset + 18, j + 19 + 100 - 12, 1, 217.0f, 107.0f, 7, 10, 256, 256);
        }
        if (((CrowContainer)this.menu).crowEntity.interactionRange > 0) {
            guiGraphics.blit(this.GUI, i + 5 - (int)this.leftPanelOffset, j + 19 + 100 - 12, 1, 210.0f, 107.0f, 7, 10, 256, 256);
        }
        guiGraphics.blit(this.GUI, i, j, 2, 0.0f, 0.0f, 188, 153, 256, 256);
        if (((CrowContainer)this.menu).getCommand() == 0) {
            guiGraphics.blit(this.GUI, i + 23, j + 92, 2, 238.0f, 52.0f, 18, 18, 256, 256);
        } else if (((CrowContainer)this.menu).getCommand() == 1) {
            guiGraphics.blit(this.GUI, i + 43, j + 92, 2, 238.0f, 70.0f, 18, 18, 256, 256);
        } else if (((CrowContainer)this.menu).getCommand() == 2) {
            guiGraphics.blit(this.GUI, i + 63, j + 92, 2, 238.0f, 88.0f, 18, 18, 256, 256);
        } else if (((CrowContainer)this.menu).getCommand() == 3) {
            guiGraphics.blit(this.GUI, i + 83, j + 92, 2, 238.0f, 106.0f, 18, 18, 256, 256);
        }
        if (((CrowContainer)this.menu).getCommand() == 3) {
            if (((CrowContainer)this.menu).getHelpCommand() == 0) {
                guiGraphics.blit(this.GUI, i + 107, j + 92, 2, 238.0f, 124.0f, 18, 18, 256, 256);
            }
            if (((CrowContainer)this.menu).getHelpCommand() == 1) {
                guiGraphics.blit(this.GUI, i + 127, j + 92, 2, 238.0f, 142.0f, 18, 18, 256, 256);
            }
            if (((CrowContainer)this.menu).getHelpCommand() == 2) {
                guiGraphics.blit(this.GUI, i + 147, j + 92, 2, 238.0f, 160.0f, 18, 18, 256, 256);
            }
        } else {
            if (((CrowContainer)this.menu).getHelpCommand() == 0) {
                guiGraphics.blit(this.GUI, i + 107, j + 92, 2, 220.0f, 124.0f, 18, 18, 256, 256);
            } else {
                guiGraphics.blit(this.GUI, i + 107, j + 92, 2, 202.0f, 124.0f, 18, 18, 256, 256);
            }
            if (((CrowContainer)this.menu).getHelpCommand() == 1) {
                guiGraphics.blit(this.GUI, i + 127, j + 92, 2, 220.0f, 142.0f, 18, 18, 256, 256);
            } else {
                guiGraphics.blit(this.GUI, i + 127, j + 92, 2, 202.0f, 142.0f, 18, 18, 256, 256);
            }
            if (((CrowContainer)this.menu).getHelpCommand() == 2) {
                guiGraphics.blit(this.GUI, i + 147, j + 92, 2, 220.0f, 160.0f, 18, 18, 256, 256);
            } else {
                guiGraphics.blit(this.GUI, i + 147, j + 92, 2, 202.0f, 160.0f, 18, 18, 256, 256);
            }
        }
        if (!this.crowEntity.itemHandler.getStackInSlot(0).isEmpty()) {
            guiGraphics.blit(this.GUI, i + 86, j + 50, 2, 235.0f, 31.0f, 16, 16, 256, 256);
        }
        if (!this.crowEntity.itemHandler.getStackInSlot(1).isEmpty()) {
            guiGraphics.blit(this.GUI, i + 37, j + 50, 2, 235.0f, 31.0f, 16, 16, 256, 256);
        }
        if (!this.crowEntity.itemHandler.getStackInSlot(2).isEmpty()) {
            guiGraphics.blit(this.GUI, i + 134, j + 50, 2, 235.0f, 31.0f, 16, 16, 256, 256);
        }
        guiGraphics.blit(this.GUI, i + 81, j - 30, 2, 230.0f, 0.0f, 26, 26, 256, 256);
        guiGraphics.blit(this.INVENTORY, i + 6, j + 129, 2, 0.0f, 0.0f, 176, 100, 256, 256);
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.leftPos + 94 - 20), (int)(j - 17 - 20), (int)(this.leftPos + 94 + 20), (int)(j - 17 + 20), (int)25, (float)0.0625f, (float)x, (float)y, (LivingEntity)this.crowEntity);
        RenderSystem.disableDepthTest();
        MutableComponent hat = Component.translatable((String)"entity.hexerei.crow_slot_0");
        MutableComponent misc1 = Component.translatable((String)"entity.hexerei.crow_slot_1");
        MutableComponent misc2 = Component.translatable((String)"entity.hexerei.crow_slot_2");
        MutableComponent command = ((CrowContainer)this.menu).getCommand() == 0 ? Component.translatable((String)"entity.hexerei.crow_command_gui_0") : (((CrowContainer)this.menu).getCommand() == 1 ? Component.translatable((String)"entity.hexerei.crow_command_gui_1") : (((CrowContainer)this.menu).getCommand() == 2 ? Component.translatable((String)"entity.hexerei.crow_command_gui_2") : Component.translatable((String)"entity.hexerei.crow_command_gui_3")));
        MutableComponent helpCommand = ((CrowContainer)this.menu).getHelpCommand() == 0 ? Component.translatable((String)"entity.hexerei.crow_help_command_gui_0") : (((CrowContainer)this.menu).getHelpCommand() == 1 ? Component.translatable((String)"entity.hexerei.crow_help_command_gui_1") : Component.translatable((String)"entity.hexerei.crow_help_command_gui_2"));
        this.drawFont(guiGraphics, hat, (float)(this.leftPos + 45) - (float)(this.font.width(hat.getVisualOrderText()) / 2), j + 32, 3, -10461088, false);
        this.drawFont(guiGraphics, misc1, (float)(this.leftPos + 94) - (float)(this.font.width(misc1.getVisualOrderText()) / 2), j + 32, 3, -10461088, false);
        this.drawFont(guiGraphics, misc2, (float)(this.leftPos + 142) - (float)(this.font.width(misc2.getVisualOrderText()) / 2), j + 32, 3, -10461088, false);
        this.drawFont(guiGraphics, command, (float)(this.leftPos + 56) - (float)(this.font.width(command.getVisualOrderText()) / 2), j + 77, 3, -10461088, false);
        this.drawFont(guiGraphics, helpCommand, (float)(this.leftPos + 131) - (float)(this.font.width(helpCommand.getVisualOrderText()) / 2), j + 77, 3, -10461088, false);
        if (!this.crowEntity.harvestWhitelist.isEmpty() && this.whitelistOffset > 21.0f) {
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.leftPos + 186.0f - 28.0f + (float)((int)this.whitelistOffset), (float)(j + 73), 100.0f);
            guiGraphics.pose().translate(8.0f, -8.0f, 0.0f);
            guiGraphics.pose().scale(11.0f, 11.0f, 11.0f);
            guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
            Vec3 rotationOffset = new Vec3(0.5, 0.0, 0.5);
            float zRot = 0.0f;
            float xRot = 20.0f;
            float yRot = 130.0f * (this.whitelistOffset - 21.0f) / 8.0f;
            guiGraphics.pose().translate(rotationOffset.x, rotationOffset.y, rotationOffset.z);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(zRot));
            guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(xRot));
            guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(yRot));
            guiGraphics.pose().translate(-rotationOffset.x, -rotationOffset.y, -rotationOffset.z);
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            Lighting.setupFor3DItems();
            guiGraphics.pose().last().normal().rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            int max3 = 0;
            for (int itor = this.whitelistPage * 3; itor < this.crowEntity.harvestWhitelist.size() && ++max3 <= 3; ++itor) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, (float)(-(max3 - 1)) * 1.75f, 0.0f);
                BlockState state = this.crowEntity.harvestWhitelist.get(itor).defaultBlockState();
                if (state.hasProperty((Property)BlockStateProperties.AGE_1)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_1, (Comparable)Integer.valueOf(1));
                } else if (state.hasProperty((Property)BlockStateProperties.AGE_2)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(2));
                } else if (state.hasProperty((Property)BlockStateProperties.AGE_3)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(3));
                } else if (state.hasProperty((Property)BlockStateProperties.AGE_4)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_4, (Comparable)Integer.valueOf(4));
                } else if (state.hasProperty((Property)BlockStateProperties.AGE_5)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_5, (Comparable)Integer.valueOf(5));
                } else if (state.hasProperty((Property)BlockStateProperties.AGE_7)) {
                    state = (BlockState)state.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(7));
                }
                guiGraphics.pose().scale((this.whitelistOffset - 21.0f) / 8.0f, (this.whitelistOffset - 21.0f) / 8.0f, (this.whitelistOffset - 21.0f) / 8.0f);
                this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, state, -1);
                if (state.hasProperty(PickableDoublePlant.HALF)) {
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate(0.0f, 1.0f, 0.0f);
                    state = (BlockState)state.setValue(PickableDoublePlant.HALF, (Comparable)DoubleBlockHalf.UPPER);
                    this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, state, -1);
                    guiGraphics.pose().popPose();
                }
                guiGraphics.pose().popPose();
            }
            buffer.endBatch();
            guiGraphics.pose().popPose();
        }
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    public boolean mouseReleased(double x, double y, int button) {
        boolean mouseReleased = super.mouseReleased(x, y, button);
        if (this.rangeSliderClicked) {
            this.rangeSliderClicked = false;
            this.crowEntity.interactionRange = Mth.clamp((int)(this.crowEntity.interactionRange + (int)(this.rangeSliderClickedPos - y)), (int)0, (int)24);
            HexereiPacketHandler.sendToServer(new CrowInteractionRangeToServer(this.crowEntity, this.crowEntity.interactionRange));
        }
        return mouseReleased;
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean mouseClicked = super.mouseClicked(x, y, button);
        int i = this.leftPos;
        int j = this.topPos - 28;
        if (this.whitelistOffset > 21.0f && x > (double)((float)i + 190.0f - 28.0f + (float)((int)this.whitelistOffset)) && x < (double)((float)i + 190.0f - 28.0f + (float)((int)this.whitelistOffset) + 18.0f) && y > (double)(j + 27) && y < (double)(j + 27 + 18)) {
            if (CrowWhitelistEvent.whiteListingCrow == null || ((CrowContainer)this.menu).crowEntity != CrowWhitelistEvent.whiteListingCrow) {
                CrowWhitelistEvent.whiteListingCrow = ((CrowContainer)this.menu).crowEntity;
                if (this.crowEntity.getOwner() instanceof Player) {
                    ((Player)this.crowEntity.getOwner()).displayClientMessage((Component)Component.translatable((String)"Right Click a harvestable block to add to the whitelist"), true);
                }
            } else {
                CrowWhitelistEvent.whiteListingCrow = null;
            }
            HexereiPacketHandler.sendToServer(new PlayerWhitelistingForCrowSyncToServer(CrowWhitelistEvent.whiteListingCrow != null));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        } else if (this.leftPanelOffset > 21.0f && x > (double)(i + 9 - (int)this.leftPanelOffset) && x < (double)(i + 9 - (int)this.leftPanelOffset + 16) && y > (double)(j + 30 + 52 - this.crowEntity.interactionRange) && y < (double)(j + 30 + 52 - this.crowEntity.interactionRange + 7)) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.rangeSliderClicked = true;
            this.rangeSliderClickedPos = y;
        } else if (this.leftPanelOffset > 21.0f && x > (double)(i + 9 + 6 - (int)this.leftPanelOffset) && x < (double)(i + 9 + 10 - (int)this.leftPanelOffset) && y > (double)(j + 30 + 55 - 24) && y < (double)(j + 30 + 56)) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            int newPos = j + 30 + 55 - (int)y;
            HexereiPacketHandler.sendToServer(new CrowInteractionRangeToServer(this.crowEntity, newPos));
            this.rangeSliderClicked = true;
            this.rangeSliderClickedPos = y;
        } else if (this.leftPanelOffset > 21.0f && x > (double)(i + 8 - (int)this.leftPanelOffset) && x < (double)(i + 8 - (int)this.leftPanelOffset + 18) && y > (double)(j + 30) && y < (double)(j + 30 + 18)) {
            HexereiPacketHandler.sendToServer(new CrowCanAttackToServer(this.crowEntity, !this.crowEntity.canAttack));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        } else if (this.crowEntity.getInteractionRange() > 0 && this.leftPanelOffset > 21.0f && x > (double)(i + 5 - (int)this.leftPanelOffset) && x < (double)(i + 5 - (int)this.leftPanelOffset + 7) && y > (double)(j + 107) && y < (double)(j + 107 + 10)) {
            HexereiPacketHandler.sendToServer(new CrowInteractionRangeToServer(this.crowEntity, this.crowEntity.getInteractionRange() - 1));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        } else if (this.crowEntity.getInteractionRange() < 24 && this.leftPanelOffset > 21.0f && x > (double)(i + 5 + 18 - (int)this.leftPanelOffset) && x < (double)(i + 5 + 18 - (int)this.leftPanelOffset + 7) && y > (double)(j + 107) && y < (double)(j + 107 + 10)) {
            HexereiPacketHandler.sendToServer(new CrowInteractionRangeToServer(this.crowEntity, this.crowEntity.getInteractionRange() + 1));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        } else if (this.whitelistOffset > 21.0f && x > (double)(i + 184 - 28 + 19 + (int)this.whitelistOffset) && x < (double)(i + 184 - 28 + 19 + (int)this.whitelistOffset + 7) && y > (double)(j + 19 + 29) && y < (double)(j + 19 + 29 + 7)) {
            if (((CrowContainer)this.menu).crowEntity.harvestWhitelist.size() > this.whitelistPage * 3) {
                ((CrowContainer)this.menu).crowEntity.harvestWhitelist.remove(this.whitelistPage * 3);
                if (((CrowContainer)this.menu).crowEntity.harvestWhitelist.size() - this.whitelistPage * 3 == 0 && this.whitelistPage > 0) {
                    --this.whitelistPage;
                }
                HexereiPacketHandler.sendToServer(new CrowWhitelistSyncToServer((Entity)((CrowContainer)this.menu).crowEntity, ((CrowContainer)this.menu).crowEntity.harvestWhitelist));
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        } else if (this.whitelistOffset > 21.0f && x > (double)(i + 184 - 28 + 19 + (int)this.whitelistOffset) && x < (double)(i + 184 - 28 + 19 + (int)this.whitelistOffset + 7) && y > (double)(j + 19 + 29 + 18) && y < (double)(j + 19 + 29 + 18 + 7)) {
            if (((CrowContainer)this.menu).crowEntity.harvestWhitelist.size() > 1 + this.whitelistPage * 3) {
                ((CrowContainer)this.menu).crowEntity.harvestWhitelist.remove(1 + this.whitelistPage * 3);
                HexereiPacketHandler.sendToServer(new CrowWhitelistSyncToServer((Entity)((CrowContainer)this.menu).crowEntity, ((CrowContainer)this.menu).crowEntity.harvestWhitelist));
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        } else if (this.whitelistOffset > 21.0f && x > (double)(i + 184 - 28 + 19 + (int)this.whitelistOffset) && x < (double)(i + 184 - 28 + 19 + (int)this.whitelistOffset + 7) && y > (double)(j + 19 + 29 + 18 + 18) && y < (double)(j + 19 + 29 + 18 + 18 + 7)) {
            if (((CrowContainer)this.menu).crowEntity.harvestWhitelist.size() > 2 + this.whitelistPage * 3) {
                ((CrowContainer)this.menu).crowEntity.harvestWhitelist.remove(2 + this.whitelistPage * 3);
                HexereiPacketHandler.sendToServer(new CrowWhitelistSyncToServer((Entity)((CrowContainer)this.menu).crowEntity, ((CrowContainer)this.menu).crowEntity.harvestWhitelist));
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        } else if (this.whitelistOffset > 21.0f && x > (double)(i + 184 + 3 - 28 + (int)this.whitelistOffset) && x < (double)(i + 184 + 3 - 28 + (int)this.whitelistOffset + 7) && y > (double)(j + 19 + 88) && y < (double)(j + 19 + 88 + 10)) {
            if (this.whitelistPage > 0) {
                --this.whitelistPage;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        } else if (this.whitelistOffset > 21.0f && x > (double)(i + 184 + 21 - 28 + (int)this.whitelistOffset) && x < (double)(i + 184 + 20 - 28 + (int)this.whitelistOffset + 7) && y > (double)(j + 19 + 88) && y < (double)(j + 19 + 88 + 10)) {
            if (((CrowContainer)this.menu).crowEntity.harvestWhitelist.size() > 3 + 3 * this.whitelistPage) {
                ++this.whitelistPage;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        } else if (x > (double)((float)i + 23.0f) && x < (double)((float)i + 23.0f + 18.0f) && y > (double)(j + 92) && y < (double)(j + 92 + 18)) {
            ((CrowContainer)this.menu).setCommand(0);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.crowEntity.getOwner() instanceof Player) {
                ((Player)this.crowEntity.getOwner()).displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_command_0", (Object[])new Object[]{this.crowEntity.getName()}), true);
            }
        } else if (x > (double)((float)i + 43.0f) && x < (double)((float)i + 43.0f + 18.0f) && y > (double)(j + 92) && y < (double)(j + 92 + 18)) {
            ((CrowContainer)this.menu).setCommand(1);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.crowEntity.getOwner() instanceof Player) {
                ((Player)this.crowEntity.getOwner()).displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_command_1", (Object[])new Object[]{this.crowEntity.getName()}), true);
            }
        } else if (x > (double)((float)i + 63.0f) && x < (double)((float)i + 63.0f + 18.0f) && y > (double)(j + 92) && y < (double)(j + 92 + 18)) {
            ((CrowContainer)this.menu).setCommand(2);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.crowEntity.getOwner() instanceof Player) {
                ((Player)this.crowEntity.getOwner()).displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_command_2", (Object[])new Object[]{this.crowEntity.getName()}), true);
            }
        } else if (x > (double)((float)i + 83.0f) && x < (double)((float)i + 83.0f + 18.0f) && y > (double)(j + 92) && y < (double)(j + 92 + 18)) {
            ((CrowContainer)this.menu).setCommand(3);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.crowEntity.getOwner() instanceof Player) {
                ((Player)this.crowEntity.getOwner()).displayClientMessage((Component)Component.translatable((String)("entity.hexerei.crow_command_3_" + ((CrowContainer)this.menu).getHelpCommand()), (Object[])new Object[]{this.crowEntity.getName()}), true);
            }
        } else if (x > (double)((float)i + 107.0f) && x < (double)((float)i + 107.0f + 18.0f) && y > (double)(j + 92) && y < (double)(j + 92 + 18)) {
            ((CrowContainer)this.menu).setHelpCommand(0);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.crowEntity.getOwner() instanceof Player) {
                ((Player)this.crowEntity.getOwner()).displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_command_3_0", (Object[])new Object[]{this.crowEntity.getName()}), true);
            }
        } else if (x > (double)((float)i + 127.0f) && x < (double)((float)i + 127.0f + 18.0f) && y > (double)(j + 92) && y < (double)(j + 92 + 18)) {
            ((CrowContainer)this.menu).setHelpCommand(1);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.crowEntity.getOwner() instanceof Player) {
                ((Player)this.crowEntity.getOwner()).displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_command_3_1", (Object[])new Object[]{this.crowEntity.getName()}), true);
            }
        } else if (x > (double)((float)i + 147.0f) && x < (double)((float)i + 147.0f + 18.0f) && y > (double)(j + 92) && y < (double)(j + 92 + 18)) {
            ((CrowContainer)this.menu).setHelpCommand(2);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.crowEntity.getOwner() instanceof Player) {
                ((Player)this.crowEntity.getOwner()).displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_command_3_2", (Object[])new Object[]{this.crowEntity.getName()}), true);
            }
        }
        return mouseClicked;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

