/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.particle.CauldronParticleData;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class CauldronParticle
extends TextureSheetParticle {
    private final ResourceLocation TEXTURE = HexereiUtil.getResource("textures/particle/cauldron_boil_particle.png");
    public static final Vec3[] CUBE = new Vec3[]{new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, 0.1, -0.5)};
    public static final Vec3[] CUBE_NORMALS = new Vec3[]{new Vec3(0.0, -0.1, 0.0), new Vec3(0.0, 0.25, 0.0), new Vec3(0.0, 0.0, 0.5), new Vec3(0.0, 0.0, -0.5), new Vec3(-0.5, 0.0, 0.0), new Vec3(0.5, 0.0, 0.0)};
    public static final ResourceLocation TEXTURE_BLANK = HexereiUtil.getResource("textures/block/blank.png");
    private static final ParticleRenderType renderType = new ParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_BLANK);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }
    };
    protected float scale;
    protected float rotationDirection;
    protected float rotation;
    private IClientFluidTypeExtensions clientFluid;
    private boolean canPop;
    int pixelCol = -1;

    public CauldronParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.rotation = 0.0f;
        Random random = new Random();
        this.setScale(0.2f);
        this.setRotationDirection(random.nextFloat() - 0.5f);
        this.canPop = random.nextInt(3) == 0 && this.lifetime > 10;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setSize(scale * 0.5f, scale * 0.5f);
    }

    public void setRotationDirection(float rotationDirection) {
        this.rotationDirection = rotationDirection;
    }

    public void tick() {
        this.rotation = this.rotationDirection * 0.1f + this.rotation;
        super.tick();
    }

    public float ease(float x) {
        return (float)(1.0 - Math.pow(1.0f - x, 5.0));
    }

    public void render(VertexConsumer builder, Camera renderInfo, float partial) {
        Vec3 projectedView = renderInfo.getPosition();
        float lerpX = (float)(Mth.lerp((double)partial, (double)this.xo, (double)this.x) - projectedView.x());
        float lerpY = (float)(Mth.lerp((double)partial, (double)this.yo, (double)this.y) - projectedView.y());
        float lerpZ = (float)(Mth.lerp((double)partial, (double)this.zo, (double)this.z) - projectedView.z());
        int light = 0xF000F0;
        double ageMultiplier = 1.0 - Math.pow(Mth.clamp((float)((float)this.age + partial), (float)0.0f, (float)this.lifetime), 3.0) / Math.pow(this.lifetime, 3.0);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this.TEXTURE);
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 4; ++j) {
                float alpha = this.alpha * 0.75f;
                Vec3 vec = CUBE[i * 4 + j];
                float popScale = Math.clamp((float)this.age + partial - (float)(this.lifetime - 5), 0.0f, 5.0f) / 5.0f;
                vec = vec.yRot(this.rotation).scale((double)this.scale * ageMultiplier * (double)(this.canPop && i % 6 != 0 && i % 6 != 1 ? 1.0f + this.ease(popScale) : 1.0f)).add((double)lerpX, (double)lerpY, (double)lerpZ);
                Vec3 normal = CUBE_NORMALS[i % 6];
                if (this.canPop && popScale > 0.0f) {
                    vec = vec.add(normal.yRot(this.rotation).scale((double)(this.ease(popScale) / 4.0f)));
                    alpha *= Math.clamp(this.ease(Mth.clamp((float)(1.0f - popScale), (float)0.0f, (float)1.0f)), 0.0f, 1.0f);
                }
                float[] cols = HexereiUtil.rgbaIntToFloatArray(this.pixelCol);
                if (i % 6 == 1) {
                    builder.addVertex((float)vec.x, (float)vec.y, (float)vec.z).setUv(0.0f, 0.0f).setColor(Mth.clamp((float)(this.rCol * 1.35f * cols[2]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.gCol * 1.35f * cols[1]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.bCol * 1.35f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).setNormal((float)normal.x, (float)normal.y, (float)normal.z).setLight(light);
                    continue;
                }
                if (i % 6 == 0) {
                    builder.addVertex((float)vec.x, (float)vec.y, (float)vec.z).setUv(0.0f, 0.0f).setColor(Mth.clamp((float)(this.rCol * 0.95f * cols[2]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.gCol * 0.95f * cols[1]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.bCol * 0.95f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).setNormal((float)normal.x, (float)normal.y, (float)normal.z).setLight(light);
                    continue;
                }
                if (i % 6 == 2) {
                    builder.addVertex((float)vec.x, (float)vec.y, (float)vec.z).setUv(0.0f, 0.0f).setColor(Mth.clamp((float)(this.rCol * 1.15f * cols[2]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.gCol * 1.15f * cols[1]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.bCol * 1.15f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).setNormal((float)normal.x, (float)normal.y, (float)normal.z).setLight(light);
                    continue;
                }
                if (i % 6 == 3) {
                    builder.addVertex((float)vec.x, (float)vec.y, (float)vec.z).setUv(0.0f, 0.0f).setColor(Mth.clamp((float)(this.rCol * 1.2f * cols[2]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.gCol * 1.2f * cols[1]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.bCol * 1.2f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).setNormal((float)normal.x, (float)normal.y, (float)normal.z).setLight(light);
                    continue;
                }
                if (i % 6 == 4) {
                    builder.addVertex((float)vec.x, (float)vec.y, (float)vec.z).setUv(0.0f, 0.0f).setColor(Mth.clamp((float)(this.rCol * 1.25f * cols[2]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.gCol * 1.25f * cols[1]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.bCol * 1.25f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).setNormal((float)normal.x, (float)normal.y, (float)normal.z).setLight(light);
                    continue;
                }
                builder.addVertex((float)vec.x, (float)vec.y, (float)vec.z).setUv(0.0f, 0.0f).setColor(Mth.clamp((float)(this.rCol * 1.2f * cols[2]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.gCol * 1.2f * cols[1]), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.bCol * 1.2f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).setNormal((float)normal.x, (float)normal.y, (float)normal.z).setLight(light);
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return renderType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<CauldronParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle createParticle(CauldronParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ResourceLocation stillLoc;
            CauldronParticle cauldronParticle = new CauldronParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            Random random = new Random();
            Object mixingCauldronTile = null;
            FluidStack fluidStack = data.fluid;
            Color color = new Color(BiomeColors.getAverageWaterColor((BlockAndTintGetter)worldIn, (BlockPos)new BlockPos((int)x, (int)y, (int)z)));
            BlockState blockStateAtPos = worldIn.getBlockState(new BlockPos((int)x, (int)(y - 0.1), (int)z));
            cauldronParticle.clientFluid = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            Function textureAtlasSpriteFunction = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
            TextureAtlasSprite sprite = (TextureAtlasSprite)textureAtlasSpriteFunction.apply(stillLoc = cauldronParticle.clientFluid.getStillTexture(fluidStack));
            if (sprite != null) {
                cauldronParticle.pixelCol = sprite.getPixelRGBA(0, random.nextInt(sprite.contents().width()), random.nextInt(sprite.contents().height()));
            }
            int colorInt = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
            float alpha = (float)(colorInt >> 24 & 0xFF) / 275.0f;
            float red = (float)(colorInt >> 16 & 0xFF) / 275.0f;
            float green = (float)(colorInt >> 8 & 0xFF) / 275.0f;
            float blue = (float)(colorInt & 0xFF) / 275.0f;
            float colorOffset = random.nextFloat() * 0.15f;
            cauldronParticle.setColor(Mth.clamp((float)(red + colorOffset), (float)0.0f, (float)1.0f), Mth.clamp((float)(green + colorOffset), (float)0.0f, (float)1.0f), Mth.clamp((float)(blue + colorOffset), (float)0.0f, (float)1.0f));
            if (fluidStack.is((Fluid)Fluids.WATER)) {
                cauldronParticle.setColor((float)color.getRed() / 450.0f + colorOffset, (float)color.getGreen() / 450.0f + colorOffset, (float)color.getBlue() / 450.0f + colorOffset);
            }
            cauldronParticle.setAlpha(1.0f);
            cauldronParticle.pickSprite(this.spriteSet);
            return cauldronParticle;
        }
    }
}

