/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.ClientboundOpenCourierLetterScreenPacket;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CourierLetterItem
extends BlockItem {
    public CourierLetterItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult place(BlockPlaceContext context) {
        return super.place(context);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Player player;
        if (!pContext.isSecondaryUseActive() && (player = pContext.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!pContext.getLevel().isClientSide && !pContext.getPlayer().isSteppingCarefully() && pContext.getItemInHand().getCount() == 1) {
                int slotIndex = pContext.getHand() == InteractionHand.OFF_HAND ? -1 : pContext.getPlayer().getInventory().selected;
                HexereiPacketHandler.sendToPlayerClient(new ClientboundOpenCourierLetterScreenPacket(slotIndex, pContext.getHand()), player2);
            }
        }
        return pContext.isSecondaryUseActive() ? super.useOn(pContext) : InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerIn;
            if (!playerIn.isSteppingCarefully() && itemstack.getCount() == 1) {
                int slotIndex = handIn == InteractionHand.OFF_HAND ? -1 : playerIn.getInventory().selected;
                HexereiPacketHandler.sendToPlayerClient(new ClientboundOpenCourierLetterScreenPacket(slotIndex, handIn), player);
            }
        }
        return itemstack.getCount() == 1 ? (CourierLetterItem.isSealed(itemstack) ? InteractionResultHolder.fail((Object)itemstack) : InteractionResultHolder.consume((Object)itemstack)) : InteractionResultHolder.fail((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (data == null || !data.copyTag().contains("Message")) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.courier_letter_use").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.courier_letter_menu").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.courier_letter_send").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.courier_letter_must_be_sealed").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else if (CourierLetterItem.isSealed(stack)) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.courier_letter_send").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.courier_letter_open").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.courier_letter_must_be_sealed").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
    }

    public static boolean isSealed(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        return data != null && data.copyTag().contains("Sealed") && data.copyTag().getBoolean("Sealed");
    }
}

