/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import net.joefoxe.hexerei.block.custom.ModChest;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.item.custom.CustomItemRenderer;
import net.joefoxe.hexerei.tileentity.ModChestBlockEntity;
import net.joefoxe.hexerei.tileentity.renderer.ModChestRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ChestItemRenderer
extends CustomItemRenderer {
    private ModChestRenderer renderer;
    private static final Minecraft minecraft = Minecraft.getInstance();

    @OnlyIn(value=Dist.CLIENT)
    public static ModChestBlockEntity loadBlockEntityFromItem(ItemStack item) {
        BlockItem blockItem;
        Block block;
        Item item2 = item.getItem();
        if (item2 instanceof BlockItem && (block = (blockItem = (BlockItem)item2).getBlock()) instanceof ModChest) {
            ModChest modChest = (ModChest)block;
            ModChestBlockEntity te = (ModChestBlockEntity)modChest.newBlockEntity(BlockPos.ZERO, (BlockState)block.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH));
            if (te != null && item.has(DataComponents.CUSTOM_NAME)) {
                te.name = item.getHoverName();
            }
            return te;
        }
        return null;
    }

    @Override
    public void renderByItem(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        if (this.renderer == null) {
            this.renderer = new ModChestRenderer(new BlockEntityRendererProvider.Context(minecraft.getBlockEntityRenderDispatcher(), minecraft.getBlockRenderer(), minecraft.getItemRenderer(), minecraft.getEntityRenderDispatcher(), minecraft.getEntityModels(), ChestItemRenderer.minecraft.font));
        }
        ModChestBlockEntity tileEntityIn = ChestItemRenderer.loadBlockEntityFromItem(itemStack);
        stack.pushPose();
        stack.translate(0.2, -0.1, -0.1);
        if (tileEntityIn != null) {
            this.renderer.render(tileEntityIn, ClientEvents.getPartial(), stack, source, light, overlay);
        }
        stack.popPose();
    }
}

