/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.PickableDoublePlant;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.integration.jei.PlantPickingRecipeJEI;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;

public class PlantPickingRecipeCategory
implements IRecipeCategory<PlantPickingRecipeJEI> {
    public static final ResourceLocation UID = HexereiUtil.getResource("plant_picking");
    public static final ResourceLocation TEXTURE = HexereiUtil.getResource("textures/gui/plant_picking_gui_jei.png");
    private final IDrawable background;
    private final IDrawable icon;

    public PlantPickingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 189, 59);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.MANDRAKE_PLANT.get()));
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public void getTooltip(ITooltipBuilder tooltip, PlantPickingRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.isHovering(mouseX, mouseY, 86.0, 23.0, 20.0, 20.0)) {
            tooltip.add((FormattedText)Component.translatable((String)"gui.jei.category.plant_picking_tooltip"));
        }
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public RecipeType<PlantPickingRecipeJEI> getRecipeType() {
        return new RecipeType(UID, PlantPickingRecipeJEI.class);
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.jei.category.plant_picking");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, final PlantPickingRecipeJEI recipe, IFocusGroup focuses) {
        builder.moveRecipeTransferButton(160, 90);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 15, 24).addItemStack(recipe.getInput())).setOverlay(new IDrawable(){

            public int getWidth() {
                return 16;
            }

            public int getHeight() {
                return 16;
            }

            public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
                Item item = recipe.getInput().getItem();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    int ticks = (int)(ClientEvents.getClientTicks() / 30.0f);
                    int max_age = 0;
                    BlockState blockState = blockItem.getBlock().defaultBlockState();
                    if (blockState.hasProperty((Property)BlockStateProperties.AGE_1)) {
                        max_age = 1;
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_1, (Comparable)Integer.valueOf(Mth.clamp((int)(ticks % (max_age + 1)), (int)0, (int)max_age)));
                    } else if (blockState.hasProperty((Property)BlockStateProperties.AGE_2)) {
                        max_age = 2;
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_2, (Comparable)Integer.valueOf(Mth.clamp((int)(ticks % (max_age + 1)), (int)0, (int)max_age)));
                    } else if (blockState.hasProperty((Property)BlockStateProperties.AGE_3)) {
                        max_age = 3;
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(Mth.clamp((int)(ticks % (max_age + 1)), (int)0, (int)max_age)));
                    } else if (blockState.hasProperty((Property)BlockStateProperties.AGE_4)) {
                        max_age = 4;
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_4, (Comparable)Integer.valueOf(Mth.clamp((int)(ticks % (max_age + 1)), (int)0, (int)max_age)));
                    } else if (blockState.hasProperty((Property)BlockStateProperties.AGE_5)) {
                        max_age = 5;
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_5, (Comparable)Integer.valueOf(Mth.clamp((int)(ticks % (max_age + 1)), (int)0, (int)max_age)));
                    } else if (blockState.hasProperty((Property)BlockStateProperties.AGE_7)) {
                        max_age = 7;
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(Mth.clamp((int)(ticks % (max_age + 1)), (int)0, (int)max_age)));
                    }
                    if (Mth.clamp((int)(ticks % (max_age + 1)), (int)0, (int)max_age) == max_age) {
                        guiGraphics.blit(TEXTURE, 56, 23, 3, 59, 13, 16);
                    }
                    RenderSystem.enableDepthTest();
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)xOffset, (float)yOffset, 0.0f);
                    guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
                    guiGraphics.pose().translate(-3.0f, -15.0f, 0.0f);
                    guiGraphics.pose().scale(17.0f, 17.0f, 17.0f);
                    MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                    Vec3 rotationOffset = new Vec3(0.0, 0.0, 0.0);
                    float zRot = 0.0f;
                    float xRot = 20.0f;
                    float yRot = 30.0f;
                    guiGraphics.pose().translate(rotationOffset.x, rotationOffset.y, rotationOffset.z);
                    guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(zRot));
                    guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(xRot));
                    guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(yRot));
                    guiGraphics.pose().translate(-rotationOffset.x, -rotationOffset.y, -rotationOffset.z);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    PlantPickingRecipeCategory.this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, blockState, -1);
                    if (blockState.hasProperty(PickableDoublePlant.HALF)) {
                        guiGraphics.pose().pushPose();
                        guiGraphics.pose().translate(0.0f, 1.0f, 0.0f);
                        blockState = (BlockState)blockState.setValue(PickableDoublePlant.HALF, (Comparable)DoubleBlockHalf.UPPER);
                        PlantPickingRecipeCategory.this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, blockState, -1);
                        guiGraphics.pose().popPose();
                    }
                    guiGraphics.pose().popPose();
                }
            }
        }, 74, 0);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 129, 24).addItemStack(recipe.getOutputItem());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 158, 24).addItemStack(recipe.getOutputItem2());
    }

    public void draw(PlantPickingRecipeJEI recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        Minecraft minecraft = Minecraft.getInstance();
        Component outputName = recipe.getInput().getHoverName();
        int width = minecraft.font.width((FormattedText)outputName);
        Objects.requireNonNull(minecraft.font);
        float lineHeight = 9.0f / 2.0f;
        if (width > 80) {
            float percent = (float)width / 80.0f;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(1.0f / percent, 1.0f / percent, 1.0f / percent);
            minecraft.font.drawInBatch(outputName, 39.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            guiGraphics.pose().popPose();
        } else {
            minecraft.font.drawInBatch(outputName, 39.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

