/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.data.recipes.MoonPhases;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.integration.jei.ExtraCauldronIcon;
import net.joefoxe.hexerei.integration.jei.FluidMixingRecipeCategory;
import net.joefoxe.hexerei.tileentity.renderer.MixingCauldronRenderer;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class MixingCauldronRecipeCategory
implements IRecipeCategory<MixingCauldronRecipe> {
    public static final ResourceLocation UID = HexereiUtil.getResource("mixingcauldron");
    public static final ResourceLocation TEXTURE = HexereiUtil.getResource("textures/gui/mixing_cauldron_gui_jei.png");
    public static final ResourceLocation MOON_PHASES = HexereiUtil.getResource("textures/gui/moon_phases.png");
    public static final ResourceLocation TEXTURE_BLANK = HexereiUtil.getResource("textures/block/blank.png");
    private IDrawable background;
    private final IDrawable icon;
    private final IDrawable liquid;
    private final IDrawable cauldron;
    private final IDrawable output1;
    private final IDrawable output2;
    private final IDrawable moonPhases_0;
    private final IDrawable moonPhases_1;
    private final IDrawable moonPhases_2;
    private final IDrawable moonPhases_3;
    private final IDrawable moonPhases_4;
    private final IDrawable moonPhases_5;
    private final IDrawable moonPhases_6;
    private final IDrawable moonPhases_7;
    private Block heatSource;
    private boolean findNewHeatSource;

    public void getTooltip(ITooltipBuilder tooltip, MixingCauldronRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (recipe.getHeatCondition() != FluidMixingRecipe.HeatCondition.NONE && this.isHovering(mouseX, mouseY, 79.0, 59.0, 24.0, 18.0)) {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.heat_source"));
            if (Screen.hasShiftDown()) {
                tooltip.add((FormattedText)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.heat_source_shown", (Object[])new Object[]{Component.translatable((String)this.heatSource.getDescriptionId()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xCC5522)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                tooltip.add((FormattedText)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
        }
        if (recipe.getMoonCondition() != MoonPhases.MoonCondition.NONE && this.isHovering(mouseX, mouseY, 79.0, 35.0, 24.0, 18.0)) {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.moon_phase"));
            if (Screen.hasShiftDown()) {
                tooltip.add((FormattedText)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_moon_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                tooltip.add((FormattedText)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_moon", (Object[])new Object[]{Component.translatable((String)recipe.getMoonCondition().getNameTranslated())}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
        }
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public int getWidth() {
        return 186;
    }

    public int getHeight() {
        return 109;
    }

    public MixingCauldronRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 186, 109);
        this.icon = new ExtraCauldronIcon(() -> new ItemStack((ItemLike)Items.POTION), "Normal", true);
        this.liquid = helper.createDrawable(TEXTURE, 208, 12, 16, 32);
        this.cauldron = helper.createDrawable(TEXTURE, 238, 50, 12, 10);
        this.output1 = helper.createDrawable(TEXTURE, 209, 64, 47, 82);
        this.output2 = helper.createDrawable(TEXTURE, 209, 146, 47, 82);
        this.moonPhases_0 = helper.createDrawable(MOON_PHASES, 12, 12, 8, 8);
        this.moonPhases_1 = helper.createDrawable(MOON_PHASES, 44, 12, 8, 8);
        this.moonPhases_2 = helper.createDrawable(MOON_PHASES, 76, 12, 8, 8);
        this.moonPhases_3 = helper.createDrawable(MOON_PHASES, 108, 12, 8, 8);
        this.moonPhases_4 = helper.createDrawable(MOON_PHASES, 12, 44, 8, 8);
        this.moonPhases_5 = helper.createDrawable(MOON_PHASES, 44, 44, 8, 8);
        this.moonPhases_6 = helper.createDrawable(MOON_PHASES, 76, 44, 8, 8);
        this.moonPhases_7 = helper.createDrawable(MOON_PHASES, 108, 44, 8, 8);
        this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
    }

    public RecipeType<MixingCauldronRecipe> getRecipeType() {
        return new RecipeType(UID, MixingCauldronRecipe.class);
    }

    public Component getTitle() {
        return Component.translatable((String)"Item Mixing");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MixingCauldronRecipe recipe, IFocusGroup focuses) {
        int size;
        FluidStack output;
        builder.moveRecipeTransferButton(160, 90);
        builder.setShapeless();
        FluidStack input = recipe.getLiquid();
        FluidStack fluidStack = output = recipe.getLiquidOutput() != null ? recipe.getLiquidOutput() : recipe.getLiquid().copy();
        if (recipe.getFluidLevelsConsumed() != 0) {
            if (!input.isEmpty()) {
                input.setAmount(Mth.clamp((int)recipe.getFluidLevelsConsumed(), (int)0, (int)2000));
            }
        } else if (!output.isEmpty()) {
            output.setAmount(2000);
        }
        if (!output.isEmpty()) {
            output.setAmount(2000 - recipe.getFluidLevelsConsumed());
        }
        boolean compare = FluidStack.isSameFluidSameComponents((FluidStack)recipe.getLiquid(), (FluidStack)recipe.getLiquidOutput());
        boolean changesFluid = false;
        if (!output.isEmpty() && (!recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) || recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) && !compare)) {
            changesFluid = true;
            builder.addSlot(RecipeIngredientRole.OUTPUT, 152, 71).setFluidRenderer(2000L, true, 12, 10).setBackground(this.cauldron, 0, 0).setOverlay(this.cauldron, 0, 0).addFluidStack(output.getFluid(), 2000L, output.getComponentsPatch()).addRichTooltipCallback((recipeSlotView, tooltip) -> {
                ArrayList tooltips = new ArrayList();
                ((PotionContents)output.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).addPotionTooltip(tooltips::add, 1.0f, 20.0f);
                tooltip.addAll(tooltips);
            });
        }
        if (!input.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 20, 57).setFluidRenderer(2000L, false, 16, 32).setBackground(this.liquid, 0, 0).setOverlay(this.liquid, 0, 0).addFluidStack(input.getFluid(), (long)recipe.getFluidLevelsConsumed(), input.getComponentsPatch()).addRichTooltipCallback((recipeSlotView, tooltip) -> {
                ArrayList tooltips = new ArrayList();
                ((PotionContents)input.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).addPotionTooltip(tooltips::add, 1.0f, 20.0f);
                tooltip.addAll(tooltips);
            });
        }
        if ((size = recipe.getIngredients().size()) > 0) {
            builder.addSlot(RecipeIngredientRole.INPUT, 83, 18).addIngredients((Ingredient)recipe.getIngredients().get(0));
        }
        if (size > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 105, 27).addIngredients((Ingredient)recipe.getIngredients().get(1));
        }
        if (size > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 114, 49).addIngredients((Ingredient)recipe.getIngredients().get(2));
        }
        if (size > 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 105, 71).addIngredients((Ingredient)recipe.getIngredients().get(3));
        }
        if (size > 4) {
            builder.addSlot(RecipeIngredientRole.INPUT, 83, 80).addIngredients((Ingredient)recipe.getIngredients().get(4));
        }
        if (size > 5) {
            builder.addSlot(RecipeIngredientRole.INPUT, 61, 71).addIngredients((Ingredient)recipe.getIngredients().get(5));
        }
        if (size > 6) {
            builder.addSlot(RecipeIngredientRole.INPUT, 52, 49).addIngredients((Ingredient)recipe.getIngredients().get(6));
        }
        if (size > 7) {
            builder.addSlot(RecipeIngredientRole.INPUT, 61, 27).addIngredients((Ingredient)recipe.getIngredients().get(7));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 156, changesFluid ? 30 : 49).addItemStack(recipe.getOutput());
    }

    public void draw(MixingCauldronRecipe recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        FluidStack input = recipe.getLiquid();
        FluidStack output = recipe.getLiquidOutput();
        MoonPhases.MoonCondition phase = recipe.getMoonCondition();
        float wholeScale = 1.0f;
        if (phase != MoonPhases.MoonCondition.NONE) {
            wholeScale = 0.75f;
            guiGraphics.pose().pushPose();
            float scale = 1.75f;
            guiGraphics.pose().scale(scale, scale, scale);
            guiGraphics.pose().translate(84.0f / scale, 38.0f / scale, 10.0f);
            if (phase == MoonPhases.MoonCondition.FULL_MOON) {
                this.moonPhases_0.draw(guiGraphics);
            }
            if (phase == MoonPhases.MoonCondition.WANING_GIBBOUS) {
                this.moonPhases_1.draw(guiGraphics);
            }
            if (phase == MoonPhases.MoonCondition.LAST_QUARTER) {
                this.moonPhases_2.draw(guiGraphics);
            }
            if (phase == MoonPhases.MoonCondition.WANING_CRESCENT) {
                this.moonPhases_3.draw(guiGraphics);
            }
            if (phase == MoonPhases.MoonCondition.NEW_MOON) {
                this.moonPhases_4.draw(guiGraphics);
            }
            if (phase == MoonPhases.MoonCondition.WAXING_CRESCENT) {
                this.moonPhases_5.draw(guiGraphics);
            }
            if (phase == MoonPhases.MoonCondition.FIRST_QUARTER) {
                this.moonPhases_6.draw(guiGraphics);
            }
            if (phase == MoonPhases.MoonCondition.WAXING_GIBBOUS) {
                this.moonPhases_7.draw(guiGraphics);
            }
            guiGraphics.pose().popPose();
        }
        if (recipe.getHeatCondition() == FluidMixingRecipe.HeatCondition.HEATED || recipe.getHeatCondition() == FluidMixingRecipe.HeatCondition.SUPERHEATED) {
            boolean showOutput;
            if (input != null) {
                input.setAmount(2000);
            }
            if (output != null) {
                output.setAmount(2000);
            }
            newHeatSource = (float)(Minecraft.getInstance().clientTickCount % 200L) / 200.0f;
            float craftPercent = (float)(Minecraft.getInstance().clientTickCount % 100L) / 100.0f;
            boolean bl = showOutput = Minecraft.getInstance().clientTickCount % 200L > 100L;
            if (newHeatSource <= 0.05f && this.findNewHeatSource || this.heatSource == null) {
                this.findNewHeatSource = false;
                if (Minecraft.getInstance().level != null) {
                    this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
                }
            }
            if (newHeatSource > 0.05f) {
                this.findNewHeatSource = true;
            }
            boolean compare = FluidStack.isSameFluidSameComponents((FluidStack)recipe.getLiquid(), (FluidStack)recipe.getLiquidOutput());
            Minecraft minecraft = Minecraft.getInstance();
            Component outputName = recipe.getOutput().getHoverName();
            int width = minecraft.font.width((FormattedText)outputName);
            Objects.requireNonNull(minecraft.font);
            float lineHeight = 9.0f / 2.0f;
            if (width > 131) {
                float percent = (float)width / 131.0f;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(1.0f / percent, 1.0f / percent, 1.0f / percent);
                minecraft.font.drawInBatch(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.pose().popPose();
            } else {
                minecraft.font.drawInBatch(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            BlockState blockState = (BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).defaultBlockState().setValue((Property)MixingCauldron.GUI_RENDER, (Comparable)Boolean.valueOf(true));
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            BlockRenderDispatcher rendererer = Minecraft.getInstance().getBlockRenderer();
            rendererer.getBlockModel(blockState);
            BakedModel bakedModel = rendererer.getBlockModel(blockState);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(75.0f, 67.0f, 100.0f);
            guiGraphics.pose().translate(8.0f / wholeScale, -8.0f / wholeScale, 0.0f);
            if (wholeScale != 1.0f) {
                guiGraphics.pose().translate(0.0f, 4.0f / wholeScale, 0.0f);
            }
            guiGraphics.pose().scale(16.0f * wholeScale, 16.0f * wholeScale, 16.0f * wholeScale);
            guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
            Vec3 rotationOffset = new Vec3(0.5, 0.0, 0.5);
            float zRot = 0.0f;
            float xRot = 20.0f;
            float yRot = 30.0f;
            guiGraphics.pose().translate(rotationOffset.x, rotationOffset.y, rotationOffset.z);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(zRot));
            guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(xRot));
            guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(yRot));
            guiGraphics.pose().translate(-rotationOffset.x, -rotationOffset.y, -rotationOffset.z);
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            Lighting.setupFor3DItems();
            guiGraphics.pose().last().normal().rotate((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
            this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, blockState, -1);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, -1.0f, 0.0f);
            BlockState state = this.heatSource.defaultBlockState();
            Block block = state.getBlock();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                state = (BlockState)liquidBlock.fluid.defaultFluidState().createLegacyBlock().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(7));
                MixingCauldronRenderer.renderFluidBlockGUI(guiGraphics.pose(), (MultiBufferSource)buffer, new FluidStack((Fluid)liquidBlock.fluid, 2000), 1.0f, OverlayTexture.NO_OVERLAY);
            }
            MixingCauldronRenderer.renderFluidBlockGUI(guiGraphics.pose(), (MultiBufferSource)buffer, new FluidStack((Fluid)Fluids.LAVA, 2000), 1.0f, OverlayTexture.NO_OVERLAY);
            guiGraphics.pose().popPose();
            float fillPercentage = 1.0f;
            if (!showOutput) {
                if (input.getFluid().is(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                }
                float height = 0.25f + 0.6875f * fillPercentage;
                for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                    ItemStack[] items = ((Ingredient)recipe.getIngredients().get(i)).getItems();
                    if (items.length <= 0 || items[(int)ClientEvents.getClientTicksWithoutPartial() / 40 % items.length].isEmpty()) continue;
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate(0.5, (double)(height + 0.00390625f), 0.5);
                    double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
                    guiGraphics.pose().translate(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)ClientEvents.getClientTicks() / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                    guiGraphics.pose().mulPose(Axis.YP.rotationDegrees((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((ClientEvents.getClientTicks() + (float)(i * 20)) / 40.0f))));
                    guiGraphics.pose().mulPose(Axis.XP.rotationDegrees((float)(82.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 22)) / 40.0f))));
                    guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-2.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 24)) / 40.0f))));
                    guiGraphics.pose().scale(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
                    guiGraphics.pose().scale(0.4f, 0.4f, 0.4f);
                    this.renderItem(items[(int)ClientEvents.getClientTicksWithoutPartial() / 40 % items.length], (Level)minecraft.level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
                    guiGraphics.pose().popPose();
                }
            } else {
                float percentNeeded = (float)recipe.getFluidLevelsConsumed() / 2000.0f;
                float percentChanged = percentNeeded * craftPercent;
                fillPercentage = 1.0f - percentChanged;
                if (output.isEmpty()) {
                    if (input.getFluid().is(Tags.Fluids.GASEOUS)) {
                        MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                    } else {
                        MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                    }
                } else if (output.getFluid().is(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, output, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, output, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                }
                ItemStack item2 = recipe.getOutput();
                if (!item2.isEmpty()) {
                    guiGraphics.pose().pushPose();
                    float height = 0.25f + 0.6875f * fillPercentage;
                    guiGraphics.pose().translate(0.5, (double)(height + 0.00390625f), 0.5);
                    if (fillPercentage > 0.0f) {
                        guiGraphics.pose().translate(0.0, Math.sin(Math.PI * (double)ClientEvents.getClientTicks() / 60.0 + 20.0) / 10.0 * 0.2, 0.0);
                        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees((float)(44.0 + 2.0 * Math.sin((ClientEvents.getClientTicks() + 20.0f) / 40.0f)) - (1.0f - craftPercent) * (1.0f - craftPercent) * 720.0f));
                        guiGraphics.pose().mulPose(Axis.XP.rotationDegrees((float)(82.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + 22.0f) / 40.0f))));
                        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-2.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + 24.0f) / 40.0f))));
                    } else {
                        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(45.0f - (1.0f - craftPercent) * (1.0f - craftPercent) * 720.0f));
                        guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(85.0f));
                        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(-2.5f));
                    }
                    guiGraphics.pose().scale(0.4f, 0.4f, 0.4f);
                    this.renderItem(item2, (Level)minecraft.level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
                    guiGraphics.pose().popPose();
                }
            }
            guiGraphics.pose().popPose();
            Lighting.setupFor3DItems();
            buffer.endBatch();
            RenderSystem.enableDepthTest();
            if (!output.isEmpty() && (!recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) || recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) && !compare)) {
                this.output2.draw(guiGraphics, 138, 16);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(0.6f, 0.6f, 0.6f);
                minecraft.font.drawInBatch((Component)Component.translatable((String)"gui.jei.category.mixing_cauldron.convert_fluid"), 231.574f, 96.628f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.pose().popPose();
            } else {
                this.output1.draw(guiGraphics, 138, 16);
            }
        } else {
            boolean flatLighting;
            boolean showOutput;
            if (recipe.getFluidLevelsConsumed() != 0) {
                if (!input.isEmpty()) {
                    input.setAmount(Mth.clamp((int)recipe.getFluidLevelsConsumed(), (int)0, (int)2000));
                }
            } else if (!output.isEmpty()) {
                output.setAmount(2000);
            }
            if (!output.isEmpty()) {
                output.setAmount(2000 - recipe.getFluidLevelsConsumed());
            }
            newHeatSource = (float)(Minecraft.getInstance().clientTickCount % 200L) / 200.0f;
            float craftPercent = (float)(Minecraft.getInstance().clientTickCount % 100L) / 100.0f;
            boolean bl = showOutput = Minecraft.getInstance().clientTickCount % 200L > 100L;
            if (newHeatSource <= 0.05f && this.findNewHeatSource || this.heatSource == null) {
                this.findNewHeatSource = false;
                if (Minecraft.getInstance().level != null) {
                    this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
                }
            }
            if (newHeatSource > 0.05f) {
                this.findNewHeatSource = true;
            }
            boolean compare = FluidStack.isSameFluidSameComponents((FluidStack)recipe.getLiquid(), (FluidStack)recipe.getLiquidOutput());
            Minecraft minecraft = Minecraft.getInstance();
            Component outputName = recipe.getOutput().getHoverName();
            int width = minecraft.font.width((FormattedText)outputName);
            Objects.requireNonNull(minecraft.font);
            float lineHeight = 9.0f / 2.0f;
            if (width > 131) {
                float percent = (float)width / 131.0f;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(1.0f / percent, 1.0f / percent, 1.0f / percent);
                minecraft.font.drawInBatch(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.pose().popPose();
            } else {
                minecraft.font.drawInBatch(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            BlockState blockState = (BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).defaultBlockState().setValue((Property)MixingCauldron.GUI_RENDER, (Comparable)Boolean.valueOf(true));
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            BlockRenderDispatcher rendererer = Minecraft.getInstance().getBlockRenderer();
            rendererer.getBlockModel(blockState);
            BakedModel bakedModel = rendererer.getBlockModel(blockState);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(70.0f, 73.0f, 100.0f);
            guiGraphics.pose().translate(8.0f / wholeScale, -8.0f / wholeScale, 0.0f);
            if (wholeScale != 1.0f) {
                guiGraphics.pose().translate(0.0f, 4.0f / wholeScale, 0.0f);
            }
            guiGraphics.pose().scale(20.0f * wholeScale, 20.0f * wholeScale, 20.0f * wholeScale);
            guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
            Vec3 rotationOffset = new Vec3(0.0, 0.0, 0.0);
            float zRot = 0.0f;
            float xRot = 20.0f;
            float yRot = 30.0f;
            guiGraphics.pose().translate(rotationOffset.x, rotationOffset.y, rotationOffset.z);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(zRot));
            guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(xRot));
            guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(yRot));
            guiGraphics.pose().translate(-rotationOffset.x, -rotationOffset.y, -rotationOffset.z);
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            boolean bl2 = flatLighting = !bakedModel.usesBlockLight();
            if (flatLighting) {
                Lighting.setupForFlatItems();
            }
            this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, blockState, -12566464);
            float percentNeeded = (float)recipe.getFluidLevelsConsumed() / 2000.0f;
            float percentChanged = percentNeeded * craftPercent;
            float fillPercentage = 1.0f;
            if (!showOutput) {
                if (input.getFluid().is(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                }
                float height = 0.25f + 0.6875f * fillPercentage;
                for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                    ItemStack[] items = ((Ingredient)recipe.getIngredients().get(i)).getItems();
                    if (items.length <= 0 || items[(int)ClientEvents.getClientTicksWithoutPartial() / 40 % items.length].isEmpty()) continue;
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate(0.5, (double)(height + 0.00390625f), 0.5);
                    double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
                    guiGraphics.pose().translate(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)ClientEvents.getClientTicks() / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                    guiGraphics.pose().mulPose(Axis.YP.rotationDegrees((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((ClientEvents.getClientTicks() + (float)(i * 20)) / 40.0f))));
                    guiGraphics.pose().mulPose(Axis.XP.rotationDegrees((float)(82.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 22)) / 40.0f))));
                    guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-2.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 24)) / 40.0f))));
                    guiGraphics.pose().scale(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
                    guiGraphics.pose().scale(0.4f, 0.4f, 0.4f);
                    this.renderItem(items[(int)ClientEvents.getClientTicksWithoutPartial() / 40 % items.length], (Level)minecraft.level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
                    guiGraphics.pose().popPose();
                }
            } else {
                fillPercentage = 1.0f - percentChanged;
                if (output.isEmpty()) {
                    if (input.getFluid().is(Tags.Fluids.GASEOUS)) {
                        MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                    } else {
                        MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                    }
                } else if (output.getFluid().is(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, output, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, output, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                }
                ItemStack item2 = recipe.getOutput();
                if (!item2.isEmpty()) {
                    guiGraphics.pose().pushPose();
                    float height = 0.25f + 0.6875f * fillPercentage;
                    guiGraphics.pose().translate(0.5, (double)(height + 0.00390625f), 0.5);
                    if (fillPercentage > 0.0f) {
                        guiGraphics.pose().translate(0.0, Math.sin(Math.PI * (double)ClientEvents.getClientTicks() / 60.0 + 20.0) / 10.0 * 0.2, 0.0);
                        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees((float)(44.0 + 2.0 * Math.sin((ClientEvents.getClientTicks() + 20.0f) / 40.0f)) - (1.0f - craftPercent) * (1.0f - craftPercent) * 720.0f));
                        guiGraphics.pose().mulPose(Axis.XP.rotationDegrees((float)(82.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + 22.0f) / 40.0f))));
                        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-2.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + 24.0f) / 40.0f))));
                    } else {
                        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(45.0f - (1.0f - craftPercent) * (1.0f - craftPercent) * 720.0f));
                        guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(85.0f));
                        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(-2.5f));
                    }
                    guiGraphics.pose().scale(0.4f, 0.4f, 0.4f);
                    this.renderItem(item2, (Level)minecraft.level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
                    guiGraphics.pose().popPose();
                }
            }
            buffer.endBatch();
            RenderSystem.enableDepthTest();
            if (flatLighting) {
                Lighting.setupFor3DItems();
            }
            guiGraphics.pose().popPose();
            if (!output.isEmpty() && (!recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) || recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) && !compare)) {
                this.output2.draw(guiGraphics, 138, 16);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(0.6f, 0.6f, 0.6f);
                minecraft.font.drawInBatch((Component)Component.translatable((String)"gui.jei.category.mixing_cauldron.convert_fluid"), 231.574f, 96.628f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.pose().popPose();
            } else {
                this.output1.draw(guiGraphics, 138, 16);
            }
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

