/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.HerbDryingRack;
import net.joefoxe.hexerei.data.recipes.DryingRackRecipe;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DryingRackRecipeCategory
implements IRecipeCategory<DryingRackRecipe> {
    public static final ResourceLocation UID = HexereiUtil.getResource("drying_rack");
    public static final ResourceLocation TEXTURE = HexereiUtil.getResource("textures/gui/drying_rack_jei.png");
    private final IDrawable background;
    private final IDrawable icon;

    public DryingRackRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 100, 53);
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.HERB_DRYING_RACK.get()));
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public RecipeType<DryingRackRecipe> getRecipeType() {
        return new RecipeType(UID, DryingRackRecipe.class);
    }

    public Component getTitle() {
        return ((HerbDryingRack)ModBlocks.HERB_DRYING_RACK.get()).getName();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DryingRackRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 14, 16).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 16).addItemStack(recipe.getOutput());
    }

    public void draw(DryingRackRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        String dryingTimeString;
        this.background.draw(guiGraphics);
        int dryingTime = recipe.getDryingTime();
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.6f, 0.6f, 0.6f);
        Object object = dryingTime < Integer.MAX_VALUE ? dryingTime / 20 + (String)(dryingTime % 20 == 0 ? "" : "." + dryingTime % 20) : (dryingTimeString = "?");
        if (dryingTimeString.charAt(dryingTimeString.length() - 1) == '0' && dryingTime != 0 && dryingTime % 20 != 0) {
            dryingTimeString = dryingTimeString.substring(0, dryingTimeString.length() - 1);
        }
        MutableComponent dip_time_1 = Component.translatable((String)"gui.jei.category.dipper.dry_time_1");
        MutableComponent dip_time_3 = Component.translatable((String)"gui.jei.category.dipper.resultSeconds", (Object[])new Object[]{dryingTimeString});
        minecraft.font.drawInBatch((Component)dip_time_1, 9.996f, 68.306f, -8355712, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        minecraft.font.drawInBatch((Component)dip_time_3, 91.63f, 68.306f, -8355712, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        String outputName = recipe.getOutput().getHoverName().getString();
        minecraft.font.drawInBatch(outputName, 8.33f, 6.664f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.pose().popPose();
    }
}

