/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.data.recipes.AddToCandleRecipe;
import net.joefoxe.hexerei.integration.jei.ExtraCandleIcon;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class AddToCandleRecipeCategory
implements IRecipeCategory<AddToCandleRecipe> {
    public static final ResourceLocation UID = HexereiUtil.getResource("add_to_candle");
    public static final ResourceLocation TEXTURE = HexereiUtil.getResource("textures/gui/add_to_candle_gui_jei.png");
    private IDrawable background;
    private final IDrawable icon;

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public AddToCandleRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 144, 86);
        this.icon = new ExtraCandleIcon(() -> new ItemStack((ItemLike)ModItems.CANDLE.get()));
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public RecipeType<AddToCandleRecipe> getRecipeType() {
        return new RecipeType(HexereiUtil.getResource("add_to_candle"), AddToCandleRecipe.class);
    }

    public Component getTitle() {
        return Component.translatable((String)"Adding to Candles");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AddToCandleRecipe recipe, IFocusGroup focuses) {
        builder.moveRecipeTransferButton(160, 90);
        builder.setShapeless();
        int size = recipe.getIngredients().size();
        if (size > 0) {
            builder.addSlot(RecipeIngredientRole.INPUT, 15, 19).addIngredients((Ingredient)recipe.getIngredients().get(0));
        }
        if (size > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 19).addIngredients((Ingredient)recipe.getIngredients().get(1));
        }
        if (size > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 51, 19).addIngredients((Ingredient)recipe.getIngredients().get(2));
        }
        if (size > 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 15, 37).addIngredients((Ingredient)recipe.getIngredients().get(3));
        }
        if (size > 4) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 37).addIngredients((Ingredient)recipe.getIngredients().get(4));
        }
        if (size > 5) {
            builder.addSlot(RecipeIngredientRole.INPUT, 51, 37).addIngredients((Ingredient)recipe.getIngredients().get(5));
        }
        if (size > 6) {
            builder.addSlot(RecipeIngredientRole.INPUT, 15, 55).addIngredients((Ingredient)recipe.getIngredients().get(6));
        }
        if (size > 7) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 55).addIngredients((Ingredient)recipe.getIngredients().get(7));
        }
        if (size > 8) {
            builder.addSlot(RecipeIngredientRole.INPUT, 51, 55).addIngredients((Ingredient)recipe.getIngredients().get(8));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 37).addItemStack(recipe.getOutput());
    }

    public void draw(AddToCandleRecipe recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        this.background.draw(guiGraphics);
        Component outputName = ((Ingredient)recipe.getIngredients().get(0)).getItems()[0].getHoverName();
        int width = minecraft.font.width((FormattedText)outputName);
        Objects.requireNonNull(minecraft.font);
        float lineHeight = 9.0f / 2.0f;
        if (width > 131) {
            float percent = (float)width / 131.0f;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(1.0f / percent, 1.0f / percent, 1.0f / percent);
            minecraft.font.drawInBatch(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            guiGraphics.pose().popPose();
        } else {
            minecraft.font.drawInBatch(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

