/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.events;

import net.joefoxe.hexerei.item.custom.WitchArmorItem;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class WitchArmorEvent {
    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Witch) {
            Witch witch = (Witch)livingEntity;
            if (this.isEquippedBy(event.getNewAboutToBeSetTarget(), 2)) {
                event.setNewAboutToBeSetTarget(null);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(EntityTickEvent.Pre event) {
        Witch witch;
        Entity entity = event.getEntity();
        if (entity instanceof Witch && this.isEquippedBy((witch = (Witch)entity).getLastHurtByMob(), 2)) {
            witch.setLastHurtByMob(null);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingDamageEvent.Pre event) {
        if (event.getSource().is(DamageTypes.MAGIC)) {
            LivingEntity livingEntity;
            Entity entity = event.getSource().getEntity();
            if (entity instanceof LivingEntity && this.isEquippedBy(livingEntity = (LivingEntity)entity, 3)) {
                event.setNewDamage(event.getOriginalDamage() * 1.25f);
                livingEntity.heal(event.getOriginalDamage() * 0.15f);
            }
            if (this.isEquippedBy(event.getEntity(), 2)) {
                event.setNewDamage(event.getOriginalDamage() / 2.0f);
            }
        }
    }

    private boolean isEquippedBy(LivingEntity entity, int numEquipCheck) {
        int numEquip = 0;
        if (entity == null) {
            return false;
        }
        for (ItemStack armorStack : entity.getArmorSlots()) {
            if (!(armorStack.getItem() instanceof WitchArmorItem)) continue;
            ++numEquip;
        }
        return numEquip >= numEquipCheck;
    }
}

