/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PestleAndMortarRecipe
implements Recipe<CraftingInput> {
    private final ItemStack output;
    private final int grindingTime;
    private final NonNullList<Ingredient> input;

    public boolean isSpecial() {
        return true;
    }

    public PestleAndMortarRecipe(ItemStack output, NonNullList<Ingredient> input, int grindingTime) {
        this.output = output;
        this.input = input;
        this.grindingTime = grindingTime;
    }

    public boolean matches(CraftingInput input, Level level) {
        List itemMatchesSlot = Stream.generate(() -> false).limit(input.size()).collect(Collectors.toList());
        boolean flag = false;
        if (input.size() != this.input.size()) {
            return false;
        }
        for (Ingredient recipeItem : this.input) {
            for (int i = 0; i < input.size(); ++i) {
                if (!recipeItem.test(input.getItem(i)) || ((Boolean)itemMatchesSlot.get(i)).booleanValue()) continue;
                itemMatchesSlot.set(i, true);
                flag = true;
                break;
            }
            if (!flag) break;
            flag = false;
        }
        for (int i = 0; i < input.size(); ++i) {
            if (((Boolean)itemMatchesSlot.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.input;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.getOutput();
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.PESTLE_AND_MORTAR.get());
    }

    public int getGrindingTime() {
        return this.grindingTime;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.PESTLE_AND_MORTAR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<PestleAndMortarRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pestle_and_mortar";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<PestleAndMortarRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<PestleAndMortarRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)NonNullList.codecOf((Codec)Ingredient.CODEC).fieldOf("ingredients").forGetter(recipe -> recipe.input), (App)Codec.INT.fieldOf("grindingTime").forGetter(recipe -> recipe.grindingTime)).apply((Applicative)instance, PestleAndMortarRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PestleAndMortarRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<PestleAndMortarRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PestleAndMortarRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static PestleAndMortarRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            NonNullList inputs = NonNullList.withSize((int)buffer.readInt(), (Object)Ingredient.EMPTY);
            inputs.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            int grindingTime = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            return new PestleAndMortarRecipe(output, (NonNullList<Ingredient>)inputs, grindingTime);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, PestleAndMortarRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeInt(recipe.input.size());
            for (Ingredient ingredient : recipe.input) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ByteBufCodecs.INT.encode((Object)buffer, (Object)recipe.grindingTime);
        }
    }
}

