/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.joefoxe.hexerei.data.books.HexereiBookItem;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.data_components.BookColorData;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class BookOfShadowsDyeRecipe
extends CustomRecipe {
    protected BookOfShadowsDyeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        HashMap<Tuple, List> posDyes = new HashMap<Tuple, List>();
        Tuple posBook = null;
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            int column = slot % inv.width();
            int row = slot / inv.width();
            if (slotStack.isEmpty()) continue;
            if (slotStack.getItem() instanceof HexereiBookItem) {
                if (posBook != null) {
                    return false;
                }
                posBook = new Tuple((Object)new Tuple((Object)column, (Object)row), (Object)slotStack);
                continue;
            }
            if (slotStack.is(Tags.Items.DYES)) {
                DyeColor dyeColor = DyeColor.getColor((ItemStack)slotStack);
                if (dyeColor == null) {
                    return false;
                }
                posDyes.computeIfAbsent(new Tuple((Object)column, (Object)row), c -> new ArrayList()).add(dyeColor);
                continue;
            }
            return false;
        }
        if (posBook == null || posDyes.isEmpty()) {
            return false;
        }
        boolean mainDye = false;
        boolean trimDye = false;
        for (Map.Entry entry : posDyes.entrySet()) {
            int dyeCol = (Integer)((Tuple)entry.getKey()).getA();
            int dyeRow = (Integer)((Tuple)entry.getKey()).getB();
            int bookCol = (Integer)((Tuple)posBook.getA()).getA();
            int bookRow = (Integer)((Tuple)posBook.getA()).getB();
            if (dyeCol == bookCol + 1 && dyeRow == bookRow) {
                if (!mainDye) {
                    mainDye = true;
                    continue;
                }
                return false;
            }
            if (dyeCol == bookCol - 1 && dyeRow == bookRow) {
                if (!mainDye) {
                    mainDye = true;
                    continue;
                }
                return false;
            }
            if (dyeRow == bookRow + 1 && dyeCol == bookCol) {
                if (!trimDye) {
                    trimDye = true;
                    continue;
                }
                return false;
            }
            if (dyeRow == bookRow - 1 && dyeCol == bookCol) {
                if (!trimDye) {
                    trimDye = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        HashMap<Tuple<Integer, Integer>, List<DyeColor>> posDyes = new HashMap<Tuple<Integer, Integer>, List<DyeColor>>();
        Tuple posBook = null;
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (slotStack.isEmpty()) continue;
            int column = slot % inv.width();
            int row = slot / inv.width();
            if (slotStack.getItem() instanceof HexereiBookItem) {
                if (posBook != null) {
                    return ItemStack.EMPTY;
                }
                posBook = new Tuple((Object)new Tuple((Object)column, (Object)row), (Object)slotStack);
                continue;
            }
            if (slotStack.is(Tags.Items.DYES)) {
                DyeColor dyeColor = DyeColor.getColor((ItemStack)slotStack);
                if (dyeColor == null) {
                    return ItemStack.EMPTY;
                }
                posDyes.computeIfAbsent((Tuple<Integer, Integer>)new Tuple((Object)column, (Object)row), c -> new ArrayList()).add(dyeColor);
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (posBook == null) {
            return ItemStack.EMPTY;
        }
        ItemStack book = ((ItemStack)posBook.getB()).copy();
        book.setCount(1);
        this.applyColors(posDyes, book, (Tuple<Integer, Integer>)((Tuple)posBook.getA()));
        return book;
    }

    private void applyColors(Map<Tuple<Integer, Integer>, List<DyeColor>> posDyes, ItemStack book, Tuple<Integer, Integer> posBook) {
        ArrayList mainDyes = new ArrayList();
        ArrayList trimDyes = new ArrayList();
        for (Map.Entry<Tuple<Integer, Integer>, List<DyeColor>> entry : posDyes.entrySet()) {
            if ((Integer)entry.getKey().getA() == (Integer)posBook.getA() + 1 && ((Integer)entry.getKey().getB()).equals(posBook.getB())) {
                mainDyes.addAll(entry.getValue());
            }
            if ((Integer)entry.getKey().getA() == (Integer)posBook.getA() - 1 && ((Integer)entry.getKey().getB()).equals(posBook.getB())) {
                mainDyes.addAll(entry.getValue());
            }
            if ((Integer)entry.getKey().getB() == (Integer)posBook.getB() + 1 && ((Integer)entry.getKey().getA()).equals(posBook.getA())) {
                trimDyes.addAll(entry.getValue());
            }
            if ((Integer)entry.getKey().getB() != (Integer)posBook.getB() - 1 || !((Integer)entry.getKey().getA()).equals(posBook.getA())) continue;
            trimDyes.addAll(entry.getValue());
        }
        BookColorData bookColorData = (BookColorData)book.get(ModDataComponents.BOOK_COLORS);
        if (bookColorData != null) {
            int dye1 = bookColorData.color1();
            int dye2 = bookColorData.color2();
            if (!mainDyes.isEmpty()) {
                dye1 = ((DyeColor)mainDyes.get(0)).getTextureDiffuseColor();
            }
            if (!trimDyes.isEmpty()) {
                dye2 = ((DyeColor)trimDyes.get(0)).getTextureDiffuseColor();
            }
            bookColorData = new BookColorData(dye1, dye2);
        }
        book.set(ModDataComponents.BOOK_COLORS, (Object)bookColorData);
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getOutput() {
        return this.getResultItem(null);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BOOK_OF_SHADOWS_DYE_SERIALIZER.get();
    }
}

