/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.concurrent.CompletableFuture;
import net.joefoxe.hexerei.data.datagen.AddToCandleRecipeBuilder;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CandleItem;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries);
    }

    public static String getItemName(ItemLike pItemLike) {
        return BuiltInRegistries.ITEM.getKey((Object)pItemLike.asItem()).getPath();
    }

    public static String getAddCandleRecipeName(ItemLike pResult) {
        return "add_to_candle/" + ModRecipeProvider.getItemName(pResult) + "_add_to_candle";
    }

    public static String getWoodcuttingRecipeName(String type, Item result, Item input) {
        return "woodcutting/" + type + "/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath() + "_from_" + BuiltInRegistries.ITEM.getKey((Object)input).getPath() + "_woodcutting";
    }

    protected void buildRecipes(RecipeOutput p_recipeOutput) {
        JsonArray recipesAddToCandle;
        File add_to_candle_file = new File("recipe-builder/add_to_candle.json");
        try {
            JsonElement jsonElement = JsonParser.parseReader((Reader)new FileReader(add_to_candle_file.getAbsolutePath()));
            recipesAddToCandle = GsonHelper.getAsJsonArray((JsonObject)jsonElement.getAsJsonObject(), (String)"values");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        JsonArray finalRecipesToAdd = recipesAddToCandle;
        BuiltInRegistries.BLOCK.forEach(block -> finalRecipesToAdd.forEach(recipeBlock -> {
            if (BuiltInRegistries.BLOCK.getKey(block).toString().equals(recipeBlock.getAsString())) {
                ItemStack stack = new ItemStack((ItemLike)ModItems.CANDLE.get());
                CandleItem.setLayerFromBlock(stack, BuiltInRegistries.BLOCK.getKey(block).toString(), "base");
                new AddToCandleRecipeBuilder((ItemLike)block.asItem(), stack).unlockedBy("has_candle", ModRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ModItems.CANDLE.get()}).build()})).save(p_recipeOutput, ModRecipeProvider.getAddCandleRecipeName((ItemLike)block));
            }
        }));
    }
}

