/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.coffer;

import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.joefoxe.hexerei.Hexerei;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class CofferInventorySavedData
extends SavedData {
    protected static final String DATA_NAME = "hexerei_coffer_inventories";
    private final Map<UUID, NonNullList<ItemStack>> inventories = new HashMap<UUID, NonNullList<ItemStack>>();
    private final Map<UUID, ZonedDateTime> lastModified = new HashMap<UUID, ZonedDateTime>();
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_ZONED_DATE_TIME;

    public Map<UUID, ZonedDateTime> getLastModified() {
        return new HashMap<UUID, ZonedDateTime>(this.lastModified);
    }

    public NonNullList<ItemStack> getInventory(UUID cofferId) {
        if (cofferId == null) {
            return NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        }
        if (this.inventories.containsKey(cofferId)) {
            return this.inventories.get(cofferId);
        }
        this.inventories.put(cofferId, (NonNullList<ItemStack>)NonNullList.withSize((int)36, (Object)ItemStack.EMPTY));
        return this.inventories.get(cofferId);
    }

    public void setLastModified(UUID cofferId) {
        this.lastModified.put(cofferId, ZonedDateTime.now(ZoneOffset.UTC));
    }

    private static CofferInventorySavedData create(CompoundTag tag, HolderLookup.Provider registries) {
        CofferInventorySavedData data = new CofferInventorySavedData();
        data.load(tag, registries);
        return data;
    }

    public void load(CompoundTag pCompoundTag, HolderLookup.Provider registries) {
        this.inventories.clear();
        this.lastModified.clear();
        if (pCompoundTag.contains("Inventories", 10)) {
            CompoundTag inventoriesTag = pCompoundTag.getCompound("Inventories");
            for (String cofferIdStr : inventoriesTag.getAllKeys()) {
                UUID cofferId = UUID.fromString(cofferIdStr);
                CompoundTag cofferTag = inventoriesTag.getCompound(cofferIdStr);
                if (cofferTag.contains("LastModified", 8)) {
                    try {
                        ZonedDateTime modifiedTime = ZonedDateTime.parse(cofferTag.getString("LastModified"), FORMATTER);
                        this.lastModified.put(cofferId, modifiedTime);
                    }
                    catch (DateTimeException e) {
                        Hexerei.LOGGER.error("Failed to parse last modified time for coffer {}", (Object)cofferId, (Object)e);
                        this.lastModified.put(cofferId, ZonedDateTime.now(ZoneOffset.UTC));
                    }
                }
                NonNullList items = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
                if (cofferTag.contains("Items", 9)) {
                    ListTag itemsTag = cofferTag.getList("Items", 10);
                    for (int i = 0; i < itemsTag.size(); ++i) {
                        CompoundTag slotTag = itemsTag.getCompound(i);
                        int slot = slotTag.getInt("Slot");
                        if (slot < 0 || slot >= items.size()) continue;
                        items.set(slot, (Object)ItemStack.parse((HolderLookup.Provider)registries, (Tag)slotTag.getCompound("Item")).orElse(ItemStack.EMPTY));
                    }
                }
                this.inventories.put(cofferId, (NonNullList<ItemStack>)items);
            }
        }
    }

    public CompoundTag save(CompoundTag pCompoundTag, HolderLookup.Provider registries) {
        CompoundTag inventoriesTag = new CompoundTag();
        for (Map.Entry<UUID, NonNullList<ItemStack>> entry : this.inventories.entrySet()) {
            UUID cofferId = entry.getKey();
            if (cofferId == null) continue;
            NonNullList<ItemStack> items = entry.getValue();
            CompoundTag cofferTag = new CompoundTag();
            ListTag itemsTag = new ListTag();
            if (this.lastModified.containsKey(cofferId)) {
                cofferTag.putString("LastModified", this.lastModified.get(cofferId).format(FORMATTER));
            }
            for (int slot = 0; slot < items.size(); ++slot) {
                ItemStack stack = (ItemStack)items.get(slot);
                if (stack.isEmpty()) continue;
                CompoundTag slotTag = new CompoundTag();
                slotTag.putInt("Slot", slot);
                Tag itemTag = stack.save(registries, (Tag)slotTag);
                slotTag.put("Item", itemTag);
                itemsTag.add((Object)slotTag);
            }
            cofferTag.put("Items", (Tag)itemsTag);
            inventoriesTag.put(cofferId.toString(), (Tag)cofferTag);
        }
        pCompoundTag.put("Inventories", (Tag)inventoriesTag);
        return pCompoundTag;
    }

    public static SavedData.Factory<CofferInventorySavedData> factory() {
        return new SavedData.Factory(CofferInventorySavedData::new, CofferInventorySavedData::create, null);
    }

    public static CofferInventorySavedData get(ServerLevel world) {
        return (CofferInventorySavedData)world.getServer().overworld().getDataStorage().computeIfAbsent(CofferInventorySavedData.factory(), DATA_NAME);
    }

    public static CofferInventorySavedData get() {
        return (CofferInventorySavedData)ServerLifecycleHooks.getCurrentServer().overworld().getDataStorage().computeIfAbsent(CofferInventorySavedData.factory(), DATA_NAME);
    }
}

