/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.candle;

import java.util.HashMap;
import java.util.Map;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.BonemealingCandleEffect;
import net.joefoxe.hexerei.data.candle.PotionCandleEffect;
import net.joefoxe.hexerei.data.candle.SunshineCandleEffect;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;

public class CandleEffects {
    public static Map<String, AbstractCandleEffect> effects;

    public static void init() {
        effects = new HashMap<String, AbstractCandleEffect>();
        BuiltInRegistries.MOB_EFFECT.forEach(mobEffect -> {
            ResourceLocation loc = BuiltInRegistries.MOB_EFFECT.getKey(mobEffect);
            String str = loc != null ? loc.toString() : mobEffect.getDescriptionId();
            effects.put(str, new PotionCandleEffect((MobEffect)mobEffect));
        });
        effects.put(HexereiUtil.getResource("growth_effect").toString(), new BonemealingCandleEffect());
        effects.put(HexereiUtil.getResource("sunshine_effect").toString(), new SunshineCandleEffect());
    }

    public static AbstractCandleEffect getEffect(String key) {
        if (effects == null) {
            CandleEffects.init();
        }
        return effects.containsKey(key) ? effects.get(key).getCopy() : new AbstractCandleEffect();
    }
}

