/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.joefoxe.hexerei.data.books.BookTooltipExtra;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BookBlocks {
    public float x;
    public float y;
    public BlockState blockState;
    public String type;
    public String tag;
    public boolean show_slot;
    public boolean refreshTag = false;
    public TagKey<Block> key;
    public List<Component> extra_tooltips = new ArrayList<Component>();
    List<BookTooltipExtra> extra_tooltips_raw;
    public static final Codec<BookBlocks> BLOCK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(e -> e.type), (App)Codec.FLOAT.optionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.x)), (App)Codec.FLOAT.optionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.y)), (App)Codec.STRING.fieldOf("id").forGetter(e -> BuiltInRegistries.BLOCK.getKey((Object)e.blockState.getBlock()).toString()), (App)Codec.BOOL.optionalFieldOf("show_slot", (Object)true).forGetter(e -> e.show_slot), (App)BookTooltipExtra.CODEC.listOf().optionalFieldOf("extra_tooltips", new ArrayList()).forGetter(e -> e.extra_tooltips_raw)).apply((Applicative)instance, BookBlocks::new));
    public static final Codec<BookBlocks> TAG_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(e -> e.type), (App)Codec.FLOAT.optionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.x)), (App)Codec.FLOAT.optionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.y)), (App)Codec.STRING.optionalFieldOf("id", (Object)"missing").forGetter(e -> e.tag), (App)Codec.BOOL.optionalFieldOf("show_slot", (Object)true).forGetter(e -> e.show_slot), (App)BookTooltipExtra.CODEC.listOf().optionalFieldOf("extra_tooltips", new ArrayList()).forGetter(e -> e.extra_tooltips_raw)).apply((Applicative)instance, BookBlocks::new));
    public static final Codec<BookBlocks> CODEC = Codec.of(BookBlocks::encode, BookBlocks::decode);

    BookBlocks(String type, float x, float y, String tag_or_block, boolean show_slot, List<BookTooltipExtra> extra_tooltips_raw) {
        if (type.equals("tag")) {
            this.blockState = Blocks.AIR.defaultBlockState();
            this.tag = tag_or_block;
            this.key = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)this.tag));
            if (BuiltInRegistries.BLOCK.getTag(this.key).isPresent()) {
                BuiltInRegistries.BLOCK.getRandomElementOf(this.key, RandomSource.create()).ifPresentOrElse(blockHolder -> {
                    this.blockState = ((Block)blockHolder.value()).defaultBlockState();
                }, () -> {
                    this.blockState = Blocks.AIR.defaultBlockState();
                });
            }
        } else {
            Block block = BuiltInRegistries.BLOCK.containsKey(ResourceLocation.parse((String)tag_or_block)) ? (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag_or_block)) : Blocks.AIR;
            this.blockState = block.defaultBlockState();
        }
        this.type = type;
        this.show_slot = show_slot;
        this.x = x;
        this.y = y;
        this.extra_tooltips_raw = extra_tooltips_raw;
        for (BookTooltipExtra tooltipExtra : extra_tooltips_raw) {
            if (!tooltipExtra.color_hex.isEmpty()) {
                tooltipExtra.color = (int)Long.parseLong(tooltipExtra.color_hex, 16);
            }
            if (tooltipExtra.type.equals("append")) {
                this.extra_tooltips.getLast().getSiblings().add(Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
                continue;
            }
            this.extra_tooltips.add((Component)Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
        }
    }

    public static <T> DataResult<T> encode(BookBlocks block, DynamicOps<T> ops, T prefix) {
        return switch (block.type) {
            case "block" -> BLOCK_CODEC.encode((Object)block, ops, prefix);
            case "tag" -> TAG_CODEC.encode((Object)block, ops, prefix);
            default -> DataResult.error(() -> "Unknown type: " + block.type);
        };
    }

    public static <T> DataResult<Pair<BookBlocks, T>> decode(DynamicOps<T> ops, T input) {
        String type;
        Optional typeOpt = ops.get(input, "type").result();
        if (typeOpt.isEmpty()) {
            return DataResult.error(() -> "Missing type field");
        }
        Dynamic typeDynamic = new Dynamic(ops, typeOpt.get());
        return switch (type = typeDynamic.asString("")) {
            case "block" -> BLOCK_CODEC.decode(ops, input);
            case "tag" -> TAG_CODEC.decode(ops, input);
            default -> DataResult.error(() -> "Unknown type: " + type);
        };
    }
}

