/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.CourierLetter;
import net.joefoxe.hexerei.block.custom.CourierPackage;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.client.renderer.entity.model.OwlModel;
import net.joefoxe.hexerei.client.renderer.entity.render.OwlVariant;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class OwlRenderer
extends MobRenderer<OwlEntity, OwlModel<OwlEntity>> {
    public static final ResourceLocation TEXTURE = HexereiUtil.getResource("hexerei", "textures/entity/owl.png");
    private static final Map<OwlVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(OwlVariant.class), p_114874_ -> {
        p_114874_.put(OwlVariant.GREAT_HORNED, HexereiUtil.getResource("textures/entity/owl.png"));
        p_114874_.put(OwlVariant.BARN, HexereiUtil.getResource("textures/entity/owl_barn.png"));
        p_114874_.put(OwlVariant.BARRED, HexereiUtil.getResource("textures/entity/owl_barred.png"));
        p_114874_.put(OwlVariant.SNOWY, HexereiUtil.getResource("textures/entity/owl_snowy.png"));
    });

    public OwlRenderer(EntityRendererProvider.Context erm) {
        super(erm, new OwlModel(erm.bakeLayer(OwlModel.LAYER_LOCATION)), 0.25f);
        this.addLayer(new LayerOwlItem(this));
        this.addLayer(new LayerOwlCollar((RenderLayerParent<OwlEntity, OwlModel<OwlEntity>>)this));
        this.addLayer(new LayerOwlHelmet(this, erm));
    }

    public ResourceLocation getTextureLocation(OwlEntity pEntity) {
        return LOCATION_BY_VARIANT.get((Object)pEntity.getVariant());
    }

    public void render(OwlEntity owlEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((LivingEntity)owlEntity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    protected void scale(OwlEntity entitylivingbaseIn, PoseStack poseStack, float partialTickTime) {
        float f = 1.0f;
        if (entitylivingbaseIn.isBaby()) {
            f *= 0.5f;
            this.shadowRadius = 0.125f;
        } else {
            this.shadowRadius = 0.25f;
        }
        poseStack.scale(f, f, f);
    }

    public static class LayerOwlItem
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        public LayerOwlItem(OwlRenderer render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, OwlEntity owl, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack = owl.getItem(1);
            poseStack.pushPose();
            this.translateToHand(poseStack);
            poseStack.translate(0.0, (double)0.075f, 0.05);
            if (itemstack.getItem() instanceof BroomItem) {
                poseStack.translate(0.1f, 0.12f, 0.06f);
            }
            if (owl.isBaby()) {
                poseStack.scale(0.75f, 0.75f, 0.75f);
            }
            poseStack.mulPose(Axis.YP.rotationDegrees(-2.5f));
            if (itemstack.getItem() instanceof BroomItem) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(-35.0f));
            poseStack.scale(0.75f, 0.75f, 0.75f);
            ItemStack stack = itemstack.copy();
            Minecraft.getInstance().gameRenderer.itemInHandRenderer.renderItem((LivingEntity)owl, stack, ItemDisplayContext.GROUND, false, poseStack, bufferIn, packedLightIn);
            poseStack.popPose();
            if (owl.messagingController.hasDelivery() && !owl.messagingController.getMessageStack().isEmpty()) {
                if (owl.messagingController.getMessageStack().getItem() == ModItems.COURIER_LETTER.get()) {
                    poseStack.pushPose();
                    this.translateToFeet(poseStack);
                    poseStack.translate(0.0f, 0.1f, 0.0f);
                    poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)owl.itemHeldSwingLast, (float)owl.itemHeldSwing) * 1.5f));
                    poseStack.translate(-0.42f, 0.0f, -0.65f);
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    this.renderBlock(poseStack, bufferIn, packedLightIn, ((CourierLetter)ModBlocks.COURIER_LETTER.get()).defaultBlockState());
                    poseStack.popPose();
                }
                if (owl.messagingController.getMessageStack().getItem() == ModItems.COURIER_PACKAGE.get()) {
                    poseStack.pushPose();
                    this.translateToFeet(poseStack);
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)owl.itemHeldSwingLast, (float)owl.itemHeldSwing) * 1.5f));
                    poseStack.translate(0.57f, 0.3f, -0.2f);
                    poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    this.renderBlock(poseStack, bufferIn, packedLightIn, ((CourierPackage)ModBlocks.COURIER_PACKAGE.get()).defaultBlockState());
                    poseStack.popPose();
                }
            }
        }

        private void renderBlock(PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, poseStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((OwlModel)this.getParentModel()).owl.translateAndRotate(matrixStack);
            ((OwlModel)this.getParentModel()).owl.getChild("head").translateAndRotate(matrixStack);
            ((OwlModel)this.getParentModel()).owl.getChild("head").getChild("beak").translateAndRotate(matrixStack);
        }

        protected void translateToFeet(PoseStack matrixStack) {
            ((OwlModel)this.getParentModel()).owl.translateAndRotate(matrixStack);
            ((OwlModel)this.getParentModel()).owl.getChild("rightLeg").translateAndRotate(matrixStack);
        }
    }

    public static class LayerOwlCollar
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        private static final ResourceLocation OWL_DYE_LOCATION = HexereiUtil.getResource("textures/entity/owl_dye.png");

        public LayerOwlCollar(RenderLayerParent<OwlEntity, OwlModel<OwlEntity>> p_117707_) {
            super(p_117707_);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, OwlEntity entity, float p_117724_, float p_117725_, float p_117726_, float p_117727_, float p_117728_, float p_117729_) {
            if (entity.isTame() && !entity.isInvisible() && (entity.getDyeColorId() != -1 || entity.getName().getString().equals("jeb_") || entity.getName().getString().equals("joe_"))) {
                float[] afloat = HexereiUtil.rgbIntToFloatArray(entity.getDyeColor().getTextureDiffuseColor());
                VertexConsumer vertexConsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)OWL_DYE_LOCATION), (boolean)false, (boolean)false);
                ((OwlModel)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(afloat[0], afloat[1], afloat[2], 1.0f));
            }
        }
    }

    public static class LayerOwlHelmet
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        private final RenderLayerParent<OwlEntity, OwlModel<OwlEntity>> renderer;
        private final HumanoidModel<?> defaultBipedModel;
        private final TextureAtlas armorTrimAtlas;

        public LayerOwlHelmet(OwlRenderer renderer, EntityRendererProvider.Context renderManagerIn) {
            super((RenderLayerParent)renderer);
            this.renderer = renderer;
            this.defaultBipedModel = new HumanoidModel(renderManagerIn.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
            this.armorTrimAtlas = Minecraft.getInstance().getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
        }

        private void renderTrim(Holder<ArmorMaterial> p_323506_, PoseStack p_289687_, MultiBufferSource p_289643_, int p_289683_, ArmorTrim p_289692_, Model p_289663_, boolean p_289651_) {
            TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.getSprite(p_289651_ ? p_289692_.innerTexture(p_323506_) : p_289692_.outerTexture(p_323506_));
            VertexConsumer vertexconsumer = textureatlassprite.wrap(p_289643_.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)p_289692_.pattern().value()).decal())));
            p_289663_.renderToBuffer(p_289687_, vertexconsumer, p_289683_, OverlayTexture.NO_OVERLAY);
        }

        private void renderGlint(PoseStack p_289673_, MultiBufferSource p_289654_, int p_289649_, Model p_289659_) {
            p_289659_.renderToBuffer(p_289673_, p_289654_.getBuffer(RenderType.armorEntityGlint()), p_289649_, OverlayTexture.NO_OVERLAY);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, OwlEntity owl, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            poseStack.pushPose();
            ItemStack itemstack = owl.itemHandler.getStackInSlot(0);
            Item item = itemstack.getItem();
            if (item instanceof ArmorItem) {
                ArmorItem armoritem = (ArmorItem)item;
                EquipmentSlot pSlot = armoritem.getEquipmentSlot();
                HumanoidModel<?> a = this.defaultBipedModel;
                a = this.getArmorModelHook((LivingEntity)owl, itemstack, EquipmentSlot.HEAD, a);
                a.setAllVisible(false);
                a.hat.visible = true;
                a.head.visible = true;
                this.translateToHead(poseStack);
                poseStack.scale(0.65f, 0.65f, 0.65f);
                poseStack.translate(0.0f, 0.15f, -0.05f);
                Model model = ClientHooks.getArmorModel((LivingEntity)owl, (ItemStack)itemstack, (EquipmentSlot)pSlot, a);
                ArmorMaterial armormaterial = (ArmorMaterial)armoritem.getMaterial().value();
                boolean flag1 = itemstack.hasFoil();
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)itemstack);
                extensions.setupModelAnimations((LivingEntity)owl, itemstack, EquipmentSlot.HEAD, model, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
                for (int layerIdx = 0; layerIdx < armormaterial.layers().size(); ++layerIdx) {
                    ArmorMaterial.Layer armormaterial$layer = (ArmorMaterial.Layer)armormaterial.layers().get(layerIdx);
                    int j = extensions.getArmorLayerTintColor(itemstack, (LivingEntity)owl, armormaterial$layer, layerIdx, -1);
                    ResourceLocation texture = ClientHooks.getArmorTexture((Entity)owl, (ItemStack)itemstack, (ArmorMaterial.Layer)armormaterial$layer, (boolean)false, (EquipmentSlot)pSlot);
                    this.renderHelmet(poseStack, bufferIn, packedLightIn, flag1, a, j, texture);
                }
                ArmorTrim armortrim = (ArmorTrim)itemstack.get(DataComponents.TRIM);
                if (armortrim != null) {
                    this.renderTrim((Holder<ArmorMaterial>)armoritem.getMaterial(), poseStack, bufferIn, packedLightIn, armortrim, model, false);
                }
                if (itemstack.hasFoil()) {
                    this.renderGlint(poseStack, bufferIn, packedLightIn, model);
                }
            } else if (Block.byItem((Item)itemstack.getItem()) instanceof AbstractSkullBlock) {
                this.translateToHand(poseStack);
                poseStack.scale(0.45f, 0.45f, 0.45f);
                poseStack.translate(0.0f, -0.25f, -0.2f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                this.renderItem(itemstack, owl.level(), poseStack, bufferIn, packedLightIn);
            }
            poseStack.popPose();
        }

        private void renderItem(ItemStack stack, Level level, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, poseStack, bufferIn, level, 1);
        }

        private void translateToHead(PoseStack poseStack) {
            this.translateToChest(poseStack);
            ((OwlModel)this.renderer.getModel()).head.translateAndRotate(poseStack);
        }

        private void translateToChest(PoseStack poseStack) {
            ((OwlModel)this.renderer.getModel()).owl.translateAndRotate(poseStack);
        }

        private void renderHelmet(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, int color, ResourceLocation armorResource) {
            VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
            ((OwlModel)this.renderer.getModel()).copyPropertiesTo((EntityModel)modelIn);
            modelIn.head.xRot = 0.0f;
            modelIn.head.yRot = 0.0f;
            modelIn.head.zRot = 0.0f;
            modelIn.hat.xRot = 0.0f;
            modelIn.hat.yRot = 0.0f;
            modelIn.hat.zRot = 0.0f;
            modelIn.head.x = 0.0f;
            modelIn.head.y = 0.0f;
            modelIn.head.z = 0.0f;
            modelIn.hat.x = 0.0f;
            modelIn.hat.y = 0.0f;
            modelIn.hat.z = 0.0f;
            modelIn.renderToBuffer(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, color);
        }

        protected HumanoidModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
            Model basicModel = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
            return basicModel instanceof HumanoidModel ? (HumanoidModel)basicModel : model;
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((OwlModel)this.getParentModel()).owl.translateAndRotate(matrixStack);
            ((OwlModel)this.getParentModel()).owl.getChild("head").translateAndRotate(matrixStack);
        }
    }
}

