/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.BroomType;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.client.renderer.entity.model.ArmorModels;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomAttachmentItem;
import net.joefoxe.hexerei.item.custom.BroomBrushItem;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.joefoxe.hexerei.item.custom.BroomStickItem;
import net.joefoxe.hexerei.item.custom.KeychainItem;
import net.joefoxe.hexerei.item.custom.SatchelItem;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class BroomRenderer
extends EntityRenderer<BroomEntity> {
    protected static final ResourceLocation TEXTURE = HexereiUtil.getResource("textures/entity/broom.png");
    private static final ResourceLocation POWER_LOCATION = HexereiUtil.getResource("textures/entity/power_layer_light.png");

    public BroomRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.0f;
        ArmorModels.init(context);
    }

    public ResourceLocation getTextureLocation(BroomEntity p_114482_) {
        return TEXTURE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void render(BroomEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        block44: {
            BroomAttachmentItem miscItem;
            ItemStack itemStack;
            ItemStack satchelStack;
            block47: {
                block46: {
                    block45: {
                        Item vertexConsumer;
                        Item broomBrushModel2;
                        Item brushVertexConsumer;
                        BroomBrushItem brushItem;
                        ItemStack brushStack;
                        Item item;
                        float f2;
                        BroomType broomType = entityIn.getBroomType();
                        matrixStackIn.pushPose();
                        if (entityIn.deltaMovementOld == null) {
                            entityIn.deltaMovementOld = entityIn.getDeltaMovement();
                        }
                        if (entityIn.deltaRotationOld == 0.0f) {
                            entityIn.deltaRotationOld = entityIn.deltaRotation;
                        }
                        float deltaRotation = Math.clamp(Mth.lerp((float)partialTicks, (float)entityIn.deltaRotationOld, (float)entityIn.deltaRotation), -13.0f + entityIn.deltaRotation / 22.5f, 13.0f + entityIn.deltaRotation / 22.5f);
                        float floatingOffset = Mth.lerp((float)partialTicks, (float)entityIn.floatingOffsetOld, (float)entityIn.floatingOffset);
                        float deltaMovementX = Mth.lerp((float)partialTicks, (float)((float)entityIn.deltaMovementOld.x()), (float)((float)entityIn.getDeltaMovement().x()));
                        float deltaMovementY = Mth.lerp((float)partialTicks, (float)((float)entityIn.deltaMovementOld.y()), (float)((float)entityIn.getDeltaMovement().y()));
                        float deltaMovementZ = Mth.lerp((float)partialTicks, (float)((float)entityIn.deltaMovementOld.z()), (float)((float)entityIn.getDeltaMovement().z()));
                        Vec3 deltaLerp = new Vec3((double)deltaMovementX, (double)deltaMovementY, (double)deltaMovementZ);
                        matrixStackIn.translate(0.0, 0.375 + (double)floatingOffset, 0.0);
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - HexereiUtil.lerpAngle(entityIn.yRotO, entityIn.getYRot(), partialTicks) - deltaRotation * 2.0f));
                        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(deltaMovementY * 25.0f));
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(deltaRotation * 3.0f));
                        float f = (float)entityIn.getTimeSinceHit() - partialTicks;
                        float f1 = entityIn.getDamageTaken() - partialTicks;
                        if (f1 < 0.0f) {
                            f1 = 0.0f;
                        }
                        if (f > 0.0f) {
                            matrixStackIn.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)entityIn.getForwardDirection()));
                        }
                        if (!Mth.equal((float)(f2 = entityIn.getRockingAngle(partialTicks)), (float)0.0f)) {
                            matrixStackIn.mulPose(new Quaternionf().setAngleAxis(f2 * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
                        }
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                        matrixStackIn.translate(0.0, -1.6, 0.0);
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                        matrixStackIn.translate(0.0, -2.75, 0.0);
                        Item item2 = broomType.item();
                        if (item2 instanceof BroomStickItem) {
                            BroomStickItem broomItem = (BroomStickItem)item2;
                            if (broomItem.model == null) {
                                broomItem.bakeModels();
                            }
                            if (broomItem.model != null) {
                                VertexConsumer ivertexbuilderStick = bufferIn.getBuffer(broomItem.model.renderType(broomItem.texture));
                                broomItem.model.renderToBuffer(matrixStackIn, ivertexbuilderStick, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
                            }
                            if (BroomEntity.getDyeColorNamed(entityIn) != null && broomItem.outter_model != null) {
                                void var19_21;
                                DyeColor dyeColor = BroomEntity.getDyeColorNamed(entityIn);
                                float[] fArray = new float[]{1.0f, 1.0f, 1.0f};
                                if (dyeColor != null) {
                                    float[] fArray2 = HexereiUtil.rgbIntToFloatArray(dyeColor.getTextureDiffuseColor());
                                }
                                float offset = ClientEvents.getClientTicks() + partialTicks;
                                VertexConsumer ivertexbuilderStick = bufferIn.getBuffer(RenderType.energySwirl((ResourceLocation)POWER_LOCATION, (float)(offset * 0.01f % 1.0f), (float)(offset * 0.01f % 1.0f)));
                                broomItem.outter_model.renderToBuffer(matrixStackIn, ivertexbuilderStick, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha((float)var19_21[0], (float)var19_21[1], (float)var19_21[2], 1.0f));
                            }
                        }
                        if ((item = (brushStack = entityIn.itemHandler.getStackInSlot(2)).getItem()) instanceof BroomBrushItem) {
                            brushItem = (BroomBrushItem)item;
                            if (brushItem.model == null) {
                                brushItem.bakeModels();
                            }
                        }
                        if (entityIn.itemHandler.getStackInSlot(2).is(HexereiTags.Items.BROOM_BRUSH)) {
                            matrixStackIn.pushPose();
                            Item item3 = brushStack.getItem();
                            if (item3 instanceof BroomBrushItem) {
                                brushItem = (BroomBrushItem)item3;
                                if (brushItem.model != null) {
                                    int n;
                                    Item offset = broomType.item();
                                    if (offset instanceof BroomItem) {
                                        BroomItem broomItem = (BroomItem)offset;
                                        matrixStackIn.translate(broomItem.getBrushOffset().x(), broomItem.getBrushOffset().y(), broomItem.getBrushOffset().z());
                                    }
                                    int n2 = packedLightIn;
                                    if (brushItem.shouldGlow((Level)Minecraft.getInstance().level, brushStack)) {
                                        n = 0xF000F0;
                                    }
                                    Model broomBrushModel2 = brushItem.model;
                                    brushVertexConsumer = bufferIn.getBuffer(broomBrushModel2.renderType(brushItem.texture));
                                    broomBrushModel2.renderToBuffer(matrixStackIn, (VertexConsumer)brushVertexConsumer, n, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
                                    if (entityIn.hasCustomName() && BroomEntity.getDyeColorNamed(entityIn) != null) {
                                        DyeColor dyeColor = BroomEntity.getDyeColorNamed(entityIn);
                                        float[] afloat = new float[]{1.0f, 1.0f, 1.0f};
                                        if (dyeColor != null) {
                                            afloat = HexereiUtil.rgbIntToFloatArray(dyeColor.getTextureDiffuseColor());
                                        }
                                        float offset2 = ClientEvents.getClientTicks() + partialTicks;
                                        VertexConsumer vertexconsumer = bufferIn.getBuffer(RenderType.energySwirl((ResourceLocation)POWER_LOCATION, (float)(offset2 * 0.01f % 1.0f), (float)(offset2 * 0.01f % 1.0f)));
                                        broomBrushModel2.renderToBuffer(matrixStackIn, vertexconsumer, n, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(afloat[0], afloat[1], afloat[2], 1.0f));
                                    }
                                }
                            }
                            matrixStackIn.popPose();
                        }
                        if ((broomBrushModel2 = (satchelStack = entityIn.itemHandler.getStackInSlot(1)).getItem()) instanceof BroomAttachmentItem) {
                            BroomAttachmentItem broomAttachmentItem = (BroomAttachmentItem)broomBrushModel2;
                            if (broomAttachmentItem.model == null) {
                                broomAttachmentItem.bakeModels();
                            }
                        }
                        if (entityIn.itemHandler.getStackInSlot(1).is(HexereiTags.Items.ALL_SATCHELS) && (broomBrushModel2 = satchelStack.getItem()) instanceof BroomAttachmentItem) {
                            BroomAttachmentItem broomAttachmentItem = (BroomAttachmentItem)broomBrushModel2;
                            if (broomAttachmentItem.model != null) {
                                brushVertexConsumer = broomType.item();
                                if (brushVertexConsumer instanceof BroomItem) {
                                    BroomItem broomItem = (BroomItem)brushVertexConsumer;
                                    matrixStackIn.translate(broomItem.getSatchelOffset().x(), broomItem.getSatchelOffset().y(), broomItem.getSatchelOffset().z());
                                }
                                Model satchelModel = broomAttachmentItem.model;
                                vertexConsumer = bufferIn.getBuffer(satchelModel.renderType(broomAttachmentItem.texture));
                                satchelModel.renderToBuffer(matrixStackIn, (VertexConsumer)vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
                                if (broomAttachmentItem.dye_texture != null) {
                                    if (SatchelItem.getDyeColorNamed(satchelStack) != null) {
                                        float[] afloat = HexereiUtil.rgbIntToFloatArray(SatchelItem.getDyeColorNamed(satchelStack).getTextureDiffuseColor());
                                        VertexConsumer vertexConsumerDye = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)broomAttachmentItem.dye_texture), (boolean)false, (boolean)false);
                                        satchelModel.renderToBuffer(matrixStackIn, vertexConsumerDye, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(afloat[0], afloat[1], afloat[2], 1.0f));
                                    } else {
                                        int col = SatchelItem.getColorValue(SatchelItem.getDyeColorNamed(satchelStack), satchelStack);
                                        int i = (col & 0xFF0000) >> 16;
                                        int j = (col & 0xFF00) >> 8;
                                        int k = col & 0xFF;
                                        float[] afloat = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
                                        VertexConsumer vertexConsumerDye = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)broomAttachmentItem.dye_texture), (boolean)false, (boolean)false);
                                        satchelModel.renderToBuffer(matrixStackIn, vertexConsumerDye, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(afloat[0], afloat[1], afloat[2], 1.0f));
                                    }
                                }
                            }
                        }
                        if ((vertexConsumer = (itemStack = entityIn.itemHandler.getStackInSlot(0)).getItem()) instanceof BroomAttachmentItem) {
                            BroomAttachmentItem miscItem2 = (BroomAttachmentItem)vertexConsumer;
                            if (miscItem2.model == null) {
                                miscItem2.bakeModels();
                            }
                        }
                        if (!itemStack.is(HexereiTags.Items.BROOM_MISC)) break block44;
                        vertexConsumer = itemStack.getItem();
                        if (!(vertexConsumer instanceof KeychainItem)) break block45;
                        KeychainItem keychainItem = (KeychainItem)vertexConsumer;
                        if (keychainItem.model == null) break block45;
                        Item col = broomType.item();
                        if (col instanceof BroomItem) {
                            BroomItem broomItem = (BroomItem)col;
                            matrixStackIn.translate(broomItem.getTipOffset().x(), broomItem.getTipOffset().y(), broomItem.getTipOffset().z());
                        }
                        Model broomKeychainModel = keychainItem.model;
                        VertexConsumer ivertexbuilderRings = bufferIn.getBuffer(broomKeychainModel.renderType(keychainItem.texture));
                        broomKeychainModel.renderToBuffer(matrixStackIn, ivertexbuilderRings, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
                        matrixStackIn.translate(-1.1875f, 0.0f, -0.025f);
                        matrixStackIn.translate(0.0, 2.75, 0.0);
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                        matrixStackIn.translate(0.0, 1.3, 0.0);
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-deltaMovementY * 20.0f));
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(Math.atan2(deltaMovementZ, deltaMovementX) / (Math.PI * 2) * 360.0) - entityYaw));
                        if (entityIn.selfItem != null && ItemStack.isSameItemSameComponents((ItemStack)entityIn.selfItem, (ItemStack)Hexerei.proxy.getPlayer().getMainHandItem()) && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
                            matrixStackIn.mulPose(Axis.XP.rotationDegrees((Hexerei.proxy.getPlayer().yHeadRot - Hexerei.proxy.getPlayer().yHeadRotO) * 1.5f));
                            matrixStackIn.mulPose(Axis.XP.rotationDegrees(Mth.clamp((float)((float)Hexerei.proxy.getPlayer().getDeltaMovement().yRot(-90.0f).dot(Hexerei.proxy.getPlayer().getLookAngle()) * -125.0f), (float)-70.0f, (float)70.0f)));
                            matrixStackIn.mulPose(Axis.ZP.rotationDegrees((float)(Hexerei.proxy.getPlayer().getLookAngle().y * -50.0) - 50.0f));
                            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(Mth.clamp((float)((float)Hexerei.proxy.getPlayer().getDeltaMovement().dot(Hexerei.proxy.getPlayer().getLookAngle()) * -125.0f), (float)-70.0f, (float)70.0f)));
                        }
                        matrixStackIn.mulPose(Axis.ZP.rotationDegrees((float)Mth.length((double)deltaMovementX, (double)deltaMovementZ) * 50.0f));
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                        matrixStackIn.translate(0.0, -1.3, 0.0);
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                        matrixStackIn.translate(0.0, -2.79375, 0.0);
                        Model broomKeychainChainModel = (Model)keychainItem.chain_resources.getSecond();
                        VertexConsumer ivertexbuilderChain = bufferIn.getBuffer(broomKeychainChainModel.renderType((ResourceLocation)keychainItem.chain_resources.getFirst()));
                        broomKeychainChainModel.renderToBuffer(matrixStackIn, ivertexbuilderRings, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
                        matrixStackIn.translate(0.0, 1.71875, 0.0);
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                        if (entityIn.selfItem != null && ItemStack.isSameItemSameComponents((ItemStack)entityIn.selfItem, (ItemStack)Hexerei.proxy.getPlayer().getMainHandItem()) && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
                            matrixStackIn.mulPose(Axis.ZP.rotationDegrees((float)(Hexerei.proxy.getPlayer().getLookAngle().y * 20.0)));
                            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(Mth.clamp((float)((float)Hexerei.proxy.getPlayer().getDeltaMovement().dot(Hexerei.proxy.getPlayer().getLookAngle()) * 50.0f), (float)-20.0f, (float)20.0f)));
                        }
                        matrixStackIn.mulPose(Axis.ZP.rotationDegrees((float)Mth.length((double)deltaMovementX, (double)deltaMovementZ) * -20.0f));
                        NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
                        if (itemStack.has(DataComponents.CUSTOM_DATA)) {
                            ContainerHelper.loadAllItems((CompoundTag)((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag(), (NonNullList)items, (HolderLookup.Provider)entityIn.level().registryAccess());
                        }
                        if (((ItemStack)items.get(0)).getItem() instanceof BroomItem) {
                            matrixStackIn.scale(0.45f, 0.45f, 0.45f);
                        } else {
                            matrixStackIn.scale(0.25f, 0.25f, 0.25f);
                        }
                        this.renderItem((ItemStack)items.get(0), entityIn.level(), matrixStackIn, bufferIn, packedLightIn);
                        break block44;
                    }
                    if (!itemStack.is((Item)ModItems.BROOM_NETHERITE_TIP.get())) break block46;
                    Item ivertexbuilderRings = itemStack.getItem();
                    if (ivertexbuilderRings instanceof BroomAttachmentItem) {
                        miscItem = (BroomAttachmentItem)ivertexbuilderRings;
                        if (miscItem.model != null) {
                            int light = packedLightIn / 15 * (15 - (int)(8.0f * ((float)itemStack.getDamageValue() / (float)itemStack.getMaxDamage())));
                            Model miscModel = miscItem.model;
                            VertexConsumer vertexConsumer = bufferIn.getBuffer(miscModel.renderType(miscItem.texture));
                            miscModel.renderToBuffer(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
                            matrixStackIn.translate(-1.375f, 0.0f, -0.025f);
                            matrixStackIn.translate(0.0, 2.68, 0.0);
                            matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                            matrixStackIn.translate(0.0, 1.3, 0.0);
                            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
                            matrixStackIn.scale(0.3f, 0.3f, 0.3f);
                            this.renderItem(new ItemStack((ItemLike)ModItems.SELENITE_SHARD.get()), entityIn.level(), matrixStackIn, bufferIn, light);
                        }
                    }
                    break block44;
                }
                if (!itemStack.is((Item)ModItems.BROOM_WATERPROOF_TIP.get())) break block47;
                Item light = itemStack.getItem();
                if (light instanceof BroomAttachmentItem) {
                    miscItem = (BroomAttachmentItem)light;
                    if (miscItem.model != null) {
                        int light2 = packedLightIn / 15 * (15 - (int)(8.0f * ((float)itemStack.getDamageValue() / (float)itemStack.getMaxDamage())));
                        Model miscModel = miscItem.model;
                        VertexConsumer vertexConsumer = bufferIn.getBuffer(miscModel.renderType(miscItem.texture));
                        miscModel.renderToBuffer(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
                        matrixStackIn.translate(-1.375f, 0.0f, -0.025f);
                        matrixStackIn.translate(0.0, 2.68, 0.0);
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                        matrixStackIn.translate(0.0, 1.3, 0.0);
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
                        matrixStackIn.scale(0.3f, 0.3f, 0.3f);
                        this.renderItem(new ItemStack((ItemLike)Items.CONDUIT), entityIn.level(), matrixStackIn, bufferIn, light2);
                    }
                }
                break block44;
            }
            Item light2 = itemStack.getItem();
            if (light2 instanceof BroomAttachmentItem) {
                miscItem = (BroomAttachmentItem)light2;
                if (miscItem.model != null) {
                    Model miscModel = miscItem.model;
                    VertexConsumer vertexConsumer = bufferIn.getBuffer(miscModel.renderType(miscItem.texture));
                    miscModel.renderToBuffer(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
                    if (miscItem.dye_texture != null) {
                        if (SatchelItem.getDyeColorNamed(satchelStack) != null) {
                            float[] afloat = HexereiUtil.rgbIntToFloatArray(SatchelItem.getDyeColorNamed(satchelStack).getTextureDiffuseColor());
                            VertexConsumer vertexConsumerDye = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)miscItem.dye_texture), (boolean)false, (boolean)false);
                            miscModel.renderToBuffer(matrixStackIn, vertexConsumerDye, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(afloat[0], afloat[1], afloat[2], 1.0f));
                        } else {
                            int col = SatchelItem.getColorValue(SatchelItem.getDyeColorNamed(satchelStack), satchelStack);
                            int i = (col & 0xFF0000) >> 16;
                            int j = (col & 0xFF00) >> 8;
                            int k = col & 0xFF;
                            float[] afloat = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
                            VertexConsumer vertexConsumerDye = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)miscItem.dye_texture), (boolean)false, (boolean)false);
                            miscModel.renderToBuffer(matrixStackIn, vertexConsumerDye, packedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(afloat[0], afloat[1], afloat[2], 1.0f));
                        }
                    }
                }
            }
        }
        matrixStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }
}

