/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import net.joefoxe.hexerei.event.ClientEvents;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public class WitchArmorModel
extends HumanoidModel<LivingEntity> {
    public EquipmentSlot slot;
    public ModelPart root;
    public ModelPart hat;
    public ModelPart head;
    public ModelPart body;
    public ModelPart leftArm;
    public ModelPart rightArm;
    public ModelPart leftLeg;
    public ModelPart rightLeg;

    public WitchArmorModel(ModelPart root) {
        super(root);
        this.root = root;
        this.hat = root.getChild("hat");
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftArm = root.getChild("left_arm");
        this.rightArm = root.getChild("right_arm");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
    }

    public void setupAnim(LivingEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float pPartialTicks = ClientEvents.getPartial();
        if (pEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)pEntity;
            double d0 = Mth.lerp((double)pPartialTicks, (double)clientPlayer.xCloakO, (double)clientPlayer.xCloak) - Mth.lerp((double)pPartialTicks, (double)pEntity.xo, (double)pEntity.getX());
            double d1 = Mth.lerp((double)pPartialTicks, (double)clientPlayer.yCloakO, (double)clientPlayer.yCloak) - Mth.lerp((double)pPartialTicks, (double)pEntity.yo, (double)pEntity.getY());
            double d2 = Mth.lerp((double)pPartialTicks, (double)clientPlayer.zCloakO, (double)clientPlayer.zCloak) - Mth.lerp((double)pPartialTicks, (double)pEntity.zo, (double)pEntity.getZ());
            float f = pEntity.yBodyRotO + (pEntity.yBodyRot - pEntity.yBodyRotO);
            double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.clamp((float)f1, (float)-6.0f, (float)16.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 65.0f;
            f2 = Mth.clamp((float)f2, (float)0.0f, (float)75.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.lerp((float)pPartialTicks, (float)clientPlayer.oBob, (float)clientPlayer.bob);
            f1 += Mth.sin((float)(Mth.lerp((float)pPartialTicks, (float)pEntity.walkDistO, (float)pEntity.walkDist) * 6.0f)) * 32.0f * f4;
            if (pEntity.isCrouching()) {
                f1 += 25.0f;
            }
            float x = (float)Math.toRadians(6.0f + f2 / 2.0f + f1);
            float y = (float)Math.toRadians(f3 / 2.0f);
            float f5 = (float)Math.toRadians(f3 / 2.0f);
        }
        super.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
    }

    protected Iterable<ModelPart> headParts() {
        return this.slot == EquipmentSlot.HEAD ? ImmutableList.of((Object)this.head) : ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return ImmutableList.of();
        }
        if (this.slot == EquipmentSlot.FEET) {
            return ImmutableList.of((Object)this.leftLeg, (Object)this.rightLeg);
        }
        return ImmutableList.of();
    }

    public static MeshDefinition createBodyLayer(CubeDeformation cube) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition right_foot = root.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition left_foot = root.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition left_arm = root.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition right_arm = root.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition hat = root.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(0, 14).addBox(-2.75f, -1.95f, -5.25f, 10.0f, 1.0f, 10.0f, cube), PartPose.offsetAndRotation((float)-2.0f, (float)-5.0f, (float)0.0f, (float)-0.3048f, (float)-0.0186f, (float)-0.1276f));
        PartDefinition head_r2 = head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(0, 55).addBox(1.35f, 0.05f, -1.0f, 3.0f, 3.0f, 3.0f, cube), PartPose.offsetAndRotation((float)4.704f, (float)-14.2025f, (float)5.7117f, (float)-0.5968f, (float)0.6696f, (float)1.2934f));
        PartDefinition head_r3 = head.addOrReplaceChild("head_r3", CubeListBuilder.create().texOffs(0, 30).addBox(1.5f, 0.0f, -0.75f, 2.0f, 2.0f, 2.0f, cube), PartPose.offsetAndRotation((float)6.4009f, (float)-12.7447f, (float)6.4586f, (float)-0.6173f, (float)0.8249f, (float)1.5822f));
        PartDefinition head_r4 = head.addOrReplaceChild("head_r4", CubeListBuilder.create().texOffs(75, 74).addBox(6.5f, -31.75f, -11.25f, 4.0f, 2.0f, 2.0f, cube).texOffs(43, 28).addBox(-1.5f, -31.75f, -11.25f, 5.0f, 2.0f, 2.0f, cube).texOffs(34, 67).addBox(-3.5f, -31.75f, -11.25f, 2.0f, 2.0f, 3.0f, cube).texOffs(70, 65).addBox(-3.5f, -31.75f, -4.25f, 2.0f, 2.0f, 7.0f, cube).texOffs(0, 0).addBox(-1.5f, -31.75f, -9.25f, 12.0f, 2.0f, 12.0f, cube), PartPose.offsetAndRotation((float)0.6618f, (float)25.413f, (float)-5.3821f, (float)-0.3048f, (float)-0.0186f, (float)-0.1276f));
        PartDefinition head_r5 = head.addOrReplaceChild("head_r5", CubeListBuilder.create().texOffs(30, 20).addBox(-3.175f, -0.9999f, -0.175f, 3.0f, 2.0f, 2.0f, cube), PartPose.offsetAndRotation((float)2.6707f, (float)-7.2899f, (float)-5.1f, (float)-0.3521f, (float)-0.5156f, (float)0.0458f));
        PartDefinition head_r6 = head.addOrReplaceChild("head_r6", CubeListBuilder.create().texOffs(16, 78).addBox(-1.575f, -0.9746f, 0.0f, 3.0f, 2.0f, 2.0f, cube), PartPose.offsetAndRotation((float)2.0033f, (float)-7.4583f, (float)-5.8296f, (float)-0.4114f, (float)0.7224f, (float)-0.4143f));
        PartDefinition head_r7 = head.addOrReplaceChild("head_r7", CubeListBuilder.create().texOffs(34, 51).addBox(-0.425f, -1.0f, -1.25f, 2.0f, 2.0f, 3.0f, cube), PartPose.offsetAndRotation((float)-5.2544f, (float)-4.9491f, (float)-1.0762f, (float)-0.4441f, (float)-0.7977f, (float)0.1948f));
        PartDefinition head_r8 = head.addOrReplaceChild("head_r8", CubeListBuilder.create().texOffs(54, 29).addBox(-0.575f, -0.9748f, -0.975f, 2.0f, 2.0f, 3.0f, cube), PartPose.offsetAndRotation((float)-5.879f, (float)-5.6909f, (float)-3.5945f, (float)-0.353f, (float)0.5198f, (float)-0.3144f));
        PartDefinition head_r9 = head.addOrReplaceChild("head_r9", CubeListBuilder.create().texOffs(0, 25).addBox(-2.5f, 0.0f, -4.5f, 9.0f, 3.0f, 9.0f, cube), PartPose.offsetAndRotation((float)-1.9901f, (float)-8.6229f, (float)0.9681f, (float)-0.3481f, (float)0.0316f, (float)0.0844f));
        PartDefinition head_r10 = head.addOrReplaceChild("head_r10", CubeListBuilder.create().texOffs(36, 0).addBox(-1.5f, -1.5f, -3.75f, 8.0f, 4.0f, 8.0f, cube), PartPose.offsetAndRotation((float)-1.9868f, (float)-9.5805f, (float)1.2908f, (float)-0.4582f, (float)0.1451f, (float)0.2752f));
        PartDefinition head_r11 = head.addOrReplaceChild("head_r11", CubeListBuilder.create().texOffs(72, 19).addBox(3.0f, -2.55f, -2.25f, 4.0f, 4.0f, 4.0f, cube), PartPose.offsetAndRotation((float)-1.5121f, (float)-13.9451f, (float)5.148f, (float)-0.4867f, (float)0.5183f, (float)0.7968f));
        PartDefinition head_r12 = head.addOrReplaceChild("head_r12", CubeListBuilder.create().texOffs(59, 28).addBox(0.0f, -1.5f, -3.0f, 6.0f, 4.0f, 6.0f, cube), PartPose.offsetAndRotation((float)-1.3545f, (float)-11.8213f, (float)2.9487f, (float)-0.3675f, (float)0.2629f, (float)0.4639f));
        PartDefinition body_1 = body.addOrReplaceChild("body_1", CubeListBuilder.create().texOffs(40, 14).addBox(-5.0f, -24.5f, -3.0f, 10.0f, 8.0f, 6.0f, cube), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body_2 = body.addOrReplaceChild("body_2", CubeListBuilder.create().texOffs(31, 32).addBox(-4.5f, -16.499f, -2.501f, 9.0f, 6.0f, 5.0f, cube), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(72, 38).addBox(-5.0f, -16.5f, 0.01f, 2.0f, 9.0f, 3.0f, cube).texOffs(57, 72).addBox(-5.0f, -16.5f, -2.99f, 2.0f, 7.0f, 3.0f, cube), PartPose.offsetAndRotation((float)-2.9102f, (float)24.2703f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition body_r2 = body.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(67, 74).addBox(-1.025f, -2.7f, -1.5f, 2.0f, 3.0f, 4.0f, cube), PartPose.offsetAndRotation((float)5.2869f, (float)14.7125f, (float)-1.49f, (float)-0.5236f, (float)0.0f, (float)-0.1745f));
        PartDefinition body_r3 = body.addOrReplaceChild("body_r3", CubeListBuilder.create().texOffs(59, 38).addBox(-0.975f, -2.7f, -1.5f, 2.0f, 3.0f, 4.0f, cube), PartPose.offsetAndRotation((float)-5.2869f, (float)14.7125f, (float)-1.49f, (float)-0.5236f, (float)0.0f, (float)0.1745f));
        PartDefinition body_r4 = body.addOrReplaceChild("body_r4", CubeListBuilder.create().texOffs(0, 14).addBox(3.0f, -16.5f, -2.99f, 2.0f, 7.0f, 3.0f, cube), PartPose.offsetAndRotation((float)2.9102f, (float)24.2703f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition body_r5 = body.addOrReplaceChild("body_r5", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -4.5f, -1.5f, 2.0f, 9.0f, 3.0f, cube), PartPose.offsetAndRotation((float)4.7661f, (float)11.758f, (float)1.51f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition body_r6 = body.addOrReplaceChild("body_r6", CubeListBuilder.create().texOffs(0, 37).addBox(-4.975f, -10.5f, -0.75f, 10.0f, 16.0f, 2.0f, cube), PartPose.offsetAndRotation((float)-0.01f, (float)11.2618f, (float)2.7227f, (float)0.1317f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm_r1 = right_arm.addOrReplaceChild("rightarm_r1", CubeListBuilder.create().texOffs(0, 61).addBox(-2.2814f, 1.8917f, -2.9187f, 6.0f, 2.0f, 6.0f, cube), PartPose.offsetAndRotation((float)-1.6951f, (float)5.1954f, (float)0.2218f, (float)-0.014f, (float)0.0821f, (float)0.1306f));
        PartDefinition rightarm_r2 = right_arm.addOrReplaceChild("rightarm_r2", CubeListBuilder.create().texOffs(39, 51).addBox(-1.969f, -8.4881f, -2.5253f, 5.0f, 11.0f, 5.0f, cube), PartPose.offsetAndRotation((float)-1.6951f, (float)5.9454f, (float)0.0218f, (float)0.0f, (float)-0.0064f, (float)0.0445f));
        PartDefinition rightarm_r3 = right_arm.addOrReplaceChild("rightarm_r3", CubeListBuilder.create().texOffs(30, 14).addBox(-1.75f, -0.5f, -2.25f, 4.0f, 2.0f, 4.0f, cube), PartPose.offsetAndRotation((float)-1.1622f, (float)7.9253f, (float)3.2088f, (float)-0.2886f, (float)0.8566f, (float)-0.0735f));
        PartDefinition rightarm_r4 = right_arm.addOrReplaceChild("rightarm_r4", CubeListBuilder.create().texOffs(36, 77).addBox(-4.55f, 1.5f, 0.05f, 3.0f, 4.0f, 3.0f, cube).texOffs(36, 0).addBox(-4.05f, -1.5f, 0.55f, 2.0f, 3.0f, 2.0f, cube), PartPose.offsetAndRotation((float)0.0983f, (float)3.2608f, (float)-0.7944f, (float)-0.0041f, (float)0.7798f, (float)0.0409f));
        PartDefinition rightarm_r5 = right_arm.addOrReplaceChild("rightarm_r5", CubeListBuilder.create().texOffs(36, 0).addBox(-1.25f, -1.25f, -0.75f, 2.0f, 3.0f, 2.0f, cube), PartPose.offsetAndRotation((float)-0.5781f, (float)0.1539f, (float)2.0367f, (float)-0.0041f, (float)-0.791f, (float)0.0467f));
        PartDefinition leftarm_r1 = left_arm.addOrReplaceChild("leftarm_r1", CubeListBuilder.create().texOffs(60, 0).addBox(-3.7186f, 1.8917f, -2.9187f, 6.0f, 2.0f, 6.0f, cube), PartPose.offsetAndRotation((float)1.7068f, (float)5.1989f, (float)0.1468f, (float)-0.0217f, (float)-0.0703f, (float)-0.1311f));
        PartDefinition leftarm_r2 = left_arm.addOrReplaceChild("leftarm_r2", CubeListBuilder.create().texOffs(19, 51).addBox(-3.031f, -8.4881f, -2.7253f, 5.0f, 11.0f, 5.0f, cube).texOffs(54, 45).addBox(-3.531f, -9.2381f, -3.0253f, 6.0f, 5.0f, 6.0f, cube), PartPose.offsetAndRotation((float)1.7068f, (float)5.9489f, (float)0.1468f, (float)0.0f, (float)0.0188f, (float)-0.0457f));
        PartDefinition leftarm_r3 = left_arm.addOrReplaceChild("leftarm_r3", CubeListBuilder.create().texOffs(27, 25).addBox(-2.25f, -0.5f, -2.25f, 4.0f, 2.0f, 4.0f, cube), PartPose.offsetAndRotation((float)1.1739f, (float)7.9288f, (float)3.1338f, (float)-0.2964f, (float)-0.8435f, (float)0.0782f));
        PartDefinition leftarm_r4 = left_arm.addOrReplaceChild("leftarm_r4", CubeListBuilder.create().texOffs(77, 27).addBox(1.7f, 1.5f, -0.2f, 3.0f, 4.0f, 3.0f, cube).texOffs(0, 25).addBox(2.2f, -1.5f, 0.3f, 2.0f, 3.0f, 2.0f, cube), PartPose.offsetAndRotation((float)-0.5866f, (float)3.2643f, (float)-0.8694f, (float)-0.0132f, (float)-0.7673f, (float)-0.0356f));
        PartDefinition feathers = left_arm.addOrReplaceChild("feathers", CubeListBuilder.create(), PartPose.offset((float)-1.4287f, (float)0.229f, (float)0.15f));
        PartDefinition feather_r1 = feathers.addOrReplaceChild("feather_r1", CubeListBuilder.create().texOffs(23, 46).addBox(0.25f, 0.5f, 0.0f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)3.3075f, (float)-3.5968f, (float)2.3999f, (float)-0.5107f, (float)-0.5313f, (float)-0.6482f));
        PartDefinition feather_r2 = feathers.addOrReplaceChild("feather_r2", CubeListBuilder.create().texOffs(23, 45).addBox(-1.5f, -0.2f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)4.4492f, (float)-1.1555f, (float)3.3527f, (float)-1.7342f, (float)-0.5874f, (float)0.389f));
        PartDefinition feather_r3 = feathers.addOrReplaceChild("feather_r3", CubeListBuilder.create().texOffs(23, 44).addBox(-0.5f, 1.25f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)3.2999f, (float)0.6819f, (float)3.9032f, (float)-2.0813f, (float)-0.3443f, (float)1.1283f));
        PartDefinition feather_r4 = feathers.addOrReplaceChild("feather_r4", CubeListBuilder.create().texOffs(53, 12).addBox(-1.0f, 0.25f, -1.0f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)3.3075f, (float)-3.5968f, (float)-2.3999f, (float)0.5107f, (float)0.5313f, (float)-0.6482f));
        PartDefinition feather_r5 = feathers.addOrReplaceChild("feather_r5", CubeListBuilder.create().texOffs(47, 12).addBox(-0.5f, 1.25f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)3.2999f, (float)0.6819f, (float)-3.9032f, (float)2.0813f, (float)0.3443f, (float)1.1283f));
        PartDefinition feather_r6 = feathers.addOrReplaceChild("feather_r6", CubeListBuilder.create().texOffs(23, 42).addBox(-0.5f, 0.1f, 1.0f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)3.1114f, (float)-1.5281f, (float)3.6198f, (float)-2.0357f, (float)-0.4057f, (float)1.0041f));
        PartDefinition feather_r7 = feathers.addOrReplaceChild("feather_r7", CubeListBuilder.create().texOffs(23, 43).addBox(-2.0f, -0.4f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)3.1114f, (float)-1.5281f, (float)3.6198f, (float)-1.4383f, (float)-0.5375f, (float)0.5115f));
        PartDefinition feather_r8 = feathers.addOrReplaceChild("feather_r8", CubeListBuilder.create().texOffs(23, 43).addBox(-2.0f, -0.15f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)3.1114f, (float)-1.5281f, (float)-3.6198f, (float)1.4383f, (float)0.5375f, (float)0.5115f));
        PartDefinition feather_r9 = feathers.addOrReplaceChild("feather_r9", CubeListBuilder.create().texOffs(23, 43).addBox(-0.5f, 0.1f, -2.0f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)3.1114f, (float)-1.5281f, (float)-3.6198f, (float)2.0357f, (float)0.4057f, (float)1.0041f));
        PartDefinition feather_r10 = feathers.addOrReplaceChild("feather_r10", CubeListBuilder.create().texOffs(47, 13).addBox(-1.5f, 0.0f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)4.4492f, (float)-1.1555f, (float)-3.3527f, (float)1.7342f, (float)0.5874f, (float)0.389f));
        PartDefinition feather_r11 = feathers.addOrReplaceChild("feather_r11", CubeListBuilder.create().texOffs(58, 57).addBox(-1.5f, 0.25f, -0.25f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)4.7935f, (float)-3.8956f, (float)-1.885f, (float)0.2882f, (float)0.5236f, (float)-0.4894f));
        PartDefinition feather_r12 = feathers.addOrReplaceChild("feather_r12", CubeListBuilder.create().texOffs(58, 56).addBox(-1.3959f, -0.2137f, 0.6724f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)2.909f, (float)-3.7249f, (float)-0.1261f, (float)-0.2465f, (float)-0.2182f, (float)-0.4841f));
        PartDefinition feather_r13 = feathers.addOrReplaceChild("feather_r13", CubeListBuilder.create().texOffs(58, 56).addBox(-1.4228f, -0.2341f, -1.4583f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)2.909f, (float)-3.7249f, (float)0.1261f, (float)0.0243f, (float)0.436f, (float)-0.3914f));
        PartDefinition feather_r14 = feathers.addOrReplaceChild("feather_r14", CubeListBuilder.create().texOffs(11, 58).addBox(-0.75f, 0.25f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)4.8214f, (float)-3.843f, (float)2.1146f, (float)-0.4088f, (float)-0.3926f, (float)-0.4746f));
        PartDefinition feather_r15 = feathers.addOrReplaceChild("feather_r15", CubeListBuilder.create().texOffs(23, 41).addBox(-0.8894f, -0.9203f, 1.1842f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)5.4017f, (float)3.3284f, (float)0.0985f, (float)-0.5627f, (float)-0.3357f, (float)1.3216f));
        PartDefinition feather_r16 = feathers.addOrReplaceChild("feather_r16", CubeListBuilder.create().texOffs(23, 40).addBox(-1.0927f, -1.0827f, -2.3443f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)5.4017f, (float)3.3284f, (float)0.0985f, (float)0.6259f, (float)0.2169f, (float)1.1857f));
        PartDefinition feather_r17 = feathers.addOrReplaceChild("feather_r17", CubeListBuilder.create().texOffs(23, 39).addBox(-0.3885f, 0.5048f, -0.772f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)5.4017f, (float)3.3284f, (float)0.0985f, (float)-0.008f, (float)-0.1183f, (float)1.2219f));
        PartDefinition feather_r18 = feathers.addOrReplaceChild("feather_r18", CubeListBuilder.create().texOffs(23, 49).addBox(-1.0927f, -0.8327f, -2.0443f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)5.9017f, (float)0.3284f, (float)0.0985f, (float)0.6259f, (float)0.2169f, (float)1.1857f));
        PartDefinition feather_r19 = feathers.addOrReplaceChild("feather_r19", CubeListBuilder.create().texOffs(23, 48).addBox(-0.3885f, 0.5048f, -0.022f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)5.9017f, (float)0.3284f, (float)0.0985f, (float)-0.0081f, (float)0.2308f, (float)1.2191f));
        PartDefinition feather_r20 = feathers.addOrReplaceChild("feather_r20", CubeListBuilder.create().texOffs(23, 47).addBox(-0.8894f, -0.6703f, 1.0842f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)5.9017f, (float)0.3284f, (float)0.0985f, (float)-0.5627f, (float)-0.3357f, (float)1.3216f));
        PartDefinition feather_r21 = feathers.addOrReplaceChild("feather_r21", CubeListBuilder.create().texOffs(17, 55).addBox(-1.5f, 0.75f, -0.25f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)6.401f, (float)-2.0952f, (float)2.0806f, (float)-0.5627f, (float)-0.3357f, (float)0.6235f));
        PartDefinition feather_r22 = feathers.addOrReplaceChild("feather_r22", CubeListBuilder.create().texOffs(54, 28).addBox(-1.5f, 0.75f, -0.75f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)6.3731f, (float)-2.1478f, (float)-1.919f, (float)0.6259f, (float)0.2169f, (float)0.4876f));
        PartDefinition feather_r23 = feathers.addOrReplaceChild("feather_r23", CubeListBuilder.create().texOffs(53, 13).addBox(-0.5f, 1.0f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)5.679f, (float)-3.3455f, (float)0.1018f, (float)-0.0109f, (float)0.0101f, (float)0.2609f));
        PartDefinition feather_r24 = feathers.addOrReplaceChild("feather_r24", CubeListBuilder.create().texOffs(58, 58).addBox(-0.75f, 0.0f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)5.679f, (float)-3.3455f, (float)0.1018f, (float)0.4006f, (float)-0.1312f, (float)-0.2155f));
        PartDefinition feather_r25 = feathers.addOrReplaceChild("feather_r25", CubeListBuilder.create().texOffs(23, 50).addBox(-1.5f, 0.0f, 0.25f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)6.0712f, (float)-2.7099f, (float)2.5799f, (float)-0.9739f, (float)-0.6044f, (float)0.6491f));
        PartDefinition feather_r26 = feathers.addOrReplaceChild("feather_r26", CubeListBuilder.create().texOffs(59, 0).addBox(-1.5f, 0.0f, -1.25f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)6.0712f, (float)-2.7099f, (float)-2.5799f, (float)0.9739f, (float)0.6044f, (float)0.6491f));
        PartDefinition feather_r27 = right_foot.addOrReplaceChild("feather_r27", CubeListBuilder.create().texOffs(35, 5).addBox(-14.4073f, 8.6673f, -6.5443f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-8.4017f, (float)-8.6716f, (float)0.0985f, (float)0.6259f, (float)-0.2169f, (float)-1.1857f));
        PartDefinition feather_r28 = right_foot.addOrReplaceChild("feather_r28", CubeListBuilder.create().texOffs(26, 33).addBox(-1.25f, 0.25f, -1.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-4.0794f, (float)6.8242f, (float)-0.7251f, (float)0.652f, (float)0.1706f, (float)-1.1512f));
        PartDefinition feather_r29 = right_foot.addOrReplaceChild("feather_r29", CubeListBuilder.create().texOffs(35, 7).mirror().addBox(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, cube).mirror(false), PartPose.offsetAndRotation((float)-2.4226f, (float)6.7928f, (float)3.351f, (float)-1.0817f, (float)0.55f, (float)-1.552f));
        PartDefinition feather_r30 = right_foot.addOrReplaceChild("feather_r30", CubeListBuilder.create().texOffs(32, 31).addBox(-1.25f, 0.35f, 0.25f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-4.0794f, (float)6.8242f, (float)-0.7251f, (float)-0.1277f, (float)7.0E-4f, (float)-1.1415f));
        PartDefinition feather_r31 = right_foot.addOrReplaceChild("feather_r31", CubeListBuilder.create().texOffs(26, 32).addBox(-1.0f, 0.75f, 0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-4.0794f, (float)6.8242f, (float)0.7251f, (float)-0.5606f, (float)0.1156f, (float)-1.1423f));
        PartDefinition feather_r32 = right_foot.addOrReplaceChild("feather_r32", CubeListBuilder.create().texOffs(26, 31).addBox(-14.4073f, 8.9173f, 5.7943f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-8.4017f, (float)-9.0716f, (float)-0.0985f, (float)-0.6259f, (float)0.2169f, (float)-1.1857f));
        PartDefinition rightboot_r1 = right_foot.addOrReplaceChild("rightboot_r1", CubeListBuilder.create().texOffs(19, 67).addBox(-2.5f, -17.75f, -2.5f, 5.0f, 6.0f, 5.0f, cube).texOffs(78, 0).addBox(-2.5f, -14.75f, -3.5f, 5.0f, 3.0f, 1.0f, cube).texOffs(13, 69).addBox(-2.0f, -13.75f, -4.5f, 4.0f, 2.0f, 1.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition rightboot_r2 = right_foot.addOrReplaceChild("rightboot_r2", CubeListBuilder.create().texOffs(59, 56).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 6.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)5.75f, (float)0.0f, (float)0.0718f, (float)0.0936f, (float)-0.175f));
        PartDefinition feather_r33 = left_foot.addOrReplaceChild("feather_r33", CubeListBuilder.create().texOffs(21, 37).addBox(-1.75f, 0.35f, 0.25f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)4.0794f, (float)6.8242f, (float)-0.7251f, (float)-0.1277f, (float)-7.0E-4f, (float)1.1415f));
        PartDefinition feather_r34 = left_foot.addOrReplaceChild("feather_r34", CubeListBuilder.create().texOffs(35, 7).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)2.4226f, (float)6.7928f, (float)3.351f, (float)-1.0817f, (float)-0.55f, (float)1.552f));
        PartDefinition feather_r35 = left_foot.addOrReplaceChild("feather_r35", CubeListBuilder.create().texOffs(35, 7).addBox(11.4073f, 8.9173f, 5.7943f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)8.4017f, (float)-9.0716f, (float)-0.0985f, (float)-0.6259f, (float)-0.2169f, (float)1.1857f));
        PartDefinition feather_r36 = left_foot.addOrReplaceChild("feather_r36", CubeListBuilder.create().texOffs(35, 6).addBox(-2.0f, 0.75f, 0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)4.0794f, (float)6.8242f, (float)0.7251f, (float)-0.5606f, (float)-0.1156f, (float)1.1423f));
        PartDefinition feather_r37 = left_foot.addOrReplaceChild("feather_r37", CubeListBuilder.create().texOffs(21, 38).addBox(-1.75f, 0.25f, -1.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)4.0794f, (float)6.8242f, (float)-0.7251f, (float)0.652f, (float)-0.1706f, (float)1.1512f));
        PartDefinition feather_r38 = left_foot.addOrReplaceChild("feather_r38", CubeListBuilder.create().texOffs(38, 28).addBox(11.4073f, 8.6673f, -6.5443f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)8.4017f, (float)-8.6716f, (float)0.0985f, (float)0.6259f, (float)0.2169f, (float)1.1857f));
        PartDefinition leftboot_r1 = left_foot.addOrReplaceChild("leftboot_r1", CubeListBuilder.create().texOffs(66, 8).addBox(-2.5f, -17.75f, -2.5f, 5.0f, 6.0f, 5.0f, cube).texOffs(77, 55).addBox(-2.5f, -14.75f, -3.5f, 5.0f, 3.0f, 1.0f, cube).texOffs(9, 55).addBox(-2.0f, -13.75f, -4.5f, 4.0f, 2.0f, 1.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition leftboot_r2 = left_foot.addOrReplaceChild("leftboot_r2", CubeListBuilder.create().texOffs(53, 64).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 6.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)5.75f, (float)0.0f, (float)0.0718f, (float)-0.0936f, (float)0.175f));
        return mesh;
    }
}

