/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.BroomType;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.joefoxe.hexerei.container.BroomContainer;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomAttachmentItem;
import net.joefoxe.hexerei.item.custom.BroomBrushItem;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.joefoxe.hexerei.item.custom.BroomTickableAttachmentItem;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.BroomActivateToServer;
import net.joefoxe.hexerei.util.message.BroomAskForSyncPacket;
import net.joefoxe.hexerei.util.message.BroomDamageBrushToServer;
import net.joefoxe.hexerei.util.message.BroomDamageMiscToServer;
import net.joefoxe.hexerei.util.message.BroomSyncFloatModeToServer;
import net.joefoxe.hexerei.util.message.BroomSyncPacket;
import net.joefoxe.hexerei.util.message.BroomSyncRotation;
import net.joefoxe.hexerei.util.message.BroomSyncRotationToServer;
import net.minecraft.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BroomEntity
extends Entity
implements Container,
MenuProvider,
HasCustomInventoryScreen {
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FORWARD_DIRECTION = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE_TAKEN = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> LEFT_PADDLE = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> RIGHT_PADDLE = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ROCKING_TICKS = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> BROOM_TYPE = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> FIRST_SLOT = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SECOND_SLOT = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> THIRD_SLOT = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float speedMultiplier = 0.75f;
    private final float[] paddlePositions = new float[2];
    private float outOfControlTicks;
    public float deltaRotation;
    public float deltaRotationLerp;
    public float deltaRotationOld;
    public float floatingOffset;
    public float floatingOffsetOld;
    public Vec3 deltaMovementLerp;
    public Vec3 deltaMovementOld;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    public boolean leftInputDown;
    public boolean rightInputDown;
    public boolean forwardInputDown;
    public boolean backInputDown;
    public boolean jumpInputDown;
    public boolean sneakingInputDown;
    public boolean activateInputDown;
    private double waterLevel;
    private float boatGlide;
    private Status status;
    private Status previousStatus;
    private double lastYd;
    private boolean rocking;
    private boolean downwards;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;
    private final int drainTimeMax = 200;
    private int drainTime = 200;
    private final int miscDrainTimeMax = 20;
    private int miscDrainTime = 20;
    private boolean broomSync = false;
    public boolean floatMode = false;
    public boolean isItem = false;
    public boolean broomCalled = false;
    public int broomCalledDelay = 40;
    public ItemStack selfItem = null;
    public float age = 0.0f;
    public List<Entity> prevPassengers = null;
    public UUID broomUUID;
    public final ItemStackHandler itemHandler = this.createHandler();
    public NonNullList<ItemStack> items = NonNullList.withSize((int)30, (Object)ItemStack.EMPTY);

    public BroomEntity(Level worldIn, double x, double y, double z) {
        this((EntityType<BroomEntity>)((EntityType)ModEntityTypes.BROOM.get()), worldIn);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.speedMultiplier = this.getBroomType().speedMultiplier();
    }

    public BroomEntity(EntityType<BroomEntity> broomEntityEntityType, Level world) {
        super(broomEntityEntityType, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TIME_SINCE_HIT, (Object)0);
        builder.define(FORWARD_DIRECTION, (Object)1);
        builder.define(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        builder.define(LEFT_PADDLE, (Object)false);
        builder.define(RIGHT_PADDLE, (Object)false);
        builder.define(ROCKING_TICKS, (Object)0);
        builder.define(FIRST_SLOT, (Object)0);
        builder.define(SECOND_SLOT, (Object)0);
        builder.define(THIRD_SLOT, (Object)0);
        builder.define(BROOM_TYPE, (Object)"willow");
    }

    public boolean canCollideWith(Entity entity) {
        return BroomEntity.func_242378_a(this, entity);
    }

    public static boolean func_242378_a(Entity p_242378_0_, Entity entity) {
        return (entity.canBeCollidedWith() || entity.isPushable()) && !p_242378_0_.isPassengerOfSameVehicle(entity);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return !this.broomCalled;
    }

    public Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle portal) {
        return PortalShape.getRelativePosition((BlockUtil.FoundRectangle)portal, (Direction.Axis)axis, (Vec3)this.position(), (EntityDimensions)this.getDimensions(this.getPose()));
    }

    protected int getMaxPassengers() {
        return this.getModule(BroomSlot.SATCHEL).is((Item)ModItems.BROOM_SEAT.get()) ? 2 : 1;
    }

    public double getPassengersRidingOffset(Entity passenger) {
        float height = 2.25f;
        if (passenger != null) {
            height = passenger.getBbHeight();
        }
        return this.floatingOffset - height;
    }

    public Vec3 getVehicleAttachmentPoint(Entity entity) {
        return super.getVehicleAttachmentPoint(entity);
    }

    public Vec3 getPassengerRidingPosition(Entity passenger) {
        return super.getPassengerRidingPosition(passenger).add(0.0, this.getPassengersRidingOffset(passenger), 0.0);
    }

    /*
     * Unable to fully structure code
     */
    public boolean hurt(DamageSource source, float amount) {
        block5: {
            if (this.isInvulnerableTo(source)) {
                return false;
            }
            if (this.level().isClientSide || this.isRemoved()) break block5;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.markHurt();
            var5_3 = source.getDirectEntity();
            if (!(var5_3 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var5_3;
            if (player.getAbilities().instabuild) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = flag = false;
            }
            if (flag || this.getDamageTaken() > 50.0f) {
                if (!flag) {
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), (double)((float)this.blockPosition().getX() + 0.5f), (double)((float)this.blockPosition().getY() + 0.5f), (double)((float)this.blockPosition().getZ() + 0.5f), this.getPickResult()));
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return true;
    }

    public static DyeColor getDyeColorNamed(BroomEntity broom) {
        if (broom.getCustomName() == null) {
            return null;
        }
        if (broom.getCustomName().getString().equals("Thunderbolt VII")) {
            return DyeColor.byId((int)4);
        }
        if (broom.getCustomName().getString().equals("Firebolt")) {
            return DyeColor.byId((int)14);
        }
        return HexereiUtil.getDyeColorNamed(broom.getCustomName().getString(), 0);
    }

    @org.jetbrains.annotations.Nullable
    public ItemStack getPickedResult(HitResult target) {
        return super.getPickedResult(target);
    }

    @NotNull
    public ItemStack getPickResult() {
        return this.getPickResult(true);
    }

    public ItemStack getPickResult(boolean getNewUUID) {
        ItemStack item = this.getBroomItem().getDefaultInstance();
        CompoundTag tag = ((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        CompoundTag inv = this.itemHandler.serializeNBT((HolderLookup.Provider)this.level().registryAccess());
        boolean flag = false;
        for (int i = 0; i < 30; ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            flag = true;
            break;
        }
        if (flag) {
            tag.put("Inventory", (Tag)inv);
        }
        tag.putBoolean("floatMode", this.floatMode);
        if (this.broomUUID != null && !getNewUUID) {
            tag.putUUID("broomUUID", this.broomUUID);
        } else {
            UUID newUUID = UUID.randomUUID();
            tag.putUUID("broomUUID", newUUID);
        }
        item.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        Component name = this.getCustomName();
        if (name != null && !name.getString().isEmpty()) {
            item.set(DataComponents.CUSTOM_NAME, (Object)name);
        }
        return item;
    }

    public void onAboveBubbleCol(boolean downwards) {
        if (!this.level().isClientSide) {
            this.rocking = true;
            this.downwards = downwards;
            if (this.getRockingTicks() == 0) {
                this.setRockingTicks(60);
            }
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + (double)this.random.nextFloat(), this.getY() + 0.7, this.getZ() + (double)this.random.nextFloat(), 0.0, 0.0, 0.0);
        if (this.random.nextInt(20) == 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.getSwimSplashSound(), this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat());
        }
    }

    public void push(Entity entityIn) {
        if (entityIn instanceof BroomEntity) {
            if (entityIn.getBoundingBox().minY < this.getBoundingBox().maxY) {
                super.push(entityIn);
            }
        } else if (entityIn.getBoundingBox().minY <= this.getBoundingBox().minY) {
            super.push(entityIn);
        }
    }

    public Item getBroomItem() {
        return this.getBroomType().item();
    }

    public void animateHurt(float pYaw) {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = 10;
    }

    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    public Direction getMotionDirection() {
        return this.getDirection().getClockWise();
    }

    public int getExtraBrush() {
        for (int i = 3; i < 30; ++i) {
            if (!this.itemHandler.getStackInSlot(i).is(HexereiTags.Items.BROOM_BRUSH)) continue;
            return i;
        }
        return -1;
    }

    public void damageBrush() {
        this.getModule(BroomSlot.BRUSH).setDamageValue(this.getModule(BroomSlot.BRUSH).getDamageValue() + 1);
        if (this.getModule(BroomSlot.BRUSH).getDamageValue() >= this.getModule(BroomSlot.BRUSH).getMaxDamage()) {
            this.setModule(BroomSlot.BRUSH, ItemStack.EMPTY);
            this.level().playSound(null, (Entity)this, SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 0.5f, this.random.nextFloat() * 0.4f + 1.0f);
            this.sync();
        }
        for (BroomSlot slot : BroomSlot.values()) {
            Item item = this.getModule(slot).getItem();
            if (!(item instanceof BroomAttachmentItem)) continue;
            BroomAttachmentItem broomAttachment = (BroomAttachmentItem)item;
            broomAttachment.onBrushDamage(this, this.random);
        }
    }

    public void transferBrushParticles() {
        int i;
        for (i = 0; i < 20; ++i) {
            int j = this.random.nextInt(2) * 2 - 1;
            int k = this.random.nextInt(2) * 2 - 1;
            double d3 = this.random.nextFloat() * (float)j;
            double d4 = ((double)this.random.nextFloat() - 0.5) * 0.125;
            double d5 = this.random.nextFloat() * (float)k;
            float rotOffset = this.random.nextFloat() * 10.0f - 5.0f;
            float rot = this.random.nextFloat() * 360.0f;
            if (this.random.nextInt(5) == 0) {
                this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getX() - Math.sin((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.getDeltaMovement().length() / 4.0) + Math.cos(rot) * (this.random.nextDouble() * 0.05 + 0.5), this.getY() + (double)this.floatingOffset + (double)(0.1f * this.random.nextFloat()) - this.getDeltaMovement().y(), this.getZ() + Math.cos((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.getDeltaMovement().length() / 4.0) + Math.sin(rot) * (this.random.nextDouble() * 0.05 + 0.5), -Math.cos(rot) * (this.random.nextDouble() * 0.005 + 0.025), (this.random.nextDouble() - 0.5) * 0.005, -Math.sin(rot) * (this.random.nextDouble() * 0.005 + 0.025));
            }
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX() - Math.sin((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.getDeltaMovement().length() / 4.0), this.getY() + (double)this.floatingOffset + (double)(0.1f * this.random.nextFloat()) - this.getDeltaMovement().y(), this.getZ() + Math.cos((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.getDeltaMovement().length() / 4.0), d3, d4, d5);
            Item item = this.getModule(BroomSlot.BRUSH).getItem();
            if (!(item instanceof BroomBrushItem)) continue;
            BroomBrushItem brushItem = (BroomBrushItem)item;
            if (brushItem.list == null) continue;
            ParticleEngine pe = Minecraft.getInstance().particleEngine;
            Random random = new Random();
            for (Tuple<ParticleOptions, Integer> tuple : brushItem.list) {
                ParticleOptions option = (ParticleOptions)tuple.getA();
                int delay = (Integer)tuple.getB();
                if (random.nextInt(delay) != 0) continue;
                this.level().addParticle(option, this.getX() - Math.sin((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.getDeltaMovement().length() / 4.0), this.getY() + (double)this.floatingOffset + (double)(0.25f * random.nextFloat()) - this.getDeltaMovement().y(), this.getZ() + Math.cos((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.getDeltaMovement().length() / 4.0), (random.nextDouble() - 0.5) * 0.05, (random.nextDouble() - 0.5) * 0.05, (random.nextDouble() - 0.5) * 0.05);
            }
        }
        for (i = 0; i < 20; ++i) {
            float rotOffset = this.random.nextFloat() * 10.0f - 5.0f;
            float rot = 18 * i;
            Item item = this.getModule(BroomSlot.BRUSH).getItem();
            if (!(item instanceof BroomBrushItem)) continue;
            BroomBrushItem brushItem = (BroomBrushItem)item;
            if (brushItem.list == null) continue;
            ParticleEngine pe = Minecraft.getInstance().particleEngine;
            Random random = new Random();
            for (Tuple<ParticleOptions, Integer> tuple : brushItem.list) {
                ParticleOptions option = (ParticleOptions)tuple.getA();
                int delay = (Integer)tuple.getB();
                if (random.nextInt(delay) != 0) continue;
                this.level().addParticle(option, this.getX() - Math.sin((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.getDeltaMovement().length() / 4.0), this.getY() + (double)this.floatingOffset + (double)(0.1f * random.nextFloat()) - this.getDeltaMovement().y(), this.getZ() + Math.cos((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (1.25 + this.getDeltaMovement().length() / 4.0), Math.cos(rot) * (random.nextDouble() * 0.005 + 0.15), (random.nextDouble() - 0.5) * 0.005, Math.sin(rot) * (random.nextDouble() * 0.005 + 0.15));
            }
        }
    }

    public void damageMisc() {
        this.getModule(BroomSlot.MISC).setDamageValue(this.getModule(BroomSlot.MISC).getDamageValue() + 1);
        if (this.getModule(BroomSlot.MISC).getDamageValue() >= this.getModule(BroomSlot.MISC).getMaxDamage()) {
            this.setModule(BroomSlot.MISC, ItemStack.EMPTY);
            this.level().playSound(null, (Entity)this, SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 1.0f, this.random.nextFloat() * 0.4f + 1.0f);
            this.sync();
        }
    }

    public void startOpen(Player pPlayer) {
        super.startOpen(pPlayer);
        SoundEvent sound = (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value();
        float volume = 0.75f;
        if (this.isEnder()) {
            sound = SoundEvents.ENDER_CHEST_OPEN;
            volume = 0.5f;
        }
        this.level().playSound(null, this.getX(), this.getY() + 0.5, this.getZ(), sound, SoundSource.BLOCKS, volume, this.random.nextFloat() * 0.1f + 0.9f);
    }

    public void stopOpen(Player p_18954_) {
        super.stopOpen(p_18954_);
        SoundEvent sound = (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value();
        float pitch = 0.4f;
        float volume = 0.75f;
        if (this.isEnder()) {
            sound = SoundEvents.ENDER_CHEST_CLOSE;
            pitch = 0.9f;
            volume = 0.5f;
        }
        this.level().playSound(null, this.getX(), this.getY() + 0.5, this.getZ(), sound, SoundSource.BLOCKS, volume, this.random.nextFloat() * 0.1f + pitch);
    }

    public void tick() {
        this.age += 1.0f;
        this.floatingOffsetOld = this.floatingOffset;
        this.deltaMovementOld = this.getDeltaMovement();
        this.deltaRotationOld = this.deltaRotation;
        if (!this.level().isClientSide) {
            if (this.prevPassengers != null && this.prevPassengers.size() != this.getPassengers().size()) {
                ArrayList<Entity> dismounted = new ArrayList<Entity>(this.prevPassengers);
                dismounted.removeAll(this.getPassengers());
                for (Entity passenger : dismounted) {
                    for (BroomSlot slot2 : BroomSlot.values()) {
                        Item item = this.getModule(slot2).getItem();
                        if (!(item instanceof BroomAttachmentItem)) continue;
                        BroomAttachmentItem broomAttachment = (BroomAttachmentItem)item;
                        broomAttachment.onDismount(this, passenger, this.random);
                    }
                }
            }
            this.prevPassengers = this.getPassengers();
        }
        if (!this.broomSync && this.level() instanceof ServerLevel) {
            this.sync();
            this.broomSync = true;
        }
        if (!this.broomSync && this.level() instanceof ClientLevel) {
            if (this.level().isClientSide) {
                HexereiPacketHandler.sendToServer(new BroomAskForSyncPacket(this.getId()));
            }
            this.broomSync = true;
        }
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        if (this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER) {
            this.outOfControlTicks = 0.0f;
        } else {
            this.outOfControlTicks += 1.0f;
            if (this.getModule(BroomSlot.MISC).is((Item)ModItems.BROOM_WATERPROOF_TIP.get())) {
                this.outOfControlTicks = 0.0f;
            }
        }
        if (!this.level().isClientSide && this.outOfControlTicks >= 60.0f) {
            this.ejectPassengers();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        LivingEntity entityPassenger = this.getControllingPassenger();
        if (this.level().isClientSide()) {
            if (entityPassenger instanceof LivingEntity && entityPassenger.equals((Object)Hexerei.proxy.getPlayer())) {
                BroomSlot[] player = (BroomSlot[])Hexerei.proxy.getPlayer();
                this.setNoGravity(true);
                this.updateInputs(player.input.left, player.input.right, player.input.up, player.input.down, player.input.jumping, player.input.shiftKeyDown);
            } else if (entityPassenger == null) {
                this.setNoGravity(this.floatMode);
            }
        } else if (entityPassenger instanceof Player) {
            this.setNoGravity(true);
        } else if (entityPassenger == null) {
            this.setNoGravity(this.floatMode);
        }
        if (!this.getModule(BroomSlot.BRUSH).is(HexereiTags.Items.BROOM_BRUSH)) {
            this.setNoGravity(false);
            this.floatMode = false;
        } else if (this.level().isClientSide()) {
            if (entityPassenger instanceof Player && (this.getPaddleState(0) || this.getPaddleState(1))) {
                --this.drainTime;
            }
            if (this.drainTime <= 0) {
                HexereiPacketHandler.sendToServer(new BroomDamageBrushToServer(this.getId()));
                this.drainTime = 200;
            }
        }
        for (BroomSlot slot : BroomSlot.values()) {
            BroomSlot slot2;
            slot2 = this.getModule(slot).getItem();
            if (!(slot2 instanceof BroomTickableAttachmentItem)) continue;
            BroomTickableAttachmentItem toTick = (BroomTickableAttachmentItem)((Object)slot2);
            toTick.tick(this, this.getModule(slot));
        }
        super.tick();
        this.tickLerp();
        if (this.isEnder() && this.random.nextInt(5) == 0) {
            RandomSource pRandom = this.random;
            int j = pRandom.nextInt(2) * 2 - 1;
            int k = pRandom.nextInt(2) * 2 - 1;
            double d3 = pRandom.nextFloat() * (float)j;
            double d4 = ((double)pRandom.nextFloat() - 0.5) * 0.125;
            double d5 = pRandom.nextFloat() * (float)k;
            float rotOffset = this.random.nextFloat() * 10.0f - 5.0f;
            float rot = this.random.nextFloat() * 360.0f;
            if (this.random.nextInt(5) == 0) {
                this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getX() - Math.sin((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (0.25 + this.getDeltaMovement().length() / 4.0) + Math.cos(rot) * (this.random.nextDouble() * 0.05 + 0.5), this.getY() + (double)this.floatingOffset + (double)(0.1f * this.random.nextFloat()) - this.getDeltaMovement().y(), this.getZ() + Math.cos((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (0.25 + this.getDeltaMovement().length() / 4.0) + Math.sin(rot) * (this.random.nextDouble() * 0.05 + 0.5), -Math.cos(rot) * (this.random.nextDouble() * 0.005 + 0.025), (this.random.nextDouble() - 0.5) * 0.005, -Math.sin(rot) * (this.random.nextDouble() * 0.005 + 0.025));
            }
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getX() - Math.sin((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (0.25 + this.getDeltaMovement().length() / 4.0), this.getY() + (double)this.floatingOffset + (double)(0.1f * this.random.nextFloat()) - this.getDeltaMovement().y(), this.getZ() + Math.cos((double)((this.getYRot() - 90.0f + this.deltaRotation + rotOffset) / 180.0f) * Math.PI) * (0.25 + this.getDeltaMovement().length() / 4.0), d3, d4, d5);
        }
        if (this.isControlledByLocalInstance()) {
            Item j;
            if (this.getPassengers().isEmpty() || !(this.getPassengers().getFirst() instanceof Player)) {
                this.setPaddleState(false, false);
            }
            if (this.getModule(BroomSlot.BRUSH).is(HexereiTags.Items.BROOM_BRUSH) && this.level().isClientSide) {
                this.floatingOffset = HexereiUtil.moveTo(this.floatingOffset, 0.05f + (float)Math.sin((this.age * 2.0f + (float)(this.getId() * 1000)) / 30.0f) * 0.15f, 0.0075f);
            }
            this.updateMotion();
            if (this.level().isClientSide) {
                this.controlBoat();
                this.level().sendPacketToServer((Packet)new ServerboundPaddleBoatPacket(this.getPaddleState(0), this.getPaddleState(1)));
                HexereiPacketHandler.sendToServer(new BroomSyncRotationToServer(this));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.getModule(BroomSlot.BRUSH).is(HexereiTags.Items.BROOM_BRUSH) && (j = this.getModule(BroomSlot.BRUSH).getItem()) instanceof BroomBrushItem) {
                brushItem = (BroomBrushItem)j;
                brushItem.renderParticles(this, this.level(), this.status, this.random);
            }
        } else {
            if (this.getPassengers().isEmpty()) {
                this.updateMotion();
                this.move(MoverType.SELF, this.getDeltaMovement());
            }
            if (this.floatMode) {
                Item j;
                if (this.level().isClientSide) {
                    this.floatingOffset = HexereiUtil.moveTo(this.floatingOffset, 0.05f + (float)Math.sin((this.age * 2.0f + (float)(this.getId() * 1000)) / 30.0f) * 0.15f, 0.01f);
                }
                if ((j = this.getModule(BroomSlot.BRUSH).getItem()) instanceof BroomBrushItem) {
                    brushItem = (BroomBrushItem)j;
                    brushItem.renderParticles(this, this.level(), this.status, this.random);
                }
            } else {
                this.floatingOffset = HexereiUtil.moveTo(this.floatingOffset, 0.0f, 0.04f);
            }
        }
        this.updateRocking();
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.isSilent() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.paddlePositions[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                    Vec3 vector3d = this.getViewVector(1.0f);
                    double d0 = i == 1 ? -vector3d.z : vector3d.z;
                    double d1 = i == 1 ? vector3d.x : -vector3d.x;
                    this.level().playSound(null, this.getX() + d0, this.getY(), this.getZ() + d1, soundevent, this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat());
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        if (this.broomCalledDelay > 0) {
            --this.broomCalledDelay;
            if (this.broomCalledDelay <= 0) {
                this.broomCalled = false;
            }
        }
        this.checkInsideBlocks();
        List<Entity> list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, (double)0.01f, (double)0.2f), EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.level().isClientSide && this.getControllingPassenger() instanceof Player;
            List<Entity> pushableList = list.stream().filter(entity -> entity instanceof Player).toList();
            list = list.stream().filter(entity -> {
                TamableAnimal tamableAnimal;
                return entity != this.getControllingPassenger() && entity.getType().is(HexereiTags.Entity.CAN_RIDE_BROOM) && !(entity instanceof Player) && !entity.isPassenger() && (!(entity instanceof TamableAnimal) || (tamableAnimal = (TamableAnimal)entity).isTame() && this.getControllingPassenger() != null && tamableAnimal.isOwnedBy(this.getControllingPassenger()));
            }).toList();
            for (Entity entity2 : list) {
                if (entity2.hasPassenger((Entity)this) || !flag || this.getPassengers().size() != 1) continue;
                entity2.startRiding((Entity)this, true);
            }
            for (Entity entity3 : pushableList) {
                if (entity3.hasPassenger((Entity)this)) continue;
                this.push(entity3);
            }
        }
        if (this.level().isClientSide() && this.getDeltaMovement().length() >= 0.01 && this.getModule(BroomSlot.BRUSH).is(HexereiTags.Items.BROOM_BRUSH)) {
            BroomAttachmentItem attachmentItem;
            ItemStack misc = this.getModule(BroomSlot.MISC);
            Item d0 = misc.getItem();
            if (d0 instanceof BroomAttachmentItem && (attachmentItem = (BroomAttachmentItem)d0).shouldRenderParticles(this, this.level(), this.status)) {
                attachmentItem.renderParticles(this, this.level(), this.status, this.random);
            } else {
                Item item = this.getModule(BroomSlot.BRUSH).getItem();
                if (item instanceof BroomBrushItem) {
                    BroomBrushItem brushItem = (BroomBrushItem)item;
                    brushItem.renderParticles(this, this.level(), this.status, this.random);
                }
            }
        }
    }

    private void updateRocking() {
        if (this.level().isClientSide) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 0.05f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = Mth.clamp((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.level().getGameTime()) * this.rockingIntensity;
        } else {
            int k;
            if (!this.rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    Vec3 vector3d = this.getDeltaMovement();
                    if (this.downwards) {
                        this.setDeltaMovement(vector3d.add(0.0, -0.7, 0.0));
                        this.ejectPassengers();
                    } else {
                        this.setDeltaMovement(vector3d.x, this.hasPassenger(Player.class::isInstance) ? 2.7 : 0.6, vector3d.z);
                    }
                }
                this.rocking = false;
            }
        }
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        return switch (this.getBoatStatus().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2 -> SoundEvents.BOAT_PADDLE_WATER;
            case 3, 4, 6 -> null;
            case 5 -> SoundEvents.BOAT_PADDLE_LAND;
        };
    }

    protected void playStepSound(BlockPos pPos, BlockState pState) {
    }

    private void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0 && this.deltaMovementLerp != null) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            this.deltaRotation = Mth.lerp((float)(1.0f / (float)this.lerpSteps), (float)this.deltaRotation, (float)this.deltaRotationLerp);
            this.setDeltaMovement(new Vec3(Mth.lerp((double)(1.0f / (float)this.lerpSteps), (double)this.getDeltaMovement().x, (double)this.deltaMovementLerp.x), Mth.lerp((double)(1.0f / (float)this.lerpSteps), (double)this.getDeltaMovement().y, (double)this.deltaMovementLerp.y), Mth.lerp((double)(1.0f / (float)this.lerpSteps), (double)this.getDeltaMovement().z, (double)this.deltaMovementLerp.z)));
            --this.lerpSteps;
        }
    }

    public void setPaddleState(boolean left, boolean right) {
        this.entityData.set(LEFT_PADDLE, (Object)left);
        this.entityData.set(RIGHT_PADDLE, (Object)right);
    }

    private Status getBoatStatus() {
        Status boatentity$status = this.getUnderwaterStatus();
        if (boatentity$status != null) {
            this.waterLevel = this.getBoundingBox().maxY;
            return boatentity$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getBoatGlide();
        if (f > 0.0f) {
            this.boatGlide = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getWaterLevelAbove() {
        AABB axisalignedbb = this.getBoundingBox();
        int i = Mth.floor((double)axisalignedbb.minX);
        int j = Mth.ceil((double)axisalignedbb.maxX);
        int k = Mth.floor((double)axisalignedbb.maxY);
        int l = Mth.ceil((double)(axisalignedbb.maxY - this.lastYd));
        int i1 = Mth.floor((double)axisalignedbb.minZ);
        int j1 = Mth.ceil((double)axisalignedbb.maxZ);
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.set(l1, k1, i2);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)blockpos$mutable);
                    if (fluidstate.is(FluidTags.WATER)) {
                        f = Math.max(f, fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.getY() + f;
        }
        return l + 1;
    }

    public float getBoatGlide() {
        AABB axisalignedbb = this.getBoundingBox();
        AABB axisalignedbb1 = new AABB(axisalignedbb.minX, axisalignedbb.minY - 0.001, axisalignedbb.minZ, axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        int i = Mth.floor((double)axisalignedbb1.minX) - 1;
        int j = Mth.ceil((double)axisalignedbb1.maxX) + 1;
        int k = Mth.floor((double)axisalignedbb1.minY) - 1;
        int l = Mth.ceil((double)axisalignedbb1.maxY) + 1;
        int i1 = Mth.floor((double)axisalignedbb1.minZ) - 1;
        int j1 = Mth.ceil((double)axisalignedbb1.maxZ) + 1;
        VoxelShape voxelshape = Shapes.create((AABB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.set(l1, k2, i2);
                    BlockState blockstate = this.level().getBlockState((BlockPos)blockpos$mutable);
                    if (blockstate.getBlock() instanceof WaterlilyBlock || !Shapes.joinIsNotEmpty((VoxelShape)blockstate.getCollisionShape((BlockGetter)this.level(), (BlockPos)blockpos$mutable).move((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.AND)) continue;
                    f += blockstate.getFriction((LevelReader)this.level(), (BlockPos)blockpos$mutable, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    public boolean fireImmune() {
        return this.getModule(BroomSlot.MISC).is((Item)ModItems.BROOM_NETHERITE_TIP.get());
    }

    private boolean checkInWater() {
        AABB axisalignedbb = this.getBoundingBox();
        int i = Mth.floor((double)axisalignedbb.minX);
        int j = Mth.ceil((double)axisalignedbb.maxX);
        int k = Mth.floor((double)axisalignedbb.minY);
        int l = Mth.ceil((double)(axisalignedbb.minY + 0.001));
        int i1 = Mth.floor((double)axisalignedbb.minZ);
        int j1 = Mth.ceil((double)axisalignedbb.maxZ);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.set(k1, l1, i2);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)blockpos$mutable);
                    if (!fluidstate.is(FluidTags.WATER)) continue;
                    float f = (float)l1 + fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.minY < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status getUnderwaterStatus() {
        AABB axisalignedbb = this.getBoundingBox();
        double d0 = axisalignedbb.maxY + 0.001;
        int i = Mth.floor((double)axisalignedbb.minX);
        int j = Mth.ceil((double)axisalignedbb.maxX);
        int k = Mth.floor((double)axisalignedbb.maxY);
        int l = Mth.ceil((double)d0);
        int i1 = Mth.floor((double)axisalignedbb.minZ);
        int j1 = Mth.ceil((double)axisalignedbb.maxZ);
        boolean flag = false;
        boolean lavaFlag = false;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.set(k1, l1, i2);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)blockpos$mutable);
                    if (fluidstate.is(FluidTags.WATER) && d0 < (double)((float)blockpos$mutable.getY() + fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)blockpos$mutable))) {
                        if (!fluidstate.isSource()) {
                            return Status.UNDER_FLOWING_WATER;
                        }
                        flag = true;
                        continue;
                    }
                    if (!fluidstate.is(FluidTags.LAVA) || !(d0 < (double)((float)blockpos$mutable.getY() + fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.isSource()) {
                        return Status.UNDER_FLOWING_LAVA;
                    }
                    lavaFlag = true;
                }
            }
        }
        if (lavaFlag) {
            return Status.UNDER_LAVA;
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private void updateMotion() {
        double d0 = -0.04f;
        double d1 = this.isNoGravity() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        float momentum = 0.05f;
        this.speedMultiplier = this.getBroomType().speedMultiplier();
        Item item = this.getModule(BroomSlot.BRUSH).getItem();
        if (item instanceof BroomBrushItem) {
            BroomBrushItem brush = (BroomBrushItem)item;
            this.speedMultiplier += brush.getSpeedModifier(this);
        }
        if (this.previousStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            Vec3 vector3d = this.getDeltaMovement();
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.getY()) / (double)this.getBbHeight();
                momentum = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER || this.status == Status.UNDER_WATER) {
                d2 = (this.waterLevel - this.getY()) / (double)this.getBbHeight();
                momentum = 0.8f;
                if (this.level().isClientSide() && this.getModule(BroomSlot.MISC).is((Item)ModItems.BROOM_WATERPROOF_TIP.get())) {
                    --this.miscDrainTime;
                    if (this.miscDrainTime <= 0) {
                        HexereiPacketHandler.sendToServer(new BroomDamageMiscToServer(this.getId()));
                        this.miscDrainTime = 20;
                    }
                }
            } else if (this.status == Status.UNDER_FLOWING_LAVA || this.status == Status.UNDER_LAVA) {
                d2 = (this.waterLevel - this.getY()) / (double)this.getBbHeight();
                momentum = 0.7f;
                if (this.level().isClientSide()) {
                    --this.miscDrainTime;
                    if (this.miscDrainTime <= 0) {
                        HexereiPacketHandler.sendToServer(new BroomDamageMiscToServer(this.getId()));
                        this.miscDrainTime = 20;
                    }
                }
            } else if (this.status == Status.IN_AIR) {
                momentum = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                momentum = this.boatGlide;
                if (this.getControllingPassenger() instanceof Player) {
                    this.boatGlide /= 2.0f;
                }
            }
            this.setDeltaMovement(vector3d.x * (double)momentum, vector3d.y + d1, vector3d.z * (double)momentum);
            this.deltaRotation *= momentum;
            if (d2 > 0.0) {
                Vec3 vector3d1 = this.getDeltaMovement();
                this.setDeltaMovement(vector3d1.x, (vector3d1.y + d2 * 0.06153846016296973) * 0.75, vector3d1.z);
            }
        }
        if (this.isNoGravity() && Mth.abs((float)((float)(this.getDeltaMovement().y() / (double)(1.15f + Mth.abs((float)((float)this.getDeltaMovement().y())) / 6.0f)))) > 0.0f) {
            this.setDeltaMovement(this.getDeltaMovement().x(), Mth.abs((float)((float)(this.getDeltaMovement().y() / (double)(1.15f + Mth.abs((float)((float)this.getDeltaMovement().y())) / 6.0f)))) < 0.1f ? 0.0 : this.getDeltaMovement().y() / (double)(1.15f + Mth.abs((float)((float)this.getDeltaMovement().y())) / 6.0f), this.getDeltaMovement().z());
        }
        if (this.getDeltaMovement().y() > (double)(this.speedMultiplier / 4.0f)) {
            this.setDeltaMovement(this.getDeltaMovement().x(), this.speedMultiplier / 4.0f, this.getDeltaMovement().z());
        }
        if (this.getDeltaMovement().y() < (double)(-this.speedMultiplier / 4.0f)) {
            this.setDeltaMovement(this.getDeltaMovement().x(), -this.speedMultiplier / 4.0f, this.getDeltaMovement().z());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void controlBoat() {
        Options settings = Minecraft.getInstance().options;
        boolean down = ModKeyBindings.broomDown.isDown();
        boolean up = ModKeyBindings.broomUp.isDown();
        boolean activate = ModKeyBindings.broomActivate.isDown();
        if (this.isVehicle()) {
            if (activate && !this.activateInputDown) {
                HexereiPacketHandler.sendToServer(new BroomActivateToServer(this.getId()));
            }
            float f = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation -= 1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.02f;
            }
            this.setYRot(this.getYRot() + this.deltaRotation);
            if (this.forwardInputDown) {
                f += 0.1f;
            }
            if (this.backInputDown) {
                f -= 0.02f;
            }
            if (up) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(0.1275f + 0.01f * this.speedMultiplier), 0.0));
            }
            if (down) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-0.1275f - 0.01f * this.speedMultiplier), 0.0));
            }
            this.setDeltaMovement(this.getDeltaMovement().add((double)(Mth.sin((float)(-(this.getYRot() + 90.0f) * ((float)Math.PI / 180))) * f) * (double)this.speedMultiplier, 0.0, (double)(Mth.cos((float)((this.getYRot() + 90.0f) * ((float)Math.PI / 180))) * f) * (double)this.speedMultiplier));
            this.setPaddleState(this.rightInputDown && !this.leftInputDown || this.forwardInputDown, this.leftInputDown && !this.rightInputDown || this.forwardInputDown);
        }
        this.activateInputDown = activate;
    }

    public void activate() {
        for (BroomSlot slot : BroomSlot.values()) {
            Item item = this.getModule(slot).getItem();
            if (!(item instanceof BroomAttachmentItem)) continue;
            BroomAttachmentItem broomAttachment = (BroomAttachmentItem)item;
            broomAttachment.onActivate(this, this.random);
        }
        Item item = this.getBroomType().item();
        if (item instanceof BroomItem) {
            BroomItem broomItem = (BroomItem)item;
            broomItem.onActivate(this, this.random);
        }
    }

    public void positionRider(Entity passenger, Entity.MoveFunction pCallback) {
        if (this.hasPassenger(passenger)) {
            Vec3 vec3 = this.getPassengerOffset(passenger);
            pCallback.accept(passenger, this.getX() + vec3.x, this.getY() + vec3.y, this.getZ() + vec3.z);
            passenger.setYRot(passenger.getYRot() + this.deltaRotation);
            passenger.setYHeadRot(passenger.getYHeadRot() + this.deltaRotation);
            this.applyYawToEntity(passenger);
        }
    }

    public Vec3 getPassengerOffset(Entity passenger) {
        Vec3 vec3;
        float f = 0.0f;
        float f1 = this.floatingOffset - 0.4f;
        boolean hasSeat = this.getModule(BroomSlot.SATCHEL).is((Item)ModItems.BROOM_SEAT.get());
        Vec3 offset = Vec3.ZERO;
        Item item = this.getBroomType().item();
        if (item instanceof BroomItem) {
            BroomItem broomItem = (BroomItem)item;
            offset = broomItem.getTipOffset();
        }
        if (this.getPassengers().size() > 1 || passenger instanceof Animal) {
            int i = this.getPassengers().indexOf(passenger);
            if (i == 1 || passenger instanceof Animal) {
                f = -0.6f;
                if (passenger instanceof Animal) {
                    f = -1.0f;
                }
                vec3 = new Vec3((double)f, 0.0, 0.0).add(offset).zRot((float)this.getDeltaMovement().y() * 25.0f * ((float)Math.PI / 180));
                f1 += (float)vec3.y;
            } else {
                f = 0.4f;
                vec3 = new Vec3((double)f, 0.0, 0.0).zRot((float)this.getDeltaMovement().y() * 25.0f * ((float)Math.PI / 180));
                f1 += (float)vec3.y + 0.1f;
            }
        } else if (hasSeat) {
            f = 0.4f;
            Vec3 vec32 = new Vec3((double)f, 0.0, 0.0).zRot((float)this.getDeltaMovement().y() * 25.0f * ((float)Math.PI / 180));
            f1 += (float)vec32.y + 0.1f;
        }
        float offsetZ = 0.0f;
        if (passenger instanceof Animal) {
            f1 += 0.575f;
            offsetZ = 0.05f;
        }
        vec3 = new Vec3((double)f, 0.0, (double)offsetZ).yRot((-this.getYRot() - Math.clamp(this.deltaRotation, -13.0f + this.deltaRotation / 22.5f, 13.0f + this.deltaRotation / 22.5f) * 2.0f + 90.0f) * ((float)Math.PI / 180) - 1.5707964f);
        return vec3.add(0.0, (double)f1, 0.0);
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        int i = -1;
        float rotation = 0.0f;
        boolean hasSeat = this.getModule(BroomSlot.SATCHEL).is((Item)ModItems.BROOM_SEAT.get());
        if (this.getPassengers().size() > 1) {
            i = this.getPassengers().indexOf(entityToUpdate);
        }
        if (i == 1) {
            rotation = 0.0f;
        } else if (hasSeat && (i == 0 || i == -1)) {
            rotation = 90.0f;
        }
        if (entityToUpdate.getType().is(HexereiTags.Entity.CAN_RIDE_BROOM)) {
            rotation = 80.0f;
        }
        if (entityToUpdate instanceof CrowEntity) {
            rotation = 60.0f;
        }
        if (entityToUpdate instanceof OwlEntity) {
            rotation = 40.0f;
        }
        if (entityToUpdate instanceof Cat) {
            rotation = 90.0f;
        }
        entityToUpdate.setYBodyRot(this.getYRot() + rotation);
        float f = Mth.wrapDegrees((float)(entityToUpdate.getYRot() - this.getYRot() - rotation));
        float f1 = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.yRotO += f1 - f;
        entityToUpdate.setYRot(entityToUpdate.getYRot() + f1 - f);
        if (!(entityToUpdate instanceof Cat)) {
            entityToUpdate.setYHeadRot(entityToUpdate.getYRot());
        }
        if (entityToUpdate instanceof TamableAnimal) {
            TamableAnimal animal = (TamableAnimal)entityToUpdate;
            if (animal instanceof Cat) {
                Cat cat = (Cat)animal;
                cat.setInSittingPose(false);
                cat.setOrderedToSit(false);
                cat.setLying(true);
            } else {
                animal.setInSittingPose(true);
                animal.setOrderedToSit(true);
                entityToUpdate.setYHeadRot(this.getYRot() + 90.0f);
                animal.yHeadRotO = this.getYRot() + 90.0f;
            }
        }
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        return super.getDismountLocationForPassenger(passenger).add(0.0, (double)(passenger.getBbHeight() / 2.0f), 0.0).add(this.getPassengerOffset((Entity)passenger).multiply((double)0.85f, (double)0.85f, (double)0.85f));
    }

    public void onPassengerTurned(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        if (this.level().isClientSide) {
            HexereiPacketHandler.sendToServer(new BroomAskForSyncPacket(this.getId()));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("BroomType", this.getBroomType().name());
        compound.put("inv", (Tag)this.itemHandler.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
        compound.putBoolean("floatMode", this.floatMode);
        if (this.broomUUID != null) {
            compound.putUUID("broomUUID", this.broomUUID);
        }
    }

    public boolean save(CompoundTag compound) {
        compound.putString("BroomType", this.getBroomType().name());
        compound.put("inv", (Tag)this.itemHandler.serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
        compound.putBoolean("floatMode", this.floatMode);
        if (this.broomUUID != null) {
            compound.putUUID("broomUUID", this.broomUUID);
        }
        return super.save(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Type", 8)) {
            this.setBroomType(compound.getString("Type"));
        }
        if (compound.contains("BroomType", 8)) {
            this.setBroomType(compound.getString("BroomType"));
        }
        this.itemHandler.deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), compound.getCompound("inv"));
        this.floatMode = compound.getBoolean("floatMode");
        if (compound.contains("broomUUID")) {
            this.broomUUID = compound.getUUID("broomUUID");
        }
    }

    public void load(CompoundTag compound) {
        super.load(compound);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(30){

            protected void onContentsChanged(int slot) {
                BroomEntity.this.sync();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return switch (slot) {
                    case 0 -> stack.is(HexereiTags.Items.BROOM_MISC);
                    case 1 -> {
                        if (stack.is(HexereiTags.Items.SMALL_SATCHELS) || stack.is(HexereiTags.Items.MEDIUM_SATCHELS) || stack.is(HexereiTags.Items.LARGE_SATCHELS)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> stack.is(HexereiTags.Items.BROOM_BRUSH);
                    default -> true;
                };
            }

            public int getSlotLimit(int slot) {
                if (slot == 0 || slot == 1 || slot == 2) {
                    return 1;
                }
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    private MenuProvider createContainerProvider(Level worldIn, BlockPos pos, final boolean isEnder) {
        return new MenuProvider(){

            @org.jetbrains.annotations.Nullable
            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                return new BroomContainer(i, BroomEntity.this, playerInventory, playerEntity, isEnder);
            }

            public Component getDisplayName() {
                return Component.translatable((String)"");
            }
        };
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isSecondaryUseActive()) {
            if (!this.level().isClientSide()) {
                MenuProvider containerProvider = this.createContainerProvider(this.level(), this.blockPosition(), this.getModule(BroomSlot.SATCHEL).is((Item)ModItems.ENDER_SATCHEL.get()));
                player.openMenu(containerProvider, b -> b.writeInt(this.getId()).writeBoolean(this.isEnder()));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.outOfControlTicks < 60.0f) {
            if (!this.level().isClientSide) {
                if (player.startRiding((Entity)this)) {
                    for (BroomSlot slot : BroomSlot.values()) {
                        Item item = this.getModule(slot).getItem();
                        if (!(item instanceof BroomAttachmentItem)) continue;
                        BroomAttachmentItem broomAttachment = (BroomAttachmentItem)item;
                        broomAttachment.onMount(this, (Entity)player, this.random);
                    }
                    if (this.getModule(BroomSlot.BRUSH).is(HexereiTags.Items.BROOM_BRUSH)) {
                        this.push(0.0, 0.25, 0.0);
                    }
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean getPaddleState(int side) {
        return (Boolean)this.entityData.get(side == 0 ? LEFT_PADDLE : RIGHT_PADDLE) != false && this.getControllingPassenger() != null;
    }

    public void setFloatMode(boolean floatMode) {
        this.floatMode = floatMode;
        if (this.level().isClientSide) {
            HexereiPacketHandler.sendToServer(new BroomSyncFloatModeToServer(this.getId(), this.getFloatMode()));
        }
        this.sync();
    }

    public boolean getFloatMode() {
        return this.floatMode;
    }

    public void setRotation(float rotation) {
        this.setYRot(rotation);
        this.yRotO = rotation;
    }

    public void syncDeltaRotation() {
        HexereiPacketHandler.sendToNearbyClient(this.level(), this, (CustomPacketPayload)new BroomSyncRotation(this));
    }

    public void setDamageTaken(float damageTaken) {
        this.entityData.set(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.entityData.get(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.entityData.set(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.entityData.get(TIME_SINCE_HIT);
    }

    private void setRockingTicks(int ticks) {
        this.entityData.set(ROCKING_TICKS, (Object)ticks);
    }

    private int getRockingTicks() {
        return (Integer)this.entityData.get(ROCKING_TICKS);
    }

    public float getRockingAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevRockingAngle, (float)this.rockingAngle);
    }

    public void setForwardDirection(int forwardDirection) {
        this.entityData.set(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.entityData.get(FORWARD_DIRECTION);
    }

    public void setBroomType(String broomType) {
        this.entityData.set(BROOM_TYPE, (Object)BroomType.byName(broomType).name());
    }

    public BroomType getBroomType() {
        return BroomType.byName((String)this.entityData.get(BROOM_TYPE));
    }

    protected boolean canAddPassenger(Entity passenger) {
        if (this.getPassengers().size() == 1 && this.getPassengers().get(0) instanceof CrowEntity && passenger instanceof Player) {
            return true;
        }
        return this.getPassengers().size() < this.getMaxPassengers();
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        List list = this.getPassengers();
        return list.isEmpty() || !(this.getFirstPassenger() instanceof Player) ? null : (LivingEntity)this.getFirstPassenger();
    }

    public void updateInputs(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown, boolean jumpInputDown, boolean sneakingInputDown) {
        this.leftInputDown = leftInputDown;
        this.rightInputDown = rightInputDown;
        this.forwardInputDown = forwardInputDown;
        this.backInputDown = backInputDown;
        this.jumpInputDown = jumpInputDown;
        this.sneakingInputDown = sneakingInputDown;
        if (!this.getModule(BroomSlot.BRUSH).is(HexereiTags.Items.BROOM_BRUSH)) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.jumpInputDown = false;
            this.sneakingInputDown = false;
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return super.getAddEntityPacket(entity);
    }

    public boolean canSwim() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (this.isControlledByLocalInstance() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.absMoveTo(this.lerpX, this.lerpY, this.lerpZ, this.getYRot(), (float)this.lerpXRot);
        }
    }

    public int getContainerSize() {
        return 30;
    }

    public boolean isEmpty() {
        return false;
    }

    public ItemStack getItem(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.EMPTY;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index == 1 && !stack.is(HexereiTags.Items.SMALL_SATCHELS)) {
            return false;
        }
        return ((ItemStack)this.items.get(index)).isEmpty();
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemStack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        if (itemStack.getCount() < 1) {
            itemStack.setCount(1);
        }
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.copy();
            this.items.set(index, (Object)itemStack);
        }
        this.sync();
    }

    public void setChanged() {
    }

    public void sync() {
        this.setChanged();
        if (!this.level().isClientSide) {
            HexereiPacketHandler.sendToNearbyClient(this.level(), this, (CustomPacketPayload)new BroomSyncPacket(this.getId(), this.saveWithoutId(new CompoundTag())));
        }
    }

    public boolean stillValid(Player player) {
        if (this.isRemoved()) {
            return false;
        }
        return !(player.distanceToSqr((Entity)this) > 64.0);
    }

    public void clearContent() {
        this.items.clear();
    }

    @org.jetbrains.annotations.Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new BroomContainer(id, this, inv, player, this.isEnder());
    }

    public boolean isEnder() {
        return this.getModule(BroomSlot.SATCHEL).is((Item)ModItems.ENDER_SATCHEL.get());
    }

    public boolean isReplacer() {
        return this.getModule(BroomSlot.SATCHEL).is((Item)ModItems.REPLACER_SATCHEL.get());
    }

    public void openCustomInventoryScreen(Player pPlayer) {
        if (!(this.level().isClientSide || this.isVehicle() && !this.hasPassenger((Entity)pPlayer))) {
            MenuProvider containerProvider = this.createContainerProvider(this.level(), this.blockPosition(), this.getModule(BroomSlot.SATCHEL).is((Item)ModItems.ENDER_SATCHEL.get()));
            pPlayer.openMenu(containerProvider, b -> b.writeInt(this.getId()).writeBoolean(this.isEnder()));
        }
    }

    public ItemStack getModule(BroomSlot slot) {
        return this.itemHandler.getStackInSlot(slot.ordinal());
    }

    public void setModule(BroomSlot slot, ItemStack module) {
        this.itemHandler.setStackInSlot(slot.ordinal(), module);
    }

    public List<ItemStack> getSatchelSlots(int satchelSize) {
        ArrayList<ItemStack> content = new ArrayList<ItemStack>();
        for (int i = 3; i < satchelSize; ++i) {
            content.add(this.itemHandler.getStackInSlot(i));
        }
        return content;
    }

    public static enum BroomSlot {
        MISC,
        SATCHEL,
        BRUSH;

    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        UNDER_LAVA,
        UNDER_FLOWING_LAVA,
        ON_LAND,
        IN_AIR;

    }

    public static enum AccelerationDirection {
        FORWARD,
        NONE,
        REVERSE,
        CHARGING;


        public static AccelerationDirection fromEntity(LivingEntity entity) {
            if (entity.yya > 0.0f) {
                return FORWARD;
            }
            if (entity.yya < 0.0f) {
                return REVERSE;
            }
            return NONE;
        }
    }
}

