/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity;

import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.HexereiPaintingEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ModBoatEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ModChestBoatEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="hexerei", bus=EventBusSubscriber.Bus.MOD)
public class ModEntityTypes {
    public static DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"hexerei");
    public static final DeferredHolder<EntityType<?>, EntityType<BroomEntity>> BROOM = ENTITY_TYPES.register("broom", () -> EntityType.Builder.of(BroomEntity::new, (MobCategory)MobCategory.MISC).sized(1.175f, 0.3625f).setShouldReceiveVelocityUpdates(true).setTrackingRange(10).updateInterval(1).build(HexereiUtil.getResource("broom").toString()));
    public static final DeferredHolder<EntityType<?>, EntityType<ModBoatEntity>> HEXEREI_BOAT = ENTITY_TYPES.register("boat", () -> EntityType.Builder.of(ModBoatEntity::new, (MobCategory)MobCategory.MISC).sized(1.175f, 0.3625f).setTrackingRange(10).build(HexereiUtil.getResource("boat").toString()));
    public static final DeferredHolder<EntityType<?>, EntityType<ModChestBoatEntity>> HEXEREI_CHEST_BOAT = ENTITY_TYPES.register("chest_boat", () -> EntityType.Builder.of(ModChestBoatEntity::new, (MobCategory)MobCategory.MISC).sized(1.175f, 0.3625f).setTrackingRange(10).build(HexereiUtil.getResource("chest_boat").toString()));
    public static final DeferredHolder<EntityType<?>, EntityType<CrowEntity>> CROW = ENTITY_TYPES.register("crow", () -> EntityType.Builder.of(CrowEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.375f, 0.5f).setTrackingRange(64).setUpdateInterval(1).build(HexereiUtil.getResource("crow").toString()));
    public static final DeferredHolder<EntityType<?>, EntityType<OwlEntity>> OWL = ENTITY_TYPES.register("owl", () -> EntityType.Builder.of(OwlEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.5f, 0.65f).setTrackingRange(64).setUpdateInterval(1).build(HexereiUtil.getResource("owl").toString()));
    public static final DeferredHolder<EntityType<?>, EntityType<HexereiPaintingEntity>> BOOK_CANVAS = ENTITY_TYPES.register("book_canvas", () -> EntityType.Builder.of(HexereiPaintingEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).build(HexereiUtil.getResource("book_canvas").toString()));

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CROW.get(), CrowEntity.createAttributes());
        event.put((EntityType)OWL.get(), OwlEntity.createAttributes());
    }

    static <T extends Mob> DeferredHolder<EntityType<?>, EntityType<T>> addEntityWithEgg(String name, int color1, int color2, float width, float height, EntityType.EntityFactory<T> factory, MobCategory kind) {
        EntityType type = EntityType.Builder.of(factory, (MobCategory)kind).setTrackingRange(64).setUpdateInterval(1).sized(width, height).build("hexerei:" + name);
        ModItems.ITEMS.register(name + "_spawn_egg", () -> new SpawnEggItem(type, color1, color2, new Item.Properties()));
        return ENTITY_TYPES.register(name, () -> type);
    }
}

