/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ModRenderTypes
extends RenderType {
    public static List<RenderType> renderTypes = new ArrayList<RenderType>();
    public static List<RenderType> normalRenderTypes = new ArrayList<RenderType>();
    public static List<RenderType> particleRenderTypes = new ArrayList<RenderType>();
    private static final RenderStateShard.LineStateShard THICK_LINE = new RenderStateShard.LineStateShard(OptionalDouble.of(10.0));
    public static final RenderType BLOCK_HIGHLIGHT_FACE = ModRenderTypes.create((String)"block_highlight", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState(NO_TEXTURE).setDepthTestState(NO_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).setWriteMaskState(COLOR_WRITE).createCompositeState(false));
    public static final RenderType HUE_SLIDER = ModRenderTypes.registerRenderType((RenderType)ModRenderTypes.create((String)"hue_slider", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ClientEvents.hueSliderShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.parse((String)"hexerei:textures/book/blank.png"), false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true)));
    public static final RenderType SLIDER = ModRenderTypes.registerRenderType((RenderType)ModRenderTypes.create((String)"slider", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ClientEvents.sliderShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.parse((String)"hexerei:textures/book/blank.png"), false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true)));
    public static final BiFunction<ResourceLocation, Boolean, RenderType> BOOK_TRANSLUCENT = Util.memoize((location, bool) -> {
        RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ClientEvents.bookTranslucentShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(bool.booleanValue());
        return ModRenderTypes.create((String)"book_translucent", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)true, (RenderType.CompositeState)rendertype$compositestate);
    });
    public static final RenderType MOON_PHASE = RenderType.create((String)"moon_phase", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(HexereiUtil.getResource("textures/gui/moon_phases.png"), false, false)).setLightmapState(RenderStateShard.LIGHTMAP).setTransparencyState(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).createCompositeState(false));
    public static final RenderType BLOCK_HILIGHT_LINE = ModRenderTypes.create((String)"block_hilight_line", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLineState(THICK_LINE).setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTextureState(NO_TEXTURE).setDepthTestState(NO_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).setWriteMaskState(COLOR_WRITE).createCompositeState(false));
    private static final RenderType FLUID = RenderType.create((String)"hexerei:fluid", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_CULL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(true));
    private static final BiFunction<ResourceLocation, Boolean, RenderType> ENTITY_TRANSLUCENT = Util.memoize((p_286156_, p_286157_) -> {
        RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_286156_, false, false)).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setCullState(NO_CULL).setLightmapState(LIGHTMAP).setOverlayState(OVERLAY).createCompositeState(p_286157_.booleanValue());
        return ModRenderTypes.create((String)"entity_translucent", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)rendertype$compositestate);
    });

    public ModRenderTypes(String name, VertexFormat format, VertexFormat.Mode drawMode, int bufferSize, boolean useDelegate, boolean needsSorting, Runnable pre, Runnable post) {
        super(name, format, drawMode, bufferSize, useDelegate, needsSorting, pre, post);
    }

    public static RenderType hueSlider(ResourceLocation location) {
        return HUE_SLIDER;
    }

    public static RenderType slider(ResourceLocation location) {
        return SLIDER;
    }

    public static RenderType bookTranslucent(ResourceLocation location) {
        return BOOK_TRANSLUCENT.apply(location, true);
    }

    public static RenderType getFluid() {
        return FLUID;
    }

    public static RenderType createGenericRenderType(String name, VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader, RenderStateShard.TransparencyStateShard transparency, ResourceLocation texture) {
        RenderType.CompositeRenderType type = RenderType.create((String)("hexerei:" + name), (VertexFormat)format, (VertexFormat.Mode)mode, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(shader).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, true)).setLightmapState(new RenderStateShard.LightmapStateShard(false)).setTransparencyState(transparency).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setCullState(new RenderStateShard.CullStateShard(true)).createCompositeState(true));
        return type;
    }

    public static RenderType registerRenderType(RenderType type, boolean isParticle) {
        renderTypes.add(type);
        if (isParticle) {
            particleRenderTypes.add(type);
        } else {
            normalRenderTypes.add(type);
        }
        return type;
    }

    public static RenderType registerRenderType(RenderType type) {
        return ModRenderTypes.registerRenderType(type, false);
    }
}

