/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.ModRenderTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.events.CrowWhitelistEvent;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.custom.CrowFluteItem;
import net.joefoxe.hexerei.item.data_components.FluteData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class CrowPerchRenderer {
    private static final float BOX_SIZE = 0.5f;
    private static final float BOX_START = 0.25f;
    private static ItemStack lastStackMain = ItemStack.EMPTY;
    private static ItemStack lastStackOff = ItemStack.EMPTY;
    public static final ResourceLocation BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png");

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        if (Hexerei.proxy.getPlayer() != null) {
            ItemStack curItemMain = Hexerei.proxy.getPlayer().getMainHandItem();
            ItemStack curItemOff = Hexerei.proxy.getPlayer().getOffhandItem();
            if (!ItemStack.matches((ItemStack)curItemMain, (ItemStack)lastStackMain)) {
                lastStackMain = curItemMain.copy();
            }
            if (!ItemStack.matches((ItemStack)curItemOff, (ItemStack)lastStackOff)) {
                lastStackOff = curItemOff.copy();
            }
        }
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Vec3 projectedView;
            PoseStack matrixStack;
            MultiBufferSource.BufferSource buffer;
            FluteData fluteData;
            if (CrowWhitelistEvent.whiteListingCrow != null) {
                MultiBufferSource.BufferSource buffer2 = Minecraft.getInstance().renderBuffers().bufferSource();
                PoseStack matrixStack2 = event.getPoseStack();
                matrixStack2.pushPose();
                Vec3 projectedView2 = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                matrixStack2.translate(-projectedView2.x, -projectedView2.y, -projectedView2.z);
                CrowPerchRenderer.renderWhitelisting(buffer2, matrixStack2, CrowWhitelistEvent.whiteListingCrow);
                matrixStack2.popPose();
            }
            if (lastStackMain.getItem() instanceof CrowFluteItem) {
                fluteData = (FluteData)lastStackMain.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.empty());
                int command = fluteData.commandMode();
                if (command == 2) {
                    buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                    matrixStack = event.getPoseStack();
                    matrixStack.pushPose();
                    projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    matrixStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
                    CrowPerchRenderer.renderPerch(buffer, matrixStack, lastStackMain);
                    matrixStack.popPose();
                }
                if (command == 1 || command == 2) {
                    buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                    matrixStack = event.getPoseStack();
                    matrixStack.pushPose();
                    projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    matrixStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
                    CrowPerchRenderer.renderSelect(buffer, matrixStack, lastStackMain);
                    matrixStack.popPose();
                }
            }
            if (lastStackOff.getItem() instanceof CrowFluteItem) {
                fluteData = (FluteData)lastStackOff.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.empty());
                int command = fluteData.commandMode();
                if (command == 2) {
                    buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                    matrixStack = event.getPoseStack();
                    matrixStack.pushPose();
                    projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    matrixStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
                    CrowPerchRenderer.renderPerch(buffer, matrixStack, lastStackOff);
                    matrixStack.popPose();
                }
                if (command == 1 || command == 2) {
                    buffer = Minecraft.getInstance().renderBuffers().bufferSource();
                    matrixStack = event.getPoseStack();
                    matrixStack.pushPose();
                    projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    matrixStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
                    CrowPerchRenderer.renderSelect(buffer, matrixStack, lastStackOff);
                    matrixStack.popPose();
                }
            }
        }
    }

    private static void renderPillar(MultiBufferSource.BufferSource buffer, PoseStack matrixStack, float xOffset, float yOffset, float zOffset) {
        VertexConsumer faceBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
        Matrix4f posMat = matrixStack.last().pose();
        int color = 0x110511;
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        int alpha = 40;
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.5f, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset + 0.5f, zOffset).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset, zOffset).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset + 0.5f, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.5f, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.5f, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.5f, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset + 0.5f, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset + 0.5f, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset, zOffset).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.5f, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset + 0.5f, zOffset + 0.05f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.05f, yOffset + 0.5f, zOffset).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.5f, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        RenderSystem.disableDepthTest();
        buffer.endBatch(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
    }

    private static void renderHorizontalPillar(MultiBufferSource.BufferSource buffer, PoseStack matrixStack, float xOffset, float yOffset, float zOffset) {
        VertexConsumer faceBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
        Matrix4f posMat = matrixStack.last().pose();
        int color = 0x110511;
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        int alpha = 40;
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset + 0.05f, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset + 0.05f, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.45f, yOffset + 0.05f, zOffset).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        RenderSystem.disableDepthTest();
        buffer.endBatch(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
    }

    private static void renderHorizontalPillarTurned(MultiBufferSource.BufferSource buffer, PoseStack matrixStack, float xOffset, float yOffset, float zOffset) {
        VertexConsumer faceBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
        Matrix4f posMat = matrixStack.last().pose();
        int color = 0x110511;
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        int alpha = 40;
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.05f, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.05f, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset + 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset + 0.5f, yOffset + 0.05f, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        faceBuilder.addVertex(posMat, xOffset, yOffset + 0.05f, zOffset + 0.45f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        RenderSystem.disableDepthTest();
        buffer.endBatch(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
    }

    private static void renderPerch(MultiBufferSource.BufferSource buffer, PoseStack matrixStack, ItemStack stack) {
        FluteData data = (FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY);
        HashMap<BlockPos, Integer> map = new HashMap<BlockPos, Integer>();
        for (int i = 0; i < data.crowList().size(); ++i) {
            int amount;
            int crowId = data.crowList().get(i).id();
            Level level = Hexerei.proxy.getPlayer().level();
            Entity entity = level.getEntity(crowId);
            if (!(entity instanceof CrowEntity)) continue;
            CrowEntity crow = (CrowEntity)entity;
            if (((CrowEntity)level.getEntity(crowId)).getPerchPos() == null) continue;
            BlockPos pos = crow.getPerchPos();
            double topOffset = level.getBlockState(pos).getOcclusionShape((BlockGetter)level, pos).max(Direction.Axis.Y);
            if (!map.containsKey(pos)) {
                amount = 1;
            } else {
                if ((Integer)map.get(pos) >= 3) continue;
                amount = (Integer)map.get(pos) + 1;
            }
            map.put(pos, amount);
            Vec3 vec3 = new Vec3((double)pos.getX(), (double)pos.getY() + topOffset, (double)pos.getZ());
            matrixStack.pushPose();
            matrixStack.translate(vec3.x, vec3.y, vec3.z);
            Matrix4f posMat = matrixStack.last().pose();
            int color = 3871805;
            if (crow.getDyeColorId() != -1) {
                color = crow.getDyeColor().getMapColor().col;
            }
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            int alpha = 40;
            matrixStack.translate(0.5f, Mth.sin((float)(ClientEvents.getClientTicks() / 25.0f)) / 25.0f, 0.5f);
            matrixStack.mulPose(Axis.YP.rotationDegrees(ClientEvents.getClientTicks() * 0.5f));
            matrixStack.translate(-0.5f, 0.0f, -0.5f);
            matrixStack.translate(0.25f, 0.25f, 0.25f);
            CrowPerchRenderer.renderPillar(buffer, matrixStack, -0.05f, 0.0f, -0.05f);
            CrowPerchRenderer.renderPillar(buffer, matrixStack, 0.5f, 0.0f, -0.05f);
            CrowPerchRenderer.renderPillar(buffer, matrixStack, -0.05f, 0.0f, 0.5f);
            CrowPerchRenderer.renderPillar(buffer, matrixStack, 0.5f, 0.0f, 0.5f);
            CrowPerchRenderer.renderHorizontalPillar(buffer, matrixStack, 0.05f, -0.05f, 0.0f);
            CrowPerchRenderer.renderHorizontalPillar(buffer, matrixStack, -0.5f, -0.05f, 0.0f);
            CrowPerchRenderer.renderHorizontalPillarTurned(buffer, matrixStack, 0.0f, -0.05f, 0.05f);
            CrowPerchRenderer.renderHorizontalPillarTurned(buffer, matrixStack, 0.0f, -0.05f, -0.5f);
            CrowPerchRenderer.renderHorizontalPillar(buffer, matrixStack, 0.05f, 0.5f, 0.0f);
            CrowPerchRenderer.renderHorizontalPillar(buffer, matrixStack, -0.5f, 0.5f, 0.0f);
            CrowPerchRenderer.renderHorizontalPillarTurned(buffer, matrixStack, 0.0f, 0.5f, 0.05f);
            CrowPerchRenderer.renderHorizontalPillarTurned(buffer, matrixStack, 0.0f, 0.5f, -0.5f);
            VertexConsumer lineBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
            RenderSystem.disableDepthTest();
            buffer.endBatch(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
            matrixStack.popPose();
        }
    }

    private static void renderSelect(MultiBufferSource.BufferSource buffer, PoseStack matrixStack, ItemStack stack) {
        FluteData data = (FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY);
        for (int i = 0; i < data.crowList().size(); ++i) {
            int crowId = data.crowList().get(i).id();
            Entity entity = Hexerei.proxy.getPlayer().level().getEntity(crowId);
            if (!(entity instanceof CrowEntity)) continue;
            CrowEntity crow = (CrowEntity)entity;
            Vec3 pos = crow.position();
            matrixStack.pushPose();
            matrixStack.translate(pos.x, pos.y + (double)0.45f, pos.z);
            Matrix4f posMat = matrixStack.last().pose();
            int color = 3871805;
            if (crow.getCommand() == 0) {
                color = 38558;
            }
            if (crow.getCommand() == 1) {
                color = 0x771100;
            }
            if (crow.getCommand() == 2) {
                color = 38402;
            }
            if (crow.getCommand() == 3) {
                if (crow.getHelpCommand() == 0) {
                    color = 3871805;
                }
                if (crow.getHelpCommand() == 1) {
                    color = 11378944;
                }
                if (crow.getHelpCommand() == 2) {
                    color = 6832133;
                }
            }
            if (crow.getDyeColorId() != -1) {
                color = crow.getDyeColor().getMapColor().col;
            }
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            int alpha = 80;
            matrixStack.translate(0.0f, Mth.sin((float)((ClientEvents.getClientTicks() + (float)(crowId * 20)) / 10.0f)) / 10.0f, 0.0f);
            matrixStack.mulPose(Axis.YP.rotationDegrees(ClientEvents.getClientTicks() + (float)(crowId * 20)));
            matrixStack.translate(-0.5f, 0.0f, -0.5f);
            matrixStack.translate(0.25f, 0.25f, 0.25f);
            matrixStack.scale(0.35f, 0.35f, 0.35f);
            matrixStack.translate(0.5f, 0.0f, 0.5f);
            VertexConsumer lineBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
            lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
            RenderSystem.disableDepthTest();
            buffer.endBatch(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
            matrixStack.popPose();
        }
    }

    private static void renderWhitelisting(MultiBufferSource.BufferSource buffer, PoseStack matrixStack, CrowEntity crow) {
        Vec3 pos = crow.position();
        matrixStack.pushPose();
        matrixStack.translate(pos.x, pos.y + (double)0.45f, pos.z);
        Matrix4f posMat = matrixStack.last().pose();
        int color = 0xE2E2E2;
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        int alpha = 80;
        matrixStack.translate(0.0f, Mth.sin((float)(ClientEvents.getClientTicks() / 10.0f)) / 10.0f, 0.0f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(ClientEvents.getClientTicks()));
        matrixStack.translate(-0.5f, 0.0f, -0.5f);
        matrixStack.translate(0.25f, 0.25f, 0.25f);
        matrixStack.scale(0.35f, 0.35f, 0.35f);
        matrixStack.translate(0.5f, 0.0f, 0.5f);
        VertexConsumer lineBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
        lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, -1.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 0.0f, 1.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(-1.0f, 0.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(1.0f, 0.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, -1.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        lineBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv2(0, 10).setNormal(0.0f, 1.0f, 0.0f);
        RenderSystem.disableDepthTest();
        buffer.endBatch(ModRenderTypes.BLOCK_HIGHLIGHT_FACE);
        matrixStack.popPose();
    }
}

