/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.container.HerbJarContainer;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.data_components.FluteData;
import net.joefoxe.hexerei.items.JarHandler;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HerbJar
extends Block
implements ITileEntity<HerbJarTile>,
EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty GUI_RENDER = BooleanProperty.create((String)"gui_render");
    public static final BooleanProperty DYED = BooleanProperty.create((String)"dyed");
    public static final DyedItemColor DEFAULT_COLOR = new DyedItemColor(13218201, false);
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)5.0, (double)-0.5, (double)5.0, (double)11.0, (double)0.0, (double)11.0), Block.box((double)5.5, (double)13.0, (double)5.5, (double)10.5, (double)15.0, (double)10.5), Block.box((double)4.5, (double)12.0, (double)10.5, (double)11.5, (double)14.0, (double)11.5), Block.box((double)4.5, (double)12.0, (double)4.5, (double)11.5, (double)14.0, (double)5.5), Block.box((double)4.5, (double)12.0, (double)5.5, (double)5.5, (double)14.0, (double)10.5), Block.box((double)10.5, (double)12.0, (double)5.5, (double)11.5, (double)14.0, (double)10.5), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public RenderShape getRenderShape(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate;
            if (direction.getAxis() != Direction.Axis.Y || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)((BlockState)((BlockState)((BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue((Property)GUI_RENDER, (Comparable)Boolean.valueOf(false))).setValue((Property)DYED, (Comparable)Boolean.valueOf(HexereiUtil.getDyeColor(context.getItemInHand()) != 4337438))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection());
        }
        return null;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is((Item)ModItems.CROW_FLUTE.get()) && ((FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).commandMode() == 2) {
            stack.useOn(new UseOnContext(player, hand, hitResult));
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof HerbJarTile && ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite() == hitResult.getDirection()) {
            ((HerbJarTile)tileEntity).interactPutItems(player);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite() != hitResult.getDirection()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (!level.isClientSide()) {
                if (tileEntity instanceof HerbJarTile) {
                    ((HerbJarTile)tileEntity).sync();
                    MenuProvider containerProvider = this.createContainerProvider(level, pos, this.getCloneItemStack(state, (HitResult)hitResult, (LevelReader)level, pos, player));
                    player.openMenu(containerProvider, b -> b.writeNbt(this.getCloneItemStack((LevelReader)level, pos, state).save((HolderLookup.Provider)level.registryAccess())).writeBlockPos(tileEntity.getBlockPos()));
                } else {
                    throw new IllegalStateException("Our Container provider is missing!");
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (tileentity != null) {
                ItemStack cloneItemStack = this.getCloneItemStack(state, (HitResult)new BlockHitResult(pos.getCenter(), Direction.UP, pos, true), (LevelReader)level, pos, null);
                if (!level.isClientSide()) {
                    HerbJar.popResource((Level)level, (BlockPos)pos, (ItemStack)cloneItemStack);
                }
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected BlockHitResult rayTraceEyeLevel(Level world, Player player, double length) {
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookPos = player.getViewVector(1.0f);
        Vec3 endPos = eyePos.add(lookPos.x * length, lookPos.y * length, lookPos.z * length);
        ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return world.clip(context);
    }

    public void attack(BlockState state, Level worldIn, BlockPos pos, Player playerIn) {
        BlockHitResult rayResult = this.rayTraceEyeLevel(worldIn, playerIn, playerIn.blockInteractionRange() + 1.0);
        if (rayResult.getType() == HitResult.Type.MISS) {
            return;
        }
        Direction side = rayResult.getDirection();
        BlockEntity tile = worldIn.getBlockEntity(pos);
        HerbJarTile herbJarTile = null;
        if (tile instanceof HerbJarTile) {
            herbJarTile = (HerbJarTile)tile;
        }
        if (((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite() != rayResult.getDirection()) {
            return;
        }
        ItemStack item = playerIn.isShiftKeyDown() ? herbJarTile.takeItems(0, herbJarTile.itemHandler.getStackInSlot(0).getCount()) : herbJarTile.takeItems(0, 1);
        if (!item.isEmpty()) {
            if (!playerIn.getInventory().add(item)) {
                this.dropItemStack(worldIn, pos.relative(side), playerIn, item);
                worldIn.sendBlockUpdated(pos, state, state, 3);
            } else {
                worldIn.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        super.attack(state, worldIn, pos, playerIn);
    }

    private void dropItemStack(Level world, BlockPos pos, Player player, @Nonnull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.3f), (double)((float)pos.getZ() + 0.5f), stack);
        Vec3 motion = entity.getDeltaMovement();
        entity.push(-motion.x, -motion.y, -motion.z);
        world.addFreshEntity((Entity)entity);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public HerbJar(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)GUI_RENDER, (Comparable)Boolean.valueOf(false))).setValue((Property)DYED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, HANGING, WATERLOGGED, GUI_RENDER, DYED});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return super.getCloneItemStack(level, pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        Component customName;
        ItemStack item = new ItemStack((ItemLike)this);
        Optional<HerbJarTile> tileEntityOptional = Optional.ofNullable((HerbJarTile)this.getBlockEntity((BlockGetter)level, pos));
        CompoundTag tag = ((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        JarHandler empty = tileEntityOptional.map(herb_jar -> herb_jar.itemHandler).orElse(new JarHandler(1, 1024));
        CompoundTag inv = tileEntityOptional.map(herb_jar -> herb_jar.itemHandler.serializeNBT((HolderLookup.Provider)level.registryAccess())).orElse(new CompoundTag());
        if (!empty.getStackInSlot(0).isEmpty()) {
            tag.put("Inventory", (Tag)inv);
        }
        tileEntityOptional.ifPresent(herbJarTile -> {
            if (herbJarTile.hasDyeColor()) {
                item.set(DataComponents.DYED_COLOR, (Object)herbJarTile.dyeColor);
            }
        });
        int toggled = tileEntityOptional.map(herbJarTile -> herbJarTile.buttonToggled).orElse(0);
        if (toggled == 1) {
            tag.putInt("ButtonToggled", toggled);
        }
        if (!tag.isEmpty()) {
            item.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        if ((customName = (Component)tileEntityOptional.map(HerbJarTile::getCustomName).orElse(null)) != null && !customName.getString().isEmpty()) {
            item.set(DataComponents.CUSTOM_NAME, (Object)customName);
        }
        return item;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (stack.has(DataComponents.CUSTOM_NAME) && (blockEntity = worldIn.getBlockEntity(pos)) instanceof HerbJarTile) {
            HerbJarTile herbJarTile = (HerbJarTile)blockEntity;
            herbJarTile.customName = stack.getHoverName();
        }
        if (worldIn.isClientSide()) {
            return;
        }
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            te.readInventory((HolderLookup.Provider)worldIn.registryAccess(), tag.getCompound("Inventory"));
            if (stack.has(DataComponents.DYED_COLOR)) {
                te.dyeColor = (DyedItemColor)stack.getOrDefault(DataComponents.DYED_COLOR, (Object)DEFAULT_COLOR);
            }
            te.buttonToggled = tag.getInt("ButtonToggled");
        });
    }

    public boolean placeLiquid(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidStateIn.getType() == Fluids.WATER) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            worldIn.scheduleTick(pos, fluidStateIn.getType(), fluidStateIn.getType().getTickDelay((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = HerbJar.getBlockConnected(state).getOpposite();
        return Block.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.getValue((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
    }

    private MenuProvider createContainerProvider(final Level worldIn, final BlockPos pos, final ItemStack stack) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                return new HerbJarContainer(i, stack, worldIn, pos, playerInventory, playerEntity);
            }

            public Component getDisplayName() {
                if (((HerbJarTile)worldIn.getBlockEntity((BlockPos)pos)).customName != null) {
                    return Component.translatable((String)((HerbJarTile)worldIn.getBlockEntity((BlockPos)pos)).customName.getString());
                }
                return Component.translatable((String)"screen.hexerei.herb_jar");
            }
        };
    }

    @Override
    public Class<HerbJarTile> getTileEntityClass() {
        return HerbJarTile.class;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HerbJarTile((BlockEntityType)ModTileEntities.HERB_JAR_TILE.get(), pos, state);
    }
}

