/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.connected.CTDyable;
import net.joefoxe.hexerei.block.connected.Waxed;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ItemAbility;

public class ConnectingCarpetDyed
extends CarpetBlock
implements Waxed,
CTDyable {
    public static BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final EnumProperty<North> NORTH = EnumProperty.create((String)"north", North.class);
    public static final EnumProperty<South> SOUTH = EnumProperty.create((String)"south", South.class);
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);
    public DyeColor dyeColor;

    public ConnectingCarpetDyed(BlockBehaviour.Properties pProperties, DyeColor dyeColor) {
        super(pProperties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.defaultBlockState().setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue(NORTH, (Comparable)((Object)North.NONE))).setValue(SOUTH, (Comparable)((Object)South.NONE))).setValue(COLOR, (Comparable)dyeColor));
        this.dyeColor = dyeColor;
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        List drops = super.getDrops(pState, pParams);
        if (!pState.hasProperty(COLOR)) {
            return drops;
        }
        ArrayList<ItemStack> updated_drops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            if (stack.getItem() == ((ConnectingCarpetDyed)ModBlocks.INFUSED_FABRIC_CARPET.get()).asItem() || stack.getItem() == ((ConnectingCarpetDyed)ModBlocks.WAXED_INFUSED_FABRIC_CARPET.get()).asItem()) {
                DyeColor color = (DyeColor)pState.getValue(COLOR);
                CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                tag.putString("color", color.getName());
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            updated_drops.add(stack);
        }
        return updated_drops;
    }

    @Override
    public DyeColor getDyeColor(BlockState blockState) {
        if (blockState.hasProperty(COLOR)) {
            return (DyeColor)blockState.getValue(COLOR);
        }
        return DyeColor.WHITE;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        boolean east = (Boolean)pState.getValue((Property)EAST);
        boolean west = (Boolean)pState.getValue((Property)WEST);
        North northState = (North)((Object)pState.getValue(NORTH));
        South southState = (South)((Object)pState.getValue(SOUTH));
        boolean north = northState == North.ALL || northState == North.JUST_NORTH || northState == North.NORTH_AND_NORTH_EAST || northState == North.NORTH_AND_NORTH_WEST;
        boolean north_east = northState == North.ALL || northState == North.JUST_NORTH_EAST || northState == North.NORTH_AND_NORTH_EAST || northState == North.NORTH_EAST_AND_NORTH_WEST;
        boolean north_west = northState == North.ALL || northState == North.JUST_NORTH_WEST || northState == North.NORTH_AND_NORTH_WEST || northState == North.NORTH_EAST_AND_NORTH_WEST;
        boolean south = southState == South.ALL || southState == South.JUST_SOUTH || southState == South.SOUTH_AND_SOUTH_EAST || southState == South.SOUTH_AND_SOUTH_WEST;
        boolean south_east = southState == South.ALL || southState == South.JUST_SOUTH_EAST || southState == South.SOUTH_AND_SOUTH_EAST || southState == South.SOUTH_EAST_AND_SOUTH_WEST;
        boolean south_west = southState == South.ALL || southState == South.JUST_SOUTH_WEST || southState == South.SOUTH_AND_SOUTH_WEST || southState == South.SOUTH_EAST_AND_SOUTH_WEST;
        switch (pRot) {
            case NONE: {
                return pState;
            }
            case CLOCKWISE_90: {
                North northTemp = North.NONE;
                South southTemp = South.NONE;
                if (south_east && east && north_east) {
                    southTemp = South.ALL;
                } else if (!south_east && east && north_east) {
                    southTemp = South.SOUTH_AND_SOUTH_EAST;
                } else if (south_east && east) {
                    southTemp = South.SOUTH_AND_SOUTH_WEST;
                } else if (south_east && north_east) {
                    southTemp = South.SOUTH_EAST_AND_SOUTH_WEST;
                } else if (!south_east && east) {
                    southTemp = South.JUST_SOUTH;
                } else if (!south_east && north_east) {
                    southTemp = South.JUST_SOUTH_EAST;
                } else if (south_east) {
                    southTemp = South.JUST_SOUTH_WEST;
                }
                if (south_west && west && north_west) {
                    northTemp = North.ALL;
                } else if (!south_west && west && north_west) {
                    northTemp = North.NORTH_AND_NORTH_EAST;
                } else if (south_west && west) {
                    northTemp = North.NORTH_AND_NORTH_WEST;
                } else if (south_west && north_west) {
                    northTemp = North.NORTH_EAST_AND_NORTH_WEST;
                } else if (!south_west && west) {
                    northTemp = North.JUST_NORTH;
                } else if (!south_west && north_west) {
                    northTemp = North.JUST_NORTH_EAST;
                } else if (south_west) {
                    northTemp = North.JUST_NORTH_WEST;
                }
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)EAST, (Comparable)Boolean.valueOf(north))).setValue((Property)WEST, (Comparable)Boolean.valueOf(south))).setValue(NORTH, (Comparable)((Object)northTemp))).setValue(SOUTH, (Comparable)((Object)southTemp));
            }
            case CLOCKWISE_180: {
                North northTemp = North.NONE;
                South southTemp = South.NONE;
                if (north && north_east && north_west) {
                    southTemp = South.ALL;
                } else if (north && north_west) {
                    southTemp = South.SOUTH_AND_SOUTH_EAST;
                } else if (north && north_east) {
                    southTemp = South.SOUTH_AND_SOUTH_WEST;
                } else if (north_west && north_east) {
                    southTemp = South.SOUTH_EAST_AND_SOUTH_WEST;
                } else if (!north_west && !north_east && north) {
                    southTemp = South.JUST_SOUTH;
                } else if (north_west) {
                    southTemp = South.JUST_SOUTH_EAST;
                } else if (north_east) {
                    southTemp = South.JUST_SOUTH_WEST;
                }
                if (south && south_east && south_west) {
                    northTemp = North.ALL;
                } else if (south && south_west) {
                    northTemp = North.NORTH_AND_NORTH_EAST;
                } else if (south && south_east) {
                    northTemp = North.NORTH_AND_NORTH_WEST;
                } else if (south_west && south_east) {
                    northTemp = North.NORTH_EAST_AND_NORTH_WEST;
                } else if (!south_west && !south_east && south) {
                    northTemp = North.JUST_NORTH;
                } else if (south_west) {
                    northTemp = North.JUST_NORTH_EAST;
                } else if (south_east) {
                    northTemp = North.JUST_NORTH_WEST;
                }
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)EAST, (Comparable)Boolean.valueOf(west))).setValue((Property)WEST, (Comparable)Boolean.valueOf(east))).setValue(NORTH, (Comparable)((Object)northTemp))).setValue(SOUTH, (Comparable)((Object)southTemp));
            }
            case COUNTERCLOCKWISE_90: {
                North northTemp = North.NONE;
                South southTemp = South.NONE;
                if (north_west && west && south_west) {
                    southTemp = South.ALL;
                } else if (!north_west && west && south_west) {
                    southTemp = South.SOUTH_AND_SOUTH_EAST;
                } else if (north_west && west) {
                    southTemp = South.SOUTH_AND_SOUTH_WEST;
                } else if (north_west && south_west) {
                    southTemp = South.SOUTH_EAST_AND_SOUTH_WEST;
                } else if (!north_west && west) {
                    southTemp = South.JUST_SOUTH;
                } else if (!north_west && south_west) {
                    southTemp = South.JUST_SOUTH_EAST;
                } else if (north_west) {
                    southTemp = South.JUST_SOUTH_WEST;
                }
                if (north_east && east && south_east) {
                    northTemp = North.ALL;
                } else if (!north_east && east && south_east) {
                    northTemp = North.NORTH_AND_NORTH_EAST;
                } else if (north_east && east) {
                    northTemp = North.NORTH_AND_NORTH_WEST;
                } else if (north_east && south_east) {
                    northTemp = North.NORTH_EAST_AND_NORTH_WEST;
                } else if (!north_east && east) {
                    northTemp = North.JUST_NORTH;
                } else if (!north_east && south_east) {
                    northTemp = North.JUST_NORTH_EAST;
                } else if (north_east) {
                    northTemp = North.JUST_NORTH_WEST;
                }
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)EAST, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(north))).setValue(NORTH, (Comparable)((Object)northTemp))).setValue(SOUTH, (Comparable)((Object)southTemp));
            }
        }
        return pState;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            DyeColor dyecolor = dyeItem.getDyeColor();
            if (this.getDyeColor(state) == dyecolor) {
                return ItemInteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, player.getItemInHand(hand));
            }
            BlockState newBlockstate = (BlockState)level.getBlockState(pos).setValue(COLOR, (Comparable)dyecolor);
            if (state.getBlock() == ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.GOLD_NUGGET));
                newBlockstate = (BlockState)((ConnectingCarpetDyed)ModBlocks.INFUSED_FABRIC_CARPET.get()).defaultBlockState().setValue(COLOR, (Comparable)dyecolor);
            }
            level.setBlockAndUpdate(pos, newBlockstate);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newBlockstate));
            level.levelEvent(player, 3003, pos, 0);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (stack.getItem() == Items.GOLD_NUGGET) {
            if (state.getBlock() == ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()) {
                return ItemInteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, player.getItemInHand(hand));
            }
            BlockState newBlockstate = ((ConnectingCarpetDyed)ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()).defaultBlockState();
            if (!player.isCreative()) {
                player.getItemInHand(hand).shrink(1);
            }
            level.setBlockAndUpdate(pos, newBlockstate);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newBlockstate));
            level.levelEvent(player, 3004, pos, 0);
            level.playSound(player, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        DyeColor color = this.getDyeColor(state);
        if (color != DyeColor.WHITE) {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            tag.putString("color", color.getName());
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return stack;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        return this.getUnWaxed(state, context, itemAbility);
    }

    public static int getColorValue(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && customData.copyTag().contains("color")) {
            return ConnectingCarpetDyed.getColorValue(DyeColor.byName((String)customData.copyTag().getString("color"), (DyeColor)DyeColor.WHITE));
        }
        return ConnectingCarpetDyed.getColorValue(DyeColor.WHITE);
    }

    public static int getColorValue(BlockState state) {
        int col = ConnectingCarpetDyed.getColorValue(DyeColor.WHITE);
        Block block = state.getBlock();
        if (block instanceof CTDyable) {
            CTDyable ctDyable = (CTDyable)block;
            col = ConnectingCarpetDyed.getColorValue(ctDyable.getDyeColor(state));
        }
        return col;
    }

    public static int toDarkPastel(int color) {
        float[] rgb = HexereiUtil.rgbIntToFloatArray(color);
        float[] hsl = HexereiUtil.rgbToHsl(rgb[0], rgb[1], rgb[2]);
        hsl[1] = Math.max(0.0f, hsl[1] - 0.3f);
        return HexereiUtil.hslToRgb(hsl[0], hsl[1], hsl[2]);
    }

    public static int getColorValue(DyeColor color) {
        if (color == null) {
            return 0;
        }
        return ConnectingCarpetDyed.toDarkPastel(color.getTextureDiffuseColor());
    }

    private static boolean canConnect(BlockState state1, BlockState state2) {
        if (state1.getBlock() == state2.getBlock() && state1.hasProperty(COLOR) && state2.hasProperty(COLOR)) {
            return state1.getValue(COLOR) == state2.getValue(COLOR);
        }
        return false;
    }

    protected BlockState updateCorners(BlockGetter world, BlockPos pos, BlockState state) {
        BlockState bs_north = world.getBlockState(pos.north());
        BlockState bs_north_east = world.getBlockState(pos.north().east());
        BlockState bs_north_west = world.getBlockState(pos.north().west());
        BlockState bs_east = world.getBlockState(pos.east());
        BlockState bs_south = world.getBlockState(pos.south());
        BlockState bs_south_east = world.getBlockState(pos.south().east());
        BlockState bs_south_west = world.getBlockState(pos.south().west());
        BlockState bs_west = world.getBlockState(pos.west());
        North north = North.NONE;
        South south = South.NONE;
        if (ConnectingCarpetDyed.canConnect(state, bs_north)) {
            north = North.JUST_NORTH;
            if (ConnectingCarpetDyed.canConnect(state, bs_north_west) && !ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.NORTH_AND_NORTH_WEST;
            }
            if (!ConnectingCarpetDyed.canConnect(state, bs_north_west) && ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.NORTH_AND_NORTH_EAST;
            }
            if (ConnectingCarpetDyed.canConnect(state, bs_north_west) && ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.ALL;
            }
        } else {
            if (ConnectingCarpetDyed.canConnect(state, bs_north_west) && !ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.JUST_NORTH_WEST;
            }
            if (!ConnectingCarpetDyed.canConnect(state, bs_north_west) && ConnectingCarpetDyed.canConnect(state, bs_north_east)) {
                north = North.JUST_NORTH_EAST;
            }
        }
        if (ConnectingCarpetDyed.canConnect(state, bs_south)) {
            south = South.JUST_SOUTH;
            if (ConnectingCarpetDyed.canConnect(state, bs_south_west) && !ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.SOUTH_AND_SOUTH_WEST;
            }
            if (!ConnectingCarpetDyed.canConnect(state, bs_south_west) && ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.SOUTH_AND_SOUTH_EAST;
            }
            if (ConnectingCarpetDyed.canConnect(state, bs_south_west) && ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.ALL;
            }
        } else {
            if (ConnectingCarpetDyed.canConnect(state, bs_south_west) && !ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.JUST_SOUTH_WEST;
            }
            if (!ConnectingCarpetDyed.canConnect(state, bs_south_west) && ConnectingCarpetDyed.canConnect(state, bs_south_east)) {
                south = South.JUST_SOUTH_EAST;
            }
        }
        boolean east = ConnectingCarpetDyed.canConnect(state, bs_east);
        boolean west = ConnectingCarpetDyed.canConnect(state, bs_west);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue(SOUTH, (Comparable)((Object)south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    public RenderShape getRenderShape(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        ItemStack stack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains("color")) {
            DyeColor color = DyeColor.byName((String)tag.getString("color"), (DyeColor)DyeColor.WHITE);
            return (BlockState)this.updateCorners((BlockGetter)iblockreader, blockpos, super.getStateForPlacement(context)).setValue(COLOR, (Comparable)color);
        }
        return this.updateCorners((BlockGetter)iblockreader, blockpos, super.getStateForPlacement(context));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WEST, EAST, NORTH, SOUTH, COLOR});
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : this.updateCorners((BlockGetter)world, pos, state);
    }

    public static enum North implements StringRepresentable
    {
        JUST_NORTH,
        NORTH_AND_NORTH_WEST,
        NORTH_AND_NORTH_EAST,
        JUST_NORTH_WEST,
        JUST_NORTH_EAST,
        NORTH_EAST_AND_NORTH_WEST,
        ALL,
        NONE;


        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "north";
                case 1 -> "north_and_north_west";
                case 2 -> "north_and_north_east";
                case 3 -> "north_west";
                case 4 -> "north_east";
                case 5 -> "north_east_and_north_west";
                case 6 -> "all";
                case 7 -> "none";
            };
        }
    }

    public static enum South implements StringRepresentable
    {
        JUST_SOUTH,
        SOUTH_AND_SOUTH_WEST,
        SOUTH_AND_SOUTH_EAST,
        JUST_SOUTH_WEST,
        JUST_SOUTH_EAST,
        SOUTH_EAST_AND_SOUTH_WEST,
        ALL,
        NONE;


        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "south";
                case 1 -> "south_and_south_west";
                case 2 -> "south_and_south_east";
                case 3 -> "south_west";
                case 4 -> "south_east";
                case 5 -> "south_east_and_south_west";
                case 6 -> "all";
                case 7 -> "none";
            };
        }
    }
}

