/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public class Candelabra
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final VoxelShape GROUNDED_SHAPE = Stream.of(Block.box((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.box((double)1.0, (double)5.5, (double)7.0, (double)3.0, (double)7.5, (double)9.0), Block.box((double)13.0, (double)8.5, (double)7.0, (double)15.0, (double)12.5, (double)9.0), Block.box((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5), Block.box((double)1.0, (double)8.5, (double)7.0, (double)3.0, (double)12.5, (double)9.0), Block.box((double)3.0, (double)5.5, (double)7.01, (double)13.0, (double)6.5, (double)9.01), Block.box((double)12.5, (double)7.5, (double)6.5, (double)15.5, (double)8.5, (double)9.5), Block.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.box((double)13.0, (double)5.5, (double)7.0, (double)15.0, (double)7.5, (double)9.0), Block.box((double)6.5, (double)9.5, (double)12.5, (double)9.5, (double)10.5, (double)15.5), Block.box((double)0.5, (double)7.5, (double)6.5, (double)3.5, (double)8.5, (double)9.5), Block.box((double)7.0, (double)10.5, (double)13.0, (double)9.0, (double)14.5, (double)15.0), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)1.0, (double)10.5), Block.box((double)7.0, (double)10.5, (double)1.0, (double)9.0, (double)14.5, (double)3.0), Block.box((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)7.0, (double)7.5, (double)13.0, (double)9.0, (double)9.5, (double)15.0), Block.box((double)7.01, (double)7.5, (double)3.0, (double)9.01, (double)8.5, (double)13.0), Block.box((double)7.0, (double)7.5, (double)1.0, (double)9.0, (double)9.5, (double)3.0), Block.box((double)6.5, (double)9.5, (double)0.5, (double)9.5, (double)10.5, (double)3.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape HANGING_SHAPES = Stream.of(Block.box((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.box((double)1.0, (double)5.5, (double)7.0, (double)3.0, (double)7.5, (double)9.0), Block.box((double)13.0, (double)8.5, (double)7.0, (double)15.0, (double)12.5, (double)9.0), Block.box((double)1.0, (double)8.5, (double)7.0, (double)3.0, (double)12.5, (double)9.0), Block.box((double)3.0, (double)5.5, (double)7.01, (double)13.0, (double)6.5, (double)9.01), Block.box((double)12.5, (double)7.5, (double)6.5, (double)15.5, (double)8.5, (double)9.5), Block.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.box((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)13.0, (double)5.5, (double)7.0, (double)15.0, (double)7.5, (double)9.0), Block.box((double)6.5, (double)9.5, (double)12.5, (double)9.5, (double)10.5, (double)15.5), Block.box((double)0.5, (double)7.5, (double)6.5, (double)3.5, (double)8.5, (double)9.5), Block.box((double)7.0, (double)10.5, (double)13.0, (double)9.0, (double)14.5, (double)15.0), Block.box((double)7.0, (double)10.5, (double)1.0, (double)9.0, (double)14.5, (double)3.0), Block.box((double)7.0, (double)7.5, (double)13.0, (double)9.0, (double)9.5, (double)15.0), Block.box((double)7.01, (double)7.5, (double)3.0, (double)9.01, (double)8.5, (double)13.0), Block.box((double)7.0, (double)7.5, (double)1.0, (double)9.0, (double)9.5, (double)3.0), Block.box((double)6.5, (double)9.5, (double)0.5, (double)9.5, (double)10.5, (double)3.5), Block.box((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)2.0, (double)8.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape GROUNDED_SHAPE_TURNED = Stream.of(Block.box((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.box((double)7.0, (double)5.5, (double)13.0, (double)9.0, (double)7.5, (double)15.0), Block.box((double)7.0, (double)8.5, (double)1.0, (double)9.0, (double)12.5, (double)3.0), Block.box((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5), Block.box((double)7.0, (double)8.5, (double)13.0, (double)9.0, (double)12.5, (double)15.0), Block.box((double)7.0, (double)5.5, (double)3.0, (double)9.01, (double)6.5, (double)13.0), Block.box((double)6.5, (double)7.5, (double)0.5, (double)9.5, (double)8.5, (double)3.5), Block.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.box((double)7.0, (double)5.5, (double)1.0, (double)9.0, (double)7.5, (double)3.0), Block.box((double)12.5, (double)9.5, (double)6.5, (double)15.5, (double)10.5, (double)9.5), Block.box((double)6.5, (double)7.5, (double)12.5, (double)9.5, (double)8.5, (double)15.5), Block.box((double)13.0, (double)10.5, (double)7.0, (double)15.0, (double)14.5, (double)9.0), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)1.0, (double)10.5), Block.box((double)1.0, (double)10.5, (double)7.0, (double)3.0, (double)14.5, (double)9.0), Block.box((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)13.0, (double)7.5, (double)7.0, (double)15.0, (double)9.5, (double)9.0), Block.box((double)3.0, (double)7.5, (double)7.0, (double)13.0, (double)8.5, (double)9.0), Block.box((double)1.0, (double)7.5, (double)7.0, (double)3.0, (double)9.5, (double)9.0), Block.box((double)0.5, (double)9.5, (double)6.5, (double)3.5, (double)10.5, (double)9.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape HANGING_SHAPES_TURNED = Stream.of(Block.box((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.box((double)7.0, (double)5.5, (double)13.0, (double)9.0, (double)7.5, (double)15.0), Block.box((double)7.0, (double)8.5, (double)1.03, (double)9.0, (double)12.5, (double)3.0), Block.box((double)7.0, (double)8.5, (double)13.0, (double)9.0, (double)12.5, (double)15.0), Block.box((double)7.01, (double)5.5, (double)3.0, (double)9.0, (double)6.5, (double)13.0), Block.box((double)6.5, (double)7.5, (double)0.5, (double)9.5, (double)8.5, (double)3.5), Block.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.box((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)7.0, (double)5.5, (double)1.03, (double)9.0, (double)7.5, (double)3.0), Block.box((double)12.5, (double)9.5, (double)6.5, (double)15.5, (double)10.5, (double)9.5), Block.box((double)6.5, (double)7.5, (double)12.5, (double)9.5, (double)8.5, (double)15.5), Block.box((double)13.0, (double)10.5, (double)7.0, (double)15.0, (double)14.5, (double)9.0), Block.box((double)1.0, (double)10.5, (double)7.0, (double)3.0, (double)14.5, (double)9.0), Block.box((double)13.0, (double)7.5, (double)7.0, (double)15.0, (double)9.5, (double)9.0), Block.box((double)3.0, (double)7.5, (double)7.0, (double)13.0, (double)8.5, (double)9.0), Block.box((double)1.0, (double)7.5, (double)7.0, (double)3.0, (double)9.5, (double)9.0), Block.box((double)0.5, (double)9.5, (double)6.5, (double)3.5, (double)10.5, (double)9.5), Block.box((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)2.0, (double)8.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public RenderShape getRenderShape(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate;
            if (direction.getAxis() != Direction.Axis.Y || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)LIT, (Comparable)Boolean.FALSE);
        }
        return null;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH || state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH ? (((Boolean)state.getValue((Property)HANGING)).booleanValue() ? HANGING_SHAPES : GROUNDED_SHAPE) : ((Boolean)state.getValue((Property)HANGING) != false ? HANGING_SHAPES_TURNED : GROUNDED_SHAPE_TURNED);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack = player.getItemInHand(hand);
        Random random = new Random();
        if (itemstack.getItem() == Items.FLINT_AND_STEEL && Candelabra.canBeLit(state)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE), 11);
            level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
            itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public static boolean canBeLit(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && (Boolean)state.getValue((Property)BlockStateProperties.LIT) == false;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public Candelabra(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)LIT, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, HANGING, WATERLOGGED, LIT});
    }

    public static void extinguish(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                Candelabra.spawnSmokeParticles((Level)world, pos, true);
            }
        }
    }

    public boolean placeLiquid(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidStateIn.getType() == Fluids.WATER) {
            boolean flag = (Boolean)state.getValue((Property)LIT);
            if (flag) {
                if (!worldIn.isClientSide()) {
                    worldIn.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                Candelabra.extinguish(worldIn, pos, state);
            }
            worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE)).setValue((Property)LIT, (Comparable)Boolean.FALSE), 3);
            worldIn.scheduleTick(pos, fluidStateIn.getType(), fluidStateIn.getType().getTickDelay((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.isClientSide && projectile.isOnFire()) {
            boolean flag;
            Entity entity = projectile.getOwner();
            boolean bl = flag = entity == null || entity instanceof Player || EventHooks.canEntityGrief((Level)level, (Entity)entity);
            if (flag && !((Boolean)state.getValue((Property)LIT)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                BlockPos blockpos = hit.getBlockPos();
                level.setBlock(blockpos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE), 11);
            }
        }
        super.onProjectileHit(level, state, hit, projectile);
    }

    public static void spawnSmokeParticles(Level worldIn, BlockPos pos, boolean spawnExtraSmoke) {
        RandomSource random = worldIn.getRandom();
        SimpleParticleType basicparticletype = ParticleTypes.CAMPFIRE_COSY_SMOKE;
        worldIn.addParticle((ParticleOptions)basicparticletype, true, (double)pos.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + random.nextDouble() + random.nextDouble(), (double)pos.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean isLit(BlockState state) {
        return state.hasProperty((Property)LIT) && (Boolean)state.getValue((Property)LIT) != false;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = Candelabra.getBlockConnected(state).getOpposite();
        return Block.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.getValue((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.candelabra_shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + rand.nextFloat() / 2.0f, rand.nextFloat() * 0.7f + 0.6f);
            }
            if (!((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0625f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0625f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
            }
            if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST || state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + 0.5f + 0.375f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.5f + 0.375f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + 0.5f - 0.375f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.5f - 0.375f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.875f), (double)((float)pos.getZ() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.875f), (double)((float)pos.getZ() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.875f), (double)((float)pos.getZ() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.875f), (double)((float)pos.getZ() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
            }
            if (state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH || state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + 0.5f + 0.375f), (double)((float)pos.getY() + 0.875f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.5f + 0.375f), (double)((float)pos.getY() + 0.875f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)pos.getX() + 0.5f - 0.375f), (double)((float)pos.getY() + 0.875f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)pos.getX() + 0.5f - 0.375f), (double)((float)pos.getY() + 0.875f), (double)((float)pos.getZ() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
            }
        }
    }
}

