/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.block.custom.BroomStand;
import net.joefoxe.hexerei.tileentity.BroomStandTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BroomStandWall
extends BroomStand
implements ITileEntity<BroomStandTile>,
EntityBlock,
SimpleWaterloggedBlock {
    VoxelShape shape = Stream.of(Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)3.0), Block.box((double)10.0, (double)3.0, (double)3.0, (double)13.0, (double)6.0, (double)8.0), Block.box((double)3.0, (double)3.0, (double)3.0, (double)6.0, (double)6.0, (double)8.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    VoxelShape shape_90 = Stream.of(Block.box((double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0), Block.box((double)3.0, (double)3.0, (double)3.0, (double)8.0, (double)6.0, (double)6.0), Block.box((double)3.0, (double)3.0, (double)10.0, (double)8.0, (double)6.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    VoxelShape shape_180 = Stream.of(Block.box((double)2.0, (double)2.0, (double)13.0, (double)14.0, (double)14.0, (double)16.0), Block.box((double)3.0, (double)3.0, (double)8.0, (double)6.0, (double)6.0, (double)13.0), Block.box((double)10.0, (double)3.0, (double)8.0, (double)13.0, (double)6.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    VoxelShape shape_270 = Stream.of(Block.box((double)13.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.box((double)8.0, (double)3.0, (double)10.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)8.0, (double)3.0, (double)3.0, (double)13.0, (double)6.0, (double)6.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public BroomStandWall(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)super.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (context.getClickedFace() != Direction.UP && context.getClickedFace() != Direction.DOWN) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!pState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            return this.shape;
        }
        Direction dir = (Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING);
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP, Direction.NORTH -> this.shape;
            case Direction.SOUTH -> this.shape_180;
            case Direction.WEST -> this.shape_90;
            case Direction.EAST -> this.shape_270;
        };
    }
}

