/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.connected;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.joefoxe.hexerei.block.connected.CustomBlockModels;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ModelEvent;

public class ModelSwapper {
    protected CustomBlockModels customBlockModels = new CustomBlockModels();

    public CustomBlockModels getCustomBlockModels() {
        return this.customBlockModels;
    }

    public void onModelBake(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        this.customBlockModels.forEach((block, modelFunc) -> ModelSwapper.swapModels((Map<ModelResourceLocation, BakedModel>)modelRegistry, ModelSwapper.getAllBlockStateModelLocations(block), modelFunc));
    }

    public void registerListeners(IEventBus modEventBus) {
        modEventBus.addListener(this::onModelBake);
    }

    public static <T extends BakedModel> void swapModels(Map<ModelResourceLocation, BakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<BakedModel, T> factory) {
        locations.forEach(location -> ModelSwapper.swapModels(modelRegistry, location, factory));
    }

    public static <T extends BakedModel> void swapModels(Map<ModelResourceLocation, BakedModel> modelRegistry, ModelResourceLocation location, Function<BakedModel, T> factory) {
        modelRegistry.put(location, (BakedModel)factory.apply(modelRegistry.get(location)));
    }

    public static List<ModelResourceLocation> getAllBlockStateModelLocations(Block block) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        ResourceLocation blockRl = HexereiUtil.getKeyOrThrow(block);
        block.getStateDefinition().getPossibleStates().forEach(state -> models.add(BlockModelShaper.stateToModelLocation((ResourceLocation)blockRl, (BlockState)state)));
        return models;
    }

    public static ModelResourceLocation getItemModelLocation(Item item) {
        return new ModelResourceLocation(HexereiUtil.getKeyOrThrow(item), "inventory");
    }
}

