/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.library;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryContainer;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryTile;
import dev.shadowsoffire.placebo.payloads.ButtonClickPayload;
import dev.shadowsoffire.placebo.util.DrawsOnLeft;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.network.PacketDistributor;

public class EnchLibraryScreen
extends AbstractContainerScreen<EnchLibraryContainer>
implements DrawsOnLeft {
    public static final ResourceLocation TEXTURES = ApothicEnchanting.loc("textures/gui/library.png");
    public static final int MAX_ENTRIES = 5;
    public static final int ENTRY_WIDTH = 113;
    public static final int ENTRY_HEIGHT = 20;
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    protected List<LibrarySlot> data = new ArrayList<LibrarySlot>();
    protected EditBox filter = null;
    private static DecimalFormat f = new DecimalFormat("##.#");

    public EnchLibraryScreen(EnchLibraryContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.imageHeight = 230;
        this.containerChanged();
        container.setNotifier(this::containerChanged);
    }

    protected void init() {
        super.init();
        this.filter = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.getGuiLeft() + 16, this.getGuiTop() + 16, 110, 11, this.filter, (Component)Component.literal((String)"")));
        this.filter.setBordered(false);
        this.filter.setTextColor(9924943);
        this.filter.setResponder(t -> this.containerChanged());
        this.setFocused((GuiEventListener)this.filter);
        this.containerChanged();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)pKeyCode, (int)pScanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey) && this.getFocused() == this.filter) {
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        super.render(gfx, mouseX, mouseY, partialTicks);
        this.renderTooltip(gfx, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics gfx, int mouseX, int mouseY) {
        super.renderTooltip(gfx, mouseX, mouseY);
        LibrarySlot libSlot = this.getHoveredSlot(mouseX, mouseY);
        if (libSlot != null) {
            int targetLevel;
            ArrayList<Object> list = new ArrayList<Object>();
            MutableComponent name = ((Enchantment)libSlot.ench.value()).description().copy().setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFF80)).withUnderlined(Boolean.valueOf(true)));
            if (ApothicAttributes.getTooltipFlag().isAdvanced()) {
                name = name.append((Component)Component.literal((String)(" [" + String.valueOf(libSlot.ench.getKey().location()) + "]")).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withUnderlined(Boolean.valueOf(false))));
            }
            list.add(name);
            String descKey = libSlot.ench.getKey().location().toLanguageKey("enchantment") + ".desc";
            if (I18n.exists((String)descKey) || ApothicAttributes.getTooltipFlag().isAdvanced()) {
                MutableComponent txt = Component.translatable((String)descKey).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)));
                list.addAll(this.font.getSplitter().splitLines((FormattedText)txt, this.getGuiLeft() - 16, txt.getStyle()));
                list.add(CommonComponents.SPACE);
            }
            list.add(Component.translatable((String)"tooltip.enchlib.max_lvl", (Object[])new Object[]{Component.translatable((String)("enchantment.level." + libSlot.maxLvl))}).withStyle(ChatFormatting.GRAY));
            list.add(Component.translatable((String)"tooltip.enchlib.points", (Object[])new Object[]{EnchLibraryScreen.format(libSlot.points), EnchLibraryScreen.format(((EnchLibraryContainer)this.menu).getPointCap())}).withStyle(ChatFormatting.GRAY));
            list.add(CommonComponents.SPACE);
            ItemStack outSlot = ((EnchLibraryContainer)this.menu).ioInv.getItem(1);
            int current = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)outSlot).getLevel(libSlot.ench);
            boolean shift = Screen.hasShiftDown();
            int n = targetLevel = shift ? Math.min(libSlot.maxLvl, 1 + (int)(Math.log(libSlot.points + EnchLibraryTile.levelToPoints(current)) / Math.log(2.0))) : current + 1;
            if (targetLevel == current) {
                ++targetLevel;
            }
            int cost = EnchLibraryTile.levelToPoints(targetLevel) - EnchLibraryTile.levelToPoints(current);
            if (targetLevel > libSlot.maxLvl) {
                list.add(Component.translatable((String)"tooltip.enchlib.unavailable").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
            } else {
                list.add(Component.translatable((String)"tooltip.enchlib.extracting", (Object[])new Object[]{Component.translatable((String)("enchantment.level." + targetLevel))}).withStyle(ChatFormatting.BLUE));
                list.add(Component.translatable((String)"tooltip.enchlib.cost", (Object[])new Object[]{cost}).withStyle(cost > libSlot.points ? ChatFormatting.RED : ChatFormatting.GOLD));
            }
            this.drawOnLeft(gfx, list, mouseY);
        }
    }

    protected void renderBg(GuiGraphics gfx, float partial, int mouseX, int mouseY) {
        int left = this.leftPos;
        int top = this.topPos;
        gfx.blit(TEXTURES, left, top, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 307, 256);
        int scrollbarPos = (int)(90.0f * this.scrollOffs);
        gfx.blit(TEXTURES, left + 13, top + 29 + scrollbarPos, 303.0f, (float)(40 + (this.isScrollBarActive() ? 0 : 12)), 4, 12, 307, 256);
        for (int idx = this.startIndex; idx < this.startIndex + 5 && idx < this.data.size(); ++idx) {
            this.renderEntry(gfx, this.data.get(idx), this.leftPos + 20, this.topPos + 30 + 20 * (idx - this.startIndex), mouseX, mouseY);
        }
    }

    private void renderEntry(GuiGraphics gfx, LibrarySlot data, int x, int y, int mouseX, int mouseY) {
        LibrarySlot hover = this.getHoveredSlot(mouseX, mouseY);
        gfx.blit(TEXTURES, x, y, 194.0f, data == hover ? 20.0f : 0.0f, 113, 20, 307, 256);
        int progress = (int)Math.round(85.0 * Math.sqrt(data.points) / (double)((float)Math.sqrt(((EnchLibraryContainer)this.menu).getPointCap())));
        gfx.blit(TEXTURES, x + 3, y + 14, 197.0f, 42.0f, progress, 3, 307, 256);
        PoseStack stack = gfx.pose();
        stack.pushPose();
        MutableComponent txt = ((Enchantment)data.ench().value()).description().plainCopy();
        float scale = 1.0f;
        if (this.font.width((FormattedText)txt) > 85) {
            scale = 85.0f / (float)this.font.width((FormattedText)txt);
        }
        stack.scale(scale, scale, 1.0f);
        gfx.drawString(this.font, (Component)txt, (int)((float)(x + 3) / scale), (int)((float)(y + 3) / scale), 9363789, false);
        stack.popPose();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        if (this.isHovering(14, 29, 4, 103, pMouseX, pMouseY)) {
            this.scrolling = true;
            this.mouseDragged(pMouseX, pMouseY, pButton, 0.0, 0.0);
            return true;
        }
        LibrarySlot libSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (libSlot != null) {
            int id = Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getId((Object)((Enchantment)libSlot.ench.value()));
            if (Screen.hasShiftDown()) {
                id |= Integer.MIN_VALUE;
            }
            ((EnchLibraryContainer)this.menu).onButtonClick(id);
            PacketDistributor.sendToServer((CustomPacketPayload)new ButtonClickPayload(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
            return true;
        }
        if (this.filter.isHovered() && pButton == 1) {
            this.filter.setValue("");
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int barTop = this.topPos + 14;
            int barBot = barTop + 103;
            this.scrollOffs = ((float)pMouseY - (float)barTop - 6.0f) / ((float)(barBot - barTop) - 12.0f) - 0.12f;
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pScrollY / (double)i);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 5;
    }

    protected int getOffscreenRows() {
        return this.data.size() - 5;
    }

    private void containerChanged() {
        this.data.clear();
        List<Object2IntMap.Entry<Holder<Enchantment>>> entries = this.filter(((EnchLibraryContainer)this.menu).getPointsForDisplay());
        for (Object2IntMap.Entry<Holder<Enchantment>> e : entries) {
            this.data.add(new LibrarySlot((Holder<Enchantment>)((Holder)e.getKey()), e.getIntValue(), ((EnchLibraryContainer)this.menu).getMaxLevel((Holder<Enchantment>)((Holder)e.getKey()))));
        }
        if (!this.isScrollBarActive()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        Collections.sort(this.data, Comparator.comparing(slot -> ((Enchantment)slot.ench.value()).description().getString()));
    }

    private List<Object2IntMap.Entry<Holder<Enchantment>>> filter(List<Object2IntMap.Entry<Holder<Enchantment>>> list) {
        return list.stream().filter(this::isAllowedByItem).filter(this::isAllowedBySearch).toList();
    }

    private boolean isAllowedByItem(Object2IntMap.Entry<Holder<Enchantment>> e) {
        ItemStack stack = ((EnchLibraryContainer)this.menu).ioInv.getItem(2);
        return stack.isEmpty() || stack.supportsEnchantment((Holder)e.getKey());
    }

    private boolean isAllowedBySearch(Object2IntMap.Entry<Holder<Enchantment>> e) {
        String name = ((Enchantment)((Holder)e.getKey()).value()).description().getString().toLowerCase(Locale.ROOT);
        String search = this.filter == null ? "" : this.filter.getValue().trim().toLowerCase(Locale.ROOT);
        return Strings.isNullOrEmpty((String)search) || ChatFormatting.stripFormatting((String)name).contains(search);
    }

    @Nullable
    public LibrarySlot getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 5; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.isHovering(21, 31 + i * 20, 113, 18, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    public int getSlotColor(int index) {
        return 0x40FFFFFF;
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    private record LibrarySlot(Holder<Enchantment> ench, int points, int maxLvl) {
    }
}

