/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class ImbuedSpellParchment
extends SpellParchment {
    public ImbuedSpellParchment() {
        super(AddonItemRegistry.defaultItemProperties().component((Supplier)DataComponentRegistry.SPELL_CASTER, (Object)new SpellCaster()));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        int cost = this.getSpellCaster(stack).getSpell().getCost();
        int seconds = -Math.floorDiv(-cost, 100);
        return seconds * 10;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        player.startUsingItem(usedHand);
        ItemStack stack = player.getItemInHand(usedHand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration > 1) {
            return;
        }
        AbstractCaster caster = this.getSpellCaster(stack);
        InteractionResultHolder result = caster.castSpell(level, livingEntity, InteractionHand.MAIN_HAND, (Component)Component.translatable((String)"ars_nouveau.invalid_spell"));
        if (result.getResult().consumesAction()) {
            stack.consume(1, livingEntity);
        }
        livingEntity.stopUsingItem();
    }

    @SubscribeEvent
    public static void calcSpellCost(SpellCostCalcEvent event) {
        if (event.context.getCasterTool().getItem() instanceof ImbuedSpellParchment) {
            event.currentCost = 0;
        }
    }
}

