/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.commands;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.LootCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class SetLootTableCommand {
    private static final SuggestionProvider<CommandSourceStack> sugg = (ctx, builder) -> SharedSuggestionProvider.suggestResource(GlyphRegistry.getSpellpartMap().keySet(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctxt) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set_loot_tables").requires(sender -> sender.hasPermission(4))).then(Commands.argument((String)"filter", (ArgumentType)BlockStateArgument.block((CommandBuildContext)ctxt)).then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"loot", (ArgumentType)ResourceLocationArgument.id()).suggests(LootCommand.SUGGEST_LOOT_TABLE).executes(context -> SetLootTableCommand.replaceLootTables((CommandContext<CommandSourceStack>)context, BlockStateArgument.getBlock((CommandContext)context, (String)"filter"), BlockPosArgument.getBlockPos((CommandContext)context, (String)"from"), BlockPosArgument.getBlockPos((CommandContext)context, (String)"to"), ResourceLocationArgument.getId((CommandContext)context, (String)"loot"))))))));
    }

    private static int replaceLootTables(CommandContext<CommandSourceStack> context, BlockInput filter, BlockPos from, BlockPos to, ResourceLocation loot) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        int counter = 0;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)from, (BlockPos)to)) {
            if (!filter.test(new BlockInWorld((LevelReader)level, pos, true))) continue;
            BlockState bs = level.getBlockState(pos);
            BlockEntity be = level.getBlockEntity(pos);
            if (be == null) continue;
            CompoundTag tag = be.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
            tag.putString("LootTable", loot.toString());
            be.loadCustomOnly(tag, (HolderLookup.Provider)level.registryAccess());
            be.setChanged();
            be.getLevel().sendBlockUpdated(pos, bs, bs, 3);
            ++counter;
        }
        if (((CommandSourceStack)context.getSource()).getPlayer() != null) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            player.sendSystemMessage((Component)Component.literal((String)("Updated " + counter + " loot tables")));
        }
        return 1;
    }
}

