/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.block.tile;

import com.github.jarva.arsadditions.server.storage.EnderSourceData;
import com.github.jarva.arsadditions.server.sync.SourceJarSync;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EnderSourceJarTile
extends SourceJarTile
implements ITickable {
    public static String OWNER_UUID_TAG = "owner_uuid";
    private UUID owner = null;
    private boolean registered = false;

    public EnderSourceJarTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)AddonBlockRegistry.ENDER_SOURCE_JAR_TILE.get(), pos, state);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            return;
        }
        if (this.level.getGameTime() % 20L == 0L && !this.registered && this.getOwner() != null) {
            int source = EnderSourceData.getSource(this.level.getServer(), this.getOwner());
            this.setSource(source);
            SourceJarSync.addPosition(this.level, this.worldPosition);
            this.registered = true;
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.getOwner() != null) {
            tag.putUUID(OWNER_UUID_TAG, this.getOwner());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (tag.hasUUID(OWNER_UUID_TAG)) {
            this.setOwner(tag.getUUID(OWNER_UUID_TAG));
        }
        super.loadAdditional(tag, pRegistries);
    }

    public int getSource() {
        if (this.getLevel() != null && !this.getLevel().isClientSide && this.getOwner() != null) {
            EnderSourceData.getSource(this.getLevel().getServer(), this.getOwner());
        }
        return super.getSource();
    }

    public int setSource(int source) {
        if (this.getLevel() != null && !this.getLevel().isClientSide && this.getOwner() != null) {
            EnderSourceData.setSource(this.getLevel().getServer(), this.getOwner(), source);
        }
        return super.setSource(source);
    }

    public boolean canAcceptSource() {
        if (this.getOwner() == null) {
            return false;
        }
        return super.canAcceptSource();
    }

    public boolean canAcceptSource(int source) {
        if (this.getOwner() == null) {
            return false;
        }
        return super.canAcceptSource(source);
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.getOwner() != null) {
            super.getTooltip(tooltip);
        }
    }
}

