/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.client.jei;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.client.jei.CharmChargingRecipeCategory;
import com.github.jarva.arsadditions.client.jei.LocateStructureRecipeCategory;
import com.github.jarva.arsadditions.common.recipe.LocateStructureRecipe;
import com.github.jarva.arsadditions.common.recipe.imbuement.CharmChargingRecipe;
import com.github.jarva.arsadditions.common.ritual.RitualLocateStructure;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ModPlugin
implements IModPlugin {
    public static final RecipeType<LocateStructureRecipe> LOCATE_STRUCTURE_RECIPE_TYPE = RecipeType.create((String)"ars_additions", (String)"locate_structure", LocateStructureRecipe.class);
    public static final RecipeType<CharmChargingRecipe> CHARM_CHARGING_RECIPE_TYPE = RecipeType.create((String)"ars_additions", (String)"charm_charging", CharmChargingRecipe.class);

    public ResourceLocation getPluginUid() {
        return ArsAdditions.prefix("main");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new LocateStructureRecipeCategory(helper), new CharmChargingRecipeCategory(helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<LocateStructureRecipe> locateStructureRecipes = new ArrayList<LocateStructureRecipe>();
        ArrayList<CharmChargingRecipe> charmChargingRecipes = new ArrayList<CharmChargingRecipe>();
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        for (RecipeHolder i : manager.getRecipes()) {
            Recipe recipe;
            Objects.requireNonNull(i.value());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocateStructureRecipe.class, CharmChargingRecipe.class}, (Object)recipe, n)) {
                case 0: {
                    LocateStructureRecipe recipe2 = (LocateStructureRecipe)recipe;
                    locateStructureRecipes.add(recipe2);
                    break;
                }
                case 1: {
                    CharmChargingRecipe recipe3 = (CharmChargingRecipe)recipe;
                    charmChargingRecipes.add(recipe3);
                    break;
                }
            }
        }
        registration.addRecipes(LOCATE_STRUCTURE_RECIPE_TYPE, locateStructureRecipes);
        registration.addRecipes(CHARM_CHARGING_RECIPE_TYPE, charmChargingRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.RITUAL_BLOCK), new RecipeType[]{LOCATE_STRUCTURE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RitualRegistry.getRitualItemMap().get(RitualLocateStructure.RESOURCE_LOCATION)), new RecipeType[]{LOCATE_STRUCTURE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.IMBUEMENT_BLOCK), new RecipeType[]{CHARM_CHARGING_RECIPE_TYPE});
    }
}

