/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks.mixin;

import com.google.common.collect.ImmutableList;
import com.thevortex.allthetweaks.AllTheTweaks;
import java.util.List;
import net.minecraft.DetectedVersion;
import net.neoforged.fml.ModList;
import net.neoforged.fml.i18n.FMLTranslations;
import net.neoforged.neoforge.internal.BrandingControl;
import net.neoforged.neoforge.internal.versions.neoforge.NeoForgeVersion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BrandingControl.class}, remap=false, priority=1)
public class NameBrandsOnly {
    @Shadow(remap=false)
    private static List<String> brandings;
    @Shadow(remap=false)
    private static List<String> brandingsNoMC;

    @Overwrite(remap=false)
    private static void computeBranding() {
        if (brandings == null) {
            ImmutableList.Builder brd = ImmutableList.builder();
            brd.add((Object)AllTheTweaks.DISPLAY);
            brd.add((Object)("NeoForge " + NeoForgeVersion.getVersion()));
            brd.add((Object)("Minecraft " + DetectedVersion.BUILT_IN.getName()));
            int tModCount = ModList.get().size();
            brd.add((Object)FMLTranslations.parseMessage((String)(tModCount + " Mods Loaded"), (Object[])new Object[]{tModCount}));
            brandings = brd.build();
            brandingsNoMC = brandings.subList(1, brandings.size());
        }
    }
}

